/*
* lv3.c
* 3d vectors for Lua 5.0
* Luiz Henrique de Figueiredo <lhf@tecgraf.puc-rio.br>
* 14 Jul 2025 13:21:27
* This code is hereby placed in the public domain and also under the MIT license
*/

#include "lua.h"
#include "lauxlib.h"
#include "mycompat.h"

#define MYNAME		"vector3"
#define MYTYPE		MYNAME " handle"
#define MYVERSION	MYNAME " library for " LUA_VERSION " / Jul 2025"

static double *Pget(lua_State *L, int i)
{
 return luaL_checkudata(L,i,MYTYPE);
}

static double *Pnew(lua_State *L)
{
 double *v=lua_newuserdata(L,3*sizeof(double));
 luaL_setmetatable(L,MYTYPE);
 return v;
}

static int Lnew(lua_State *L)			/** vector3([x,y,z]) */
{
 double *v;
 lua_settop(L,3);
 v=Pnew(L);
 v[0]=luaL_optnumber(L,1,0.0);
 v[1]=luaL_optnumber(L,2,0.0);
 v[2]=luaL_optnumber(L,3,0.0);
 return 1;
}

static int Lget(lua_State *L)
{
 double *v=Pget(L,1);
 const char *i=luaL_checkstring(L,2);
 switch (*i) {		/* lazy! */
  case '1': case 'x': case 'r': lua_pushnumber(L,v[0]); break;
  case '2': case 'y': case 'g': lua_pushnumber(L,v[1]); break;
  case '3': case 'z': case 'b': lua_pushnumber(L,v[2]); break;
  default: lua_pushnil(L); break;
 }
 return 1;
}

static int Lset(lua_State *L) {
 double *v=Pget(L,1);
 const char *i=luaL_checkstring(L,2);
 double t=luaL_checknumber(L,3);
 switch (*i) {		/* lazy! */
  case '1': case 'x': case 'r': v[0]=t; break;
  case '2': case 'y': case 'g': v[1]=t; break;
  case '3': case 'z': case 'b': v[2]=t; break;
  default: break;
 }
 return 1;
}

static const luaL_Reg R[] =
{
	{ "__index",	Lget		},
	{ "__newindex",	Lset		},
	{ "new",	Lnew		},
	{ NULL,		NULL		}
};

LUALIB_API int luaopen_v3(lua_State *L)
{
 luaL_newmetatable(L,MYTYPE);
 luaL_setfuncs(L,R,0);
 lua_pushliteral(L,"version");			/** version */
 lua_pushliteral(L,MYVERSION);
 lua_settable(L,-3);
 return 1;
}
