-- make wrappers for Lua API

formats={
 ["const char*"]='\\"%s\\"',
 ["lua_Number"]="%g",
 ["lua_Integer"]="%d",
 ["double"]="%g",
 ["size_t"]="%u",
 ["unsigned long"]="%lu",
 ["int"]="%d",
 ["long"]="%ld",
 ["lua_CFunction"]="%p",
 ["lua_State*"]="%p",
 ["void*"]="%p",
 ["const void*"]="%p",
 ["void"]="(void)",
 ["lua_Reader"]="%p",
 ["lua_Chunkreader"]="%p",
 ["lua_Writer"]="%p",
 ["lua_Chunkwriter"]="%p",
 ["lua_Debug*"]="%p",
 ["lua_Alloc"]="%p",
 ["const lua_Debug*"]="%p",
 ["lua_Hook"]="%p",
 ["void* *"]="%p",
 ["size_t*"]="%p",
 ["luaL_Buffer*"]="%p",
 ["char*"]="%s",
}

RTEMPLATE=[[

$t $F ($p$A) {
 $t rc = ($f)($a);
 printf("%s:%d [%s] $f$I -> $O\n",
	_FILE,_LINE,_FUNC$b,rc);
 return rc;
}
]]

VTEMPLATE=[[

$t $F ($p$A) {
 ($f)($a);
 printf("%s:%d [%s] $f$I\n",
	_FILE,_LINE,_FUNC,$a);
}
]]

function map(T,v)
 T=string.gsub(T,"(%$(%w+))",function (a,i) return v[i] or a end)
 return T
end

function Format(t,f)
 return formats[t] or error("cannot handle `"..t.."' in "..(f or "?"))
end

function bodyC(o,t,F,f,p,a,A)
 local v={t=t,F=F,f=f,p=p,a=a,A=A,I="",O=Format(t,f)}
 if a=="" then v.b=a else v.b=","..a
  v.I=string.gsub(p..",","%s*(.-)%s*(%w+),",
      function (t,n) return " "..n.."="..Format(t,f) end)
 end
 local T
 if t=="void" then T=VTEMPLATE else T=RTEMPLATE end
 o:write(map(T,v))
end

HTEMPLATE=[[

$t $F($p$A);

#define	$f($a) \
	$F($a$B)
]]

function bodyH(o,t,F,f,p,a,A)
 local B="__FILE__,__LINE__,__FUNCTION__"
 if p~="" then B=","..B end
 local v={t=t,F=F,f=f,p=p,a=a,A=A,B=B}
 o:write(map(HTEMPLATE,v))
end

function header(o,e,v)
 o:write("/* ctrace.",e," -- automatically extracted from lua.h (",v,") */\n")
 if e=="c" then
  o:write[[

#include <stdio.h>

#include "ctrace.h"
]]
 else
  o:write[[

/* gcc defines __FUNCTION__ but lcc uses a different name */

#ifdef __LCC__
#define __FUNCTION__ __func__
#else
#ifndef __GNUC__
#define __FUNCTION__ "-"
#endif
#endif

#include "lua.h"
#include "lauxlib.h"
]]
 end
end

function body(l)
 local a,b,t,f,z,F,p=string.find(l,"(.-) %(?((luaL?)_(%w+))%)? %((.*)%)")
 --if a==nil then return end
 if f=="lua_pushvfstring" then return end
 if f=="lua_pushfstring" then return end
 local A="const char* _FILE, int _LINE, const char* _FUNC"
 if p=="void" then
  p=""
  a=""
 else
  a=string.gsub(p..",","%s*.-%s*(%w+),","%1,")
  a=string.gsub(a,",$","")
  A=",\n\t"..A
 end
 F="Lua_"..F
 bodyC(C_OUT,t,F,f,p,a,A)
 bodyH(H_OUT,t,F,f,p,a,A)
end

local T=io.read"*a"
T=string.gsub(T,"[\t ]+"," ")
T=string.gsub(T," %*","* ")
local _,_,v=string.find(T,'LUA_VERSION.-"Lua.- (.-)"')
C_OUT=io.open("ctrace.c","w") header(C_OUT,"c",v)
H_OUT=io.open("ctrace.h","w") header(H_OUT,"h",v)
string.gsub(T,'\nLUA_API (.-%b());',body)
--string.gsub(T,'\nLUALIB_API (.-%b());',body)
