-- test interval library: plot implicit region f(x,y)>=0

local I=require"interval"
local tol=2^(-tonumber(arg[1] or 5))

function f(x,y)
	--return x^2+y^2-1
	--return y^2-x^3+x
	return (y-x^2+1)^4+(x^2+y^2)^4-1
end

local zero=I.new(0)

function explore(x,y)
	local ax,bx=x:extremes()
	local ay,by=y:extremes()
	box(ax,bx,ay,by,"b")
	local z=f(x,y)
	z=-z
	if z<zero then
		-- outside
	elseif z>zero then
		box(ax,bx,ay,by,"B")
	elseif x:diam()<=tol then
		if z>zero then
			box(ax,bx,ay,by,"B")
		else
			box(ax,bx,ay,by,"Z")
		end
	else
			local xlo,xhi=split(x)
			local ylo,yhi=split(y)
			explore(xlo,ylo)
			explore(xhi,ylo)
			explore(xlo,yhi)
			explore(xhi,yhi)
	end
end

function split(x)
	local ax,bx=x:extremes()
	local mx=x:mid()
	local xlo=I.new(ax,mx)
	local xhi=I.new(mx,bx)
	return xlo,xhi
end

function output(...)
	local arg={...}
	for i=1,#arg do
		io.write(arg[i]," ")
	end
	io.write("\n")
end

function box(xmin,xmax,ymin,ymax,t)
	local dx=xmax-xmin
	local dy=ymax-ymin
	output(xmin,ymin,dx,dy,t)
end

function plot(xmin,xmax,ymin,ymax)
	local X0,Y0,DX,DY=50,50,500,500
	output("%!PS-Adobe-2.0 EPSF-2.0")
	output("%%BoundingBox:",X0,Y0,X0+DX,Y0+DY)
	output("%%Title: implicit curve")
	output("%%Creator:",I.version)
	output("%%CreationDate:",os.date())
	output("%%Pages: 1")
	output("%%EndComments")
	output("%%EndProlog")
	output("%%BeginSetup")
	output("/b { 0.2 setgray rectstroke } bind def")
	output("/B { 4 copy 1 0.8 0.8 setrgbcolor rectfill 1 0 0 setrgbcolor rectstroke } bind def")
	output("/Z { 4 copy 0.8 0.8 1 setrgbcolor rectfill 0 0 1 setrgbcolor rectstroke } bind def")
	output("%/b { 0.2 setgray rectstroke } bind def")
	output("%/B { 4 copy 1 0.8 0.8 setrgbcolor rectfill b } bind def")
	output("%/Z { 4 copy 0.8 0.8 1 setrgbcolor rectfill b } bind def")
	output("%/b { } bind def")
	output("%/B { 4 copy 1 0.8 0.8 setrgbcolor rectfill rectstroke } bind def")
	output("%/Z { 4 copy 0.8 0.8 1 setrgbcolor rectfill rectstroke } bind def")
	output("0 setlinewidth")
	output(X0,Y0,"translate")
	output(DX,DY,"scale")
	output("%%EndSetup\n")
	output("%%Page: 1 1")
	local dx=xmax-xmin
	local dy=ymax-ymin
	output("% region is",xmin,xmax,ymin,ymax)
	output("1",dx,"div","1",dy,"div scale")
	output(-xmin,-ymin,"translate\n")
	explore(I.new(xmin,xmax),I.new(ymin,ymax))
	output("\nshowpage")
	output("%%EOF")
end

plot(-1.5,2,-2.2,1.3)
