#include<stdio.h>
#include<string.h>
#include"fi_lib.h"

typedef union { double r; char a[7]; } twoint;

twoint trick;
int wks, alltrue=1;

char hexr(char *b,int i)
{ int j;
  int k;
  char erg, rueck;

  erg=*(b+(2*i-2));
  switch (erg)
  { case 'A': k=10; break;
    case 'B': k=11; break;
    case 'C': k=12; break;
    case 'D': k=13; break;
    case 'E': k=14; break;
    case 'F': k=15; break;
    default:k=erg-48;
  }
  k=k*16;
  erg=*(b+(2*i-1));
  switch (erg)
  { case 'A': j=10; break;
    case 'B': j=11; break;
    case 'C': j=12; break;
    case 'D': j=13; break;
    case 'E': j=14; break;
    case 'F': j=15; break;
    default:j=erg-48;
  }
  k=k+j;
  rueck=k;
  return rueck;
}

double hexu(char *b)
{ int i;
  for (i=1;i<=8;i++) {
    if (wks==1) trick.a[i-1]=hexr(b,i);
    if (wks==2) trick.a[i-1]=hexr(b,9-i);
  }
  return trick.r;
}

int pred_test(){
   char* x_hex[17];
   char* z_hex[17];
   double x[17], z[17];
   double res;
   int anz_max=16;
   int i, predtrue=1;
   
   x_hex[ 1] = "FFEFFFFFFFFFFFFE";
   x_hex[ 2] = "D4B249AD2594C37D";
   x_hex[ 3] = "BFF0000000000000";
   x_hex[ 4] = "8010000000000001";
   x_hex[ 5] = "8010000000000000";
   x_hex[ 6] = "800FFFFFFFFFFFFF";
   x_hex[ 7] = "80000000000007E8";
   x_hex[ 8] = "0000000000000000";
   x_hex[ 9] = "0000000000000001";
   x_hex[10] = "00000000000007E8";
   x_hex[11] = "0010000000000000";
   x_hex[12] = "0010000000000001";
   x_hex[13] = "0010000000000002";
   x_hex[14] = "3FF0000000000000";
   x_hex[15] = "54B249AD2594C37D";
   x_hex[16] = "7FEFFFFFFFFFFFFF";
   z_hex[ 1] = "FFEFFFFFFFFFFFFF";
   z_hex[ 2] = "D4B249AD2594C37E";
   z_hex[ 3] = "BFF0000000000001";
   z_hex[ 4] = "8010000000000002";
   z_hex[ 5] = "8010000000000001";
   z_hex[ 6] = "8010000000000000";
   z_hex[ 7] = "80000000000007E9";
   z_hex[ 8] = "8000000000000001";
   z_hex[ 9] = "0000000000000000";
   z_hex[10] = "00000000000007E7";
   z_hex[11] = "000FFFFFFFFFFFFF";
   z_hex[12] = "0010000000000000";
   z_hex[13] = "0010000000000001";
   z_hex[14] = "3FEFFFFFFFFFFFFF";
   z_hex[15] = "54B249AD2594C37C";
   z_hex[16] = "7FEFFFFFFFFFFFFE";

   for (i=1;i<=anz_max;i++) {
     x[i] = hexu(x_hex[i]);
     z[i] = hexu(z_hex[i]);
   }

   for (i=1; i<=anz_max; i++) {
     res = q_pred(x[i]);
   
     if (res!=z[i]) {
             printf("\n Error function q_pred for case n=%u\n", i);
             printf("\n Error for %24.15e\n", x[i]);
             printf("computed result:  %24.15e\n", res);
             printf("correct result:   %24.15e\n", z[i]);
             predtrue=0;
     }
   }

  if (predtrue) printf("Test of function q_pred: OK! \n");
 
  return predtrue;
}

int succ_test(){
   char* x_hex[17];
   char* z_hex[17];
   double x[17], z[17];
   double res;
   int anz_max=16;
   int i, succtrue=1;
   
   x_hex[ 1] = "FFEFFFFFFFFFFFFF";
   x_hex[ 2] = "D4B249AD2594C37D";
   x_hex[ 3] = "BFF0000000000000";
   x_hex[ 4] = "8010000000000002";
   x_hex[ 5] = "8010000000000001";
   x_hex[ 6] = "8010000000000000";
   x_hex[ 7] = "80000000000007E8";
   x_hex[ 8] = "8000000000000001";
   x_hex[ 9] = "0000000000000000";
   x_hex[10] = "00000000000007E8";
   x_hex[11] = "000FFFFFFFFFFFFF";
   x_hex[12] = "0010000000000000";
   x_hex[13] = "0010000000000001";
   x_hex[14] = "3FF0000000000000";
   x_hex[15] = "54B249AD2594C37D";
   x_hex[16] = "7FEFFFFFFFFFFFFE";
   z_hex[ 1] = "FFEFFFFFFFFFFFFE";
   z_hex[ 2] = "D4B249AD2594C37C";
   z_hex[ 3] = "BFEFFFFFFFFFFFFF";
   z_hex[ 4] = "8010000000000001";
   z_hex[ 5] = "8010000000000000";
   z_hex[ 6] = "800FFFFFFFFFFFFF";
   z_hex[ 7] = "80000000000007E7";
   z_hex[ 8] = "8000000000000000";
   z_hex[ 9] = "0000000000000001";
   z_hex[10] = "00000000000007E9";
   z_hex[11] = "0010000000000000";
   z_hex[12] = "0010000000000001";
   z_hex[13] = "0010000000000002";
   z_hex[14] = "3FF0000000000001";
   z_hex[15] = "54B249AD2594C37E";
   z_hex[16] = "7FEFFFFFFFFFFFFF";

   for (i=1;i<=anz_max;i++) {
     x[i] = hexu(x_hex[i]);
     z[i] = hexu(z_hex[i]);
   }

   for (i=1; i<=anz_max; i++) {
     res = q_succ(x[i]);
   
     if (res!=z[i]) {
             printf("\n Error function q_succ for case n=%u\n", i);
             printf("\n Error for %24.15e\n", x[i]);
             printf("computed result:  %24.15e\n", res);
             printf("correct result:   %24.15e\n", z[i]);
             succtrue=0;
     }
   }

  if (succtrue) printf("Test of function q_succ: OK! \n");
 
  return succtrue;
}

int addii_test(){
   char* x_inf[20];
   char* x_sup[20];
   char* y_inf[20];
   char* y_sup[20];
   char* z_inf[20];
   char* z_sup[20];
   interval x[20], y[20], z[20];
   interval res, res2;
   int anz_max=19;
   int i, addtrue=1;
   
   x_inf[ 1] = "0000000000000000"; x_sup[ 1] = "0000000000000000";
   x_inf[ 2] = "3FF0000000000000"; x_sup[ 2] = "3FF0000000000000";
   x_inf[ 3] = "BFF0000000000000"; x_sup[ 3] = "BFF0000000000000";
   x_inf[ 4] = "3FF0000000000000"; x_sup[ 4] = "3FF0000000000000";
   x_inf[ 5] = "BFF0000000000000"; x_sup[ 5] = "BFF0000000000000";
   x_inf[ 6] = "00000000000007E8"; x_sup[ 6] = "00000000000007E8";
   x_inf[ 7] = "00000000000007E8"; x_sup[ 7] = "00000000000007E8";
   x_inf[ 8] = "80000000000007E8"; x_sup[ 8] = "80000000000007E8";
   x_inf[ 9] = "80000000000007E8"; x_sup[ 9] = "80000000000007E8";
   x_inf[10] = "7FEFFFFFFFFFFFFF"; x_sup[10] = "7FEFFFFFFFFFFFFF";
   x_inf[11] = "FFEFFFFFFFFFFFFF"; x_sup[11] = "FFEFFFFFFFFFFFFF";
   x_inf[12] = "0000000000000000"; x_sup[12] = "3FF0000000000000";
   x_inf[13] = "3FF0000000000000"; x_sup[13] = "4000000000000000";
   x_inf[14] = "3FF0000000000000"; x_sup[14] = "4000000000000000";
   x_inf[15] = "4008000000000000"; x_sup[15] = "4010000000000000";
   x_inf[16] = "BFF0000000000000"; x_sup[16] = "0000000000000000";
   x_inf[17] = "C010000000000000"; x_sup[17] = "C008000000000000";
   x_inf[18] = "C014000000000000"; x_sup[18] = "C010000000000000";
   x_inf[19] = "4010000000000000"; x_sup[19] = "4014000000000000";
   y_inf[ 1] = "0000000000000000"; y_sup[ 1] = "0000000000000000";
   y_inf[ 2] = "4000000000000000"; y_sup[ 2] = "4000000000000000";
   y_inf[ 3] = "C000000000000000"; y_sup[ 3] = "C000000000000000";
   y_inf[ 4] = "BFF0000000000000"; y_sup[ 4] = "BFF0000000000000";
   y_inf[ 5] = "3FF0000000000000"; y_sup[ 5] = "3FF0000000000000";
   y_inf[ 6] = "00000000000007E8"; y_sup[ 6] = "00000000000007E8";
   y_inf[ 7] = "3FF0000000000000"; y_sup[ 7] = "3FF0000000000000";
   y_inf[ 8] = "80000000000007E8"; y_sup[ 8] = "80000000000007E8";
   y_inf[ 9] = "3FF0000000000000"; y_sup[ 9] = "3FF0000000000000";
   y_inf[10] = "BFF0000000000000"; y_sup[10] = "BFF0000000000000";
   y_inf[11] = "3FF0000000000000"; y_sup[11] = "3FF0000000000000";
   y_inf[12] = "3FF0000000000000"; y_sup[12] = "4000000000000000";
   y_inf[13] = "0000000000000000"; y_sup[13] = "3FF0000000000000";
   y_inf[14] = "4008000000000000"; y_sup[14] = "4010000000000000";
   y_inf[15] = "3FF0000000000000"; y_sup[15] = "4000000000000000";
   y_inf[16] = "C010000000000000"; y_sup[16] = "C008000000000000";
   y_inf[17] = "BFF0000000000000"; y_sup[17] = "0000000000000000";
   y_inf[18] = "4010000000000000"; y_sup[18] = "4014000000000000";
   y_inf[19] = "C014000000000000"; y_sup[19] = "C010000000000000";
   z_inf[ 1] = "0000000000000000"; z_sup[ 1] = "0000000000000000";
   z_inf[ 2] = "4008000000000000"; z_sup[ 2] = "4008000000000000";
   z_inf[ 3] = "C008000000000000"; z_sup[ 3] = "C008000000000000";
   z_inf[ 4] = "8000000000000000"; z_sup[ 4] = "0000000000000000";
   z_inf[ 5] = "8000000000000000"; z_sup[ 5] = "0000000000000000";
   z_inf[ 6] = "0000000000000FD0"; z_sup[ 6] = "0000000000000FD0";
   z_inf[ 7] = "3FF0000000000000"; z_sup[ 7] = "3FF0000000000001";
   z_inf[ 8] = "8000000000000FD0"; z_sup[ 8] = "8000000000000FD0";
   z_inf[ 9] = "3FEFFFFFFFFFFFFF"; z_sup[ 9] = "3FF0000000000000";
   z_inf[10] = "7FEFFFFFFFFFFFFE"; z_sup[10] = "7FEFFFFFFFFFFFFF";
   z_inf[11] = "FFEFFFFFFFFFFFFF"; z_sup[11] = "FFEFFFFFFFFFFFFE";
   z_inf[12] = "3FF0000000000000"; z_sup[12] = "4008000000000000";
   z_inf[13] = "3FF0000000000000"; z_sup[13] = "4008000000000000";
   z_inf[14] = "4010000000000000"; z_sup[14] = "4018000000000000";
   z_inf[15] = "4010000000000000"; z_sup[15] = "4018000000000000";
   z_inf[16] = "C014000000000000"; z_sup[16] = "C008000000000000";
   z_inf[17] = "C014000000000000"; z_sup[17] = "C008000000000000";
   z_inf[18] = "BFF0000000000000"; z_sup[18] = "3FF0000000000000";
   z_inf[19] = "BFF0000000000000"; z_sup[19] = "3FF0000000000000";

   for (i=1;i<=anz_max;i++) {
     x[i].INF = hexu(x_inf[i]);
     x[i].SUP = hexu(x_sup[i]);
     y[i].INF = hexu(y_inf[i]);
     y[i].SUP = hexu(y_sup[i]);
     z[i].INF = hexu(z_inf[i]);
     z[i].SUP = hexu(z_sup[i]);
   }

   for (i=1; i<=anz_max; i++) {
     res  = add_ii(x[i],y[i]);
     res2 = add_ii(y[i],x[i]);
  
     if ((res.INF>z[i].INF)||(res.SUP<z[i].SUP)||(res.INF!=res2.INF)||(res.SUP!=res2.SUP)) {
             printf("\n Error function add_ii for case n=%u\n", i);
             printf("\n Error for [%24.15e,%24.15e] + [%24.15e,%24.15e]\n", x[i].INF, x[i].SUP, y[i].INF, y[i].SUP);
             printf("computed result:  %24.15e, %24.15e\n", res.INF, res.SUP);
             printf("correct result:   %24.15e, %24.15e\n", z[i].INF, z[i].SUP);
             addtrue=0;
     }
   }

  if (addtrue) printf("Test of function add_ii: OK! \n");
 
  return addtrue;
}

int subii_test(){
   char* x_inf[20];
   char* x_sup[20];
   char* y_inf[20];
   char* y_sup[20];
   char* z_inf[20];
   char* z_sup[20];
   interval x[20], y[20], z[20];
   interval res;
   int anz_max=19;
   int i, subtrue=1;
   
   x_inf[ 1] = "0000000000000000"; x_sup[ 1] = "0000000000000000";
   x_inf[ 2] = "3FF0000000000000"; x_sup[ 2] = "3FF0000000000000";
   x_inf[ 3] = "BFF0000000000000"; x_sup[ 3] = "BFF0000000000000";
   x_inf[ 4] = "3FF0000000000000"; x_sup[ 4] = "3FF0000000000000";
   x_inf[ 5] = "BFF0000000000000"; x_sup[ 5] = "BFF0000000000000";
   x_inf[ 6] = "00000000000007E8"; x_sup[ 6] = "00000000000007E8";
   x_inf[ 7] = "00000000000007E8"; x_sup[ 7] = "00000000000007E8";
   x_inf[ 8] = "80000000000007E8"; x_sup[ 8] = "80000000000007E8";
   x_inf[ 9] = "80000000000007E8"; x_sup[ 9] = "80000000000007E8";
   x_inf[10] = "7FEFFFFFFFFFFFFF"; x_sup[10] = "7FEFFFFFFFFFFFFF";
   x_inf[11] = "FFEFFFFFFFFFFFFF"; x_sup[11] = "FFEFFFFFFFFFFFFF";
   x_inf[12] = "0000000000000000"; x_sup[12] = "3FF0000000000000";
   x_inf[13] = "3FF0000000000000"; x_sup[13] = "4000000000000000";
   x_inf[14] = "3FF0000000000000"; x_sup[14] = "4000000000000000";
   x_inf[15] = "4008000000000000"; x_sup[15] = "4010000000000000";
   x_inf[16] = "BFF0000000000000"; x_sup[16] = "0000000000000000";
   x_inf[17] = "C010000000000000"; x_sup[17] = "C008000000000000";
   x_inf[18] = "C014000000000000"; x_sup[18] = "C010000000000000";
   x_inf[19] = "4010000000000000"; x_sup[19] = "4014000000000000";
   y_inf[ 1] = "0000000000000000"; y_sup[ 1] = "0000000000000000";
   y_inf[ 2] = "4000000000000000"; y_sup[ 2] = "4000000000000000";
   y_inf[ 3] = "C000000000000000"; y_sup[ 3] = "C000000000000000";
   y_inf[ 4] = "BFF0000000000000"; y_sup[ 4] = "BFF0000000000000";
   y_inf[ 5] = "3FF0000000000000"; y_sup[ 5] = "3FF0000000000000";
   y_inf[ 6] = "00000000000007E8"; y_sup[ 6] = "00000000000007E8";
   y_inf[ 7] = "3FF0000000000000"; y_sup[ 7] = "3FF0000000000000";
   y_inf[ 8] = "80000000000007E8"; y_sup[ 8] = "80000000000007E8";
   y_inf[ 9] = "3FF0000000000000"; y_sup[ 9] = "3FF0000000000000";
   y_inf[10] = "3FF0000000000000"; y_sup[10] = "3FF0000000000000";
   y_inf[11] = "BFF0000000000000"; y_sup[11] = "BFF0000000000000";
   y_inf[12] = "3FF0000000000000"; y_sup[12] = "4000000000000000";
   y_inf[13] = "0000000000000000"; y_sup[13] = "3FF0000000000000";
   y_inf[14] = "4008000000000000"; y_sup[14] = "4010000000000000";
   y_inf[15] = "3FF0000000000000"; y_sup[15] = "4000000000000000";
   y_inf[16] = "C010000000000000"; y_sup[16] = "C008000000000000";
   y_inf[17] = "BFF0000000000000"; y_sup[17] = "0000000000000000";
   y_inf[18] = "4010000000000000"; y_sup[18] = "4014000000000000";
   y_inf[19] = "C014000000000000"; y_sup[19] = "C010000000000000";
   z_inf[ 1] = "8000000000000000"; z_sup[ 1] = "0000000000000000";
   z_inf[ 2] = "BFF0000000000000"; z_sup[ 2] = "BFF0000000000000";
   z_inf[ 3] = "3FF0000000000000"; z_sup[ 3] = "3FF0000000000000";
   z_inf[ 4] = "4000000000000000"; z_sup[ 4] = "4000000000000000";
   z_inf[ 5] = "C000000000000000"; z_sup[ 5] = "C000000000000000";
   z_inf[ 6] = "8000000000000000"; z_sup[ 6] = "0000000000000000";
   z_inf[ 7] = "BFF0000000000000"; z_sup[ 7] = "BFEFFFFFFFFFFFFF";
   z_inf[ 8] = "8000000000000000"; z_sup[ 8] = "0000000000000000";
   z_inf[ 9] = "BFF0000000000001"; z_sup[ 9] = "BFF0000000000000";
   z_inf[10] = "7FEFFFFFFFFFFFFE"; z_sup[10] = "7FEFFFFFFFFFFFFF";
   z_inf[11] = "FFEFFFFFFFFFFFFF"; z_sup[11] = "FFEFFFFFFFFFFFFE";
   z_inf[12] = "C000000000000000"; z_sup[12] = "0000000000000000";
   z_inf[13] = "8000000000000000"; z_sup[13] = "4000000000000000";
   z_inf[14] = "C008000000000000"; z_sup[14] = "BFF0000000000000";
   z_inf[15] = "3FF0000000000000"; z_sup[15] = "4008000000000000";
   z_inf[16] = "4000000000000000"; z_sup[16] = "4010000000000000";
   z_inf[17] = "C010000000000000"; z_sup[17] = "C000000000000000";
   z_inf[18] = "C024000000000000"; z_sup[18] = "C020000000000000";
   z_inf[19] = "4020000000000000"; z_sup[19] = "4024000000000000";

   for (i=1;i<=anz_max;i++) {
     x[i].INF = hexu(x_inf[i]);
     x[i].SUP = hexu(x_sup[i]);
     y[i].INF = hexu(y_inf[i]);
     y[i].SUP = hexu(y_sup[i]);
     z[i].INF = hexu(z_inf[i]);
     z[i].SUP = hexu(z_sup[i]);
   }

   for (i=1; i<=anz_max; i++) {
     res = sub_ii(x[i],y[i]);
   
     if ((res.INF>z[i].INF)||(res.SUP<z[i].SUP)) {
             printf("\n Error function sub_ii for case n=%u\n", i);
             printf("\n Error for [%24.15e,%24.15e] - [%24.15e,%24.15e]\n", x[i].INF, x[i].SUP, y[i].INF, y[i].SUP);
             printf("computed result:  %24.15e, %24.15e\n", res.INF, res.SUP);
             printf("correct result:   %24.15e, %24.15e\n", z[i].INF, z[i].SUP);
             subtrue=0;
     }
   }

  if (subtrue) printf("Test of function sub_ii: OK! \n");
 
  return subtrue;
}

int mulii_test(){
   char* x_inf[47];
   char* x_sup[47];
   char* y_inf[47];
   char* y_sup[47];
   char* z_inf[47];
   char* z_sup[47];
   interval x[47], y[47], z[47];
   interval res, res2;
   int anz_max=46;
   int i, multrue=1;
   
   x_inf[ 1] = "0000000000000000"; x_sup[ 1] = "0000000000000000";
   x_inf[ 2] = "BFF0000000000000"; x_sup[ 2] = "BFF0000000000000";
   x_inf[ 3] = "BFF0000000000000"; x_sup[ 3] = "BFF0000000000000";
   x_inf[ 4] = "BFF0000000000000"; x_sup[ 4] = "BFF0000000000000";
   x_inf[ 5] = "0000000000000000"; x_sup[ 5] = "0000000000000000";
   x_inf[ 6] = "0000000000000000"; x_sup[ 6] = "0000000000000000";
   x_inf[ 7] = "3FF0000000000000"; x_sup[ 7] = "3FF0000000000000";
   x_inf[ 8] = "3FF0000000000000"; x_sup[ 8] = "3FF0000000000000";
   x_inf[ 9] = "3FF0000000000000"; x_sup[ 9] = "3FF0000000000000";
   x_inf[10] = "7FEFFFFFFFFFFFFF"; x_sup[10] = "7FEFFFFFFFFFFFFF";
   x_inf[11] = "FFEFFFFFFFFFFFFF"; x_sup[11] = "FFEFFFFFFFFFFFFF";
   x_inf[12] = "00000000000007E8"; x_sup[12] = "00000000000007E8";
   x_inf[13] = "00000000000007E8"; x_sup[13] = "00000000000007E8";
   x_inf[14] = "00000000000007E8"; x_sup[14] = "00000000000007E8";
   x_inf[15] = "C008000000000000"; x_sup[15] = "C000000000000000";
   x_inf[16] = "C008000000000000"; x_sup[16] = "C000000000000000";
   x_inf[17] = "C008000000000000"; x_sup[17] = "C000000000000000";
   x_inf[18] = "BFF0000000000000"; x_sup[18] = "3FF0000000000000";
   x_inf[19] = "BFF0000000000000"; x_sup[19] = "3FF0000000000000";
   x_inf[20] = "BFF0000000000000"; x_sup[20] = "3FF0000000000000";
   x_inf[21] = "4000000000000000"; x_sup[21] = "4008000000000000";
   x_inf[22] = "4000000000000000"; x_sup[22] = "4008000000000000";
   x_inf[23] = "4000000000000000"; x_sup[23] = "4008000000000000";
   x_inf[24] = "C014000000000000"; x_sup[24] = "4000000000000000";
   x_inf[25] = "C014000000000000"; x_sup[25] = "4000000000000000";
   x_inf[26] = "C000000000000000"; x_sup[26] = "4014000000000000";
   x_inf[27] = "C010000000000000"; x_sup[27] = "4014000000000000";
   x_inf[28] = "C008000000000000"; x_sup[28] = "0000000000000000";
   x_inf[29] = "C008000000000000"; x_sup[29] = "0000000000000000";
   x_inf[30] = "C008000000000000"; x_sup[30] = "0000000000000000";
   x_inf[31] = "C008000000000000"; x_sup[31] = "C000000000000000";
   x_inf[32] = "C008000000000000"; x_sup[32] = "C000000000000000";
   x_inf[33] = "BFF0000000000000"; x_sup[33] = "3FF0000000000000";
   x_inf[34] = "BFF0000000000000"; x_sup[34] = "3FF0000000000000";
   x_inf[35] = "0000000000000000"; x_sup[35] = "4008000000000000";
   x_inf[36] = "0000000000000000"; x_sup[36] = "4008000000000000";
   x_inf[37] = "0000000000000000"; x_sup[37] = "4008000000000000";
   x_inf[38] = "4000000000000000"; x_sup[38] = "4008000000000000";
   x_inf[39] = "4000000000000000"; x_sup[39] = "4008000000000000";
   x_inf[40] = "0000000000000000"; x_sup[40] = "4000000000000000";
   x_inf[41] = "80000000000007E8"; x_sup[41] = "80000000000007E8";
   x_inf[42] = "80000000000007E8"; x_sup[42] = "80000000000007E8";
   x_inf[43] = "80000000000007E8"; x_sup[43] = "80000000000007E8";
   x_inf[44] = "80000000000007E8"; x_sup[44] = "80000000000007E8";
   x_inf[45] = "80000000000007E8"; x_sup[45] = "80000000000007E8";
   x_inf[46] = "00000000000007E8"; x_sup[46] = "00000000000007E8";
   y_inf[ 1] = "0000000000000000"; y_sup[ 1] = "0000000000000000";
   y_inf[ 2] = "BFF0000000000000"; y_sup[ 2] = "BFF0000000000000";
   y_inf[ 3] = "0000000000000000"; y_sup[ 3] = "0000000000000000";
   y_inf[ 4] = "3FF0000000000000"; y_sup[ 4] = "3FF0000000000000";
   y_inf[ 5] = "BFF0000000000000"; y_sup[ 5] = "BFF0000000000000";
   y_inf[ 6] = "3FF0000000000000"; y_sup[ 6] = "3FF0000000000000";
   y_inf[ 7] = "BFF0000000000000"; y_sup[ 7] = "BFF0000000000000";
   y_inf[ 8] = "0000000000000000"; y_sup[ 8] = "0000000000000000";
   y_inf[ 9] = "3FF0000000000000"; y_sup[ 9] = "3FF0000000000000";
   y_inf[10] = "3FE0000000000000"; y_sup[10] = "3FE0000000000000";
   y_inf[11] = "3FE0000000000000"; y_sup[11] = "3FE0000000000000";
   y_inf[12] = "00000000000007E8"; y_sup[12] = "00000000000007E8";
   y_inf[13] = "3FF0000000000000"; y_sup[13] = "3FF0000000000000";
   y_inf[14] = "BFF0000000000000"; y_sup[14] = "BFF0000000000000";
   y_inf[15] = "C008000000000000"; y_sup[15] = "C000000000000000";
   y_inf[16] = "BFF0000000000000"; y_sup[16] = "3FF0000000000000";
   y_inf[17] = "4000000000000000"; y_sup[17] = "4008000000000000";
   y_inf[18] = "C008000000000000"; y_sup[18] = "C000000000000000";
   y_inf[19] = "BFF0000000000000"; y_sup[19] = "3FF0000000000000";
   y_inf[20] = "4000000000000000"; y_sup[20] = "4008000000000000";
   y_inf[21] = "C008000000000000"; y_sup[21] = "C000000000000000";
   y_inf[22] = "BFF0000000000000"; y_sup[22] = "3FF0000000000000";
   y_inf[23] = "4000000000000000"; y_sup[23] = "4008000000000000";
   y_inf[24] = "C010000000000000"; y_sup[24] = "4008000000000000";
   y_inf[25] = "C008000000000000"; y_sup[25] = "4020000000000000";
   y_inf[26] = "C010000000000000"; y_sup[26] = "4008000000000000";
   y_inf[27] = "C010000000000000"; y_sup[27] = "4008000000000000";
   y_inf[28] = "C008000000000000"; y_sup[28] = "C000000000000000";
   y_inf[29] = "BFF0000000000000"; y_sup[29] = "3FF0000000000000";
   y_inf[30] = "4000000000000000"; y_sup[30] = "4008000000000000";
   y_inf[31] = "C008000000000000"; y_sup[31] = "0000000000000000";
   y_inf[32] = "0000000000000000"; y_sup[32] = "4008000000000000";
   y_inf[33] = "C008000000000000"; y_sup[33] = "0000000000000000";
   y_inf[34] = "0000000000000000"; y_sup[34] = "4008000000000000";
   y_inf[35] = "C008000000000000"; y_sup[35] = "C000000000000000";
   y_inf[36] = "BFF0000000000000"; y_sup[36] = "3FF0000000000000";
   y_inf[37] = "4000000000000000"; y_sup[37] = "4008000000000000";
   y_inf[38] = "C008000000000000"; y_sup[38] = "0000000000000000";
   y_inf[39] = "C008000000000000"; y_sup[39] = "0000000000000000";
   y_inf[40] = "C008000000000000"; y_sup[40] = "0000000000000000";
   y_inf[41] = "80000000000007E8"; y_sup[41] = "80000000000007E8";
   y_inf[42] = "3FF0000000000000"; y_sup[42] = "3FF0000000000000";
   y_inf[43] = "BFF0000000000000"; y_sup[43] = "BFF0000000000000";
   y_inf[44] = "00000000000007E8"; y_sup[44] = "00000000000007E8";
   y_inf[45] = "0000000000000000"; y_sup[45] = "0000000000000000";
   y_inf[46] = "0000000000000000"; y_sup[46] = "0000000000000000";
   z_inf[ 1] = "0000000000000000"; z_sup[ 1] = "0000000000000000";
   z_inf[ 2] = "3FF0000000000000"; z_sup[ 2] = "3FF0000000000000";
   z_inf[ 3] = "8000000000000000"; z_sup[ 3] = "8000000000000000";
   z_inf[ 4] = "BFF0000000000000"; z_sup[ 4] = "BFF0000000000000";
   z_inf[ 5] = "8000000000000000"; z_sup[ 5] = "8000000000000000";
   z_inf[ 6] = "0000000000000000"; z_sup[ 6] = "0000000000000000";
   z_inf[ 7] = "BFF0000000000000"; z_sup[ 7] = "BFF0000000000000";
   z_inf[ 8] = "0000000000000000"; z_sup[ 8] = "0000000000000000";
   z_inf[ 9] = "3FF0000000000000"; z_sup[ 9] = "3FF0000000000000";
   z_inf[10] = "7FDFFFFFFFFFFFFF"; z_sup[10] = "7FDFFFFFFFFFFFFF";
   z_inf[11] = "FFDFFFFFFFFFFFFF"; z_sup[11] = "FFDFFFFFFFFFFFFF";
   z_inf[12] = "0000000000000000"; z_sup[12] = "0000000000000001";
   z_inf[13] = "00000000000007E8"; z_sup[13] = "00000000000007E8";
   z_inf[14] = "80000000000007E8"; z_sup[14] = "80000000000007E8";
   z_inf[15] = "4010000000000000"; z_sup[15] = "4022000000000000";
   z_inf[16] = "C008000000000000"; z_sup[16] = "4008000000000000";
   z_inf[17] = "C022000000000000"; z_sup[17] = "C010000000000000";
   z_inf[18] = "C008000000000000"; z_sup[18] = "4008000000000000";
   z_inf[19] = "BFF0000000000000"; z_sup[19] = "3FF0000000000000";
   z_inf[20] = "C008000000000000"; z_sup[20] = "4008000000000000";
   z_inf[21] = "C022000000000000"; z_sup[21] = "C010000000000000";
   z_inf[22] = "C008000000000000"; z_sup[22] = "4008000000000000";
   z_inf[23] = "4010000000000000"; z_sup[23] = "4022000000000000";
   z_inf[24] = "C02E000000000000"; z_sup[24] = "4034000000000000";
   z_inf[25] = "C044000000000000"; z_sup[25] = "4030000000000000";
   z_inf[26] = "C034000000000000"; z_sup[26] = "402E000000000000";
   z_inf[27] = "C034000000000000"; z_sup[27] = "4030000000000000";
   z_inf[28] = "8000000000000000"; z_sup[28] = "4022000000000000";
   z_inf[29] = "C008000000000000"; z_sup[29] = "4008000000000000";
   z_inf[30] = "C022000000000000"; z_sup[30] = "0000000000000000";
   z_inf[31] = "8000000000000000"; z_sup[31] = "4022000000000000";
   z_inf[32] = "C022000000000000"; z_sup[32] = "8000000000000000";
   z_inf[33] = "C008000000000000"; z_sup[33] = "4008000000000000";
   z_inf[34] = "C008000000000000"; z_sup[34] = "4008000000000000";
   z_inf[35] = "C022000000000000"; z_sup[35] = "8000000000000000";
   z_inf[36] = "C008000000000000"; z_sup[36] = "4008000000000000";
   z_inf[37] = "0000000000000000"; z_sup[37] = "4022000000000000";
   z_inf[38] = "C022000000000000"; z_sup[38] = "0000000000000000";
   z_inf[39] = "C022000000000000"; z_sup[39] = "0000000000000000";
   z_inf[40] = "C018000000000000"; z_sup[40] = "0000000000000000";
   z_inf[41] = "0000000000000000"; z_sup[41] = "0000000000000001";
   z_inf[42] = "80000000000007E8"; z_sup[42] = "80000000000007E8";
   z_inf[43] = "00000000000007E8"; z_sup[43] = "00000000000007E8";
   z_inf[44] = "8000000000000001"; z_sup[44] = "8000000000000000";
   z_inf[45] = "8000000000000000"; z_sup[45] = "8000000000000000";
   z_inf[46] = "0000000000000000"; z_sup[46] = "0000000000000000";

   for (i=1;i<=anz_max;i++) {
     x[i].INF = hexu(x_inf[i]);
     x[i].SUP = hexu(x_sup[i]);
     y[i].INF = hexu(y_inf[i]);
     y[i].SUP = hexu(y_sup[i]);
     z[i].INF = hexu(z_inf[i]);
     z[i].SUP = hexu(z_sup[i]);
   }

   for (i=1; i<=anz_max; i++) {
     res  = mul_ii(x[i],y[i]);
     res2 = mul_ii(y[i],x[i]);
  
     if ((res.INF>z[i].INF)||(res.SUP<z[i].SUP)||(res.INF!=res2.INF)||(res.SUP!=res2.SUP)) {

             printf("\n Error function mul_ii for case n=%u\n", i);
             printf("\n Error for [%24.15e,%24.15e] * [%24.15e,%24.15e]\n", x[i].INF, x[i].SUP, y[i].INF, y[i].SUP);
             printf("computed result:  %24.15e, %24.15e\n", res.INF, res.SUP);
             printf("correct result:   %24.15e, %24.15e\n", z[i].INF, z[i].SUP);
             multrue=0;
     }
   }

  if (multrue) printf("Test of function mul_ii: OK! \n");
 
  return multrue;
}

int divii_test(){
   char* x_inf[22];
   char* x_sup[22];
   char* y_inf[22];
   char* y_sup[22];
   char* z_inf[22];
   char* z_sup[22];
   interval x[22], y[22], z[22];
   interval res;
   int anz_max=21;
   int i, divtrue=1;
   

   x_inf[ 1] = "BFF0000000000000"; x_sup[ 1] = "BFF0000000000000";
   x_inf[ 2] = "BFF0000000000000"; x_sup[ 2] = "BFF0000000000000";
   x_inf[ 3] = "0000000000000000"; x_sup[ 3] = "0000000000000000";
   x_inf[ 4] = "0000000000000000"; x_sup[ 4] = "0000000000000000";
   x_inf[ 5] = "3FF0000000000000"; x_sup[ 5] = "3FF0000000000000";
   x_inf[ 6] = "3FF0000000000000"; x_sup[ 6] = "3FF0000000000000";
   x_inf[ 7] = "7FEFFFFFFFFFFFFF"; x_sup[ 7] = "7FEFFFFFFFFFFFFF";
   x_inf[ 8] = "FFEFFFFFFFFFFFFF"; x_sup[ 8] = "FFEFFFFFFFFFFFFF";
   x_inf[ 9] = "00000000000007E8"; x_sup[ 9] = "00000000000007E8";
   x_inf[10] = "00000000000007E8"; x_sup[10] = "00000000000007E8";
   x_inf[11] = "00000000000007E8"; x_sup[11] = "00000000000007E8";
   x_inf[12] = "C008000000000000"; x_sup[12] = "C000000000000000";
   x_inf[13] = "C008000000000000"; x_sup[13] = "C000000000000000";
   x_inf[14] = "BFF0000000000000"; x_sup[14] = "3FF0000000000000";
   x_inf[15] = "BFF0000000000000"; x_sup[15] = "3FF0000000000000";
   x_inf[16] = "4000000000000000"; x_sup[16] = "4008000000000000";
   x_inf[17] = "4000000000000000"; x_sup[17] = "4008000000000000";
   x_inf[18] = "C008000000000000"; x_sup[18] = "0000000000000000";
   x_inf[19] = "C008000000000000"; x_sup[19] = "0000000000000000";
   x_inf[20] = "0000000000000000"; x_sup[20] = "4008000000000000";
   x_inf[21] = "0000000000000000"; x_sup[21] = "4008000000000000";
   y_inf[ 1] = "BFF0000000000000"; y_sup[ 1] = "BFF0000000000000";
   y_inf[ 2] = "3FF0000000000000"; y_sup[ 2] = "3FF0000000000000";
   y_inf[ 3] = "BFF0000000000000"; y_sup[ 3] = "BFF0000000000000";
   y_inf[ 4] = "3FF0000000000000"; y_sup[ 4] = "3FF0000000000000";
   y_inf[ 5] = "BFF0000000000000"; y_sup[ 5] = "BFF0000000000000";
   y_inf[ 6] = "3FF0000000000000"; y_sup[ 6] = "3FF0000000000000";
   y_inf[ 7] = "4000000000000000"; y_sup[ 7] = "4000000000000000";
   y_inf[ 8] = "4000000000000000"; y_sup[ 8] = "4000000000000000";
   y_inf[ 9] = "00000000000007E8"; y_sup[ 9] = "00000000000007E8";
   y_inf[10] = "3FF0000000000000"; y_sup[10] = "3FF0000000000000";
   y_inf[11] = "BFF0000000000000"; y_sup[11] = "BFF0000000000000";
   y_inf[12] = "C008000000000000"; y_sup[12] = "C000000000000000";
   y_inf[13] = "4000000000000000"; y_sup[13] = "4008000000000000";
   y_inf[14] = "C008000000000000"; y_sup[14] = "C000000000000000";
   y_inf[15] = "4000000000000000"; y_sup[15] = "4008000000000000";
   y_inf[16] = "C008000000000000"; y_sup[16] = "C000000000000000";
   y_inf[17] = "4000000000000000"; y_sup[17] = "4008000000000000";
   y_inf[18] = "C008000000000000"; y_sup[18] = "C000000000000000";
   y_inf[19] = "4000000000000000"; y_sup[19] = "4008000000000000";
   y_inf[20] = "C008000000000000"; y_sup[20] = "C000000000000000";
   y_inf[21] = "4000000000000000"; y_sup[21] = "4008000000000000";
   z_inf[ 1] = "3FF0000000000000"; z_sup[ 1] = "3FF0000000000000";
   z_inf[ 2] = "BFF0000000000000"; z_sup[ 2] = "BFF0000000000000";
   z_inf[ 3] = "8000000000000000"; z_sup[ 3] = "8000000000000000";
   z_inf[ 4] = "0000000000000000"; z_sup[ 4] = "0000000000000000";
   z_inf[ 5] = "BFF0000000000000"; z_sup[ 5] = "BFF0000000000000";
   z_inf[ 6] = "3FF0000000000000"; z_sup[ 6] = "3FF0000000000000";
   z_inf[ 7] = "7FDFFFFFFFFFFFFF"; z_sup[ 7] = "7FDFFFFFFFFFFFFF";
   z_inf[ 8] = "FFDFFFFFFFFFFFFF"; z_sup[ 8] = "FFDFFFFFFFFFFFFF";
   z_inf[ 9] = "3FF0000000000000"; z_sup[ 9] = "3FF0000000000000";
   z_inf[10] = "00000000000007E8"; z_sup[10] = "00000000000007E8";
   z_inf[11] = "80000000000007E8"; z_sup[11] = "80000000000007E8";
   z_inf[12] = "3FE5555555555555"; z_sup[12] = "3FF8000000000000";
   z_inf[13] = "BFF8000000000000"; z_sup[13] = "BFE5555555555555";
   z_inf[14] = "BFE0000000000000"; z_sup[14] = "3FE0000000000000";
   z_inf[15] = "BFE0000000000000"; z_sup[15] = "3FE0000000000000";
   z_inf[16] = "BFF8000000000000"; z_sup[16] = "BFE5555555555555";
   z_inf[17] = "3FE5555555555555"; z_sup[17] = "3FF8000000000000";
   z_inf[18] = "8000000000000000"; z_sup[18] = "3FF8000000000000";
   z_inf[19] = "BFF8000000000000"; z_sup[19] = "0000000000000000";
   z_inf[20] = "BFF8000000000000"; z_sup[20] = "8000000000000000";
   z_inf[21] = "0000000000000000"; z_sup[21] = "3FF8000000000000";

   for (i=1;i<=anz_max;i++) {
     x[i].INF = hexu(x_inf[i]);
     x[i].SUP = hexu(x_sup[i]);
     y[i].INF = hexu(y_inf[i]);
     y[i].SUP = hexu(y_sup[i]);
     z[i].INF = hexu(z_inf[i]);
     z[i].SUP = hexu(z_sup[i]);
   }

   for (i=1; i<=anz_max; i++) {
     res = div_ii(x[i],y[i]);
   
     if ((res.INF>z[i].INF)||(res.SUP<z[i].SUP)) {
             printf("\n Error function div_ii for case n=%u\n", i);
             printf("\n Error for [%24.15e,%24.15e] / [%24.15e,%24.15e]\n", x[i].INF, x[i].SUP, y[i].INF, y[i].SUP);
             printf("computed result:  %24.15e, %24.15e\n", res.INF, res.SUP);
             printf("correct result:   %24.15e, %24.15e\n", z[i].INF, z[i].SUP);
             divtrue=0;
     }
   }

  if (divtrue) printf("Test of function div_ii: OK! \n");
 
  return divtrue;
}

int main()
{   interval x[80]; interval y[80]; interval z[80];
    int j=1;
    int i;
    int eing=0;
    int schalt=0;
    int boolhelp;
    int anz_max = 60;
    int fkt_max = 26;
    char* in_no[27][61];
    char* out_no[27][61];

    in_no[1][1] = "C6F16CC0DF1540F5";
    in_no[1][2] = "B17B3E4076622F04";
    in_no[1][3] = "B24210215CD4421C";
    in_no[1][4] = "A045109A14ED8284";
    in_no[1][5] = "D1007172058AEC0A";
    in_no[1][6] = "B375D74CFDA6B292";
    in_no[1][7] = "A600753C8C437B89";
    in_no[1][8] = "A38FF335468D1A39";
    in_no[1][9] = "D25BFD0932C988E7";
    in_no[1][10] = "CFC44FB341090DD4";
    in_no[1][11] = "D4E101DDFBEE0029";
    in_no[1][12] = "BFFC4E85E50A626D";
    in_no[1][13] = "CEDB2A0D51958E97";
    in_no[1][14] = "A493C3CA0DC2427F";
    in_no[1][15] = "CAD39815CB53F3F4";
    in_no[1][16] = "AA7EB095183538C8";
    in_no[1][17] = "AE03F6C4AA3B2589";
    in_no[1][18] = "90E0E3B84422F7D2";
    in_no[1][19] = "BB6B9E7371BAD173";
    in_no[1][20] = "9CE0040B8B626AF6";
    in_no[1][21] = "D37582D3AFB2C63D";
    in_no[1][22] = "CB54237210F95FB5";
    in_no[1][23] = "D012BCA5B74DFF5D";
    in_no[1][24] = "BD172F8AF508EC0B";
    in_no[1][25] = "E8F1FBA2D1252D2B";
    in_no[1][26] = "C0825BD204AE48DA";
    in_no[1][27] = "EB097E9FEF192A01";
    in_no[1][28] = "C3039C311E11C138";
    in_no[1][29] = "C0744F2134E1901E";
    in_no[1][30] = "B542C0ED6CD7F36E";
    in_no[1][31] = "FDC4A94F199F955D";
    in_no[1][32] = "9E1C64E43E18BD27";
    in_no[1][33] = "B6B58391FD92C387";
    in_no[1][34] = "A490304909A95C65";
    in_no[1][35] = "D5E7F5B89F707C28";
    in_no[1][36] = "A02E27C711642CBE";
    in_no[1][37] = "CEEBE4AA571EC12F";
    in_no[1][38] = "CBDFEF6F0C825E69";
    in_no[1][39] = "B1210D04D9C356E0";
    in_no[1][40] = "AC53FAA34E8FB406";
    in_no[1][41] = "3FF0000000000000";
    in_no[1][42] = "4000000000000000";
    in_no[1][43] = "BFF0000000000000";
    in_no[1][44] = "4000000000000000";
    in_no[1][45] = "C014000000000000";
    in_no[1][46] = "C008000000000000";
    in_no[1][47] = "C000000000000000";
    in_no[1][48] = "3FE3333333333333";
    in_no[1][49] = "0000000000000001";
    in_no[1][50] = "0000000000111111";
    in_no[1][51] = "0000000000001111";
    in_no[1][52] = "3FF0000000000000";
    in_no[1][53] = "8000000000011111";
    in_no[1][54] = "0000000000011111";
    in_no[1][55] = "8000000000000111";
    in_no[1][56] = "3FFFFF0000000000";
    in_no[1][57] = "BFFFFFF000000000";
    in_no[1][58] = "8000000002222222";
    in_no[1][59] = "BFFFFFFFFF000000";
    in_no[1][60] = "0000000233445555";
    in_no[2][1] = "C6F16CC0DF1540F5";
    in_no[2][2] = "B17B3E4076622F04";
    in_no[2][3] = "B24210215CD4421C";
    in_no[2][4] = "A045109A14ED8284";
    in_no[2][5] = "D1007172058AEC0A";
    in_no[2][6] = "B375D74CFDA6B292";
    in_no[2][7] = "A600753C8C437B89";
    in_no[2][8] = "A38FF335468D1A39";
    in_no[2][9] = "D25BFD0932C988E7";
    in_no[2][10] = "CFC44FB341090DD4";
    in_no[2][11] = "D4E101DDFBEE0029";
    in_no[2][12] = "BFFC4E85E50A626D";
    in_no[2][13] = "CEDB2A0D51958E97";
    in_no[2][14] = "A493C3CA0DC2427F";
    in_no[2][15] = "CAD39815CB53F3F4";
    in_no[2][16] = "AA7EB095183538C8";
    in_no[2][17] = "AE03F6C4AA3B2589";
    in_no[2][18] = "90E0E3B84422F7D2";
    in_no[2][19] = "BB6B9E7371BAD173";
    in_no[2][20] = "9CE0040B8B626AF6";
    in_no[2][21] = "D37582D3AFB2C63D";
    in_no[2][22] = "CB54237210F95FB5";
    in_no[2][23] = "D012BCA5B74DFF5D";
    in_no[2][24] = "BD172F8AF508EC0B";
    in_no[2][25] = "E8F1FBA2D1252D2B";
    in_no[2][26] = "C0825BD204AE48DA";
    in_no[2][27] = "EB097E9FEF192A01";
    in_no[2][28] = "C3039C311E11C138";
    in_no[2][29] = "C0744F2134E1901E";
    in_no[2][30] = "B542C0ED6CD7F36E";
    in_no[2][31] = "FDC4A94F199F955D";
    in_no[2][32] = "9E1C64E43E18BD27";
    in_no[2][33] = "B6B58391FD92C387";
    in_no[2][34] = "A490304909A95C65";
    in_no[2][35] = "D5E7F5B89F707C28";
    in_no[2][36] = "A02E27C711642CBE";
    in_no[2][37] = "CEEBE4AA571EC12F";
    in_no[2][38] = "CBDFEF6F0C825E69";
    in_no[2][39] = "B1210D04D9C356E0";
    in_no[2][40] = "AC53FAA34E8FB406";
    in_no[2][41] = "3FF0000000000000";
    in_no[2][42] = "4000000000000000";
    in_no[2][43] = "BFF0000000000000";
    in_no[2][44] = "4000000000000000";
    in_no[2][45] = "C014000000000000";
    in_no[2][46] = "C008000000000000";
    in_no[2][47] = "C000000000000000";
    in_no[2][48] = "3FE3333333333333";
    in_no[2][49] = "0000000000000111";
    in_no[2][50] = "0000000001123344";
    in_no[2][51] = "8000001234542222";
    in_no[2][52] = "0000000012344555";
    in_no[2][53] = "0000000342223444";
    in_no[2][54] = "3FF000003443AAAA";
    in_no[2][55] = "8000003455543322";
    in_no[2][56] = "0000000012345433";
    in_no[2][57] = "8000000012345678";
    in_no[2][58] = "3FFFFFFFF0999999";
    in_no[2][59] = "BFFFFFFFFFFFFFFF";
    in_no[2][60] = "0000000453224455";
    in_no[3][1] = "C70422BDE014CC37";
    in_no[3][2] = "B177A77BFCCF5A9E";
    in_no[3][3] = "B2581702EC6F2DCC";
    in_no[3][4] = "A04E2F6187DDB464";
    in_no[3][5] = "D104D84C8CDFCECF";
    in_no[3][6] = "B36C41FE837A300B";
    in_no[3][7] = "A5F1503444763FC5";
    in_no[3][8] = "A3803AEFCC5923C6";
    in_no[3][9] = "D243E0327B49491A";
    in_no[3][10] = "CFB5444E676976F1";
    in_no[3][11] = "D4D3B2F21561C420";
    in_no[3][12] = "BFF3A01905E36F84";
    in_no[3][13] = "CEDCCBB6ADFD8294";
    in_no[3][14] = "A48202722624E322";
    in_no[3][15] = "CAD9498F3E13BCE2";
    in_no[3][16] = "AA763A15E999EB64";
    in_no[3][17] = "ADF4171976A1CA54";
    in_no[3][18] = "90DA507D1C29C01D";
    in_no[3][19] = "BB51A6EC74D2E55C";
    in_no[3][20] = "9CDDE287D1D68C1B";
    in_no[3][21] = "D37F0D19ADCB5D74";
    in_no[3][22] = "CB3BA04D452BBB35";
    in_no[3][23] = "D0070236DAAA01BE";
    in_no[3][24] = "BD0355E0AABCD959";
    in_no[3][25] = "E8EC678939EB70F2";
    in_no[3][26] = "C0A052F533DB3DA1";
    in_no[3][27] = "EB0534D4B4BB97EF";
    in_no[3][28] = "C30A1B6FF47840CA";
    in_no[3][29] = "C077AAA15EBBD3F2";
    in_no[3][30] = "B558F96439899147";
    in_no[3][31] = "FDC47C9025E2020F";
    in_no[3][32] = "9E1AB3E906363E4B";
    in_no[3][33] = "B6C5802285246AC3";
    in_no[3][34] = "A485DAB859AB6365";
    in_no[3][35] = "D5F9E7DDBBE00F75";
    in_no[3][36] = "A028826528C34186";
    in_no[3][37] = "CEEABC408B9DD2E4";
    in_no[3][38] = "CBD9A5E124A8C193";
    in_no[3][39] = "B135BD629B25AA23";
    in_no[3][40] = "AC5F7A98177B25F3";
    in_no[3][41] = "E36752884A66E610";
    in_no[3][42] = "DAAA0BD399ECD9EB";
    in_no[3][43] = "CA8D70EE09D32965";
    in_no[3][44] = "BC99975F82891DDE";
    in_no[3][45] = "BBE44F68AAA2B029";
    in_no[3][46] = "AA94AD560048C7B2";
    in_no[3][47] = "C0BD68A6BA7E617F";
    in_no[3][48] = "B158DAD9877389A2";
    in_no[3][49] = "C8398EF0C6A8BD66";
    in_no[3][50] = "A1FEB0E1AB78F314";
    in_no[3][51] = "CDBC08152CC09416";
    in_no[3][52] = "B41D33C64C4C7E99";
    in_no[3][53] = "B75BDC3836934AE8";
    in_no[3][54] = "95F7036C237D5B00";
    in_no[3][55] = "D46649A33C01908C";
    in_no[3][56] = "CFBD283CF8F05665";
    in_no[3][57] = "E8AF9926FF4661C8";
    in_no[3][58] = "ABCD07742228E496";
    in_no[3][59] = "B897DDD664E50062";
    in_no[3][60] = "B838BCA641025A83";
    in_no[4][1] = "2FA89694DD6D675E";
    in_no[4][2] = "45E5BA589837C966";
    in_no[4][3] = "1FC3109F10D8A44A";
    in_no[4][4] = "3219981BC265797D";
    in_no[4][5] = "31221FE595436609";
    in_no[4][6] = "4EB95F14B9BA7449";
    in_no[4][7] = "2161C55B51BF7D27";
    in_no[4][8] = "23CB3E59DF05D8A3";
    in_no[4][9] = "4C3394270BBCBA7E";
    in_no[4][10] = "4E2092EDE17E8B48";
    in_no[4][11] = "3D5A800284A0E694";
    in_no[4][12] = "514C36E2CA1CA0AD";
    in_no[4][13] = "2233C84E4F9C80CE";
    in_no[4][14] = "4C623D287387686B";
    in_no[4][15] = "28A083A5B6DB26A9";
    in_no[4][16] = "48C76E7A53C8C81A";
    in_no[4][17] = "0FF2C18FEEBCAEAE";
    in_no[4][18] = "2B7C369E759DF5E3";
    in_no[4][19] = "1BD3653A458674FC";
    in_no[4][20] = "37C4FB657B5AA89F";
    in_no[4][21] = "4744E68960E85562";
    in_no[4][22] = "514DFBF07296E0D5";
    in_no[4][23] = "39C9B6F2E2AACA77";
    in_no[4][24] = "4CBD0460177B1553";
    in_no[4][25] = "4052F500C5CDBDEA";
    in_no[4][26] = "652F4217679238F6";
    in_no[4][27] = "4144712C6D9E227C";
    in_no[4][28] = "6748D276F38CD260";
    in_no[4][29] = "35019CA879C7C187";
    in_no[4][30] = "3E96F80E21866C06";
    in_no[4][31] = "1D092781EF99AB46";
    in_no[4][32] = "79ACCE4AB046843D";
    in_no[4][33] = "22C6AB931CEE2FD4";
    in_no[4][34] = "35F95CF42AA171CD";
    in_no[4][35] = "1ED1C1680A0C0B6C";
    in_no[4][36] = "54472B9A0E0A4B86";
    in_no[4][37] = "49136E874875BCC2";
    in_no[4][38] = "4C4B33CC462BC32D";
    in_no[4][39] = "2B927E9687937DD0";
    in_no[4][40] = "30F11B85141B78F6";
    in_no[4][41] = "56A419BD3B802B61";
    in_no[4][42] = "60EF33B09F0C558B";
    in_no[4][43] = "395A211040E355AE";
    in_no[4][44] = "4889EB2E04C9C099";
    in_no[4][45] = "29DC5D872AC1544D";
    in_no[4][46] = "3B392EFD09488689";
    in_no[4][47] = "30588217909D04F2";
    in_no[4][48] = "3DE719BA76049D42";
    in_no[4][49] = "20A7EBE381F4672F";
    in_no[4][50] = "4492493763542C73";
    in_no[4][51] = "32A778FC6FD65A71";
    in_no[4][52] = "4BFCFE27BB53DEBB";
    in_no[4][53] = "14FE139DD116F868";
    in_no[4][54] = "36EA4A8A68DAD1FA";
    in_no[4][55] = "4C07064732544856";
    in_no[4][56] = "5043544C696554D2";
    in_no[4][57] = "2AD671190BB5E2F2";
    in_no[4][58] = "64D18C6F488CBC30";
    in_no[4][59] = "34EF80BD5021BFD1";
    in_no[4][60] = "36A40B109F7DABE9";
    in_no[5][1] = "2FA89694DD6D675E";
    in_no[5][2] = "45E5BA589837C966";
    in_no[5][3] = "1FC3109F10D8A44A";
    in_no[5][4] = "3219981BC265797D";
    in_no[5][5] = "31221FE595436609";
    in_no[5][6] = "4EB95F14B9BA7449";
    in_no[5][7] = "2161C55B51BF7D27";
    in_no[5][8] = "23CB3E59DF05D8A3";
    in_no[5][9] = "4C3394270BBCBA7E";
    in_no[5][10] = "4E2092EDE17E8B48";
    in_no[5][11] = "3D5A800284A0E694";
    in_no[5][12] = "514C36E2CA1CA0AD";
    in_no[5][13] = "2233C84E4F9C80CE";
    in_no[5][14] = "4C623D287387686B";
    in_no[5][15] = "28A083A5B6DB26A9";
    in_no[5][16] = "48C76E7A53C8C81A";
    in_no[5][17] = "0FF2C18FEEBCAEAE";
    in_no[5][18] = "2B7C369E759DF5E3";
    in_no[5][19] = "1BD3653A458674FC";
    in_no[5][20] = "37C4FB657B5AA89F";
    in_no[5][21] = "4744E68960E85562";
    in_no[5][22] = "514DFBF07296E0D5";
    in_no[5][23] = "39C9B6F2E2AACA77";
    in_no[5][24] = "4CBD0460177B1553";
    in_no[5][25] = "4052F500C5CDBDEA";
    in_no[5][26] = "652F4217679238F6";
    in_no[5][27] = "4144712C6D9E227C";
    in_no[5][28] = "6748D276F38CD260";
    in_no[5][29] = "35019CA879C7C187";
    in_no[5][30] = "3E96F80E21866C06";
    in_no[5][31] = "1D092781EF99AB46";
    in_no[5][32] = "79ACCE4AB046843D";
    in_no[5][33] = "22C6AB931CEE2FD4";
    in_no[5][34] = "35F95CF42AA171CD";
    in_no[5][35] = "1ED1C1680A0C0B6C";
    in_no[5][36] = "54472B9A0E0A4B86";
    in_no[5][37] = "49136E874875BCC2";
    in_no[5][38] = "4C4B33CC462BC32D";
    in_no[5][39] = "2B927E9687937DD0";
    in_no[5][40] = "30F11B85141B78F6";
    in_no[5][41] = "56A419BD3B802B61";
    in_no[5][42] = "60EF33B09F0C558B";
    in_no[5][43] = "395A211040E355AE";
    in_no[5][44] = "4889EB2E04C9C099";
    in_no[5][45] = "29DC5D872AC1544D";
    in_no[5][46] = "3B392EFD09488689";
    in_no[5][47] = "30588217909D04F2";
    in_no[5][48] = "3DE719BA76049D42";
    in_no[5][49] = "20A7EBE381F4672F";
    in_no[5][50] = "4492493763542C73";
    in_no[5][51] = "32A778FC6FD65A71";
    in_no[5][52] = "4BFCFE27BB53DEBB";
    in_no[5][53] = "14FE139DD116F868";
    in_no[5][54] = "36EA4A8A68DAD1FA";
    in_no[5][55] = "4C07064732544856";
    in_no[5][56] = "5043544C696554D2";
    in_no[5][57] = "2AD671190BB5E2F2";
    in_no[5][58] = "64D18C6F488CBC30";
    in_no[5][59] = "34EF80BD5021BFD1";
    in_no[5][60] = "36A40B109F7DABE9";
    in_no[6][1] = "2FA89694DD6D675E";
    in_no[6][2] = "45E5BA589837C966";
    in_no[6][3] = "1FC3109F10D8A44A";
    in_no[6][4] = "3219981BC265797D";
    in_no[6][5] = "31221FE595436609";
    in_no[6][6] = "4EB95F14B9BA7449";
    in_no[6][7] = "2161C55B51BF7D27";
    in_no[6][8] = "23CB3E59DF05D8A3";
    in_no[6][9] = "4C3394270BBCBA7E";
    in_no[6][10] = "4E2092EDE17E8B48";
    in_no[6][11] = "3D5A800284A0E694";
    in_no[6][12] = "514C36E2CA1CA0AD";
    in_no[6][13] = "2233C84E4F9C80CE";
    in_no[6][14] = "4C623D287387686B";
    in_no[6][15] = "28A083A5B6DB26A9";
    in_no[6][16] = "48C76E7A53C8C81A";
    in_no[6][17] = "0FF2C18FEEBCAEAE";
    in_no[6][18] = "2B7C369E759DF5E3";
    in_no[6][19] = "1BD3653A458674FC";
    in_no[6][20] = "37C4FB657B5AA89F";
    in_no[6][21] = "4744E68960E85562";
    in_no[6][22] = "514DFBF07296E0D5";
    in_no[6][23] = "39C9B6F2E2AACA77";
    in_no[6][24] = "4CBD0460177B1553";
    in_no[6][25] = "4052F500C5CDBDEA";
    in_no[6][26] = "652F4217679238F6";
    in_no[6][27] = "4144712C6D9E227C";
    in_no[6][28] = "6748D276F38CD260";
    in_no[6][29] = "35019CA879C7C187";
    in_no[6][30] = "3E96F80E21866C06";
    in_no[6][31] = "1D092781EF99AB46";
    in_no[6][32] = "79ACCE4AB046843D";
    in_no[6][33] = "22C6AB931CEE2FD4";
    in_no[6][34] = "35F95CF42AA171CD";
    in_no[6][35] = "1ED1C1680A0C0B6C";
    in_no[6][36] = "54472B9A0E0A4B86";
    in_no[6][37] = "49136E874875BCC2";
    in_no[6][38] = "4C4B33CC462BC32D";
    in_no[6][39] = "2B927E9687937DD0";
    in_no[6][40] = "30F11B85141B78F6";
    in_no[6][41] = "56A419BD3B802B61";
    in_no[6][42] = "60EF33B09F0C558B";
    in_no[6][43] = "395A211040E355AE";
    in_no[6][44] = "4889EB2E04C9C099";
    in_no[6][45] = "29DC5D872AC1544D";
    in_no[6][46] = "3B392EFD09488689";
    in_no[6][47] = "30588217909D04F2";
    in_no[6][48] = "3DE719BA76049D42";
    in_no[6][49] = "20A7EBE381F4672F";
    in_no[6][50] = "4492493763542C73";
    in_no[6][51] = "32A778FC6FD65A71";
    in_no[6][52] = "4BFCFE27BB53DEBB";
    in_no[6][53] = "14FE139DD116F868";
    in_no[6][54] = "36EA4A8A68DAD1FA";
    in_no[6][55] = "4C07064732544856";
    in_no[6][56] = "5043544C696554D2";
    in_no[6][57] = "2AD671190BB5E2F2";
    in_no[6][58] = "64D18C6F488CBC30";
    in_no[6][59] = "34EF80BD5021BFD1";
    in_no[6][60] = "36A40B109F7DABE9";
    in_no[7][1] = "B6A4C8993B11D519";
    in_no[7][2] = "852B1D8F24F24DE3";
    in_no[7][3] = "A4B9EE1A9DB994F5";
    in_no[7][4] = "991B6451C0720BFB";
    in_no[7][5] = "C0559415FCFBFF18";
    in_no[7][6] = "8401B0BE7AC0AF65";
    in_no[7][7] = "A8B975299CCB0E08";
    in_no[7][8] = "1B677D8FA6B68B60";
    in_no[7][9] = "A9CA8E9C46A3D769";
    in_no[7][10] = "9CBC3A9CD7025105";
    in_no[7][11] = "AB69B66C64D19EE1";
    in_no[7][12] = "A640B8DBEBDFF270";
    in_no[7][13] = "BD732690AAC2472D";
    in_no[7][14] = "8EA0E0DD7B9E7391";
    in_no[7][15] = "B3940516BC314CC9";
    in_no[7][16] = "B347AD0659980C2B";
    in_no[7][17] = "2F6E80EF8FD19AD4";
    in_no[7][18] = "3B0BA9A1304C562D";
    in_no[7][19] = "A8A764BF1B176FF7";
    in_no[7][20] = "86C00BD1997CD82E";
    in_no[7][21] = "9B2B28F9484FFBFC";
    in_no[7][22] = "3F2C77C9276B791D";
    in_no[7][23] = "AB2388C331648E3E";
    in_no[7][24] = "9BF65ED85DF2D4B7";
    in_no[7][25] = "85896433E013EDA2";
    in_no[7][26] = "27D8620FAA09EADB";
    in_no[7][27] = "A14AB077C8E23EF5";
    in_no[7][28] = "3ED504D993745EAF";
    in_no[7][29] = "AD206D7F9AE94DAD";
    in_no[7][30] = "8BC9610758986A88";
    in_no[7][31] = "A0DAF3B21180E563";
    in_no[7][32] = "907068B13DA99666";
    in_no[7][33] = "9C72789C2D583BCD";
    in_no[7][34] = "8F3F2BD89DAD0665";
    in_no[7][35] = "9DE9FC9D1B0AFC7C";
    in_no[7][36] = "0F3580844B9DC45C";
    in_no[7][37] = "BCE8A11A53596037";
    in_no[7][38] = "167B1E6B793078DD";
    in_no[7][39] = "B86425EEF071014F";
    in_no[7][40] = "9DCBB2EFB4F70837";
    in_no[7][41] = "8818E96354BF7E11";
    in_no[7][42] = "80F039E2518CF503";
    in_no[7][43] = "B5A7BA62E3FBDD83";
    in_no[7][44] = "11B069E434EE9E0F";
    in_no[7][45] = "8F8E7802992BA99D";
    in_no[7][46] = "85F7883A587654E5";
    in_no[7][47] = "13F455801D3D2B63";
    in_no[7][48] = "3E4D2648ABC1E83D";
    in_no[7][49] = "A8804BE837A6F1F1";
    in_no[7][50] = "0FC173AB0FEC92AF";
    in_no[7][51] = "BAB7E13DBB66E5A3";
    in_no[7][52] = "9E5AF23D175AA3D2";
    in_no[7][53] = "AED07D4317CB3695";
    in_no[7][54] = "A10EF8B7BCBAB211";
    in_no[7][55] = "AB9FB31317BB132B";
    in_no[7][56] = "89470170EDBD047B";
    in_no[7][57] = "B028378F49913A88";
    in_no[7][58] = "1A053FAB12968E9A";
    in_no[7][59] = "B1679CA1AF65E50D";
    in_no[7][60] = "A52CD61131067370";
    in_no[8][1] = "B6A4C8993B11D519";
    in_no[8][2] = "852B1D8F24F24DE3";
    in_no[8][3] = "A4B9EE1A9DB994F5";
    in_no[8][4] = "991B6451C0720BFB";
    in_no[8][5] = "C0559415FCFBFF18";
    in_no[8][6] = "8401B0BE7AC0AF65";
    in_no[8][7] = "A8B975299CCB0E08";
    in_no[8][8] = "1B677D8FA6B68B60";
    in_no[8][9] = "A9CA8E9C46A3D769";
    in_no[8][10] = "9CBC3A9CD7025105";
    in_no[8][11] = "AB69B66C64D19EE1";
    in_no[8][12] = "A640B8DBEBDFF270";
    in_no[8][13] = "BD732690AAC2472D";
    in_no[8][14] = "8EA0E0DD7B9E7391";
    in_no[8][15] = "B3940516BC314CC9";
    in_no[8][16] = "B347AD0659980C2B";
    in_no[8][17] = "2F6E80EF8FD19AD4";
    in_no[8][18] = "3B0BA9A1304C562D";
    in_no[8][19] = "A8A764BF1B176FF7";
    in_no[8][20] = "86C00BD1997CD82E";
    in_no[8][21] = "9B2B28F9484FFBFC";
    in_no[8][22] = "3F2C77C9276B791D";
    in_no[8][23] = "AB2388C331648E3E";
    in_no[8][24] = "9BF65ED85DF2D4B7";
    in_no[8][25] = "85896433E013EDA2";
    in_no[8][26] = "27D8620FAA09EADB";
    in_no[8][27] = "A14AB077C8E23EF5";
    in_no[8][28] = "3ED504D993745EAF";
    in_no[8][29] = "AD206D7F9AE94DAD";
    in_no[8][30] = "8BC9610758986A88";
    in_no[8][31] = "A0DAF3B21180E563";
    in_no[8][32] = "907068B13DA99666";
    in_no[8][33] = "9C72789C2D583BCD";
    in_no[8][34] = "8F3F2BD89DAD0665";
    in_no[8][35] = "9DE9FC9D1B0AFC7C";
    in_no[8][36] = "0F3580844B9DC45C";
    in_no[8][37] = "BCE8A11A53596037";
    in_no[8][38] = "167B1E6B793078DD";
    in_no[8][39] = "B86425EEF071014F";
    in_no[8][40] = "9DCBB2EFB4F70837";
    in_no[8][41] = "8818E96354BF7E11";
    in_no[8][42] = "80F039E2518CF503";
    in_no[8][43] = "B5A7BA62E3FBDD83";
    in_no[8][44] = "11B069E434EE9E0F";
    in_no[8][45] = "8F8E7802992BA99D";
    in_no[8][46] = "85F7883A587654E5";
    in_no[8][47] = "13F455801D3D2B63";
    in_no[8][48] = "3E4D2648ABC1E83D";
    in_no[8][49] = "A8804BE837A6F1F1";
    in_no[8][50] = "0FC173AB0FEC92AF";
    in_no[8][51] = "BAB7E13DBB66E5A3";
    in_no[8][52] = "9E5AF23D175AA3D2";
    in_no[8][53] = "AED07D4317CB3695";
    in_no[8][54] = "A10EF8B7BCBAB211";
    in_no[8][55] = "AB9FB31317BB132B";
    in_no[8][56] = "89470170EDBD047B";
    in_no[8][57] = "B028378F49913A88";
    in_no[8][58] = "1A053FAB12968E9A";
    in_no[8][59] = "B1679CA1AF65E50D";
    in_no[8][60] = "A52CD61131067370";
    in_no[9][1] = "4051ABE4C698BADC";
    in_no[9][2] = "4051B03626B3E0FC";
    in_no[9][3] = "40637048632CF1D3";
    in_no[9][4] = "4063706CA82D6631";
    in_no[9][5] = "402C463ADBCD6522";
    in_no[9][6] = "402C4642AB313FAB";
    in_no[9][7] = "404D0F4CA2BB579C";
    in_no[9][8] = "404D0FB1659EC586";
    in_no[9][9] = "409141144B19D322";
    in_no[9][10] = "4091411451F7D15C";
    in_no[9][11] = "401F6A7A3099EC00";
    in_no[9][12] = "4025998E051427CA";
    in_no[9][13] = "40E9953D2ADC130E";
    in_no[9][14] = "40E9953FD66BD1A5";
    in_no[9][15] = "4087B58E9870D616";
    in_no[9][16] = "4087B58F56C876B7";
    in_no[9][17] = "40A7866EE95918A2";
    in_no[9][18] = "40A7866F1F2C8170";
    in_no[9][19] = "4012D97C809D003B";
    in_no[9][20] = "4012D97DA429140F";
    in_no[9][21] = "408E305163BA6C53";
    in_no[9][22] = "408E3053B5947216";
    in_no[9][23] = "401F6A7A2977CEDF";
    in_no[9][24] = "401F6AA73F91519B";
    in_no[9][25] = "404D0F4A998AD811";
    in_no[9][26] = "404D1B127E4DC260";
    in_no[9][27] = "401F6A7A2AC6DEDF";
    in_no[9][28] = "4021C94579773116";
    in_no[9][29] = "409521E0F04AC063";
    in_no[9][30] = "409521E18EA2831E";
    in_no[9][31] = "403AB41B772619C2";
    in_no[9][32] = "403AB96C295E1A23";
    in_no[9][33] = "40F87E20C8B7CCC1";
    in_no[9][34] = "40F87E20E060934F";
    in_no[9][35] = "4102DD2B14821824";
    in_no[9][36] = "4102DD2D30836EFA";
    in_no[9][37] = "407A9AF913EE27CF";
    in_no[9][38] = "407A9AFA6D06E549";
    in_no[9][39] = "409D933D00E94652";
    in_no[9][40] = "409D9344E7C644B9";
    in_no[9][41] = "411050DEC23E2E9C";
    in_no[9][42] = "411050E689FA1B54";
    in_no[9][43] = "4043A28C59DD7DBE";
    in_no[9][44] = "4043A28C6F2D3060";
    in_no[9][45] = "403DD85A7816A0FF";
    in_no[9][46] = "403DD89849DFDF09";
    in_no[9][47] = "403AB41B29964887";
    in_no[9][48] = "403B5CBD4ED0D1DD";
    in_no[9][49] = "40B19454E95BC804";
    in_no[9][50] = "40B194551E9AD95A";
    in_no[9][51] = "40931208F4B0C340";
    in_no[9][52] = "4093120B7AB8E573";
    in_no[9][53] = "403DD85BAAB9BAF9";
    in_no[9][54] = "403DD8660423BAAC";
    in_no[9][55] = "4107BCC5D9A9B348";
    in_no[9][56] = "4107BCD1B1984619";
    in_no[9][57] = "40378FDB9F143616";
    in_no[9][58] = "40378FDB9F143616";
    in_no[9][59] = "40378FDB9F143616";
    in_no[9][60] = "40379367E02D4EAA";
    in_no[10][1] = "4051475CD947AA27";
    in_no[10][2] = "40514BAE3962D047";
    in_no[10][3] = "40633E046C846979";
    in_no[10][4] = "40633E28B184DDD7";
    in_no[10][5] = "402921FB7144DF7F";
    in_no[10][6] = "4029220340A8BA08";
    in_no[10][7] = "404C463CC8193634";
    in_no[10][8] = "404C46A18AFCA41E";
    in_no[10][9] = "40913ACBCC44C217";
    in_no[10][10] = "40913ACBD322C051";
    in_no[10][11] = "401921FB5B88E0BB";
    in_no[10][12] = "4022754E9A8BA227";
    in_no[10][13] = "40E9950AE6E56A85";
    in_no[10][14] = "40E9950D9275291C";
    in_no[10][15] = "4087A8FD9AC6B400";
    in_no[10][16] = "4087A8FE591E54A1";
    in_no[10][17] = "40A7834AA9EE901C";
    in_no[10][18] = "40A7834ADFC1F8EA";
    in_no[10][19] = "400921FB5717E9EC";
    in_no[10][20] = "400921FD9E301192";
    in_no[10][21] = "408E23C066104A3C";
    in_no[10][22] = "408E23C2B7EA4FFF";
    in_no[10][23] = "401921FB5466C39A";
    in_no[10][24] = "401922286A804656";
    in_no[10][25] = "404C463ABEE8B6A9";
    in_no[10][26] = "404C5202A3ABA0F8";
    in_no[10][27] = "401921FB55B5D39A";
    in_no[10][28] = "401D4A0C1DDD56E7";
    in_no[10][29] = "40951B987175AF58";
    in_no[10][30] = "40951B990FCD7213";
    in_no[10][31] = "403921FBC1E1D6F1";
    in_no[10][32] = "4039274C7419D752";
    in_no[10][33] = "40F87E07A6BC787D";
    in_no[10][34] = "40F87E07BE653F0B";
    in_no[10][35] = "4102DD1E83846E02";
    in_no[10][36] = "4102DD209F85C4D8";
    in_no[10][37] = "407A81D71899E3A2";
    in_no[10][38] = "407A81D871B2A11C";
    in_no[10][39] = "409D8CF482143547";
    in_no[10][40] = "409D8CFC68F133AE";
    in_no[10][41] = "411050D879BF598B";
    in_no[10][42] = "411050E0417B4643";
    in_no[10][43] = "4042D97C7F3B5C56";
    in_no[10][44] = "4042D97C948B0EF8";
    in_no[10][45] = "403C463AC2D25E2E";
    in_no[10][46] = "403C4678949B9C38";
    in_no[10][47] = "403921FB745205B6";
    in_no[10][48] = "4039CA9D998C8F0C";
    in_no[10][49] = "40B192C2C9A683C1";
    in_no[10][50] = "40B192C2FEE59517";
    in_no[10][51] = "40930BC075DBB235";
    in_no[10][52] = "40930BC2FBE3D468";
    in_no[10][53] = "403C463BF5757828";
    in_no[10][54] = "403C46464EDF77DB";
    in_no[10][55] = "4107BCB948AC0926";
    in_no[10][56] = "4107BCC5209A9BF7";
    in_no[10][57] = "4089B8CA1F29B74F";
    in_no[10][58] = "4089B8E83C2349FD";
    in_no[10][59] = "4035FDBBE9CFF344";
    in_no[10][60] = "403601482AE90BD8";
    in_no[11][1] = "B5C88D184A3AF3B1";
    in_no[11][2] = "95A86F08605C2AA0";
    in_no[11][3] = "AE95F745E909234E";
    in_no[11][4] = "98044C7E079C37BA";
    in_no[11][5] = "ADADB07B9AFEAC94";
    in_no[11][6] = "90362F61FBA0F40F";
    in_no[11][7] = "84F67712A1E64C2C";
    in_no[11][8] = "82FC0102C4D258EF";
    in_no[11][9] = "12871ECC8D742334";
    in_no[11][10] = "19B92C3C728CCF4A";
    in_no[11][11] = "97FBCD3FEB3B0175";
    in_no[11][12] = "1E7BEBE69E3BF3C2";
    in_no[11][13] = "A8B2469575189327";
    in_no[11][14] = "811D47030E7D6293";
    in_no[11][15] = "AAFC4D163A6CCCD9";
    in_no[11][16] = "8E33BEE6DAB70397";
    in_no[11][17] = "88007D72EF4864C6";
    in_no[11][18] = "830103CBBBF6120C";
    in_no[11][19] = "8CF08C248C37E53B";
    in_no[11][20] = "04C464F82772EF42";
    in_no[11][21] = "B1C00012A1580A3A";
    in_no[11][22] = "0E426ACF90BDFBA6";
    in_no[11][23] = "0B6BA8067112E534";
    in_no[11][24] = "1D5D11146FE4675E";
    in_no[11][25] = "BC00448C580B4CAE";
    in_no[11][26] = "2F49FE1322863725";
    in_no[11][27] = "A7C3364ADEC6BB8B";
    in_no[11][28] = "3177E16B310F878A";
    in_no[11][29] = "B00ECE335E985BBA";
    in_no[11][30] = "A392A30C3D9E32DA";
    in_no[11][31] = "8DBAA045CCB15AED";
    in_no[11][32] = "3EAA8A188E64CAC2";
    in_no[11][33] = "AA811D6FD2B8FE1E";
    in_no[11][34] = "89B30D1074DC059E";
    in_no[11][35] = "BBCEFDE0D25F9C44";
    in_no[11][36] = "8B92A278E6C91F21";
    in_no[11][37] = "2122B060C8A4BA6E";
    in_no[11][38] = "268633B2978352AF";
    in_no[11][39] = "AD09C5FC40761841";
    in_no[11][40] = "A01DEC661DF94DAB";
    in_no[11][41] = "BD456DF81B91C381";
    in_no[11][42] = "1CB98DC940C3AE1E";
    in_no[11][43] = "AB93929E7122CE96";
    in_no[11][44] = "0AA451605CB3A73B";
    in_no[11][45] = "B19A034FA1EE4476";
    in_no[11][46] = "9F81EFAA10962372";
    in_no[11][47] = "A1F4E54C309C46F8";
    in_no[11][48] = "15228FD3055907F3";
    in_no[11][49] = "8D813B101113D36F";
    in_no[11][50] = "0FFC53E9BA64FADF";
    in_no[11][51] = "B2D2392D35EE9B74";
    in_no[11][52] = "9DB4B35284C1064B";
    in_no[11][53] = "B08AE295C6CFFAC1";
    in_no[11][54] = "87057C346B295C33";
    in_no[11][55] = "14B6938CC5EE183A";
    in_no[11][56] = "16A7EF4B0758702D";
    in_no[11][57] = "9D0B459AF91D9283";
    in_no[11][58] = "2D23F39248DA0A27";
    in_no[11][59] = "9FE57BCE16D0A1D4";
    in_no[11][60] = "0045DBB6ADFB81FD";
    in_no[12][1] = "B5C88D184A3AF3B1";
    in_no[12][2] = "95A86F08605C2AA0";
    in_no[12][3] = "AE95F745E909234E";
    in_no[12][4] = "98044C7E079C37BA";
    in_no[12][5] = "ADADB07B9AFEAC94";
    in_no[12][6] = "90362F61FBA0F40F";
    in_no[12][7] = "84F67712A1E64C2C";
    in_no[12][8] = "82FC0102C4D258EF";
    in_no[12][9] = "12871ECC8D742334";
    in_no[12][10] = "19B92C3C728CCF4A";
    in_no[12][11] = "97FBCD3FEB3B0175";
    in_no[12][12] = "1E7BEBE69E3BF3C2";
    in_no[12][13] = "A8B2469575189327";
    in_no[12][14] = "811D47030E7D6293";
    in_no[12][15] = "AAFC4D163A6CCCD9";
    in_no[12][16] = "8E33BEE6DAB70397";
    in_no[12][17] = "88007D72EF4864C6";
    in_no[12][18] = "830103CBBBF6120C";
    in_no[12][19] = "8CF08C248C37E53B";
    in_no[12][20] = "04C464F82772EF42";
    in_no[12][21] = "B1C00012A1580A3A";
    in_no[12][22] = "0E426ACF90BDFBA6";
    in_no[12][23] = "0B6BA8067112E534";
    in_no[12][24] = "1D5D11146FE4675E";
    in_no[12][25] = "BC00448C580B4CAE";
    in_no[12][26] = "2F49FE1322863725";
    in_no[12][27] = "A7C3364ADEC6BB8B";
    in_no[12][28] = "3177E16B310F878A";
    in_no[12][29] = "B00ECE335E985BBA";
    in_no[12][30] = "A392A30C3D9E32DA";
    in_no[12][31] = "8DBAA045CCB15AED";
    in_no[12][32] = "3EAA8A188E64CAC2";
    in_no[12][33] = "AA811D6FD2B8FE1E";
    in_no[12][34] = "89B30D1074DC059E";
    in_no[12][35] = "BBCEFDE0D25F9C44";
    in_no[12][36] = "8B92A278E6C91F21";
    in_no[12][37] = "2122B060C8A4BA6E";
    in_no[12][38] = "268633B2978352AF";
    in_no[12][39] = "AD09C5FC40761841";
    in_no[12][40] = "A01DEC661DF94DAB";
    in_no[12][41] = "BD456DF81B91C381";
    in_no[12][42] = "1CB98DC940C3AE1E";
    in_no[12][43] = "AB93929E7122CE96";
    in_no[12][44] = "0AA451605CB3A73B";
    in_no[12][45] = "B19A034FA1EE4476";
    in_no[12][46] = "9F81EFAA10962372";
    in_no[12][47] = "A1F4E54C309C46F8";
    in_no[12][48] = "15228FD3055907F3";
    in_no[12][49] = "8D813B101113D36F";
    in_no[12][50] = "0FFC53E9BA64FADF";
    in_no[12][51] = "B2D2392D35EE9B74";
    in_no[12][52] = "9DB4B35284C1064B";
    in_no[12][53] = "B08AE295C6CFFAC1";
    in_no[12][54] = "87057C346B295C33";
    in_no[12][55] = "14B6938CC5EE183A";
    in_no[12][56] = "16A7EF4B0758702D";
    in_no[12][57] = "9D0B459AF91D9283";
    in_no[12][58] = "2D23F39248DA0A27";
    in_no[12][59] = "9FE57BCE16D0A1D4";
    in_no[12][60] = "0045DBB6ADFB81FD";
    in_no[13][1] = "3177A77BFCCF5A9E";
    in_no[13][2] = "470422BDE014CC37";
    in_no[13][3] = "204E2F6187DDB464";
    in_no[13][4] = "32581702EC6F2DCC";
    in_no[13][5] = "336C41FE837A300B";
    in_no[13][6] = "5104D84C8CDFCECF";
    in_no[13][7] = "23803AEFCC5923C6";
    in_no[13][8] = "25F1503444763FC5";
    in_no[13][9] = "4FB5444E676976F1";
    in_no[13][10] = "5243E0327B49491A";
    in_no[13][11] = "3FF3A01905E36F84";
    in_no[13][12] = "54D3B2F21561C420";
    in_no[13][13] = "248202722624E322";
    in_no[13][14] = "4EDCCBB6ADFD8294";
    in_no[13][15] = "2A763A15E999EB64";
    in_no[13][16] = "4AD9498F3E13BCE2";
    in_no[13][17] = "10DA507D1C29C01D";
    in_no[13][18] = "2DF4171976A1CA54";
    in_no[13][19] = "1CDDE287D1D68C1B";
    in_no[13][20] = "3B51A6EC74D2E55C";
    in_no[13][21] = "4B3BA04D452BBB35";
    in_no[13][22] = "537F0D19ADCB5D74";
    in_no[13][23] = "3D0355E0AABCD959";
    in_no[13][24] = "50070236DAAA01BE";
    in_no[13][25] = "40A052F533DB3DA1";
    in_no[13][26] = "68EC678939EB70F2";
    in_no[13][27] = "430A1B6FF47840CA";
    in_no[13][28] = "6B0534D4B4BB97EF";
    in_no[13][29] = "3558F96439899147";
    in_no[13][30] = "4077AAA15EBBD3F2";
    in_no[13][31] = "1E1AB3E906363E4B";
    in_no[13][32] = "7DC47C9025E2020F";
    in_no[13][33] = "2485DAB859AB6365";
    in_no[13][34] = "36C5802285246AC3";
    in_no[13][35] = "2028826528C34186";
    in_no[13][36] = "55F9E7DDBBE00F75";
    in_no[13][37] = "4BD9A5E124A8C193";
    in_no[13][38] = "4EEABC408B9DD2E4";
    in_no[13][39] = "2C5F7A98177B25F3";
    in_no[13][40] = "3135BD629B25AA23";
    in_no[13][41] = "5AAA0BD399ECD9EB";
    in_no[13][42] = "636752884A66E610";
    in_no[13][43] = "3C99975F82891DDE";
    in_no[13][44] = "4A8D70EE09D32965";
    in_no[13][45] = "2A94AD560048C7B2";
    in_no[13][46] = "3BE44F68AAA2B029";
    in_no[13][47] = "3158DAD9877389A2";
    in_no[13][48] = "40BD68A6BA7E617F";
    in_no[13][49] = "21FEB0E1AB78F314";
    in_no[13][50] = "48398EF0C6A8BD66";
    in_no[13][51] = "341D33C64C4C7E99";
    in_no[13][52] = "4DBC08152CC09416";
    in_no[13][53] = "15F7036C237D5B00";
    in_no[13][54] = "375BDC3836934AE8";
    in_no[13][55] = "4FBD283CF8F05665";
    in_no[13][56] = "546649A33C01908C";
    in_no[13][57] = "2BCD07742228E496";
    in_no[13][58] = "68AF9926FF4661C8";
    in_no[13][59] = "3838BCA641025A83";
    in_no[13][60] = "3897DDD664E50062";
    in_no[14][1] = "3177A77BFCCF5A9E";
    in_no[14][2] = "470422BDE014CC37";
    in_no[14][3] = "204E2F6187DDB464";
    in_no[14][4] = "32581702EC6F2DCC";
    in_no[14][5] = "336C41FE837A300B";
    in_no[14][6] = "5104D84C8CDFCECF";
    in_no[14][7] = "23803AEFCC5923C6";
    in_no[14][8] = "25F1503444763FC5";
    in_no[14][9] = "4FB5444E676976F1";
    in_no[14][10] = "5243E0327B49491A";
    in_no[14][11] = "3FF3A01905E36F84";
    in_no[14][12] = "54D3B2F21561C420";
    in_no[14][13] = "248202722624E322";
    in_no[14][14] = "4EDCCBB6ADFD8294";
    in_no[14][15] = "2A763A15E999EB64";
    in_no[14][16] = "4AD9498F3E13BCE2";
    in_no[14][17] = "10DA507D1C29C01D";
    in_no[14][18] = "2DF4171976A1CA54";
    in_no[14][19] = "1CDDE287D1D68C1B";
    in_no[14][20] = "3B51A6EC74D2E55C";
    in_no[14][21] = "4B3BA04D452BBB35";
    in_no[14][22] = "537F0D19ADCB5D74";
    in_no[14][23] = "3D0355E0AABCD959";
    in_no[14][24] = "50070236DAAA01BE";
    in_no[14][25] = "40A052F533DB3DA1";
    in_no[14][26] = "68EC678939EB70F2";
    in_no[14][27] = "430A1B6FF47840CA";
    in_no[14][28] = "6B0534D4B4BB97EF";
    in_no[14][29] = "3558F96439899147";
    in_no[14][30] = "4077AAA15EBBD3F2";
    in_no[14][31] = "1E1AB3E906363E4B";
    in_no[14][32] = "7DC47C9025E2020F";
    in_no[14][33] = "2485DAB859AB6365";
    in_no[14][34] = "36C5802285246AC3";
    in_no[14][35] = "2028826528C34186";
    in_no[14][36] = "55F9E7DDBBE00F75";
    in_no[14][37] = "4BD9A5E124A8C193";
    in_no[14][38] = "4EEABC408B9DD2E4";
    in_no[14][39] = "2C5F7A98177B25F3";
    in_no[14][40] = "3135BD629B25AA23";
    in_no[14][41] = "5AAA0BD399ECD9EB";
    in_no[14][42] = "636752884A66E610";
    in_no[14][43] = "3C99975F82891DDE";
    in_no[14][44] = "4A8D70EE09D32965";
    in_no[14][45] = "2A94AD560048C7B2";
    in_no[14][46] = "3BE44F68AAA2B029";
    in_no[14][47] = "3158DAD9877389A2";
    in_no[14][48] = "40BD68A6BA7E617F";
    in_no[14][49] = "21FEB0E1AB78F314";
    in_no[14][50] = "48398EF0C6A8BD66";
    in_no[14][51] = "341D33C64C4C7E99";
    in_no[14][52] = "4DBC08152CC09416";
    in_no[14][53] = "15F7036C237D5B00";
    in_no[14][54] = "375BDC3836934AE8";
    in_no[14][55] = "4FBD283CF8F05665";
    in_no[14][56] = "546649A33C01908C";
    in_no[14][57] = "2BCD07742228E496";
    in_no[14][58] = "68AF9926FF4661C8";
    in_no[14][59] = "3838BCA641025A83";
    in_no[14][60] = "3897DDD664E50062";
    in_no[15][1] =  "B60A9EE4A4B6F050";
    in_no[15][2] = "842850FC1C21D837";
    in_no[15][3] = "A3BCF3637DCBCC9A";
    in_no[15][4] = "98579211918BFCCF";
    in_no[15][5] = "BFF0362421843787";
    in_no[15][6] = "8349E96677B4C52D";
    in_no[15][7] = "A83494A24A7585D1";
    in_no[15][8] = "1A3A0790A9E3013E";
    in_no[15][9] = "A905B25E2F4CCC33";
    in_no[15][10] = "9C6E0C6608222185";
    in_no[15][11] = "AB1D5BD4BD3FB615";
    in_no[15][12] = "A613D028E4D2CCD5";
    in_no[15][13] = "BD241C6785752B91";
    in_no[15][14] = "8D71927CA3847669";
    in_no[15][15] = "B2F1BBBD6FE8B950";
    in_no[15][16] = "B23463A32DBA649D";
    in_no[15][17] = "2F54A43FA124554C";
    in_no[15][18] = "39F8C9AF520C22C3";
    in_no[15][19] = "A8073999632A55DB";
    in_no[15][20] = "85B4363967367F55";
    in_no[15][21] = "9AF55EBB1D70A46E";
    in_no[15][22] = "3ED1CCFE9451A14C";
    in_no[15][23] = "AAB1B4B8388A3D92";
    in_no[15][24] = "9AAAA3A9479C9892";
    in_no[15][25] = "849086DCDD16F130";
    in_no[15][26] = "26EBC81B0724787C";
    in_no[15][27] = "A0773D14FA7DA1CB";
    in_no[15][28] = "3E35B3AFEEB17A85";
    in_no[15][29] = "AC09E69A4CBEF833";
    in_no[15][30] = "8AB606C7BCE75819";
    in_no[15][31] = "9FE8A6AD4ADCB2E9";
    in_no[15][32] = "8FB33B9A95C55513";
    in_no[15][33] = "9B57EA21E54298F3";
    in_no[15][34] = "8E05B83BA0D8AA3C";
    in_no[15][35] = "9DC4A3B2325572DD";
    in_no[15][36] = "0F101CD385F009B5";
    in_no[15][37] = "BBEF48D580B61D55";
    in_no[15][38] = "153EFA89F34F4188";
    in_no[15][39] = "B86329119640B5F5";
    in_no[15][40] = "9D44A00C068D5157";
    in_no[15][41] = "870FCECFF2BC9670";
    in_no[15][42] = "808F807E4671256E";
    in_no[15][43] = "B51F568A3BE035AC";
    in_no[15][44] = "10E8BA571FF9655B";
    in_no[15][45] = "8F16D772AA08698A";
    in_no[15][46] = "85348532232C10FD";
    in_no[15][47] = "130C088689D581BC";
    in_no[15][48] = "3D43BA1170C4C0E1";
    in_no[15][49] = "A834AD562C0B5178";
    in_no[15][50] = "0E8E759A7A0754DD";
    in_no[15][51] = "BA5FB40BBD5B902C";
    in_no[15][52] = "9D78C80275A696B0";
    in_no[15][53] = "AD756FBE834FC822";
    in_no[15][54] = "9FCB3020AAC5D654";
    in_no[15][55] = "AAD911493DBF33E3";
    in_no[15][56] = "8814FA3B55DA84CD";
    in_no[15][57] = "AF6125EB7DB4B38F";
    in_no[15][58] = "19C28D88E1763B5D";
    in_no[15][59] = "B0D1E1711AF70A94";
    in_no[15][60] = "A4FBA5C062DE8F00";
    in_no[16][1] = "B60A9EE4A4B6F050";
    in_no[16][2] = "842850FC1C21D837";
    in_no[16][3] = "A3BCF3637DCBCC9A";
    in_no[16][4] = "98579211918BFCCF";
    in_no[16][5] = "BFF0362421843787";
    in_no[16][6] = "8349E96677B4C52D";
    in_no[16][7] = "A83494A24A7585D1";
    in_no[16][8] = "1A3A0790A9E3013E";
    in_no[16][9] = "A905B25E2F4CCC33";
    in_no[16][10] = "9C6E0C6608222185";
    in_no[16][11] = "AB1D5BD4BD3FB615";
    in_no[16][12] = "A613D028E4D2CCD5";
    in_no[16][13] = "BD241C6785752B91";
    in_no[16][14] = "8D71927CA3847669";
    in_no[16][15] = "B2F1BBBD6FE8B950";
    in_no[16][16] = "B23463A32DBA649D";
    in_no[16][17] = "2F54A43FA124554C";
    in_no[16][18] = "39F8C9AF520C22C3";
    in_no[16][19] = "A8073999632A55DB";
    in_no[16][20] = "85B4363967367F55";
    in_no[16][21] = "9AF55EBB1D70A46E";
    in_no[16][22] = "3ED1CCFE9451A14C";
    in_no[16][23] = "AAB1B4B8388A3D92";
    in_no[16][24] = "9AAAA3A9479C9892";
    in_no[16][25] = "849086DCDD16F130";
    in_no[16][26] = "26EBC81B0724787C";
    in_no[16][27] = "A0773D14FA7DA1CB";
    in_no[16][28] = "3E35B3AFEEB17A85";
    in_no[16][29] = "AC09E69A4CBEF833";
    in_no[16][30] = "8AB606C7BCE75819";
    in_no[16][31] = "9FE8A6AD4ADCB2E9";
    in_no[16][32] = "8FB33B9A95C55513";
    in_no[16][33] = "9B57EA21E54298F3";
    in_no[16][34] = "8E05B83BA0D8AA3C";
    in_no[16][35] = "9DC4A3B2325572DD";
    in_no[16][36] = "0F101CD385F009B5";
    in_no[16][37] = "BBEF48D580B61D55";
    in_no[16][38] = "153EFA89F34F4188";
    in_no[16][39] = "B86329119640B5F5";
    in_no[16][40] = "9D44A00C068D5157";
    in_no[16][41] = "870FCECFF2BC9670";
    in_no[16][42] = "808F807E4671256E";
    in_no[16][43] = "B51F568A3BE035AC";
    in_no[16][44] = "10E8BA571FF9655B";
    in_no[16][45] = "8F16D772AA08698A";
    in_no[16][46] = "85348532232C10FD";
    in_no[16][47] = "130C088689D581BC";
    in_no[16][48] = "3D43BA1170C4C0E1";
    in_no[16][49] = "A834AD562C0B5178";
    in_no[16][50] = "0E8E759A7A0754DD";
    in_no[16][51] = "BA5FB40BBD5B902C";
    in_no[16][52] = "9D78C80275A696B0";
    in_no[16][53] = "AD756FBE834FC822";
    in_no[16][54] = "9FCB3020AAC5D654";
    in_no[16][55] = "AAD911493DBF33E3";
    in_no[16][56] = "8814FA3B55DA84CD";
    in_no[16][57] = "AF6125EB7DB4B38F";
    in_no[16][58] = "19C28D88E1763B5D";
    in_no[16][59] = "B0D1E1711AF70A94";
    in_no[16][60] = "A4FBA5C062DE8F00";
    in_no[17][1] = "3177A77BFCCF5A9E";
    in_no[17][2] = "470422BDE014CC37";
    in_no[17][3] = "204E2F6187DDB464";
    in_no[17][4] = "32581702EC6F2DCC";
    in_no[17][5] = "336C41FE837A300B";
    in_no[17][6] = "5104D84C8CDFCECF";
    in_no[17][7] = "23803AEFCC5923C6";
    in_no[17][8] = "25F1503444763FC5";
    in_no[17][9] = "4FB5444E676976F1";
    in_no[17][10] = "5243E0327B49491A";
    in_no[17][11] = "3FF3A01905E36F84";
    in_no[17][12] = "54D3B2F21561C420";
    in_no[17][13] = "248202722624E322";
    in_no[17][14] = "4EDCCBB6ADFD8294";
    in_no[17][15] = "2A763A15E999EB64";
    in_no[17][16] = "4AD9498F3E13BCE2";
    in_no[17][17] = "10DA507D1C29C01D";
    in_no[17][18] = "2DF4171976A1CA54";
    in_no[17][19] = "1CDDE287D1D68C1B";
    in_no[17][20] = "3B51A6EC74D2E55C";
    in_no[17][21] = "4B3BA04D452BBB35";
    in_no[17][22] = "537F0D19ADCB5D74";
    in_no[17][23] = "3D0355E0AABCD959";
    in_no[17][24] = "50070236DAAA01BE";
    in_no[17][25] = "40A052F533DB3DA1";
    in_no[17][26] = "68EC678939EB70F2";
    in_no[17][27] = "430A1B6FF47840CA";
    in_no[17][28] = "6B0534D4B4BB97EF";
    in_no[17][29] = "3558F96439899147";
    in_no[17][30] = "4077AAA15EBBD3F2";
    in_no[17][31] = "1E1AB3E906363E4B";
    in_no[17][32] = "7DC47C9025E2020F";
    in_no[17][33] = "2485DAB859AB6365";
    in_no[17][34] = "36C5802285246AC3";
    in_no[17][35] = "2028826528C34186";
    in_no[17][36] = "55F9E7DDBBE00F75";
    in_no[17][37] = "4BD9A5E124A8C193";
    in_no[17][38] = "4EEABC408B9DD2E4";
    in_no[17][39] = "2C5F7A98177B25F3";
    in_no[17][40] = "3135BD629B25AA23";
    in_no[17][41] = "5AAA0BD399ECD9EB";
    in_no[17][42] = "636752884A66E610";
    in_no[17][43] = "3C99975F82891DDE";
    in_no[17][44] = "4A8D70EE09D32965";
    in_no[17][45] = "2A94AD560048C7B2";
    in_no[17][46] = "3BE44F68AAA2B029";
    in_no[17][47] = "3158DAD9877389A2";
    in_no[17][48] = "40BD68A6BA7E617F";
    in_no[17][49] = "21FEB0E1AB78F314";
    in_no[17][50] = "48398EF0C6A8BD66";
    in_no[17][51] = "341D33C64C4C7E99";
    in_no[17][52] = "4DBC08152CC09416";
    in_no[17][53] = "15F7036C237D5B00";
    in_no[17][54] = "375BDC3836934AE8";
    in_no[17][55] = "4FBD283CF8F05665";
    in_no[17][56] = "546649A33C01908C";
    in_no[17][57] = "2BCD07742228E496";
    in_no[17][58] = "68AF9926FF4661C8";
    in_no[17][59] = "3838BCA641025A83";
    in_no[17][60] = "3897DDD664E50062";
    in_no[18][1] = "2F9675FBBAA6E7B8";
    in_no[18][2] = "45CF81E83281E551";
    in_no[18][3] = "C5CF81E83281E551";
    in_no[18][4] = "AF9675FBBAA6E7B8";
    in_no[18][5] = "1FA6CC01E471FC0C";
    in_no[18][6] = "31FBB63631B595B0";
    in_no[18][7] = "B1FBB63631B595B0";
    in_no[18][8] = "9FA6CC01E471FC0C";
    in_no[18][9] = "31137227B400D31B";
    in_no[18][10] = "4EAB43A23147123D";
    in_no[18][11] = "CEAB43A23147123D";
    in_no[18][12] = "B1137227B400D31B";
    in_no[18][13] = "2151FE4FE1E69869";
    in_no[18][14] = "23BBDC6388153882";
    in_no[18][15] = "A3BBDC6388153882";
    in_no[18][16] = "A151FE4FE1E69869";
    in_no[18][17] = "4C2F8F9251B376E3";
    in_no[18][18] = "4E20834F2A8C0B53";
    in_no[18][19] = "CE20834F2A8C0B53";
    in_no[18][20] = "CC2F8F9251B376E3";
    in_no[18][21] = "3D4F83E05C002938";
    in_no[18][22] = "5146E9E42C07E5F0";
    in_no[18][23] = "D146E9E42C07E5F0";
    in_no[18][24] = "BD4F83E05C002938";
    in_no[18][25] = "222552FBDA53FFE6";
    in_no[18][26] = "4C54D7BAA7141218";
    in_no[18][27] = "CC54D7BAA7141218";
    in_no[18][28] = "A22552FBDA53FFE6";
    in_no[18][29] = "288E7A5B93A28A01";
    in_no[18][30] = "48B759F6C21DAF9A";
    in_no[18][31] = "C8B759F6C21DAF9A";
    in_no[18][32] = "A88E7A5B93A28A01";
    in_no[18][33] = "0FD954DDBD307143";
    in_no[18][34] = "2B70120DD4EBC019";
    in_no[18][35] = "AB70120DD4EBC019";
    in_no[18][36] = "8FD954DDBD307143";
    in_no[18][37] = "1BBB63F1F7AED49E";
    in_no[18][38] = "37C122D7ADE599AB";
    in_no[18][39] = "B7C122D7ADE599AB";
    in_no[18][40] = "9BBB63F1F7AED49E";
    in_no[18][41] = "47439D91E646C7BB";
    in_no[18][42] = "513F1E4F59403FC3";
    in_no[18][43] = "D13F1E4F59403FC3";
    in_no[18][44] = "C7439D91E646C7BB";
    in_no[18][45] = "39C2DA7AFB8E52FE";
    in_no[18][46] = "4CB5C244CE1AC6B3";
    in_no[18][47] = "CCB5C244CE1AC6B3";
    in_no[18][48] = "B9C2DA7AFB8E52FE";
    in_no[18][49] = "4034E7212DD5ABB9";
    in_no[18][50] = "652B3E6BCC3FBEFD";
    in_no[18][51] = "E52B3E6BCC3FBEFD";
    in_no[18][52] = "C034E7212DD5ABB9";
    in_no[18][53] = "413271B33491E515";
    in_no[18][54] = "67459818E79D7A76";
    in_no[18][55] = "E7459818E79D7A76";
    in_no[18][56] = "C13271B33491E515";
    in_no[18][57] = "34E3B6C6BC5FEA56";
    in_no[18][58] = "3E857820BB292683";
    in_no[18][59] = "BE857820BB292683";
    in_no[18][60] = "B4E3B6C6BC5FEA56";
    in_no[19][1] = "3177A77BFCCF5A9E";
    in_no[19][2] = "470422BDE014CC37";
    in_no[19][3] = "204E2F6187DDB464";
    in_no[19][4] = "32581702EC6F2DCC";
    in_no[19][5] = "336C41FE837A300B";
    in_no[19][6] = "5104D84C8CDFCECF";
    in_no[19][7] = "23803AEFCC5923C6";
    in_no[19][8] = "25F1503444763FC5";
    in_no[19][9] = "4FB5444E676976F1";
    in_no[19][10] = "5243E0327B49491A";
    in_no[19][11] = "3FF3A01905E36F84";
    in_no[19][12] = "54D3B2F21561C420";
    in_no[19][13] = "248202722624E322";
    in_no[19][14] = "4EDCCBB6ADFD8294";
    in_no[19][15] = "2A763A15E999EB64";
    in_no[19][16] = "4AD9498F3E13BCE2";
    in_no[19][17] = "10DA507D1C29C01D";
    in_no[19][18] = "2DF4171976A1CA54";
    in_no[19][19] = "1CDDE287D1D68C1B";
    in_no[19][20] = "3B51A6EC74D2E55C";
    in_no[19][21] = "4B3BA04D452BBB35";
    in_no[19][22] = "537F0D19ADCB5D74";
    in_no[19][23] = "3D0355E0AABCD959";
    in_no[19][24] = "50070236DAAA01BE";
    in_no[19][25] = "40A052F533DB3DA1";
    in_no[19][26] = "68EC678939EB70F2";
    in_no[19][27] = "430A1B6FF47840CA";
    in_no[19][28] = "6B0534D4B4BB97EF";
    in_no[19][29] = "3558F96439899147";
    in_no[19][30] = "4077AAA15EBBD3F2";
    in_no[19][31] = "1E1AB3E906363E4B";
    in_no[19][32] = "7DC47C9025E2020F";
    in_no[19][33] = "2485DAB859AB6365";
    in_no[19][34] = "36C5802285246AC3";
    in_no[19][35] = "2028826528C34186";
    in_no[19][36] = "55F9E7DDBBE00F75";
    in_no[19][37] = "4BD9A5E124A8C193";
    in_no[19][38] = "4EEABC408B9DD2E4";
    in_no[19][39] = "2C5F7A98177B25F3";
    in_no[19][40] = "3135BD629B25AA23";
    in_no[19][41] = "5AAA0BD399ECD9EB";
    in_no[19][42] = "636752884A66E610";
    in_no[19][43] = "3C99975F82891DDE";
    in_no[19][44] = "4A8D70EE09D32965";
    in_no[19][45] = "2A94AD560048C7B2";
    in_no[19][46] = "3BE44F68AAA2B029";
    in_no[19][47] = "3158DAD9877389A2";
    in_no[19][48] = "40BD68A6BA7E617F";
    in_no[19][49] = "21FEB0E1AB78F314";
    in_no[19][50] = "48398EF0C6A8BD66";
    in_no[19][51] = "341D33C64C4C7E99";
    in_no[19][52] = "4DBC08152CC09416";
    in_no[19][53] = "15F7036C237D5B00";
    in_no[19][54] = "375BDC3836934AE8";
    in_no[19][55] = "4FBD283CF8F05665";
    in_no[19][56] = "546649A33C01908C";
    in_no[19][57] = "2BCD07742228E496";
    in_no[19][58] = "68AF9926FF4661C8";
    in_no[19][59] = "3838BCA641025A83";
    in_no[19][60] = "3897DDD664E50062";
    in_no[20][1] = "5116B626B453771D";
    in_no[20][2] = "75C3762E98B3852F";
    in_no[20][3] = "5592915F0D619250";
    in_no[20][4] = "5BC1D6F7DAA5E024";
    in_no[20][5] = "439A50722E541B64";
    in_no[20][6] = "6E8D88EC041D74AC";
    in_no[20][7] = "48309A940A083EE3";
    in_no[20][8] = "57F047FD514ADF08";
    in_no[20][9] = "501DC41D02DC6835";
    in_no[20][10] = "632F80F31A2AD7F4";
    in_no[20][11] = "6341B90D00FB822B";
    in_no[20][12] = "6DA38C577E63FA52";
    in_no[20][13] = "42DBC1B514AF73BC";
    in_no[20][14] = "6082412C989B35DE";
    in_no[20][15] = "44D74C9B52C220F6";
    in_no[20][16] = "60F77175C5A113AD";
    in_no[20][17] = "52705ADFE119D4C2";
    in_no[20][18] = "7FC35E6FA8702F1A";
    in_no[20][19] = "59A4FEBA4AB7024D";
    in_no[20][20] = "75F9D1EDDC132B36";
    in_no[20][21] = "5E69F7C9C58DA150";
    in_no[20][22] = "76537DD6F705F0CC";
    in_no[20][23] = "57E6482065F2E014";
    in_no[20][24] = "67F04A65B06B2920";
    in_no[20][25] = "6617C81FABD7E2ED";
    in_no[20][26] = "68A5790F8DF215DC";
    in_no[20][27] = "40FBCD62C46ADFD7";
    in_no[20][28] = "63659A51366BD9A0";
    in_no[20][29] = "4E194D2EE90282D1";
    in_no[20][30] = "5C38DE35856E91FB";
    in_no[20][31] = "5FC627AC8097A724";
    in_no[20][32] = "6AF1854765A9A205";
    in_no[20][33] = "42E0DF120A458316";
    in_no[20][34] = "4DCFC3AC96B8F036";
    in_no[20][35] = "47E255206B4AF12E";
    in_no[20][36] = "65F35EE42DCA8B75";
    in_no[20][37] = "4CD49904457E1B4E";
    in_no[20][38] = "4FDEF8CF42039961";
    in_no[20][39] = "44A50E8DEE5437B2";
    in_no[20][40] = "7695AAF8A68C5548";
    in_no[20][41] = "4E27A12E7FEE0800";
    in_no[20][42] = "7D017ECD5DE84E9A";
    in_no[20][43] = "61A582BAA3B6FB3E";
    in_no[20][44] = "71B7207A70831D7A";
    in_no[20][45] = "4B50A02FB1E4479F";
    in_no[20][46] = "719AD3C47A1BB28E";
    in_no[20][47] = "5D4A59133A4B0587";
    in_no[20][48] = "72A4A0B40C3BE99B";
    in_no[20][49] = "6F41C1FE13EAF272";
    in_no[20][50] = "799623A725959795";
    in_no[20][51] = "44720E762C8AAB55";
    in_no[20][52] = "7BFDBB7B8FE35847";
    in_no[20][53] = "7171265074E9E3DF";
    in_no[20][54] = "798114D942D384E0";
    in_no[20][55] = "5B3054DCDEF21349";
    in_no[20][56] = "67B618994D07D9A7";
    in_no[20][57] = "5CD16F83669FFC33";
    in_no[20][58] = "63837962AF8B1AA5";
    in_no[20][59] = "45237B1734FF6CC6";
    in_no[20][60] = "70056AFC22C64391";
    in_no[21][1] = "B5C88D184A3AF3B1";
    in_no[21][2] = "95A86F08605C2AA0";
    in_no[21][3] = "AE95F745E909234E";
    in_no[21][4] = "98044C7E079C37BA";
    in_no[21][5] = "ADADB07B9AFEAC94";
    in_no[21][6] = "90362F61FBA0F40F";
    in_no[21][7] = "84F67712A1E64C2C";
    in_no[21][8] = "82FC0102C4D258EF";
    in_no[21][9] = "12871ECC8D742334";
    in_no[21][10] = "19B92C3C728CCF4A";
    in_no[21][11] = "97FBCD3FEB3B0175";
    in_no[21][12] = "1E7BEBE69E3BF3C2";
    in_no[21][13] = "A8B2469575189327";
    in_no[21][14] = "811D47030E7D6293";
    in_no[21][15] = "AAFC4D163A6CCCD9";
    in_no[21][16] = "8E33BEE6DAB70397";
    in_no[21][17] = "88007D72EF4864C6";
    in_no[21][18] = "830103CBBBF6120C";
    in_no[21][19] = "8CF08C248C37E53B";
    in_no[21][20] = "04C464F82772EF42";
    in_no[21][21] = "B1C00012A1580A3A";
    in_no[21][22] = "0E426ACF90BDFBA6";
    in_no[21][23] = "0B6BA8067112E534";
    in_no[21][24] = "1D5D11146FE4675E";
    in_no[21][25] = "BC00448C580B4CAE";
    in_no[21][26] = "2F49FE1322863725";
    in_no[21][27] = "A7C3364ADEC6BB8B";
    in_no[21][28] = "3177E16B310F878A";
    in_no[21][29] = "B00ECE335E985BBA";
    in_no[21][30] = "A392A30C3D9E32DA";
    in_no[21][31] = "8DBAA045CCB15AED";
    in_no[21][32] = "3EAA8A188E64CAC2";
    in_no[21][33] = "AA811D6FD2B8FE1E";
    in_no[21][34] = "89B30D1074DC059E";
    in_no[21][35] = "BBCEFDE0D25F9C44";
    in_no[21][36] = "8B92A278E6C91F21";
    in_no[21][37] = "2122B060C8A4BA6E";
    in_no[21][38] = "268633B2978352AF";
    in_no[21][39] = "AD09C5FC40761841";
    in_no[21][40] = "A01DEC661DF94DAB";
    in_no[21][41] = "BD456DF81B91C381";
    in_no[21][42] = "1CB98DC940C3AE1E";
    in_no[21][43] = "AB93929E7122CE96";
    in_no[21][44] = "0AA451605CB3A73B";
    in_no[21][45] = "B19A034FA1EE4476";
    in_no[21][46] = "9F81EFAA10962372";
    in_no[21][47] = "A1F4E54C309C46F8";
    in_no[21][48] = "15228FD3055907F3";
    in_no[21][49] = "8D813B101113D36F";
    in_no[21][50] = "0FFC53E9BA64FADF";
    in_no[21][51] = "B2D2392D35EE9B74";
    in_no[21][52] = "9DB4B35284C1064B";
    in_no[21][53] = "B08AE295C6CFFAC1";
    in_no[21][54] = "87057C346B295C33";
    in_no[21][55] = "14B6938CC5EE183A";
    in_no[21][56] = "16A7EF4B0758702D";
    in_no[21][57] = "9D0B459AF91D9283";
    in_no[21][58] = "2D23F39248DA0A27";
    in_no[21][59] = "9FE57BCE16D0A1D4";
    in_no[21][60] = "0045DBB6ADFB81FD";
    in_no[22][1] = "5116B626B453771E";
    in_no[22][2] = "75C3762E98B38530";
    in_no[22][3] = "F5C3762E98B38530";
    in_no[22][4] = "D116B626B453771E";
    in_no[22][5] = "5592915F0D619251";
    in_no[22][6] = "5BC1D6F7DAA5E025";
    in_no[22][7] = "DBC1D6F7DAA5E025";
    in_no[22][8] = "D592915F0D619251";
    in_no[22][9] = "439A50722E541B66";
    in_no[22][10] = "6E8D88EC041D74AE";
    in_no[22][11] = "EE8D88EC041D74AE";
    in_no[22][12] = "C39A50722E541B66";
    in_no[22][13] = "48309A940A083EE4";
    in_no[22][14] = "57F047FD514ADF09";
    in_no[22][15] = "D7F047FD514ADF09";
    in_no[22][16] = "C8309A940A083EE4";
    in_no[22][17] = "501DC41D02DC6837";
    in_no[22][18] = "632F80F31A2AD7F6";
    in_no[22][19] = "E32F80F31A2AD7F6";
    in_no[22][20] = "D01DC41D02DC6837";
    in_no[22][21] = "6341B90D00FB822C";
    in_no[22][22] = "6DA38C577E63FA53";
    in_no[22][23] = "EDA38C577E63FA53";
    in_no[22][24] = "E341B90D00FB822C";
    in_no[22][25] = "42DBC1B514AF73BE";
    in_no[22][26] = "6082412C989B35DF";
    in_no[22][27] = "E082412C989B35DF";
    in_no[22][28] = "C2DBC1B514AF73BE";
    in_no[22][29] = "44D74C9B52C220F7";
    in_no[22][30] = "60F77175C5A113AE";
    in_no[22][31] = "E0F77175C5A113AE";
    in_no[22][32] = "C4D74C9B52C220F7";
    in_no[22][33] = "52705ADFE119D4C3";
    in_no[22][34] = "7FC35E6FA8702F1B";
    in_no[22][35] = "FFC35E6FA8702F1B";
    in_no[22][36] = "D2705ADFE119D4C3";
    in_no[22][37] = "59A4FEBA4AB7024E";
    in_no[22][38] = "75F9D1EDDC132B38";
    in_no[22][39] = "F5F9D1EDDC132B38";
    in_no[22][40] = "D9A4FEBA4AB7024E";
    in_no[22][41] = "5E69F7C9C58DA152";
    in_no[22][42] = "76537DD6F705F0CD";
    in_no[22][43] = "F6537DD6F705F0CD";
    in_no[22][44] = "DE69F7C9C58DA152";
    in_no[22][45] = "57E6482065F2E015";
    in_no[22][46] = "67F04A65B06B2921";
    in_no[22][47] = "E7F04A65B06B2921";
    in_no[22][48] = "D7E6482065F2E015";
    in_no[22][49] = "6617C81FABD7E2EE";
    in_no[22][50] = "68A5790F8DF215DD";
    in_no[22][51] = "E8A5790F8DF215DD";
    in_no[22][52] = "E617C81FABD7E2EE";
    in_no[22][53] = "40FBCD62C46ADFD9";
    in_no[22][54] = "63659A51366BD9A1";
    in_no[22][55] = "E3659A51366BD9A1";
    in_no[22][56] = "C0FBCD62C46ADFD9";
    in_no[22][57] = "4E194D2EE90282D3";
    in_no[22][58] = "5C38DE35856E91FD";
    in_no[22][59] = "DC38DE35856E91FD";
    in_no[22][60] = "CE194D2EE90282D3";
    in_no[23][1] = "C6F16CC0DF1540F5";
    in_no[23][2] = "B17B3E4076622F04";
    in_no[23][3] = "B24210215CD4421C";
    in_no[23][4] = "A045109A14ED8284";
    in_no[23][5] = "D1007172058AEC0A";
    in_no[23][6] = "B375D74CFDA6B292";
    in_no[23][7] = "A600753C8C437B89";
    in_no[23][8] = "A38FF335468D1A39";
    in_no[23][9] = "D25BFD0932C988E7";
    in_no[23][10] = "CFC44FB341090DD4";
    in_no[23][11] = "D4E101DDFBEE0029";
    in_no[23][12] = "BFFC4E85E50A626D";
    in_no[23][13] = "CEDB2A0D51958E97";
    in_no[23][14] = "A493C3CA0DC2427F";
    in_no[23][15] = "CAD39815CB53F3F4";
    in_no[23][16] = "AA7EB095183538C8";
    in_no[23][17] = "AE03F6C4AA3B2589";
    in_no[23][18] = "90E0E3B84422F7D2";
    in_no[23][19] = "BB6B9E7371BAD173";
    in_no[23][20] = "9CE0040B8B626AF6";
    in_no[23][21] = "D37582D3AFB2C63D";
    in_no[23][22] = "CB54237210F95FB5";
    in_no[23][23] = "D012BCA5B74DFF5D";
    in_no[23][24] = "BD172F8AF508EC0B";
    in_no[23][25] = "E8F1FBA2D1252D2B";
    in_no[23][26] = "C0825BD204AE48DA";
    in_no[23][27] = "EB097E9FEF192A01";
    in_no[23][28] = "C3039C311E11C138";
    in_no[23][29] = "C0744F2134E1901E";
    in_no[23][30] = "B542C0ED6CD7F36E";
    in_no[23][31] = "FDC4A94F199F955D";
    in_no[23][32] = "9E1C64E43E18BD27";
    in_no[23][33] = "B6B58391FD92C387";
    in_no[23][34] = "A490304909A95C65";
    in_no[23][35] = "D5E7F5B89F707C28";
    in_no[23][36] = "A02E27C711642CBE";
    in_no[23][37] = "CEEBE4AA571EC12F";
    in_no[23][38] = "CBDFEF6F0C825E69";
    in_no[23][39] = "B1210D04D9C356E0";
    in_no[23][40] = "AC53FAA34E8FB406";
    in_no[23][41] = "3FF0000000000000";
    in_no[23][42] = "4000000000000000";
    in_no[23][43] = "BFF0000000000000";
    in_no[23][44] = "4000000000000000";
    in_no[23][45] = "C014000000000000";
    in_no[23][46] = "C008000000000000";
    in_no[23][47] = "C000000000000000";
    in_no[23][48] = "3FE3333333333333";
    in_no[23][49] = "0000000000000001";
    in_no[23][50] = "0000000000111111";
    in_no[23][51] = "0000000000001111";
    in_no[23][52] = "3FF0000000000000";
    in_no[23][53] = "8000000000011111";
    in_no[23][54] = "0000000000011111";
    in_no[23][55] = "8000000000000111";
    in_no[23][56] = "3FFFFF0000000000";
    in_no[23][57] = "BFFFFFF000000000";
    in_no[23][58] = "8000000002222222";
    in_no[23][59] = "BFFFFFFFFF000000";
    in_no[23][60] = "0000000233445555";
    in_no[24][1] = "2FA89694DD6D675E";
    in_no[24][2] = "45E5BA589837C966";
    in_no[24][3] = "1FC3109F10D8A44A";
    in_no[24][4] = "3219981BC265797D";
    in_no[24][5] = "31221FE595436609";
    in_no[24][6] = "4EB95F14B9BA7449";
    in_no[24][7] = "2161C55B51BF7D27";
    in_no[24][8] = "23CB3E59DF05D8A3";
    in_no[24][9] = "4C3394270BBCBA7E";
    in_no[24][10] = "4E2092EDE17E8B48";
    in_no[24][11] = "3D5A800284A0E694";
    in_no[24][12] = "514C36E2CA1CA0AD";
    in_no[24][13] = "2233C84E4F9C80CE";
    in_no[24][14] = "4C623D287387686B";
    in_no[24][15] = "28A083A5B6DB26A9";
    in_no[24][16] = "48C76E7A53C8C81A";
    in_no[24][17] = "0FF2C18FEEBCAEAE";
    in_no[24][18] = "2B7C369E759DF5E3";
    in_no[24][19] = "1BD3653A458674FC";
    in_no[24][20] = "37C4FB657B5AA89F";
    in_no[24][21] = "4744E68960E85562";
    in_no[24][22] = "514DFBF07296E0D5";
    in_no[24][23] = "39C9B6F2E2AACA77";
    in_no[24][24] = "4CBD0460177B1553";
    in_no[24][25] = "4052F500C5CDBDEA";
    in_no[24][26] = "652F4217679238F6";
    in_no[24][27] = "4144712C6D9E227C";
    in_no[24][28] = "6748D276F38CD260";
    in_no[24][29] = "35019CA879C7C187";
    in_no[24][30] = "3E96F80E21866C06";
    in_no[24][31] = "1D092781EF99AB46";
    in_no[24][32] = "79ACCE4AB046843D";
    in_no[24][33] = "22C6AB931CEE2FD4";
    in_no[24][34] = "35F95CF42AA171CD";
    in_no[24][35] = "1ED1C1680A0C0B6C";
    in_no[24][36] = "54472B9A0E0A4B86";
    in_no[24][37] = "49136E874875BCC2";
    in_no[24][38] = "4C4B33CC462BC32D";
    in_no[24][39] = "2B927E9687937DD0";
    in_no[24][40] = "30F11B85141B78F6";
    in_no[24][41] = "56A419BD3B802B61";
    in_no[24][42] = "60EF33B09F0C558B";
    in_no[24][43] = "395A211040E355AE";
    in_no[24][44] = "4889EB2E04C9C099";
    in_no[24][45] = "29DC5D872AC1544D";
    in_no[24][46] = "3B392EFD09488689";
    in_no[24][47] = "30588217909D04F2";
    in_no[24][48] = "3DE719BA76049D42";
    in_no[24][49] = "20A7EBE381F4672F";
    in_no[24][50] = "4492493763542C73";
    in_no[24][51] = "32A778FC6FD65A71";
    in_no[24][52] = "4BFCFE27BB53DEBB";
    in_no[24][53] = "14FE139DD116F868";
    in_no[24][54] = "36EA4A8A68DAD1FA";
    in_no[24][55] = "4C07064732544856";
    in_no[24][56] = "5043544C696554D2";
    in_no[24][57] = "2AD671190BB5E2F2";
    in_no[24][58] = "64D18C6F488CBC30";
    in_no[24][59] = "34EF80BD5021BFD1";
    in_no[24][60] = "36A40B109F7DABE9";
    in_no[25][1] = "2FA89694DD6D675E";
    in_no[25][2] = "45E5BA589837C966";
    in_no[25][3] = "1FC3109F10D8A44A";
    in_no[25][4] = "3219981BC265797D";
    in_no[25][5] = "31221FE595436609";
    in_no[25][6] = "4EB95F14B9BA7449";
    in_no[25][7] = "2161C55B51BF7D27";
    in_no[25][8] = "23CB3E59DF05D8A3";
    in_no[25][9] = "4C3394270BBCBA7E";
    in_no[25][10] = "4E2092EDE17E8B48";
    in_no[25][11] = "3D5A800284A0E694";
    in_no[25][12] = "514C36E2CA1CA0AD";
    in_no[25][13] = "2233C84E4F9C80CE";
    in_no[25][14] = "4C623D287387686B";
    in_no[25][15] = "28A083A5B6DB26A9";
    in_no[25][16] = "48C76E7A53C8C81A";
    in_no[25][17] = "0FF2C18FEEBCAEAE";
    in_no[25][18] = "2B7C369E759DF5E3";
    in_no[25][19] = "1BD3653A458674FC";
    in_no[25][20] = "37C4FB657B5AA89F";
    in_no[25][21] = "4744E68960E85562";
    in_no[25][22] = "514DFBF07296E0D5";
    in_no[25][23] = "39C9B6F2E2AACA77";
    in_no[25][24] = "4CBD0460177B1553";
    in_no[25][25] = "4052F500C5CDBDEA";
    in_no[25][26] = "652F4217679238F6";
    in_no[25][27] = "4144712C6D9E227C";
    in_no[25][28] = "6748D276F38CD260";
    in_no[25][29] = "35019CA879C7C187";
    in_no[25][30] = "3E96F80E21866C06";
    in_no[25][31] = "1D092781EF99AB46";
    in_no[25][32] = "79ACCE4AB046843D";
    in_no[25][33] = "22C6AB931CEE2FD4";
    in_no[25][34] = "35F95CF42AA171CD";
    in_no[25][35] = "1ED1C1680A0C0B6C";
    in_no[25][36] = "54472B9A0E0A4B86";
    in_no[25][37] = "49136E874875BCC2";
    in_no[25][38] = "4C4B33CC462BC32D";
    in_no[25][39] = "2B927E9687937DD0";
    in_no[25][40] = "30F11B85141B78F6";
    in_no[25][41] = "56A419BD3B802B61";
    in_no[25][42] = "60EF33B09F0C558B";
    in_no[25][43] = "395A211040E355AE";
    in_no[25][44] = "4889EB2E04C9C099";
    in_no[25][45] = "29DC5D872AC1544D";
    in_no[25][46] = "3B392EFD09488689";
    in_no[25][47] = "30588217909D04F2";
    in_no[25][48] = "3DE719BA76049D42";
    in_no[25][49] = "20A7EBE381F4672F";
    in_no[25][50] = "4492493763542C73";
    in_no[25][51] = "32A778FC6FD65A71";
    in_no[25][52] = "4BFCFE27BB53DEBB";
    in_no[25][53] = "14FE139DD116F868";
    in_no[25][54] = "36EA4A8A68DAD1FA";
    in_no[25][55] = "4C07064732544856";
    in_no[25][56] = "5043544C696554D2";
    in_no[25][57] = "2AD671190BB5E2F2";
    in_no[25][58] = "64D18C6F488CBC30";
    in_no[25][59] = "34EF80BD5021BFD1";
    in_no[25][60] = "36A40B109F7DABE9";
    in_no[26][1] = "B6A4C8993B11D519";
    in_no[26][2] = "852B1D8F24F24DE3";
    in_no[26][3] = "A4B9EE1A9DB994F5";
    in_no[26][4] = "991B6451C0720BFB";
    in_no[26][5] = "C0559415FCFBFF18";
    in_no[26][6] = "8401B0BE7AC0AF65";
    in_no[26][7] = "A8B975299CCB0E08";
    in_no[26][8] = "1B677D8FA6B68B60";
    in_no[26][9] = "A9CA8E9C46A3D769";
    in_no[26][10] = "9CBC3A9CD7025105";
    in_no[26][11] = "AB69B66C64D19EE1";
    in_no[26][12] = "A640B8DBEBDFF270";
    in_no[26][13] = "BD732690AAC2472D";
    in_no[26][14] = "8EA0E0DD7B9E7391";
    in_no[26][15] = "B3940516BC314CC9";
    in_no[26][16] = "B347AD0659980C2B";
    in_no[26][17] = "2F6E80EF8FD19AD4";
    in_no[26][18] = "3B0BA9A1304C562D";
    in_no[26][19] = "A8A764BF1B176FF7";
    in_no[26][20] = "86C00BD1997CD82E";
    in_no[26][21] = "9B2B28F9484FFBFC";
    in_no[26][22] = "3F2C77C9276B791D";
    in_no[26][23] = "AB2388C331648E3E";
    in_no[26][24] = "9BF65ED85DF2D4B7";
    in_no[26][25] = "85896433E013EDA2";
    in_no[26][26] = "27D8620FAA09EADB";
    in_no[26][27] = "A14AB077C8E23EF5";
    in_no[26][28] = "3ED504D993745EAF";
    in_no[26][29] = "AD206D7F9AE94DAD";
    in_no[26][30] = "8BC9610758986A88";
    in_no[26][31] = "A0DAF3B21180E563";
    in_no[26][32] = "907068B13DA99666";
    in_no[26][33] = "9C72789C2D583BCD";
    in_no[26][34] = "8F3F2BD89DAD0665";
    in_no[26][35] = "9DE9FC9D1B0AFC7C";
    in_no[26][36] = "0F3580844B9DC45C";
    in_no[26][37] = "BCE8A11A53596037";
    in_no[26][38] = "167B1E6B793078DD";
    in_no[26][39] = "B86425EEF071014F";
    in_no[26][40] = "9DCBB2EFB4F70837";
    in_no[26][41] = "8818E96354BF7E11";
    in_no[26][42] = "80F039E2518CF503";
    in_no[26][43] = "B5A7BA62E3FBDD83";
    in_no[26][44] = "11B069E434EE9E0F";
    in_no[26][45] = "8F8E7802992BA99D";
    in_no[26][46] = "85F7883A587654E5";
    in_no[26][47] = "13F455801D3D2B63";
    in_no[26][48] = "3E4D2648ABC1E83D";
    in_no[26][49] = "A8804BE837A6F1F1";
    in_no[26][50] = "0FC173AB0FEC92AF";
    in_no[26][51] = "BAB7E13DBB66E5A3";
    in_no[26][52] = "9E5AF23D175AA3D2";
    in_no[26][53] = "AED07D4317CB3695";
    in_no[26][54] = "A10EF8B7BCBAB211";
    in_no[26][55] = "AB9FB31317BB132B";
    in_no[26][56] = "89470170EDBD047B";
    in_no[26][57] = "B028378F49913A88";
    in_no[26][58] = "1A053FAB12968E9A";
    in_no[26][59] = "B1679CA1AF65E50D";
    in_no[26][60] = "A52CD61131067370";

    out_no[1][1] = "0000000000000000";
    out_no[1][2] = "3FF0000000000000";
    out_no[1][3] = "3FEFFFFFFFFFFFFF";
    out_no[1][4] = "3FF0000000000000";
    out_no[1][5] = "0000000000000000";
    out_no[1][6] = "3FF0000000000000";
    out_no[1][7] = "3FEFFFFFFFFFFFFF";
    out_no[1][8] = "3FF0000000000000";
    out_no[1][9] = "0000000000000000";
    out_no[1][10] = "0000000000000000";
    out_no[1][11] = "0000000000000000";
    out_no[1][12] = "3FC5D21A2BD88ECC";
    out_no[1][13] = "0000000000000000";
    out_no[1][14] = "3FF0000000000000";
    out_no[1][15] = "0000000000000000";
    out_no[1][16] = "3FF0000000000000";
    out_no[1][17] = "3FEFFFFFFFFFFFFF";
    out_no[1][18] = "3FF0000000000000";
    out_no[1][19] = "3FEFFFFFFFFFFFFF";
    out_no[1][20] = "3FF0000000000000";
    out_no[1][21] = "0000000000000000";
    out_no[1][22] = "0000000000000000";
    out_no[1][23] = "0000000000000000";
    out_no[1][24] = "3FEFFFFFFFFFFF47";
    out_no[1][25] = "0000000000000000";
    out_no[1][26] = "0AF5D7A2F6655DFC";
    out_no[1][27] = "0000000000000000";
    out_no[1][28] = "0000000000000000";
    out_no[1][29] = "22A26980ECC80364";
    out_no[1][30] = "3FF0000000000000";
    out_no[1][31] = "0000000000000000";
    out_no[1][32] = "3FF0000000000000";
    out_no[1][33] = "3FEFFFFFFFFFFFFF";
    out_no[1][34] = "3FF0000000000000";
    out_no[1][35] = "0000000000000000";
    out_no[1][36] = "3FF0000000000000";
    out_no[1][37] = "0000000000000000";
    out_no[1][38] = "0000000000000000";
    out_no[1][39] = "3FEFFFFFFFFFFFFF";
    out_no[1][40] = "3FF0000000000000";
    out_no[1][41] = "4005BF0A8B145769";
    out_no[1][42] = "401D8E64B8D4DDAE";
    out_no[1][43] = "3FD78B56362CEF37";
    out_no[1][44] = "401D8E64B8D4DDAE";
    out_no[1][45] = "3F7B993FE00D5376";
    out_no[1][46] = "3FA97DB0CCCEB0AF";
    out_no[1][47] = "3FC152AAA3BF81CB";
    out_no[1][48] = "3FFD27660B11A9F0";
    out_no[1][49] = "3FF0000000000000";
    out_no[1][50] = "3FF0000000000001";
    out_no[1][51] = "3FF0000000000000";
    out_no[1][52] = "4005BF0A8B14576A";
    out_no[1][53] = "3FEFFFFFFFFFFFFF";
    out_no[1][54] = "3FF0000000000001";
    out_no[1][55] = "3FEFFFFFFFFFFFFF";
    out_no[1][56] = "401D8C8BE15033ED";
    out_no[1][57] = "3FC152BBF672CEE3";
    out_no[1][58] = "3FF0000000000000";
    out_no[1][59] = "3FC152AAA4D4AC75";
    out_no[1][60] = "3FF0000000000001";
    out_no[2][1] = "0000000000000000";
    out_no[2][2] = "3FF0000000000000";
    out_no[2][3] = "3FEFFFFFFFFFFFFF";
    out_no[2][4] = "3FF0000000000000";
    out_no[2][5] = "0000000000000000";
    out_no[2][6] = "3FF0000000000000";
    out_no[2][7] = "3FEFFFFFFFFFFFFF";
    out_no[2][8] = "3FF0000000000000";
    out_no[2][9] = "0000000000000000";
    out_no[2][10] = "0000000000000000";
    out_no[2][11] = "0000000000000000";
    out_no[2][12] = "3FD2C6B1BE11C121";
    out_no[2][13] = "0000000000000000";
    out_no[2][14] = "3FF0000000000000";
    out_no[2][15] = "0000000000000000";
    out_no[2][16] = "3FF0000000000000";
    out_no[2][17] = "3FEFFFFFFFFFFFFF";
    out_no[2][18] = "3FF0000000000000";
    out_no[2][19] = "3FEFFFFFFFFFFFFF";
    out_no[2][20] = "3FF0000000000000";
    out_no[2][21] = "0000000000000000";
    out_no[2][22] = "0000000000000000";
    out_no[2][23] = "0000000000000000";
    out_no[2][24] = "3FEFFFFFFFFFFF80";
    out_no[2][25] = "0000000000000000";
    out_no[2][26] = "1B36FB78C613E5EC";
    out_no[2][27] = "0000000000000000";
    out_no[2][28] = "0000000000000000";
    out_no[2][29] = "2BA09D60717370A1";
    out_no[2][30] = "3FF0000000000000";
    out_no[2][31] = "0000000000000000";
    out_no[2][32] = "3FF0000000000000";
    out_no[2][33] = "3FEFFFFFFFFFFFFF";
    out_no[2][34] = "3FF0000000000000";
    out_no[2][35] = "0000000000000000";
    out_no[2][36] = "3FF0000000000000";
    out_no[2][37] = "0000000000000000";
    out_no[2][38] = "0000000000000000";
    out_no[2][39] = "3FEFFFFFFFFFFFFF";
    out_no[2][40] = "3FF0000000000000";
    out_no[2][41] = "4000000000000000";
    out_no[2][42] = "4010000000000000";
    out_no[2][43] = "3FE0000000000000";
    out_no[2][44] = "4010000000000000";
    out_no[2][45] = "3FA0000000000000";
    out_no[2][46] = "3FC0000000000000";
    out_no[2][47] = "3FD0000000000000";
    out_no[2][48] = "3FF8406003B2AE5D";
    out_no[2][49] = "3FF0000000000000";
    out_no[2][50] = "3FF0000000000001";
    out_no[2][51] = "3FEFFFFFFFFFFFFF";
    out_no[2][52] = "3FF0000000000001";
    out_no[2][53] = "3FF0000000000000";
    out_no[2][54] = "40000000243A1430";
    out_no[2][55] = "3FEFFFFFFFFFFFFF";
    out_no[2][56] = "3FF0000000000001";
    out_no[2][57] = "3FEFFFFFFFFFFFFF";
    out_no[2][58] = "400FFFFFEAA6AC58";
    out_no[2][59] = "3FD0000000000000";
    out_no[2][60] = "3FF0000000000001";



    out_no[3][1] = "0000000000000000";
    out_no[3][2] = "3FF0000000000000";
    out_no[3][3] = "3FEFFFFFFFFFFFFF";
    out_no[3][4] = "3FF0000000000000";
    out_no[3][5] = "0000000000000000";
    out_no[3][6] = "3FF0000000000000";
    out_no[3][7] = "3FEFFFFFFFFFFFFF";
    out_no[3][8] = "3FF0000000000000";
    out_no[3][9] = "0000000000000000";
    out_no[3][10] = "0000000000000000";
    out_no[3][11] = "0000000000000000";
    out_no[3][12] = "3FAE62FF0AAAC51E";
    out_no[3][13] = "0000000000000000";
    out_no[3][14] = "3FF0000000000000";
    out_no[3][15] = "0000000000000000";
    out_no[3][16] = "3FF0000000000000";
    out_no[3][17] = "3FEFFFFFFFFFFFFF";
    out_no[3][18] = "3FF0000000000000";
    out_no[3][19] = "3FEFFFFFFFFFFFFF";
    out_no[3][20] = "3FF0000000000000";
    out_no[3][21] = "0000000000000000";
    out_no[3][22] = "0000000000000000";
    out_no[3][23] = "0000000000000000";
    out_no[3][24] = "3FEFFFFFFFFFFF4E";
    out_no[3][25] = "0000000000000000";
    out_no[3][26] = "0000000000000001";
    out_no[3][27] = "0000000000000000";
    out_no[3][28] = "0000000000000000";
    out_no[3][29] = "0000000000000000";
    out_no[3][30] = "3FF0000000000000";
    out_no[3][31] = "0000000000000000";
    out_no[3][32] = "3FF0000000000000";
    out_no[3][33] = "3FEFFFFFFFFFFFFF";
    out_no[3][34] = "3FF0000000000000";
    out_no[3][35] = "0000000000000000";
    out_no[3][36] = "3FF0000000000000";
    out_no[3][37] = "0000000000000000";
    out_no[3][38] = "0000000000000000";
    out_no[3][39] = "3FEFFFFFFFFFFFFF";
    out_no[3][40] = "3FF0000000000000";
    out_no[3][41] = "0000000000000000";
    out_no[3][42] = "0000000000000000";
    out_no[3][43] = "0000000000000000";
    out_no[3][44] = "3FEFFFFFFFFFFFFF";
    out_no[3][45] = "3FEFFFFFFFFFFFFF";
    out_no[3][46] = "3FF0000000000000";
    out_no[3][47] = "0000000000000000";
    out_no[3][48] = "3FF0000000000000";
    out_no[3][49] = "0000000000000000";
    out_no[3][50] = "3FF0000000000000";
    out_no[3][51] = "0000000000000000";
    out_no[3][52] = "3FF0000000000000";
    out_no[3][53] = "3FEFFFFFFFFFFFFF";
    out_no[3][54] = "3FF0000000000000";
    out_no[3][55] = "0000000000000000";
    out_no[3][56] = "0000000000000000";
    out_no[3][57] = "0000000000000000";
    out_no[3][58] = "3FF0000000000000";
    out_no[3][59] = "3FEFFFFFFFFFFFFF";
    out_no[3][60] = "3FF0000000000000";
    out_no[4][1] = "C0668F6A61420A9B";
    out_no[4][2] = "405089EB6060FEDC";
    out_no[4][3] = "C0764CBA844FC0EA";
    out_no[4][4] = "C0632D15B16AD3FC";
    out_no[4][5] = "C06484D6A28B4894";
    out_no[4][6] = "406481668DE8A843";
    out_no[4][7] = "C0752D81024E4C23";
    out_no[4][8] = "C073813C01ACD25C";
    out_no[4][9] = "406101E0E2F43B88";
    out_no[4][10] = "4063AC261E03F16F";
    out_no[4][11] = "C03C9B8D4127E3DA";
    out_no[4][12] = "406812355A240E0B";
    out_no[4][13] = "C0749B9D16B7E46A";
    out_no[4][14] = "40614226F7BCAB9F";
    out_no[4][15] = "C07028323B4D95B4";
    out_no[4][16] = "4058876036464EAE";
    out_no[4][17] = "C080A16CC1E8AD14";
    out_no[4][18] = "C06C591F47F12D4A";
    out_no[4][19] = "C07907255D3994FE";
    out_no[4][20] = "C056A1FF3D7EF600";
    out_no[4][21] = "40545762D0438297";
    out_no[4][22] = "40681427B8A6D9AB";
    out_no[4][23] = "C051096A11D38E60";
    out_no[4][24] = "4061BFEA0DFC1B3F";
    out_no[4][25] = "4011505A690A5D52";
    out_no[4][26] = "4079D179EA5204D0";
    out_no[4][27] = "402D9A297D7C59AD";
    out_no[4][28] = "407B46DC0D02B874";
    out_no[4][29] = "C05E4D1AEAE0E6D6";
    out_no[4][30] = "C02DC67E59267732";
    out_no[4][31] = "C0783044F26AAA2B";
    out_no[4][32] = "408402E716E4881B";
    out_no[4][33] = "C074359ECD75CB6C";
    out_no[4][34] = "C05B9C5786E838D7";
    out_no[4][35] = "C076F438EE9F6020";
    out_no[4][36] = "406C34946A47E4CB";
    out_no[4][37] = "4059593426B47485";
    out_no[4][38] = "406122952A63FA23";
    out_no[4][39] = "C06C3A466D4B7C35";
    out_no[4][40] = "C064C93A886C545E";
    out_no[4][41] = "406F7AE611DAE7FE";
    out_no[4][42] = "4076DF4DA39DC5DD";
    out_no[4][43] = "C0523EEBBC45A709";
    out_no[4][44] = "4057DC62EFC338BE";
    out_no[4][45] = "C06E99A612947697";
    out_no[4][46] = "C04A1CDFEB8CDD74";
    out_no[4][47] = "C0659B8835DCE863";
    out_no[4][48] = "C03681AFF89E9C89";
    out_no[4][49] = "C075ADD53379EF4D";
    out_no[4][50] = "4049B695890A8454";
    out_no[4][51] = "C062683A32D5A5AB";
    out_no[4][52] = "4060B5B80D3EC315";
    out_no[4][53] = "C07DC410CBC8E1C8";
    out_no[4][54] = "C059009EDE74BAAA";
    out_no[4][55] = "4060C486291E8C41";
    out_no[4][56] = "4066A336DCA89F13";
    out_no[4][57] = "C06D3E40CE850A83";
    out_no[4][58] = "407990C99B6124FE";
    out_no[4][59] = "C05E809CA35F4DE4";
    out_no[4][60] = "C059C36EA24E85B8";
    out_no[5][1] = "C0704614E93EA794";
    out_no[5][2] = "4057DC412C120139";
    out_no[5][3] = "C08015FA2A3E7BA5";
    out_no[5][4] = "C06BAA4FECD36F54";
    out_no[5][5] = "C06D9A3E7294584D";
    out_no[5][6] = "406D9548C27863FA";
    out_no[5][7] = "C07E8D93AC78E47C";
    out_no[5][8] = "C07C23B6E9F9BE73";
    out_no[5][9] = "40688951A1490120";
    out_no[5][10] = "406C61A0857A65C1";
    out_no[5][11] = "C044A2D36F1AB279";
    out_no[5][12] = "40715D18004DA527";
    out_no[5][13] = "C07DBB1A03AD9911";
    out_no[5][14] = "4068E60BD9F1CEBB";
    out_no[5][15] = "C0774F450FB5F194";
    out_no[5][16] = "4061B19CB810411A";
    out_no[5][17] = "C087FE2A6AF7CF2D";
    out_no[5][18] = "C07472E83799CCFA";
    out_no[5][19] = "C0820DC762820DB4";
    out_no[5][20] = "C060537C42B00082";
    out_no[5][21] = "405D58AB8177D1A6";
    out_no[5][22] = "40715E7F7FA196AA";
    out_no[5][23] = "C0589430DA57F3C8";
    out_no[5][24] = "40699B7B8B271AAC";
    out_no[5][25] = "4018FA88AFB44648";
    out_no[5][26] = "40829FBAB2D37D26";
    out_no[5][27] = "40355A7D090E9BC4";
    out_no[5][28] = "4083AD11853778A4";
    out_no[5][29] = "C065DB918D5C1340";
    out_no[5][30] = "C0357A778189781E";
    out_no[5][31] = "C08172C7330DF7A9";
    out_no[5][32] = "408CDEC94BA0C393";
    out_no[5][33] = "C07D27F4D5811EC0";
    out_no[5][34] = "C063EABB1C94A3F1";
    out_no[5][35] = "C0808ECC674F80F4";
    out_no[5][36] = "4074588C1B9F05FC";
    out_no[5][37] = "406248F8941AD448";
    out_no[5][38] = "4068B88046862DBC";
    out_no[5][39] = "C0745CA7D7508D73";
    out_no[5][40] = "C06DFCE901514D4E";
    out_no[5][41] = "4076B54440063A2F";
    out_no[5][42] = "40807FB56050EF84";
    out_no[5][43] = "C05A52B6DEA01D8C";
    out_no[5][44] = "40613644F9AD36F6";
    out_no[5][45] = "C07612C877FDEFC9";
    out_no[5][46] = "C052D61E26DF4AAE";
    out_no[5][47] = "C06F2C505B013DBC";
    out_no[5][48] = "C0403C2DCD138608";
    out_no[5][49] = "C07F46B75E4932F4";
    out_no[5][50] = "40528C54AB0884A6";
    out_no[5][51] = "C06A8E4E985C1653";
    out_no[5][52] = "40681B71A4A4E095";
    out_no[5][53] = "C08578B7269EB094";
    out_no[5][54] = "C0620912609254F4";
    out_no[5][55] = "406830CD9D4B6081";
    out_no[5][56] = "4070545D0C4DA7BA";
    out_no[5][57] = "C0751830AD8B30FC";
    out_no[5][58] = "40827110F60EDA9F";
    out_no[5][59] = "C06600B90A02A915";
    out_no[5][60] = "C062959940544905";
    out_no[6][1] = "C053987653132356";
    out_no[6][2] = "403CBB1247192AE0";
    out_no[6][3] = "C0635E89E485066B";
    out_no[6][4] = "C050A7FA1147E789";
    out_no[6][5] = "C051D28EB6E5C712";
    out_no[6][6] = "4051CF9249409319";
    out_no[6][7] = "C062650EF9402C17";
    out_no[6][8] = "C060F1117BB79CBA";
    out_no[6][9] = "404D8B7629283EF9";
    out_no[6][10] = "40511657E5D5225A";
    out_no[6][11] = "C028D927FFDEC9EF";
    out_no[6][12] = "4054E86D1C6887FD";
    out_no[6][13] = "C061E656FB764201";
    out_no[6][14] = "404DFB1DD3D1E32C";
    out_no[6][15] = "C05C114F0BC18592";
    out_no[6][16] = "40454E3250B4187E";
    out_no[6][17] = "C06CE3E78A053B09";
    out_no[6][18] = "C0589F74CC710DFC";
    out_no[6][19] = "C065BD2D1FB2B57C";
    out_no[6][20] = "C043A89A14B4233A";
    out_no[6][21] = "4041AB13F7E80530";
    out_no[6][22] = "4054EA1DFD2B563A";
    out_no[6][23] = "C03D988D7EBC5AE3";
    out_no[6][24] = "404ED5966BF9312F";
    out_no[6][25] = "3FFE13C93CF0C5D8";
    out_no[6][26] = "40666CEB0959229A";
    out_no[6][27] = "4019B64ED5359908";
    out_no[6][28] = "4067B13C19524EB3";
    out_no[6][29] = "C04A51BC6556AA6D";
    out_no[6][30] = "C019DCD053621B05";
    out_no[6][31] = "C06502896B71EBBB";
    out_no[6][32] = "407161B25DAC86EC";
    out_no[6][33] = "C0618DBFE038ED2E";
    out_no[6][34] = "C047FB7BD8445866";
    out_no[6][35] = "C063F0059C673D08";
    out_no[6][36] = "40587FB743EE235E";
    out_no[6][37] = "40460473631F9972";
    out_no[6][38] = "404DC4464C944BAA";
    out_no[6][39] = "C05884A9ADA4493C";
    out_no[6][40] = "C0520DF5E1A324EF";
    out_no[6][41] = "405B57DED7C53752";
    out_no[6][42] = "4063DDDA1003D490";
    out_no[6][43] = "C03FB238786D64F9";
    out_no[6][44] = "4044B9AD54CFA155";
    out_no[6][45] = "C05A943888037FC5";
    out_no[6][46] = "C036AE688B7C8203";
    out_no[6][47] = "C052C4A0B1A3F93E";
    out_no[6][48] = "C0238C89BF73DC7C";
    out_no[6][49] = "C062D486066D5AD0";
    out_no[6][50] = "4036558F570C1420";
    out_no[6][51] = "C04FF9FA31C27071";
    out_no[6][52] = "404D0728B08FFBAF";
    out_no[6][53] = "C069DAB473CBA90F";
    out_no[6][54] = "C045B782266F2506";
    out_no[6][55] = "404D20E0C87F4F3D";
    out_no[6][56] = "4053A9A8C08793EE";
    out_no[6][57] = "C059667A13FBDC6F";
    out_no[6][58] = "406634BAEF78ABF3";
    out_no[6][59] = "C04A7E795E085C20";
    out_no[6][60] = "C04660B83700B3E9";
    out_no[7][1] = "B6A4C8993B11D519";
    out_no[7][2] = "852B1D8F24F24DE2";
    out_no[7][3] = "A4B9EE1A9DB994F5";
    out_no[7][4] = "991B6451C0720BFA";
    out_no[7][5] = "BFF0000000000000";
    out_no[7][6] = "3FF0000000000000";
    out_no[7][7] = "A8B975299CCB0E08";
    out_no[7][8] = "1B677D8FA6B68B60";
    out_no[7][9] = "A9CA8E9C46A3D769";
    out_no[7][10] = "9CBC3A9CD7025104";
    out_no[7][11] = "AB69B66C64D19EE1";
    out_no[7][12] = "A640B8DBEBDFF26F";
    out_no[7][13] = "BD732690AAC2472D";
    out_no[7][14] = "8EA0E0DD7B9E7390";
    out_no[7][15] = "B3940516BC314CC9";
    out_no[7][16] = "B347AD0659980C2A";
    out_no[7][17] = "2F6E80EF8FD19AD3";
    out_no[7][18] = "3B0BA9A1304C562D";
    out_no[7][19] = "A8A764BF1B176FF7";
    out_no[7][20] = "86C00BD1997CD82D";
    out_no[7][21] = "9B2B28F9484FFBFC";
    out_no[7][22] = "3F2C77C923AA2E2E";
    out_no[7][23] = "AB2388C331648E3E";
    out_no[7][24] = "9BF65ED85DF2D4B6";
    out_no[7][25] = "85896433E013EDA2";
    out_no[7][26] = "27D8620FAA09EADB";
    out_no[7][27] = "A14AB077C8E23EF5";
    out_no[7][28] = "3ED504D99373FDF5";
    out_no[7][29] = "AD206D7F9AE94DAD";
    out_no[7][30] = "8BC9610758986A87";
    out_no[7][31] = "A0DAF3B21180E563";
    out_no[7][32] = "907068B13DA99665";
    out_no[7][33] = "9C72789C2D583BCD";
    out_no[7][34] = "8F3F2BD89DAD0664";
    out_no[7][35] = "9DE9FC9D1B0AFC7C";
    out_no[7][36] = "0F3580844B9DC45C";
    out_no[7][37] = "BCE8A11A53596037";
    out_no[7][38] = "167B1E6B793078DD";
    out_no[7][39] = "B86425EEF071014F";
    out_no[7][40] = "9DCBB2EFB4F70836";
    out_no[7][41] = "8818E96354BF7E11";
    out_no[7][42] = "80F039E2518CF502";
    out_no[7][43] = "B5A7BA62E3FBDD83";
    out_no[7][44] = "11B069E434EE9E0F";
    out_no[7][45] = "8F8E7802992BA99D";
    out_no[7][46] = "85F7883A587654E4";
    out_no[7][47] = "13F455801D3D2B62";
    out_no[7][48] = "3E4D2648ABC1E83D";
    out_no[7][49] = "A8804BE837A6F1F1";
    out_no[7][50] = "0FC173AB0FEC92AF";
    out_no[7][51] = "BAB7E13DBB66E5A3";
    out_no[7][52] = "9E5AF23D175AA3D1";
    out_no[7][53] = "AED07D4317CB3695";
    out_no[7][54] = "A10EF8B7BCBAB210";
    out_no[7][55] = "AB9FB31317BB132B";
    out_no[7][56] = "89470170EDBD047A";
    out_no[7][57] = "B028378F49913A88";
    out_no[7][58] = "1A053FAB12968E9A";
    out_no[7][59] = "B1679CA1AF65E50D";
    out_no[7][60] = "A52CD6113106736F";

    out_no[8][1] = "3FEFFFFFFFFFFFFF";
    out_no[8][2] = "3FF0000000000000";
    out_no[8][3] = "3FEFFFFFFFFFFFFF";
    out_no[8][4] = "3FF0000000000000";
    out_no[8][5] = "BFF0000000000000";
    out_no[8][6] = "3FF0000000000000";
    out_no[8][7] = "3FEFFFFFFFFFFFFF";
    out_no[8][8] = "3FF0000000000000";
    out_no[8][9] = "3FEFFFFFFFFFFFFF";
    out_no[8][10] = "3FF0000000000000";
    out_no[8][11] = "3FEFFFFFFFFFFFFF";
    out_no[8][12] = "3FF0000000000000";
    out_no[8][13] = "3FEFFFFFFFFFFFFF";
    out_no[8][14] = "3FF0000000000000";
    out_no[8][15] = "3FEFFFFFFFFFFFFF";
    out_no[8][16] = "3FF0000000000000";
    out_no[8][17] = "3FEFFFFFFFFFFFFF";
    out_no[8][18] = "3FF0000000000000";
    out_no[8][19] = "3FEFFFFFFFFFFFFF";
    out_no[8][20] = "3FF0000000000000";
    out_no[8][21] = "3FEFFFFFF3564FCB";
    out_no[8][22] = "3FF0000000000000";
    out_no[8][23] = "3FEFFFFFFFFFFFFF";
    out_no[8][24] = "3FF0000000000000";
    out_no[8][25] = "3FEFFFFFFFFFFFFF";
    out_no[8][26] = "3FF0000000000000";
    out_no[8][27] = "3FEFFFFFFFFE4634";
    out_no[8][28] = "3FF0000000000000";
    out_no[8][29] = "3FEFFFFFFFFFFFFF";
    out_no[8][30] = "3FF0000000000000";
    out_no[8][31] = "3FEFFFFFFFFFFFFF";
    out_no[8][32] = "3FF0000000000000";
    out_no[8][33] = "3FEFFFFFFFFFFFFF";
    out_no[8][34] = "3FF0000000000000";
    out_no[8][35] = "3FEFFFFFFFFFFFFF";
    out_no[8][36] = "3FF0000000000000";
    out_no[8][37] = "3FEFFFFFFFFFFFFF";
    out_no[8][38] = "3FF0000000000000";
    out_no[8][39] = "3FEFFFFFFFFFFFFF";
    out_no[8][40] = "3FF0000000000000";
    out_no[8][41] = "3FEFFFFFFFFFFFFF";
    out_no[8][42] = "3FF0000000000000";
    out_no[8][43] = "3FEFFFFFFFFFFFFF";
    out_no[8][44] = "3FF0000000000000";
    out_no[8][45] = "3FEFFFFFFFFFFFFF";
    out_no[8][46] = "3FF0000000000000";
    out_no[8][47] = "3FEFFFFFFFFFFFFF";
    out_no[8][48] = "3FF0000000000000";
    out_no[8][49] = "3FEFFFFFFFFFFFFF";
    out_no[8][50] = "3FF0000000000000";
    out_no[8][51] = "3FEFFFFFFFFFFFFF";
    out_no[8][52] = "3FF0000000000000";
    out_no[8][53] = "3FEFFFFFFFFFFFFF";
    out_no[8][54] = "3FF0000000000000";
    out_no[8][55] = "3FEFFFFFFFFFFFFF";
    out_no[8][56] = "3FF0000000000000";
    out_no[8][57] = "3FEFFFFFFFFFFFFF";
    out_no[8][58] = "3FF0000000000000";
    out_no[8][59] = "3FEFFFFFFFFFFFFF";
    out_no[8][60] = "3FF0000000000000";
    out_no[9][1] = "C110AE5296E191D2";
    out_no[9][2] = "C02D98FDFF87377D";
    out_no[9][3] = "C1E2A2EC2193FE9E";
    out_no[9][4] = "C06C3B9D7A157425";
    out_no[9][5] = "C131A74CC770CA81";
    out_no[9][6] = "C0D02797F0002D0C";
    out_no[9][7] = "C0CF6DDF31D42D10";
    out_no[9][8] = "C073EC2E09B0B82D";
    out_no[9][9] = "C1E8BD033E5794E1";
    out_no[9][10] = "C0E2A3A40EA27098";
    out_no[9][11] = "C1619C4DB4F71995";
    out_no[9][12] = "40142E8A6723DD8F";
    out_no[9][13] = "C12281AD1A684049";
    out_no[9][14] = "C027E9968792C573";
    out_no[9][15] = "C131E211833A60A2";
    out_no[9][16] = "C0A577FAB846BD1D";
    out_no[9][17] = "C0CDC74D19ACF53B";
    out_no[9][18] = "C0A06780CB6101EF";
    out_no[9][19] = "C186A35693EEDAA4";
    out_no[9][20] = "C10BF6798FCCD6E2";
    out_no[9][21] = "C189471E22608DA2";
    out_no[9][22] = "C08B96C2D98DEB30";
    out_no[9][23] = "C1BD9B11082E8FC3";
    out_no[9][24] = "C0B6B6333E88C1DF";
    out_no[9][25] = "C1924694A629D8BF";
    out_no[9][26] = "C025AB37594D2BE9";
    out_no[9][27] = "C1862956C2A2D62A";
    out_no[9][28] = "BFE2D2399B72EA3D";
    out_no[9][29] = "C051D19765E3FC7A";
    out_no[9][30] = "C05115461C99ECA5";
    out_no[9][31] = "C102AEF4FA14F93B";
    out_no[9][32] = "C048121CE094B034";
    out_no[9][33] = "C1DD7DEEC3154C47";
    out_no[9][34] = "C065A3EBABE6E61D";
    out_no[9][35] = "C052F78F24545A36";
    out_no[9][36] = "C00C276AC2300DA6";
    out_no[9][37] = "C1065A2A934E5CAA";
    out_no[9][38] = "C0A759CDC5D55213";
    out_no[9][39] = "C1D4E3DC1208291F";
    out_no[9][40] = "C06032D0C507703D";
    out_no[9][41] = "C173ADB30F7A9B56";
    out_no[9][42] = "3FD9231D192A3E68";
    out_no[9][43] = "C1AF1C7421B66CC8";
    out_no[9][44] = "C117FD15910FF62E";
    out_no[9][45] = "C14FD2E45E8D33F6";
    out_no[9][46] = "C0908F65AC0E1D44";
    out_no[9][47] = "C11FF22D5DEE5CC4";
    out_no[9][48] = "BFF4AB8A7BB81552";
    out_no[9][49] = "C0B2A53ECF4C9B1A";
    out_no[9][50] = "C08E93F83A616D4A";
    out_no[9][51] = "C1DFDED0D28FCD51";
    out_no[9][52] = "C0795C659F53B09B";
    out_no[9][53] = "C0EA5EA670EA3939";
    out_no[9][54] = "C0B623D682415BE0";
    out_no[9][55] = "C107C60D60AD4E67";
    out_no[9][56] = "BFB731B7ACF94603";
    out_no[9][57] = "C1A939FAC71FC143";
    out_no[9][58] = "C1A939FAC71FC142";
    out_no[9][59] = "C1A939FAC71FC143";
    out_no[9][60] = "C05209AFE017139A";
    out_no[10][1] = "402D98FDFF873BC1";
    out_no[10][2] = "4110AE52978E4788";
    out_no[10][3] = "406C3B9D7A154E5A";
    out_no[10][4] = "41E2A2DBA9F4439E";
    out_no[10][5] = "40D02797F0001B0E";
    out_no[10][6] = "4131A74CC76B6B71";
    out_no[10][7] = "4073EC2E09B0928A";
    out_no[10][8] = "40CF6DDF31C877A2";
    out_no[10][9] = "40E2A3A40DE441CE";
    out_no[10][10] = "41E8BBB44DC6D017";
    out_no[10][11] = "C0142E8A6723DD91";
    out_no[10][12] = "41619C4DB2601308";
    out_no[10][13] = "4027E9968798993D";
    out_no[10][14] = "412281B091BBF826";
    out_no[10][15] = "40A577FAB836F83B";
    out_no[10][16] = "4131E2116D584957";
    out_no[10][17] = "40A06780CB797039";
    out_no[10][18] = "40CDC74D1AEEFB5E";
    out_no[10][19] = "410BF6798FCB27A1";
    out_no[10][20] = "4186A35682D05BA3";
    out_no[10][21] = "408B96C2D9934D22";
    out_no[10][22] = "41894722A721CD48";
    out_no[10][23] = "40B6B6333E883806";
    out_no[10][24] = "41BD9B101DF34E20";
    out_no[10][25] = "4025AB37594D2A82";
    out_no[10][26] = "4192469427794C89";
    out_no[10][27] = "3FE2D2399B72EA32";
    out_no[10][28] = "41862956B23AE9A3";
    out_no[10][29] = "405115461C999CC1";
    out_no[10][30] = "4051D19765E3A58E";
    out_no[10][31] = "4048121CE094ADDC";
    out_no[10][32] = "4102AEF4F9FE6794";
    out_no[10][33] = "4065A3EBABBDA6BC";
    out_no[10][34] = "41DD57D2AF50D5F2";
    out_no[10][35] = "400C276AC22EDFD9";
    out_no[10][36] = "4052F78F244481D0";
    out_no[10][37] = "40A759CDC5D3B46E";
    out_no[10][38] = "41065A2A92EF9B47";
    out_no[10][39] = "406032D0C506E098";
    out_no[10][40] = "41D4E364A2F13447";
    out_no[10][41] = "BFD9231D192B0E9D";
    out_no[10][42] = "4173AD6ED9B4C193";
    out_no[10][43] = "4117FD159035AFE3";
    out_no[10][44] = "41AF1C714371E79C";
    out_no[10][45] = "40908F65AC0DF9CD";
    out_no[10][46] = "414FD2E45A7589DD";
    out_no[10][47] = "3FF4AB8A7BB8153C";
    out_no[10][48] = "411FF22D5D6A6586";
    out_no[10][49] = "408E93F83A76A60D";
    out_no[10][50] = "40B2A53ECF8BBB09";
    out_no[10][51] = "40795C659F50F06F";
    out_no[10][52] = "41DFDDBAD98E9E26";
    out_no[10][53] = "40B623D682405E56";
    out_no[10][54] = "40EA5EA670DEFBE5";
    out_no[10][55] = "3FB731B7ACF66E92";
    out_no[10][56] = "4107C60C998F65FE";
    out_no[10][57] = "404F03684FE3EEE1";
    out_no[10][58] = "40860DAF37997EF7";
    out_no[10][59] = "405209AFE017160F";
    out_no[10][60] = "41A939FB60BBDF26";
    out_no[11][1] = "B5C88D184A3AF3B2";
    out_no[11][2] = "95A86F08605C2AA0";
    out_no[11][3] = "AE95F745E909234F";
    out_no[11][4] = "98044C7E079C37BA";
    out_no[11][5] = "ADADB07B9AFEAC95";
    out_no[11][6] = "90362F61FBA0F40F";
    out_no[11][7] = "84F67712A1E64C2D";
    out_no[11][8] = "82FC0102C4D258EF";
    out_no[11][9] = "12871ECC8D742334";
    out_no[11][10] = "19B92C3C728CCF4B";
    out_no[11][11] = "97FBCD3FEB3B0176";
    out_no[11][12] = "1E7BEBE69E3BF3C3";
    out_no[11][13] = "A8B2469575189328";
    out_no[11][14] = "811D47030E7D6293";
    out_no[11][15] = "AAFC4D163A6CCCDA";
    out_no[11][16] = "8E33BEE6DAB70397";
    out_no[11][17] = "88007D72EF4864C7";
    out_no[11][18] = "830103CBBBF6120C";
    out_no[11][19] = "8CF08C248C37E53C";
    out_no[11][20] = "04C464F82772EF43";
    out_no[11][21] = "B1C00012A1580A3B";
    out_no[11][22] = "0E426ACF90BDFBA7";
    out_no[11][23] = "0B6BA8067112E534";
    out_no[11][24] = "1D5D11146FE4675F";
    out_no[11][25] = "BC00448C580B4CAF";
    out_no[11][26] = "2F49FE1322863726";
    out_no[11][27] = "A7C3364ADEC6BB8C";
    out_no[11][28] = "3177E16B310F878B";
    out_no[11][29] = "B00ECE335E985BBB";
    out_no[11][30] = "A392A30C3D9E32DA";
    out_no[11][31] = "8DBAA045CCB15AEE";
    out_no[11][32] = "3EAA8A188E64CDCD";
    out_no[11][33] = "AA811D6FD2B8FE1F";
    out_no[11][34] = "89B30D1074DC059E";
    out_no[11][35] = "BBCEFDE0D25F9C45";
    out_no[11][36] = "8B92A278E6C91F21";
    out_no[11][37] = "2122B060C8A4BA6E";
    out_no[11][38] = "268633B2978352B0";
    out_no[11][39] = "AD09C5FC40761842";
    out_no[11][40] = "A01DEC661DF94DAB";
    out_no[11][41] = "BD456DF81B91C382";
    out_no[11][42] = "1CB98DC940C3AE1F";
    out_no[11][43] = "AB93929E7122CE97";
    out_no[11][44] = "0AA451605CB3A73C";
    out_no[11][45] = "B19A034FA1EE4477";
    out_no[11][46] = "9F81EFAA10962372";
    out_no[11][47] = "A1F4E54C309C46F9";
    out_no[11][48] = "15228FD3055907F4";
    out_no[11][49] = "8D813B101113D370";
    out_no[11][50] = "0FFC53E9BA64FAE0";
    out_no[11][51] = "B2D2392D35EE9B75";
    out_no[11][52] = "9DB4B35284C1064B";
    out_no[11][53] = "B08AE295C6CFFAC2";
    out_no[11][54] = "87057C346B295C33";
    out_no[11][55] = "14B6938CC5EE183A";
    out_no[11][56] = "16A7EF4B0758702E";
    out_no[11][57] = "9D0B459AF91D9284";
    out_no[11][58] = "2D23F39248DA0A28";
    out_no[11][59] = "9FE57BCE16D0A1D5";
    out_no[11][60] = "0045DBB6ADFB81FE";
    out_no[12][1] = "3FF921FB54442D18";
    out_no[12][2] = "3FF921FB54442D19";
    out_no[12][3] = "3FF921FB54442D18";
    out_no[12][4] = "3FF921FB54442D19";
    out_no[12][5] = "3FF921FB54442D18";
    out_no[12][6] = "3FF921FB54442D19";
    out_no[12][7] = "3FF921FB54442D18";
    out_no[12][8] = "3FF921FB54442D19";
    out_no[12][9] = "3FF921FB54442D18";
    out_no[12][10] = "3FF921FB54442D19";
    out_no[12][11] = "3FF921FB54442D18";
    out_no[12][12] = "3FF921FB54442D19";
    out_no[12][13] = "3FF921FB54442D18";
    out_no[12][14] = "3FF921FB54442D19";
    out_no[12][15] = "3FF921FB54442D18";
    out_no[12][16] = "3FF921FB54442D19";
    out_no[12][17] = "3FF921FB54442D18";
    out_no[12][18] = "3FF921FB54442D19";
    out_no[12][19] = "3FF921FB54442D18";
    out_no[12][20] = "3FF921FB54442D19";
    out_no[12][21] = "3FF921FB54442D18";
    out_no[12][22] = "3FF921FB54442D19";
    out_no[12][23] = "3FF921FB54442D18";
    out_no[12][24] = "3FF921FB54442D19";
    out_no[12][25] = "3FF921FB54442D18";
    out_no[12][26] = "3FF921FB54442D19";
    out_no[12][27] = "3FF921FB54442D18";
    out_no[12][28] = "3FF921FB54442D19";
    out_no[12][29] = "3FF921FB54442D18";
    out_no[12][30] = "3FF921FB54442D19";
    out_no[12][31] = "3FF921FA7FF368A5";
    out_no[12][32] = "3FF921FB54442D19";
    out_no[12][33] = "3FF921FB54442D18";
    out_no[12][34] = "3FF921FB54442D19";
    out_no[12][35] = "3FF921FB54442D18";
    out_no[12][36] = "3FF921FB54442D19";
    out_no[12][37] = "3FF921FB54442D18";
    out_no[12][38] = "3FF921FB54442D19";
    out_no[12][39] = "3FF921FB54442D18";
    out_no[12][40] = "3FF921FB54442D19";
    out_no[12][41] = "3FF921FB54442D18";
    out_no[12][42] = "3FF921FB54442FC7";
    out_no[12][43] = "3FF921FB54442D18";
    out_no[12][44] = "3FF921FB54442D19";
    out_no[12][45] = "3FF921FB54442D18";
    out_no[12][46] = "3FF921FB54442D19";
    out_no[12][47] = "3FF921FB54442D18";
    out_no[12][48] = "3FF921FB54442D19";
    out_no[12][49] = "3FF921FB54442D18";
    out_no[12][50] = "3FF921FB54442D19";
    out_no[12][51] = "3FF921FB54442D18";
    out_no[12][52] = "3FF921FB54442D19";
    out_no[12][53] = "3FF921FB54442D18";
    out_no[12][54] = "3FF921FB54442D19";
    out_no[12][55] = "3FF921FB54442D18";
    out_no[12][56] = "3FF921FB54442D19";
    out_no[12][57] = "3FF921FB54442D18";
    out_no[12][58] = "3FF921FB54442D19";
    out_no[12][59] = "3FF921FB54442D18";
    out_no[12][60] = "3FF921FB54442D19";
    out_no[13][1] = "3177A77BFCCF5A9D";
    out_no[13][2] = "3FF921FB54442D19";
    out_no[13][3] = "204E2F6187DDB463";
    out_no[13][4] = "32581702EC6F2DCC";
    out_no[13][5] = "336C41FE837A300A";
    out_no[13][6] = "3FF921FB54442D19";
    out_no[13][7] = "23803AEFCC5923C5";
    out_no[13][8] = "25F1503444763FC5";
    out_no[13][9] = "3FF921FB54442D18";
    out_no[13][10] = "3FF921FB54442D19";
    out_no[13][11] = "3FEC60C5C686A64F";
    out_no[13][12] = "3FF921FB54442D19";
    out_no[13][13] = "248202722624E321";
    out_no[13][14] = "3FF921FB54442D19";
    out_no[13][15] = "2A763A15E999EB63";
    out_no[13][16] = "3FF921FB54442D19";
    out_no[13][17] = "10DA507D1C29C01C";
    out_no[13][18] = "2DF4171976A1CA54";
    out_no[13][19] = "1CDDE287D1D68C1A";
    out_no[13][20] = "3B51A6EC74D2E55C";
    out_no[13][21] = "3FF921FB54442D18";
    out_no[13][22] = "3FF921FB54442D19";
    out_no[13][23] = "3D0355E0AABCD958";
    out_no[13][24] = "3FF921FB54442D19";
    out_no[13][25] = "3FF920057E3A66F1";
    out_no[13][26] = "3FF921FB54442D19";
    out_no[13][27] = "3FF921FB54442D13";
    out_no[13][28] = "3FF921FB54442D19";
    out_no[13][29] = "3558F96439899146";
    out_no[13][30] = "3FF9172A3136EB8D";
    out_no[13][31] = "1E1AB3E906363E4A";
    out_no[13][32] = "3FF921FB54442D19";
    out_no[13][33] = "2485DAB859AB6364";
    out_no[13][34] = "36C5802285246AC3";
    out_no[13][35] = "2028826528C34185";
    out_no[13][36] = "3FF921FB54442D19";
    out_no[13][37] = "3FF921FB54442D18";
    out_no[13][38] = "3FF921FB54442D19";
    out_no[13][39] = "2C5F7A98177B25F2";
    out_no[13][40] = "3135BD629B25AA23";
    out_no[13][41] = "3FF921FB54442D18";
    out_no[13][42] = "3FF921FB54442D19";
    out_no[13][43] = "3C99975F82891DDD";
    out_no[13][44] = "3FF921FB54442D19";
    out_no[13][45] = "2A94AD560048C7B1";
    out_no[13][46] = "3BE44F68AAA2B029";
    out_no[13][47] = "3158DAD9877389A1";
    out_no[13][48] = "3FF921700D14CFE5";
    out_no[13][49] = "21FEB0E1AB78F313";
    out_no[13][50] = "3FF921FB54442D19";
    out_no[13][51] = "341D33C64C4C7E98";
    out_no[13][52] = "3FF921FB54442D19";
    out_no[13][53] = "15F7036C237D5AFF";
    out_no[13][54] = "375BDC3836934AE8";
    out_no[13][55] = "3FF921FB54442D18";
    out_no[13][56] = "3FF921FB54442D19";
    out_no[13][57] = "2BCD07742228E495";
    out_no[13][58] = "3FF921FB54442D19";
    out_no[13][59] = "3838BCA641025A82";
    out_no[13][60] = "3897DDD664E50062";
    out_no[14][1] = "38D96D6E2A829A21";
    out_no[14][2] = "3FF921FB54442D19";
    out_no[14][3] = "3FF921FB54442D18";
    out_no[14][4] = "3FF921FB54442D19";
    out_no[14][5] = "2ED88FF59FFE8269";
    out_no[14][6] = "3FF921FB54442D19";
    out_no[14][7] = "3FF921FB54442D18";
    out_no[14][8] = "3FF921FB54442D19";
    out_no[14][9] = "2D99C28FE1022AFC";
    out_no[14][10] = "3028133721D61F46";
    out_no[14][11] = "2B09FDBC923A4CEB";
    out_no[14][12] = "3FE5E330E201B3E1";
    out_no[14][13] = "3101C7C826232FB5";
    out_no[14][14] = "3FF921FB54442D19";
    out_no[14][15] = "35043F4E04ECC49C";
    out_no[14][16] = "3FF921FB54442D19";
    out_no[14][17] = "3FF921FB54442D18";
    out_no[14][18] = "3FF921FB54442D19";
    out_no[14][19] = "3FF921FB54442D18";
    out_no[14][20] = "3FF921FB54442D19";
    out_no[14][21] = "2C607D29359961F1";
    out_no[14][22] = "34A2887C3BAE43FD";
    out_no[14][23] = "2FD640A3EA993EF2";
    out_no[14][24] = "3FF921FB54442CF2";
    out_no[14][25] = "16F2067D7F96AFE5";
    out_no[14][26] = "3F3F5D609C62725F";
    out_no[14][27] = "14D824C8BF95BDE5";
    out_no[14][28] = "3CD39C88FF825E02";
    out_no[14][29] = "3F65A2461A831847";
    out_no[14][30] = "3FF921FB54442D19";
    out_no[14][31] = "0218FDF234F77F1D";
    out_no[14][32] = "3FF921FB54442D19";
    out_no[14][33] = "3FF921FB54442D18";
    out_no[14][34] = "3FF921FB54442D19";
    out_no[14][35] = "29E3C393809E2AC6";
    out_no[14][36] = "3FF921FB54442D19";
    out_no[14][37] = "30F326922CF32B2E";
    out_no[14][38] = "3403F66CB32AB74E";
    out_no[14][39] = "3FF921FB54442D18";
    out_no[14][40] = "3FF921FB54442D19";
    out_no[14][41] = "1C75F401B7014200";
    out_no[14][42] = "2533A84A0CB7AC42";
    out_no[14][43] = "35516400B111E80A";
    out_no[14][44] = "3FF921FB54442D18";
    out_no[14][45] = "3FF921FB54442D18";
    out_no[14][46] = "3FF921FB54442D19";
    out_no[14][47] = "3F2168E5EBA66A26";
    out_no[14][48] = "3FF921FB54442D19";
    out_no[14][49] = "37A408575DEEF0F7";
    out_no[14][50] = "3FF921FB54442D19";
    out_no[14][51] = "322243DECBAD4A32";
    out_no[14][52] = "3FF921FB54442D19";
    out_no[14][53] = "3FF921FB54442D18";
    out_no[14][54] = "3FF921FB54442D19";
    out_no[14][55] = "2B76F8ED062CAC9B";
    out_no[14][56] = "30218F5BF6C6D10D";
    out_no[14][57] = "17303413E0E19942";
    out_no[14][58] = "3FF921FB54442D19";
    out_no[14][59] = "3FF921FB54442D18";
    out_no[14][60] = "3FF921FB54442D19";
    out_no[15][1] = "B60A9EE4A4B6F051";
    out_no[15][2] = "842850FC1C21D837";
    out_no[15][3] = "A3BCF3637DCBCC9B";
    out_no[15][4] = "98579211918BFCCF";
    out_no[15][5] = "BFF32197576F3697";
    out_no[15][6] = "8349E96677B4C52D";
    out_no[15][7] = "A83494A24A7585D2";
    out_no[15][8] = "1A3A0790A9E3013F";
    out_no[15][9] = "A905B25E2F4CCC34";
    out_no[15][10] = "9C6E0C6608222185";
    out_no[15][11] = "AB1D5BD4BD3FB616";
    out_no[15][12] = "A613D028E4D2CCD5";
    out_no[15][13] = "BD241C6785752B92";
    out_no[15][14] = "8D71927CA3847669";
    out_no[15][15] = "B2F1BBBD6FE8B951";
    out_no[15][16] = "B23463A32DBA649D";
    out_no[15][17] = "2F54A43FA124554C";
    out_no[15][18] = "39F8C9AF520C22C4";
    out_no[15][19] = "A8073999632A55DC";
    out_no[15][20] = "85B4363967367F55";
    out_no[15][21] = "9AF55EBB1D70A46F";
    out_no[15][22] = "3ED1CCFE9451DC0E";
    out_no[15][23] = "AAB1B4B8388A3D93";
    out_no[15][24] = "9AAAA3A9479C9892";
    out_no[15][25] = "849086DCDD16F131";
    out_no[15][26] = "26EBC81B0724787D";
    out_no[15][27] = "A0773D14FA7DA1CC";
    out_no[15][28] = "3E35B3AFEEB17A86";
    out_no[15][29] = "AC09E69A4CBEF834";
    out_no[15][30] = "8AB606C7BCE75819";
    out_no[15][31] = "9FE8A6AD4ADCB2EA";
    out_no[15][32] = "8FB33B9A95C55513";
    out_no[15][33] = "9B57EA21E54298F4";
    out_no[15][34] = "8E05B83BA0D8AA3C";
    out_no[15][35] = "9DC4A3B2325572DE";
    out_no[15][36] = "0F101CD385F009B6";
    out_no[15][37] = "BBEF48D580B61D56";
    out_no[15][38] = "153EFA89F34F4189";
    out_no[15][39] = "B86329119640B5F6";
    out_no[15][40] = "9D44A00C068D5157";
    out_no[15][41] = "870FCECFF2BC9671";
    out_no[15][42] = "808F807E4671256E";
    out_no[15][43] = "B51F568A3BE035AD";
    out_no[15][44] = "10E8BA571FF9655C";
    out_no[15][45] = "8F16D772AA08698B";
    out_no[15][46] = "85348532232C10FD";
    out_no[15][47] = "130C088689D581BC";
    out_no[15][48] = "3D43BA1170C4C0E2";
    out_no[15][49] = "A834AD562C0B5179";
    out_no[15][50] = "0E8E759A7A0754DE";
    out_no[15][51] = "BA5FB40BBD5B902D";
    out_no[15][52] = "9D78C80275A696B0";
    out_no[15][53] = "AD756FBE834FC823";
    out_no[15][54] = "9FCB3020AAC5D654";
    out_no[15][55] = "AAD911493DBF33E4";
    out_no[15][56] = "8814FA3B55DA84CD";
    out_no[15][57] = "AF6125EB7DB4B390";
    out_no[15][58] = "19C28D88E1763B5E";
    out_no[15][59] = "B0D1E1711AF70A95";
    out_no[15][60] = "A4FBA5C062DE8F00";
    out_no[16][1] = "3FF0000000000000";
    out_no[16][2] = "3FF0000000000001";
    out_no[16][3] = "3FF0000000000000";
    out_no[16][4] = "3FF0000000000001";
    out_no[16][5] = "3FF0000000000000";
    out_no[16][6] = "3FF8F0A39674B193";
    out_no[16][7] = "3FF0000000000000";
    out_no[16][8] = "3FF0000000000001";
    out_no[16][9] = "3FF0000000000000";
    out_no[16][10] = "3FF0000000000001";
    out_no[16][11] = "3FF0000000000000";
    out_no[16][12] = "3FF0000000000001";
    out_no[16][13] = "3FF0000000000000";
    out_no[16][14] = "3FF0000000000001";
    out_no[16][15] = "3FF0000000000000";
    out_no[16][16] = "3FF0000000000001";
    out_no[16][17] = "3FF0000000000000";
    out_no[16][18] = "3FF0000000000001";
    out_no[16][19] = "3FF0000000000000";
    out_no[16][20] = "3FF0000000000001";
    out_no[16][21] = "3FF0000000000000";
    out_no[16][22] = "3FF0000000009E6F";
    out_no[16][23] = "3FF0000000000000";
    out_no[16][24] = "3FF0000000000001";
    out_no[16][25] = "3FF0000000000000";
    out_no[16][26] = "3FF0000000000001";
    out_no[16][27] = "3FF0000000000000";
    out_no[16][28] = "3FF0000000000001";
    out_no[16][29] = "3FF0000000000000";
    out_no[16][30] = "3FF0000000000001";
    out_no[16][31] = "3FF0000000000000";
    out_no[16][32] = "3FF0000000000001";
    out_no[16][33] = "3FF0000000000000";
    out_no[16][34] = "3FF0000000000001";
    out_no[16][35] = "3FF0000000000000";
    out_no[16][36] = "3FF0000000000001";
    out_no[16][37] = "3FF0000000000000";
    out_no[16][38] = "3FF0000000000001";
    out_no[16][39] = "3FF0000000000000";
    out_no[16][40] = "3FF0000000000001";
    out_no[16][41] = "3FF0000000000000";
    out_no[16][42] = "3FF0000000000001";
    out_no[16][43] = "3FF0000000000000";
    out_no[16][44] = "3FF0000000000001";
    out_no[16][45] = "3FF0000000000000";
    out_no[16][46] = "3FF0000000000001";
    out_no[16][47] = "3FF0000000000000";
    out_no[16][48] = "3FF0000000000001";
    out_no[16][49] = "3FF0000000000000";
    out_no[16][50] = "3FF0000000000001";
    out_no[16][51] = "3FF0000000000000";
    out_no[16][52] = "3FF0000000000001";
    out_no[16][53] = "3FF0000000000000";
    out_no[16][54] = "3FF0000000000001";
    out_no[16][55] = "3FF0000000000000";
    out_no[16][56] = "3FF0000000000001";
    out_no[16][57] = "3FF0000000000000";
    out_no[16][58] = "3FF0000000000001";
    out_no[16][59] = "3FF0000000000000";
    out_no[16][60] = "3FF0000000000001";
    out_no[17][1] = "3177A77BFCCF5A9D";
    out_no[17][2] = "3FF0000000000000";
    out_no[17][3] = "204E2F6187DDB463";
    out_no[17][4] = "32581702EC6F2DCC";
    out_no[17][5] = "336C41FE837A300A";
    out_no[17][6] = "3FF0000000000000";
    out_no[17][7] = "23803AEFCC5923C5";
    out_no[17][8] = "25F1503444763FC5";
    out_no[17][9] = "3FEFFFFFFFFFFFFF";
    out_no[17][10] = "3FF0000000000000";
    out_no[17][11] = "3FEAEE466BCC4973";
    out_no[17][12] = "3FF0000000000000";
    out_no[17][13] = "248202722624E321";
    out_no[17][14] = "3FF0000000000000";
    out_no[17][15] = "2A763A15E999EB63";
    out_no[17][16] = "3FF0000000000000";
    out_no[17][17] = "10DA507D1C29C01C";
    out_no[17][18] = "2DF4171976A1CA54";
    out_no[17][19] = "1CDDE287D1D68C1A";
    out_no[17][20] = "3B51A6EC74D2E55C";
    out_no[17][21] = "3FEFFFFFFFFFFFFF";
    out_no[17][22] = "3FF0000000000000";
    out_no[17][23] = "3D0355E0AABCD958";
    out_no[17][24] = "3FF0000000000000";
    out_no[17][25] = "3FEFFFFFFFFFFFFF";
    out_no[17][26] = "3FF0000000000000";
    out_no[17][27] = "3FEFFFFFFFFFFFFF";
    out_no[17][28] = "3FF0000000000000";
    out_no[17][29] = "3558F96439899146";
    out_no[17][30] = "3FF0000000000000";
    out_no[17][31] = "1E1AB3E906363E4A";
    out_no[17][32] = "3FF0000000000000";
    out_no[17][33] = "2485DAB859AB6364";
    out_no[17][34] = "36C5802285246AC3";
    out_no[17][35] = "2028826528C34185";
    out_no[17][36] = "3FF0000000000000";
    out_no[17][37] = "3FEFFFFFFFFFFFFF";
    out_no[17][38] = "3FF0000000000000";
    out_no[17][39] = "2C5F7A98177B25F2";
    out_no[17][40] = "3135BD629B25AA23";
    out_no[17][41] = "3FEFFFFFFFFFFFFF";
    out_no[17][42] = "3FF0000000000000";
    out_no[17][43] = "3C99975F82891DDD";
    out_no[17][44] = "3FF0000000000000";
    out_no[17][45] = "2A94AD560048C7B1";
    out_no[17][46] = "3BE44F68AAA2B029";
    out_no[17][47] = "3158DAD9877389A1";
    out_no[17][48] = "3FF0000000000000";
    out_no[17][49] = "21FEB0E1AB78F313";
    out_no[17][50] = "3FF0000000000000";
    out_no[17][51] = "341D33C64C4C7E98";
    out_no[17][52] = "3FF0000000000000";
    out_no[17][53] = "15F7036C237D5AFF";
    out_no[17][54] = "375BDC3836934AE8";
    out_no[17][55] = "3FEFFFFFFFFFFFFF";
    out_no[17][56] = "3FF0000000000000";
    out_no[17][57] = "2BCD07742228E495";
    out_no[17][58] = "3FF0000000000000";
    out_no[17][59] = "3838BCA641025A82";
    out_no[17][60] = "3897DDD664E50062";
    out_no[18][1] = "3FF0000000000000";
    out_no[18][2] = "5046CB9200ABE964";
    out_no[18][3] = "D046CB9200ABE964";
    out_no[18][4] = "BFF0000000000000";
    out_no[18][5] = "4DE279D51518EDF8";
    out_no[18][6] = "6036758D7D180F69";
    out_no[18][7] = "E036758D7D180F69";
    out_no[18][8] = "CDE279D51518EDF8";
    out_no[18][9] = "3FF0000000000000";
    out_no[18][10] = "4ECA5455B5831ACD";
    out_no[18][11] = "CECA5455B5831ACD";
    out_no[18][12] = "BFF0000000000000";
    out_no[18][13] = "5C226083E8BF47AF";
    out_no[18][14] = "5E8C747236BBD01F";
    out_no[18][15] = "DE8C747236BBD01F";
    out_no[18][16] = "DC226083E8BF47AF";
    out_no[18][17] = "3FF0000000000000";
    out_no[18][18] = "3FF0000000000001";
    out_no[18][19] = "BFF0000000000001";
    out_no[18][20] = "BFF0000000000000";
    out_no[18][21] = "3FF0000000000000";
    out_no[18][22] = "42903F0440CA0E9C";
    out_no[18][23] = "C2903F0440CA0E9C";
    out_no[18][24] = "BFF0000000000000";
    out_no[18][25] = "3FF0000000000000";
    out_no[18][26] = "5DB802A4F4EFE3B2";
    out_no[18][27] = "DDB802A4F4EFE3B2";
    out_no[18][28] = "BFF0000000000000";
    out_no[18][29] = "3FF0000000000000";
    out_no[18][30] = "5750CC8CE1CE6632";
    out_no[18][31] = "D750CC8CE1CE6632";
    out_no[18][32] = "BFF0000000000000";
    out_no[18][33] = "546FDC0CE6B8DB22";
    out_no[18][34] = "70043644784D165F";
    out_no[18][35] = "F0043644784D165F";
    out_no[18][36] = "D46FDC0CE6B8DB22";
    out_no[18][37] = "481DE0E14A11E2FE";
    out_no[18][38] = "6422B1530840571D";
    out_no[18][39] = "E422B1530840571D";
    out_no[18][40] = "C81DE0E14A11E2FE";
    out_no[18][41] = "3FF0000000000000";
    out_no[18][42] = "3FF0000000000001";
    out_no[18][43] = "BFF0000000000001";
    out_no[18][44] = "BFF0000000000000";
    out_no[18][45] = "3FF0000000000000";
    out_no[18][46] = "461B282743770CC3";
    out_no[18][47] = "C61B282743770CC3";
    out_no[18][48] = "BFF0000000000000";
    out_no[18][49] = "3FF0000000000000";
    out_no[18][50] = "3FF0000000000001";
    out_no[18][51] = "BFF0000000000001";
    out_no[18][52] = "BFF0000000000000";
    out_no[18][53] = "3FF0000000000000";
    out_no[18][54] = "3FF0000000000001";
    out_no[18][55] = "BFF0000000000001";
    out_no[18][56] = "BFF0000000000000";
    out_no[18][57] = "4157D91A9DDE7C45";
    out_no[18][58] = "4AF9F8AFAA8DBFF9";
    out_no[18][59] = "CAF9F8AFAA8DBFF9";
    out_no[18][60] = "C157D91A9DDE7C45";
    out_no[19][1] = "3177A77BFCCF5A9D";
    out_no[19][2] = "4053CFEA73418196";
    out_no[19][3] = "204E2F6187DDB463";
    out_no[19][4] = "32581702EC6F2DCC";
    out_no[19][5] = "336C41FE837A300A";
    out_no[19][6] = "4067C5FAAA9C6E7C";
    out_no[19][7] = "23803AEFCC5923C5";
    out_no[19][8] = "25F1503444763FC5";
    out_no[19][9] = "4065F4D3526A4A27";
    out_no[19][10] = "40698011E3B75072";
    out_no[19][11] = "3FF086AFFAE230B6";
    out_no[19][12] = "406D0D31703C4556";
    out_no[19][13] = "248202722624E321";
    out_no[19][14] = "4064C7FE7CFAD6E6";
    out_no[19][15] = "2A763A15E999EB63";
    out_no[19][16] = "405E708ACD6C73B8";
    out_no[19][17] = "10DA507D1C29C01C";
    out_no[19][18] = "2DF4171976A1CA54";
    out_no[19][19] = "1CDDE287D1D68C1A";
    out_no[19][20] = "3B51A6EC74D2E55C";
    out_no[19][21] = "405F805F45086BB5";
    out_no[19][22] = "406B33C799E851AE";
    out_no[19][23] = "3D0355E0AABCD958";
    out_no[19][24] = "4066663F857841CE";
    out_no[19][25] = "4020ACF6612B7070";
    out_no[19][26] = "407C7474C3E00682";
    out_no[19][27] = "404192D04257C4BF";
    out_no[19][28] = "407DE8DA2F064858";
    out_no[19][29] = "3558F96439899146";
    out_no[19][30] = "401A84EA179951E2";
    out_no[19][31] = "1E1AB3E906363E4A";
    out_no[19][32] = "408573B3FF919870";
    out_no[19][33] = "2485DAB859AB6364";
    out_no[19][34] = "36C5802285246AC3";
    out_no[19][35] = "2028826528C34185";
    out_no[19][36] = "406EA535E77020FC";
    out_no[19][37] = "40609B9D970A5C3D";
    out_no[19][38] = "4064DBCC91540344";
    out_no[19][39] = "2C5F7A98177B25F2";
    out_no[19][40] = "3135BD629B25AA23";
    out_no[19][41] = "40729277EA798036";
    out_no[19][42] = "4078A159CCBD552A";
    out_no[19][43] = "3C99975F82891DDD";
    out_no[19][44] = "405D9C78021DA20C";
    out_no[19][45] = "2A94AD560048C7B1";
    out_no[19][46] = "3BE44F68AAA2B029";
    out_no[19][47] = "3158DAD9877389A1";
    out_no[19][48] = "40233D3E9EB4AC11";
    out_no[19][49] = "21FEB0E1AB78F313";
    out_no[19][50] = "40572A0B7B6CF4C8";
    out_no[19][51] = "341D33C64C4C7E98";
    out_no[19][52] = "406337E170ECD30A";
    out_no[19][53] = "15F7036C237D5AFF";
    out_no[19][54] = "375BDC3836934AE8";
    out_no[19][55] = "4065FEEC551661D4";
    out_no[19][56] = "406C75E106D65EB6";
    out_no[19][57] = "2BCD07742228E495";
    out_no[19][58] = "407C49CCB25BBD50";
    out_no[19][59] = "3838BCA641025A82";
    out_no[19][60] = "3897DDD664E50062";
    out_no[20][1] = "4067DEE77E85833B";
    out_no[20][2] = "4082AD828325B615";
    out_no[20][3] = "406E1578227B635E";
    out_no[20][4] = "4073540A29BC6B5E";
    out_no[20][5] = "4044B2548CBDFC19";
    out_no[20][6] = "40802D9B31FD7329";
    out_no[20][7] = "40570E708B5EAA42";
    out_no[20][8] = "4070AE10BDF7FE81";
    out_no[20][9] = "406684AB36B9E69D";
    out_no[20][10] = "407879CCE87EE3A1";
    out_no[20][11] = "407886C6F1DDDFF7";
    out_no[20][12] = "407FB958311209BF";
    out_no[20][13] = "4040907CADE8FB83";
    out_no[20][14] = "40769F464545899A";
    out_no[20][15] = "404B9135F80ABC98";
    out_no[20][16] = "4076F0E8DBF98710";
    out_no[20][17] = "4069BC5F7CF1FD85";
    out_no[20][18] = "408624B3322CF0D2";
    out_no[20][19] = "4071DD92C82827A1";
    out_no[20][20] = "4082C06830395F90";
    out_no[20][21] = "40752BD770642386";
    out_no[20][22] = "4082DF6DBF1BB70C";
    out_no[20][23] = "4070A7FEC190CCEE";
    out_no[20][24] = "407BC5349B021815";
    out_no[20][25] = "407A7E8C5069EA32";
    out_no[20][26] = "407C439E5E8A511C";
    out_no[20][27] = "4028AC0C581882A3";
    out_no[20][28] = "4078A0201556D85A";
    out_no[20][29] = "4063B9AF9818FFF7";
    out_no[20][30] = "4073A6FC95911674";
    out_no[20][31] = "40761D49DF92AB79";
    out_no[20][32] = "407DDAB5081E5A0E";
    out_no[20][33] = "4040A97BE96DF95E";
    out_no[20][34] = "4063520FCF8E02D2";
    out_no[20][35] = "405636F8A9FA5A64";
    out_no[20][36] = "407A6515B9ECF2F1";
    out_no[20][37] = "4061F77D677098E1";
    out_no[20][38] = "40662D377C2627ED";
    out_no[20][39] = "404A7A16DFE0725A";
    out_no[20][40] = "4082F674C9163C4A";
    out_no[20][41] = "4063CDADD40C660E";
    out_no[20][42] = "40852FE5F6E8AF96";
    out_no[20][43] = "40776986E964982D";
    out_no[20][44] = "4081467423FB4EE5";
    out_no[20][45] = "405FB898511B757E";
    out_no[20][46] = "40813C8CFA479610";
    out_no[20][47] = "4074647297977E4E";
    out_no[20][48] = "408198B76AB804EA";
    out_no[20][49] = "40806C14110011AC";
    out_no[20][50] = "408400CC014CAA86";
    out_no[20][51] = "40495C3E9BE4F57D";
    out_no[20][52] = "4084D5DF6953BF31";
    out_no[20][53] = "40812DE17E43B75E";
    out_no[20][54] = "4083F92D44FF0B73";
    out_no[20][55] = "4072EED02D819A15";
    out_no[20][56] = "407B9DB8970CC5EC";
    out_no[20][57] = "4074103588C86AB6";
    out_no[20][58] = "4078B4A572E180D4";
    out_no[20][59] = "404D35EA0B7E67B8";
    out_no[20][60] = "4080B01EA76E59B5";
    out_no[21][1] = "B5C88D184A3AF3B2";
    out_no[21][2] = "95A86F08605C2AA0";
    out_no[21][3] = "AE95F745E909234F";
    out_no[21][4] = "98044C7E079C37BA";
    out_no[21][5] = "ADADB07B9AFEAC95";
    out_no[21][6] = "90362F61FBA0F40F";
    out_no[21][7] = "84F67712A1E64C2D";
    out_no[21][8] = "82FC0102C4D258EF";
    out_no[21][9] = "12871ECC8D742334";
    out_no[21][10] = "19B92C3C728CCF4B";
    out_no[21][11] = "97FBCD3FEB3B0176";
    out_no[21][12] = "1E7BEBE69E3BF3C3";
    out_no[21][13] = "A8B2469575189328";
    out_no[21][14] = "811D47030E7D6293";
    out_no[21][15] = "AAFC4D163A6CCCDA";
    out_no[21][16] = "8E33BEE6DAB70397";
    out_no[21][17] = "88007D72EF4864C7";
    out_no[21][18] = "830103CBBBF6120C";
    out_no[21][19] = "8CF08C248C37E53C";
    out_no[21][20] = "04C464F82772EF43";
    out_no[21][21] = "B1C00012A1580A3B";
    out_no[21][22] = "0E426ACF90BDFBA7";
    out_no[21][23] = "0B6BA8067112E534";
    out_no[21][24] = "1D5D11146FE4675F";
    out_no[21][25] = "BC00448C580B4CAF";
    out_no[21][26] = "2F49FE1322863726";
    out_no[21][27] = "A7C3364ADEC6BB8C";
    out_no[21][28] = "3177E16B310F878B";
    out_no[21][29] = "B00ECE335E985BBB";
    out_no[21][30] = "A392A30C3D9E32DA";
    out_no[21][31] = "8DBAA045CCB15AEE";
    out_no[21][32] = "3EAA8A188E64D0D8";
    out_no[21][33] = "AA811D6FD2B8FE1F";
    out_no[21][34] = "89B30D1074DC059E";
    out_no[21][35] = "BBCEFDE0D25F9C45";
    out_no[21][36] = "8B92A278E6C91F21";
    out_no[21][37] = "2122B060C8A4BA6E";
    out_no[21][38] = "268633B2978352B0";
    out_no[21][39] = "AD09C5FC40761842";
    out_no[21][40] = "A01DEC661DF94DAB";
    out_no[21][41] = "BD456DF81B91C382";
    out_no[21][42] = "1CB98DC940C3AE1F";
    out_no[21][43] = "AB93929E7122CE97";
    out_no[21][44] = "0AA451605CB3A73C";
    out_no[21][45] = "B19A034FA1EE4477";
    out_no[21][46] = "9F81EFAA10962372";
    out_no[21][47] = "A1F4E54C309C46F9";
    out_no[21][48] = "15228FD3055907F4";
    out_no[21][49] = "8D813B101113D370";
    out_no[21][50] = "0FFC53E9BA64FAE0";
    out_no[21][51] = "B2D2392D35EE9B75";
    out_no[21][52] = "9DB4B35284C1064B";
    out_no[21][53] = "B08AE295C6CFFAC2";
    out_no[21][54] = "87057C346B295C33";
    out_no[21][55] = "14B6938CC5EE183A";
    out_no[21][56] = "16A7EF4B0758702E";
    out_no[21][57] = "9D0B459AF91D9284";
    out_no[21][58] = "2D23F39248DA0A28";
    out_no[21][59] = "9FE57BCE16D0A1D5";
    out_no[21][60] = "0045DBB6ADFB81FE";
    out_no[22][1] = "0A1A4EE30692B693";
    out_no[22][2] = "2EC68B2A82CBA66E";
    out_no[22][3] = "AEC68B2A82CBA66E";
    out_no[22][4] = "8A1A4EE30692B693";
    out_no[22][5] = "241CB33363CF9361";
    out_no[22][6] = "2A4B9314AE6B7014";
    out_no[22][7] = "AA4B9314AE6B7014";
    out_no[22][8] = "A41CB33363CF9361";
    out_no[22][9] = "115155E03026EC92";
    out_no[22][10] = "3C43750763036C96";
    out_no[22][11] = "BC43750763036C96";
    out_no[22][12] = "915155E03026EC92";
    out_no[22][13] = "27EF7281FCC024B8";
    out_no[22][14] = "37AED6161B945AE8";
    out_no[22][15] = "B7AED6161B945AE8";
    out_no[22][16] = "A7EF7281FCC024B8";
    out_no[22][17] = "1CB04086A3447A55";
    out_no[22][18] = "2FC133673D482A92";
    out_no[22][19] = "AFC133673D482A92";
    out_no[22][20] = "9CB04086A3447A55";
    out_no[22][21] = "123A3110641EF7BC";
    out_no[22][22] = "1C9CE3A5F6DEAF65";
    out_no[22][23] = "9C9CE3A5F6DEAF65";
    out_no[22][24] = "923A3110641EF7BC";
    out_no[22][25] = "1F5C0C3909E97DC0";
    out_no[22][26] = "3D02722E2F0C7507";
    out_no[22][27] = "BD02722E2F0C7507";
    out_no[22][28] = "9F5C0C3909E97DC0";
    out_no[22][29] = "1EE5D70B7826EB83";
    out_no[22][30] = "3B05F9970A6D8E93";
    out_no[22][31] = "BB05F9970A6D8E93";
    out_no[22][32] = "9EE5D70B7826EB83";
    out_no[22][33] = "001A6F23DAF9A6A1";
    out_no[22][34] = "2D6F4E321BDAC224";
    out_no[22][35] = "AD6F4E321BDAC224";
    out_no[22][36] = "801A6F23DAF9A6A1";
    out_no[22][37] = "09E3D45E2DA96A35";
    out_no[22][38] = "2638630054C790C6";
    out_no[22][39] = "A638630054C790C6";
    out_no[22][40] = "89E3D45E2DA96A35";
    out_no[22][41] = "098A448D13B86FBE";
    out_no[22][42] = "2173B7754395DD7F";
    out_no[22][43] = "A173B7754395DD7F";
    out_no[22][44] = "898A448D13B86FBE";
    out_no[22][45] = "17EF6DDC25C89C8F";
    out_no[22][46] = "27F6FA7BD9AAC5D2";
    out_no[22][47] = "A7F6FA7BD9AAC5D2";
    out_no[22][48] = "97EF6DDC25C89C8F";
    out_no[22][49] = "1737D8116060016C";
    out_no[22][50] = "19C58774FD30E06D";
    out_no[22][51] = "99C58774FD30E06D";
    out_no[22][52] = "9737D8116060016C";
    out_no[22][53] = "1C77B35C74EEC020";
    out_no[22][54] = "3EE26A6E9CED637D";
    out_no[22][55] = "BEE26A6E9CED637D";
    out_no[22][56] = "9C77B35C74EEC020";
    out_no[22][57] = "23A496B55DBF9CD5";
    out_no[22][58] = "31C43C67A972FDFC";
    out_no[22][59] = "B1C43C67A972FDFC";
    out_no[22][60] = "A3A496B55DBF9CD5";
    out_no[23][1] = "BFF0000000000000";
    out_no[23][2] = "B17B3E4076622F03";
    out_no[23][3] = "B24210215CD4421C";
    out_no[23][4] = "A045109A14ED8283";
    out_no[23][5] = "BFF0000000000000";
    out_no[23][6] = "B375D74CFDA6B291";
    out_no[23][7] = "A600753C8C437B89";
    out_no[23][8] = "A38FF335468D1A38";
    out_no[23][9] = "BFF0000000000000";
    out_no[23][10] = "BFF0000000000000";
    out_no[23][11] = "BFF0000000000000";
    out_no[23][12] = "BFEA8B797509DC4D";
    out_no[23][13] = "BFF0000000000000";
    out_no[23][14] = "A493C3CA0DC2427E";
    out_no[23][15] = "BFF0000000000000";
    out_no[23][16] = "AA7EB095183538C7";
    out_no[23][17] = "AE03F6C4AA3B2589";
    out_no[23][18] = "90E0E3B84422F7D1";
    out_no[23][19] = "BB6B9E7371BAD173";
    out_no[23][20] = "9CE0040B8B626AF5";
    out_no[23][21] = "BFF0000000000000";
    out_no[23][22] = "BFF0000000000000";
    out_no[23][23] = "BFF0000000000000";
    out_no[23][24] = "BD172F8AF508EBC7";
    out_no[23][25] = "BFF0000000000000";
    out_no[23][26] = "BFEFFFFFFFFFFFFF";
    out_no[23][27] = "BFF0000000000000";
    out_no[23][28] = "BFF0000000000000";
    out_no[23][29] = "BFF0000000000000";
    out_no[23][30] = "B542C0ED6CD7F36D";
    out_no[23][31] = "BFF0000000000000";
    out_no[23][32] = "9E1C64E43E18BD26";
    out_no[23][33] = "B6B58391FD92C387";
    out_no[23][34] = "A490304909A95C64";
    out_no[23][35] = "BFF0000000000000";
    out_no[23][36] = "A02E27C711642CBD";
    out_no[23][37] = "BFF0000000000000";
    out_no[23][38] = "BFF0000000000000";
    out_no[23][39] = "B1210D04D9C356E0";
    out_no[23][40] = "AC53FAA34E8FB405";
    out_no[23][41] = "3FFB7E151628AED2";
    out_no[23][42] = "40198E64B8D4DDAE";
    out_no[23][43] = "BFE43A54E4E98865";
    out_no[23][44] = "40198E64B8D4DDAE";
    out_no[23][45] = "BFEFC8CD803FE55A";
    out_no[23][46] = "BFEE6824F33314F5";
    out_no[23][47] = "BFEBAB5557101F8E";
    out_no[23][48] = "3FEA4ECC162353DF";
    out_no[23][49] = "0000000000000001";
    out_no[23][50] = "0000000000111112";
    out_no[23][51] = "0000000000001111";
    out_no[23][52] = "3FFB7E151628AED3";
    out_no[23][53] = "8000000000011111";
    out_no[23][54] = "0000000000011112";
    out_no[23][55] = "8000000000000111";
    out_no[23][56] = "40198C8BE15033ED";
    out_no[23][57] = "BFEBAB5102634C48";
    out_no[23][58] = "8000000002222221";
    out_no[23][59] = "BFEBAB5556CAD4E3";
    out_no[23][60] = "0000000233445556";
    out_no[24][1] = "2FA89694DD6D675D";
    out_no[24][2] = "405089EB6060FEDC";
    out_no[24][3] = "1FC3109F10D8A449";
    out_no[24][4] = "3219981BC265797D";
    out_no[24][5] = "31221FE595436608";
    out_no[24][6] = "406481668DE8A843";
    out_no[24][7] = "2161C55B51BF7D26";
    out_no[24][8] = "23CB3E59DF05D8A3";
    out_no[24][9] = "406101E0E2F43B88";
    out_no[24][10] = "4063AC261E03F16F";
    out_no[24][11] = "3D5A800284A0E117";
    out_no[24][12] = "406812355A240E0B";
    out_no[24][13] = "2233C84E4F9C80CD";
    out_no[24][14] = "40614226F7BCAB9F";
    out_no[24][15] = "28A083A5B6DB26A8";
    out_no[24][16] = "4058876036464EAE";
    out_no[24][17] = "0FF2C18FEEBCAEAD";
    out_no[24][18] = "2B7C369E759DF5E3";
    out_no[24][19] = "1BD3653A458674FB";
    out_no[24][20] = "37C4FB657B5AA89F";
    out_no[24][21] = "40545762D0438297";
    out_no[24][22] = "40681427B8A6D9AB";
    out_no[24][23] = "39C9B6F2E2AACA76";
    out_no[24][24] = "4061BFEA0DFC1B3F";
    out_no[24][25] = "40115DC4E47CC236";
    out_no[24][26] = "4079D179EA5204D0";
    out_no[24][27] = "402D9A298A0248F8";
    out_no[24][28] = "407B46DC0D02B874";
    out_no[24][29] = "35019CA879C7C186";
    out_no[24][30] = "3E96F80DDF9413DE";
    out_no[24][31] = "1D092781EF99AB45";
    out_no[24][32] = "408402E716E4881B";
    out_no[24][33] = "22C6AB931CEE2FD3";
    out_no[24][34] = "35F95CF42AA171CD";
    out_no[24][35] = "1ED1C1680A0C0B6B";
    out_no[24][36] = "406C34946A47E4CB";
    out_no[24][37] = "4059593426B47485";
    out_no[24][38] = "406122952A63FA23";
    out_no[24][39] = "2B927E9687937DCF";
    out_no[24][40] = "30F11B85141B78F6";
    out_no[24][41] = "406F7AE611DAE7FE";
    out_no[24][42] = "4076DF4DA39DC5DD";
    out_no[24][43] = "395A211040E355AD";
    out_no[24][44] = "4057DC62EFC338BE";
    out_no[24][45] = "29DC5D872AC1544C";
    out_no[24][46] = "3B392EFD09488689";
    out_no[24][47] = "30588217909D04F1";
    out_no[24][48] = "3DE719BA75FC46BA";
    out_no[24][49] = "20A7EBE381F4672E";
    out_no[24][50] = "4049B695890A8454";
    out_no[24][51] = "32A778FC6FD65A70";
    out_no[24][52] = "4060B5B80D3EC315";
    out_no[24][53] = "14FE139DD116F867";
    out_no[24][54] = "36EA4A8A68DAD1FA";
    out_no[24][55] = "4060C486291E8C41";
    out_no[24][56] = "4066A336DCA89F13";
    out_no[24][57] = "2AD671190BB5E2F1";
    out_no[24][58] = "407990C99B6124FE";
    out_no[24][59] = "34EF80BD5021BFD0";
    out_no[24][60] = "36A40B109F7DABE9";
    out_no[25][1] = "37CC0CE46227E574";
    out_no[25][2] = "42EA5E5061F52645";
    out_no[25][3] = "2FD8B322D746DD92";
    out_no[25][4] = "39043C7C708713A9";
    out_no[25][5] = "3888153A5585DF9B";
    out_no[25][6] = "475425E465111A84";
    out_no[25][7] = "30A7D8C77FC21799";
    out_no[25][8] = "31DD86B2273C5E01";
    out_no[25][9] = "4611B2FACB63D9C6";
    out_no[25][10] = "4707079918CD6185";
    out_no[25][11] = "3EA4975DCFE90520";
    out_no[25][12] = "489E0C3235697CF6";
    out_no[25][13] = "3111CA7DF0D1338C";
    out_no[25][14] = "462828A33ACD2FFE";
    out_no[25][15] = "3446FCF8A53263BD";
    out_no[25][16] = "445B61F599C226F6";
    out_no[25][17] = "27F152C585EDDB6A";
    out_no[25][18] = "35B53F1A81CAA4A0";
    out_no[25][19] = "2DE19DB8426BC0BD";
    out_no[25][20] = "3BD9E96FBC95E70D";
    out_no[25][21] = "4399DC8B22366176";
    out_no[25][22] = "489EF9C5CC91699A";
    out_no[25][23] = "3CDCAF89228C2349";
    out_no[25][24] = "46558C0892D42F3E";
    out_no[25][25] = "40216A76C242F69F";
    out_no[25][26] = "528FA07D2A534CF1";
    out_no[25][27] = "40999387D9205E4C";
    out_no[25][28] = "539C2EF801BA24D3";
    out_no[25][29] = "3A77BD69462CDAD2";
    out_no[25][30] = "3F432B9DFD924778";
    out_no[25][31] = "2E7C5F168118C2B1";
    out_no[25][32] = "5CCE5C6656B17688";
    out_no[25][33] = "315AEF2280DB324C";
    out_no[25][34] = "3AF4250C275A7B2B";
    out_no[25][35] = "2F60DADB347D442C";
    out_no[25][36] = "4A1B3AC5FD5BC6D4";
    out_no[25][37] = "4481A1F10AF59132";
    out_no[25][38] = "461D80F99FC38774";
    out_no[25][39] = "35C133BBE271B45F";
    out_no[25][40] = "38708B63617A4210";
    out_no[25][41] = "4B495C9A66E614F0";
    out_no[25][42] = "506F99333020215A";
    out_no[25][43] = "3CA4725936450707";
    out_no[25][44] = "443CCC9C68E6B873";
    out_no[25][45] = "34E54DBC003C350F";
    out_no[25][46] = "3D9412C2D0AC617D";
    out_no[25][47] = "3823CD62FBB21703";
    out_no[25][48] = "3EEB30435C147E51";
    out_no[25][49] = "304BAADBFCD8A3FE";
    out_no[25][50] = "42411AD7B2551299";
    out_no[25][51] = "394B6818C65B2CB8";
    out_no[25][52] = "45F589B93C7CC280";
    out_no[25][53] = "2A75EFD65C23F515";
    out_no[25][54] = "3B6D0166D0139468";
    out_no[25][55] = "45FB24CEBB3D4B84";
    out_no[25][56] = "4818DED33641A18D";
    out_no[25][57] = "3562F2F89AD0042E";
    out_no[25][58] = "5260C1A3E03E351B";
    out_no[25][59] = "3A6FC01EE5CD905F";
    out_no[25][60] = "3B495356C567E5D8";
    out_no[26][1] = "0000000000000000";
    out_no[26][2] = "2D5AFF52102CCD1E";
    out_no[26][3] = "0000000000000000";
    out_no[26][4] = "098502F54272449E";
    out_no[26][5] = "0000000000000000";
    out_no[26][6] = "40BD1A144EFBEB44";
    out_no[26][7] = "0000000000000000";
    out_no[26][8] = "118440BDFD7DEF8C";
    out_no[26][9] = "0000000000000000";
    out_no[26][10] = "13A60A3980B85D7C";
    out_no[26][11] = "0C917A0FA5BFDA4F";
    out_no[26][12] = "16E4A9194FF18274";
    out_no[26][13] = "0000000000000000";
    out_no[26][14] = "3AF6EBF489D48CA5";
    out_no[26][15] = "26A18460AD749015";
    out_no[26][16] = "27390CBA74D12CF4";
    out_no[26][17] = "1EED13C8B128FDF5";
    out_no[26][18] = "3627E9C3333AE604";
    out_no[26][19] = "0000000000000000";
    out_no[26][20] = "11611A0FE5D04EEE";
    out_no[26][21] = "0000000000000000";
    out_no[26][22] = "3E6953606A01BAAF";
    out_no[26][23] = "0000000000000000";
    out_no[26][24] = "1657D96094E3C3D1";
    out_no[26][25] = "0000000000000000";
    out_no[26][26] = "0FC29443FF0807F8";
    out_no[26][27] = "0000000000000000";
    out_no[26][28] = "3DBB9CBC9B69E7BF";
    out_no[26][29] = "0000000000000000";
    out_no[26][30] = "1A50DDEC946AF730";
    out_no[26][31] = "0000000000000000";
    out_no[26][32] = "01C6B34138BA2D21";
    out_no[26][33] = "0000000000000000";
    out_no[26][34] = "0000000000000001";
    out_no[26][35] = "0000000000000000";
    out_no[26][36] = "0000000000000001";
    out_no[26][37] = "0000000000000000";
    out_no[26][38] = "39E2F4D28E026BF5";
    out_no[26][39] = "0000000000000000";
    out_no[26][40] = "30D95F2F4822CD2B";
    out_no[26][41] = "0000000000000000";
    out_no[26][42] = "0000000000000001";
    out_no[26][43] = "0000000000000000";
    out_no[26][44] = "2B61982BC685F91B";
    out_no[26][45] = "0000000000000000";
    out_no[26][46] = "0000000000000001";
    out_no[26][47] = "0000000000000000";
    out_no[26][48] = "3CAA8D91848C69F9";
    out_no[26][49] = "0000000000000000";
    out_no[26][50] = "111099388D81EFAA";
    out_no[26][51] = "0000000000000000";
    out_no[26][52] = "3581D1FA29F657DA";
    out_no[26][53] = "022DF9E5A5EA5698";
    out_no[26][54] = "1DB0FE5AD9038BC9";
    out_no[26][55] = "0000000000000000";
    out_no[26][56] = "174F66DF1B9F564A";
    out_no[26][57] = "0000000000000000";
    out_no[26][58] = "206253B765685531";
    out_no[26][59] = "0A69FC361BC43CAD";
    out_no[26][60] = "22E16C2717C18B6F";

    printf("Workstation ('big endian')==> 0  or PC ('little endian') ==> 1 ? ");
    scanf("%d",&wks);
    wks++;

    printf("This program tests the library fi_lib.a \n");
    printf("---------------------------------------- \n");

    boolhelp = pred_test();
    alltrue=alltrue && boolhelp;
    boolhelp = succ_test();
    alltrue=alltrue && boolhelp;
    boolhelp = addii_test();
    alltrue=alltrue && boolhelp;
    boolhelp = subii_test();
    alltrue=alltrue && boolhelp;
    boolhelp = mulii_test();
    alltrue=alltrue && boolhelp;
    boolhelp = divii_test();
    alltrue=alltrue && boolhelp;

    for (eing=1;eing<=fkt_max;eing++) {
       j=1;
       for (i=1;i<=anz_max;i++) {
          if (i%2==0) { 
             x[j].SUP = hexu(in_no[eing][i]);
             z[j].SUP = hexu(out_no[eing][i]);
             j++;
          } else {
             x[j].INF = hexu(in_no[eing][i]);
             z[j].INF = hexu(out_no[eing][i]);
          }
       }

       for (i=1;i<j;i++) {
          switch (eing) {
             case  1: y[i]=j_exp(x[i]);break;
             case  2: y[i]=j_exp2(x[i]);break;
             case  3: y[i]=j_ex10(x[i]);break;
             case  4: y[i]=j_log(x[i]);break;
             case  5: y[i]=j_log2(x[i]);break;
             case  6: y[i]=j_lg10(x[i]);break;
             case  7: y[i]=j_sin(x[i]);break;
             case  8: y[i]=j_cos(x[i]);break;
             case  9: y[i]=j_tan(x[i]);break;
             case 10: y[i]=j_cot(x[i]);break;
             case 11: y[i]=j_asin(x[i]);break;
             case 12: y[i]=j_acos(x[i]);break;
             case 13: y[i]=j_atan(x[i]);break;
             case 14: y[i]=j_acot(x[i]);break;
             case 15: y[i]=j_sinh(x[i]);break;
             case 16: y[i]=j_cosh(x[i]);break;
             case 17: y[i]=j_tanh(x[i]);break;
             case 18: y[i]=j_coth(x[i]);break;
             case 19: y[i]=j_asnh(x[i]);break;
             case 20: y[i]=j_acsh(x[i]);break;
             case 21: y[i]=j_atnh(x[i]);break;
             case 22: y[i]=j_acth(x[i]);break;
             case 23: y[i]=j_expm(x[i]);break;
             case 24: y[i]=j_lg1p(x[i]);break;
             case 25: y[i]=j_sqrt(x[i]);break;
             case 26: y[i]=j_sqr(x[i]);break;
             default : printf("Error in program fi_test.c \n");break;
          }
          if ((y[i].INF>z[i].INF)||(y[i].SUP<z[i].SUP)) {
             printf("\n Error for [%24.15e,%24.15e] and n=%u\n", x[i].INF, x[i].SUP, i);
             printf("computed result:  %24.15e, %24.15e\n", y[i].INF, y[i].SUP);
             printf("correct result:   %24.15e, %24.15e\n", z[i].INF, z[i].SUP);
             schalt=1;
          }
       }
       if (schalt==0) 
          printf("No error: Test with function ");
          switch (eing) {
             case  1: printf("j_exp \n");   break;
             case  2: printf("j_exp2 \n");  break;
             case  3: printf("j_exp10 \n"); break;
             case  4: printf("j_log \n");   break;
             case  5: printf("j_log2 \n");  break;
             case  6: printf("j_log10 \n"); break;
             case  7: printf("j_sin \n");   break;
             case  8: printf("j_cos \n");   break;
             case  9: printf("j_tan \n");   break;
             case 10: printf("j_cot \n");   break;
             case 11: printf("j_asin \n");  break;
             case 12: printf("j_acos \n");  break;
             case 13: printf("j_atan \n");  break;
             case 14: printf("j_acot \n");  break;
             case 15: printf("j_sinh \n");  break;
             case 16: printf("j_cosh \n");  break;
             case 17: printf("j_tanh \n");  break;
             case 18: printf("j_coth \n");  break;
             case 19: printf("j_asinh \n"); break;
             case 20: printf("j_acosh \n"); break;
             case 21: printf("j_atanh \n"); break;
             case 22: printf("j_acoth \n"); break;
             case 23: printf("j_expm1 \n"); break;
             case 24: printf("j_log1p \n"); break;
             case 25: printf("j_sqrt \n");  break;
             case 26: printf("j_sqr \n");   break;
          }
       alltrue=alltrue && (!schalt);
    } 
        
    printf("\n----------------------------------------------\n");
    if (alltrue==1) printf("Test for library fi_lib.a: OK! \n");
    else {
       printf("Test for library fi_lib.a: ERRORS! \n\n");
       printf("If you have problems:\n");
       printf("---------------------\n");
       printf("1. Check the configuring section in file 'fi_lib.h' \n");
       printf("2. Check the call of the C-compiler in the Makefile \n");
       printf("   (e.g. CC = cc  or  CC = gcc  or ... ) \n");
       printf("3. Check the call of the C++ compiler in the Makefile \n");
       printf("   (e.g. CPP = CC or  CPP = g++  or ... ) \n");
       printf("4. Check the options for the compiler in the Makefile \n");
       printf("   (e.g. on HP-Workstations you must probably use CFLAGS= -Aa \n");
       printf("   and COPT = -O) or in the batch file compall.bat \n");
       printf("5. Compile the library without any optimization options \n");
       printf("   (e.g. without -O or -O2).\n");
       printf("   Some Compilers do some nasty things here.\n");
    }
    printf("----------------------------------------------\n");
	
    return 0;
}


