/*********************************************************************/
/*       fi_lib  --- A fast interval library (Version 1.2)           */
/*        (For copyright and info`s see file "fi_lib.h")             */
/*********************************************************************/

/* RCS $Id: q_glbl.c,v 1.4 1997/07/15 14:57:04 ae13 Exp $ */
/*
$Log: q_glbl.c,v $
 * Revision 1.4  1997/07/15  14:57:04  ae13
 * *** empty log message ***
 *
 * Revision 1.3  1997/07/15  09:08:31  ae13
 * *** empty log message ***
 *
 * Revision 1.2  1997/06/10  14:04:11  ae13
 * new approximation for arctan and new error bounds for arcus-functions
 *
 */
/****************************************************************/
/*                                                              */
/*      Description     : Constants for fast real functions     */
/*                        for double IEEE Floating-Point        */
/*                        Arithmetic                            */
/*                                                              */
/*      Date            : 1997-06-10                            */
/*                                                              */
/*      Author          : W. Hofschuster                        */
/*                                                              */
/****************************************************************/


/* --------------------------------------------------------------------- */
/* ---- relative worst case error bounds for the standard functions  --- */
/* --------------------------------------------------------------------- */

#undef RND_TO_NRST

#ifdef RND_TO_NRST

#else

   /* worst case relative error bound for q_exp */

   /* eps(q_exp)  = 2.357962555295842e-16;                   */ 
   /*     q_exem  = 1 - eps(q_exp) = 9.999999999999993E-001  */
   double q_exem  = 9007199254740986.0 / 9007199254740992.0;
   /*     q_exep  = 1 + eps(q_exp) = 1.000000000000001E+000  */
   double q_exep  = 4503599627370501.0 / 4503599627370496.0;

   /* worst case relative error bound for q_expm */

   /* eps(q_expm) = 2.592561649228397E-016;                  */
   /*     q_exmm  = 1 - eps(q_expm) = 9.999999999999993E-001 */
   double q_exmm  =  9007199254740986.0 / 9007199254740992.0;
   /*     q_exmp  = 1 + eps(q_expm) = 1.000000000000001E+000 */
   double q_exmp  =  4503599627370501.0 / 4503599627370496.0;

   /* worst case relative error bound for q_log */ 
   
   /* eps(q_log)  = 2.9398E-016;                             */
   /*     q_logm  = 1 - eps(q_log)                           */
   double q_logm  = 9007199254740986.0 / 9007199254740992.0;
   /*     q_logp  = 1 + eps(q_log)                           */
   double q_logp  = 4503599627370501.0 / 4503599627370496.0;

   /* worst case relative error bound for q_lg1p */
   
   /* eps(q_lg1p) = 2.5082E-016;                             */
   /*     q_lgpm  = 1 - eps(q_lg1p)                          */
   double q_lgpm  = 9007199254740986.0 / 9007199254740992.0;
   /*     q_lgpp  = 1 + eps(q_lg1p)                          */
   double q_lgpp  = 4503599627370501.0 / 4503599627370496.0;

   /* worst case relative error bound for sqrt */    
   
   /* eps(sqrt)   = 2.220447e-16;                            */
   /*     q_sqtm  = 1 - eps(sqrt)                            */
   double q_sqtm  = 9007199254740986.0 / 9007199254740992.0;
   /*     q_sqtp  = 1 + eps(sqrt)                            */
   double q_sqtp  = 4503599627370501.0 / 4503599627370496.0;

   /* worst case relative error bound for q_sinh */
   
   /* eps(q_sinh) = 7.093289735801012E-016;                  */
   /*     q_snhm  = 1 - eps(q_sinh) = 9.999999999999989E-001 */
   double q_snhm  = 9007199254740982.0 / 9007199254740992.0;
   /*     q_snhp  = 1 + eps(q_sinh) = 1.000000000000002E+000 */
   double q_snhp  =  4503599627370503.0 / 4503599627370496.0;

   /* worst case relative error bound for q_cosh */
   
   /* eps(q_cosh) = 4.581660384746620E-016;                  */
   /*     q_cshm  = 1 - eps(q_cosh) = 9.999999999999991E-001 */
   double q_cshm  = 9007199254740984.0 / 9007199254740992.0;
   /*     q_cshp  = 1 + eps(q_cosh) = 1.000000000000001E+000 */
   double q_cshp  = 4503599627370502.0 / 4503599627370496.0;
 
   /* worst case relative error bound for q_coth */
   
   /* eps(q_coth) = 8.325226430245611E-016;                  */
   /*     q_cthm  = 1 - eps(q_coth) = 9.999999999999988E-001 */
   double q_cthm  = 9007199254740981.0 / 9007199254740992.0;
   /*     q_cthp  = 1 + eps(q_coth) = 1.000000000000002E+000 */
   double q_cthp  = 4503599627370503.0 / 4503599627370496.0;
 
   /* worst case relative error bound for q_tanh */
   
   /* eps(q_tanh) = 1.054585718561371E-015;                  */
   /*     q_tnhm  = 1 - eps(q_tanh) = 9.999999999999986E-001 */
   double q_tnhm  = 9007199254740979.0 / 9007199254740992.0;
   /*     q_tnhp  = 1 + eps(q_tnhp) = 1.000000000000002E+000 */
   double q_tnhp  = 4503599627370504.0 / 4503599627370496.0;

   /* worst case relative error bound for q_asnh */         
   
   /* eps(q_asnh) = 7.2075e-16;                              */
   double q_asnm  = 9007199254740982.0 / 9007199254740992.0;
   double q_asnp  = 4503599627370503.0 / 4503599627370496.0;

   /* worst case relative error bound for q_acnh */          
   
   /* eps(q_acnh) = 1.6180e-15;                              */
   double q_acsm  = 9007199254740974.0 / 9007199254740992.0;
   double q_acsp  = 4503599627370507.0 / 4503599627370496.0;

   /* worst case relative error bound for q_acth */
   
   /* eps(q_acth) = 1.147880588000001E-015;                  */
   double q_actm  = 9007199254740978.0 / 9007199254740992.0;
   double q_actp  = 4503599627370505.0 / 4503599627370496.0;

   /* worst case relative error bound for q_atnh */
   
   /* eps(q_atnh) = 1.264618646263405E-015;                  */
   double q_atnm  = 9007199254740977.0 / 9007199254740992.0;
   double q_atnp  = 4503599627370505.0 / 4503599627370496.0;

   /* worst case relative error bound for q_asin */
   
   /* eps(q_asin) = 2.148875977690793E-015;                  */
   /*     q_csnm  = 1 - eps(q_asin) = 9.999999999999974E-001 */
   double q_csnm  = 9007199254740969.0 / 9007199254740992.0;
   /*     q_csnp  = 1 + eps(q_asin) = 1.000000000000003E+000 */
   double q_csnp  = 4503599627370509.0 / 4503599627370496.0;

   /* worst case relative error bound for q_acos */
   
   /* eps(q_acos) = 2.148489042525242E-015;                  */
   /*     q_ccsm  = 1 - eps(q_acos) = 9.999999999999974E-001 */
   double q_ccsm  = 9007199254740969.0 / 9007199254740992.0;
   /*     q_ccsp  = 1 + eps(q_acos) = 1.000000000000003E+000 */
   double q_ccsp  = 4503599627370509.0 / 4503599627370496.0;

   /* worst case relative error bound for q_acot */
   
   /* eps(q_acot) = 1.802884893838539E-015;                  */
   /*     q_cctm  = 1 - eps(q_acot) = 9.999999999999978E-001 */
   double q_cctm  = 9007199254740972.0 / 9007199254740992.0;
   /*     q_cctp  = 1 + eps(q_acot) = 1.000000000000003E+000 */
   double q_cctp  = 4503599627370508.0 / 4503599627370496.0;

   /* worst case relative error bound for q_atan */  
   
   /* eps(q_atan) = 1.358774060669230E-015;                  */
   /*     q_ctnm  = 1 - eps(q_atan) = 9.999999999999982E-001 */
   double q_ctnm  = 9007199254740976.0 / 9007199254740992.0;
   /*     q_ctnp  = 1 + eps(q_atan) = 1.000000000000002E+000 */
   double q_ctnp  = 4503599627370506.0 / 4503599627370496.0;

   /* worst case relative error bound for q_sin */          
   
   /* eps(q_sin)  = 1.071713978232866e-15;                   */
   double q_sinm  = 9007199254740979.0 / 9007199254740992.0;
   double q_sinp  = 4503599627370504.0 / 4503599627370496.0;

   /* worst case relative error bound for q_cos */         
   
   /* eps(q_cos)  = 1.071713978232866e-15;                   */
   double q_cosm  = 9007199254740979.0 / 9007199254740992.0;
   double q_cosp  = 4503599627370504.0 / 4503599627370496.0;

   /* worst case relative error bound for q_cot */         
   
   /* eps(q_cot)  = 2.97768e-15;                             */
   double q_cotm = 9007199254740962.0 / 9007199254740992.0;
   double q_cotp = 4503599627370513.0 / 4503599627370496.0;

   /* worst case relative error bound for q_tan */         
   
   /* eps(q_tan) = 2.97768e-15;                              */
   double q_tanm = 9007199254740962.0 / 9007199254740992.0;
   double q_tanp = 4503599627370513.0 / 4503599627370496.0;
  
   /* worst case relative error bound for q_lg2 */
   
   /* eps(q_lg2)  = 2.7754e-15;                              */
   double q_lg2m  = 9007199254740964.0 / 9007199254740992.0;
   double q_lg2p  = 4503599627370512.0 / 4503599627370496.0;

   /* worst case relative error bound for q_lg10 */
   
   /* eps(q_lg10) = 2.7754e-15;                              */
   double q_l10m = 9007199254740964.0 / 9007199254740992.0;
   double q_l10p = 4503599627370512.0 / 4503599627370496.0;

   /* worst case relative error bound for q_exp2 */ 
   
   /* eps(q_exp2) = 2.350296792932261e-16                    */
   double q_e2em  = 9007199254740986.0 / 9007199254740992.0;
   double q_e2ep  = 4503599627370501.0 / 4503599627370496.0;

   /* worst case relative error bound for q_ex10 */ 
   
   /* eps(q_ex10) = 2.418059815583812e-16;                   */
   double q_e10m  = 9007199254740986.0 / 9007199254740992.0;
   double q_e10p  = 4503599627370501.0 / 4503599627370496.0;

#endif


/* --------------------------------------------------------------------- */
/* ---- global constants for the standard functions  ------------------- */
/* --------------------------------------------------------------------- */

/*        q_minr   = smallest positive normalised number                 */
   double q_minr   = 2.2250738585072013e-308; 
/*        q_mine   = ln( q_minr ) = -708.3964185322641062617539          */
   double q_mine   = -6231120794008786.0 / 8796093022208.0;
/*        q_sqra   = 1.3407807929942596e154;                             */
   double q_sqra   = 1.3407807929942596e154;
/*        q_ctht   = 5.562684646268013e-309;                             */
   double q_ctht   = 5.562684646268013e-309;

/*        q_ln2h   = ln( 2.0 ) / 2 = 0.346573590279972654708616          */
   double q_ln2h   = 6243314768165359.0 / 18014398509481984.0;
/*        q_l10i   =  1 / ln( 10 ) = 4.342944819032518E-001              */ 
   double q_l10i   = 7823553867474190.0 / 18014398509481984.0;
/*        q_l2i    =  1 / ln( 2 )  = 1.442695040888963E+000              */ 
   double q_l2i    = 6497320848556798.0 / 4503599627370496.0;
/*        q_l10    = ln( 10 ) = 2.302585092994046E+000                   */ 
   double q_l10    = 5184960683398422.0 / 2251799813685248.0;
/*        q_l2     = ln( 2 ) = 6.931471805599453E-001                    */ 
   double q_l2     = 6243314768165359.0 / 9007199254740992.0;

/*        q_p2h    = 2^(100)                                             */
   double q_p2h    = 1267650600228229401496703205376.0; 
/*        q_p2mh   = 2^(-100)                                            */
   double q_p2mh   = 1.0/1267650600228229401496703205376.0;

/*        q_pi     = pi   ( rounding towards -infinity )                 */
   double q_pi     = 7074237752028440.0 / 2251799813685248.0;
/*        q_piha   = pi/2                                                */ 
   double q_piha   = 7074237752028440.0 / 4503599627370496.0;  

/*        q_pih[7] = pi/2 with 7*22 bits                                 */
   double q_pih[7] = {   
      7074236338274304.0 / 4503599627370496.0,
      5929713453236224.0 / 18889465931478580854784.0,
      4930663257997312.0 / 79228162514264337593543950336.0,
      5376096463749120.0 / 2658455991569831745807614120560689152.0,
      4908338017992704.0 / 1393796574908163946345982392040522594123776.0,
      8111234717057024.0 / 187072209578355573530071658587684226515959365500928.0,
      5071617642201088.0 / 24519928653854221733733552434404946937899825954937634816.0 };

/*        q_pi2i   = 2/pi                                                */
   double q_pi2i   = 5734161139222659.0 / 9007199254740992.0;
/*        q_pi2p[3]=                                                     */
   double q_pi2p[3]={
      5734160907894784.0 / 9007199254740992.0,
      7762075350728704.0 / 302231454903657293676544.0,
      5957137356292096.0 / 20282409603651670423947251286016.0};


/* --------------------------------------------------------------------- */
/* ---- global constants and table values for  q_expm1 and q_exp ------- */
/* --------------------------------------------------------------------- */

/*        q_ext1 = 5.551115123125783E-017                                */
   double q_ext1 = 4503599627370496.0 / 81129638414606681695789005144064.0;
/*        q_ext2 = 1.809114141261457E+003                                */
   double q_ext2 = 7956568137163861.0 / 4398046511104.0;
/*        q_ex2a = 7.097827128933840E+002                                */
   double q_ex2a = 6243314768165359.0 / 8796093022208.0;   
/*        q_ex2b =-744.44008                                            */
   double q_ex2b =-6548164193139965.0 / 8796093022208.0;  
/*        q_ex2c = 7.090895657128240E+002                                */
   double q_ex2c = 6237217781087072.0 / 8796093022208.0;   
/*        q_ext3 =-3.742994775023704E+001                                */
   double q_ext3 =-5267796835639521.0 / 140737488355328.0;
/*        q_ext4 =-2.876820724517810E-001                                */
   double q_ext4 =-5182419497180051.0 / 18014398509481984.0;
/*        q_ext5 = 2.231435513142098E-001                                */
   double q_ext5 = 8039593716390434.0 / 36028797018963968.0;
/*        q_extm = 307.9536855642527627036                               */
   double q_extm = 5417578529509920.0 / 17592186044416.0;
/*        q_extn =-307.65265556858878150844                               */
   double q_extn =-5412282753821250.0 / 17592186044416.0;

/*        q_exil = 4.616624130844683E+001                                */
   double q_exil = 6497320848556798.0 / 140737488355328.0;
/*        q_exl1 = 2.166084939017310E-002                                */
   double q_exl1 = 6243314767495168.0 / 288230376151711744.0;
/*        q_exl2 = 2.325192846878874E-012                                */
   double q_exl2 = 5756898648422637.0 / 2475880078570760549798248448.0;
/*        q_e10i = 32/lg10(2) = 1.063016990363956E+002                   */
   double q_e10i = 7480317065143153.0 / 70368744177664.0;
/*        q_e1l1 = lg10(2)/32 ( lead )  = 9.407187363649427E-003         */
   double q_e1l1 = 5422874304708608.0 / 576460752303423488.0;
/*        q_e1l2 = lg10(2)/32 ( trail ) = 8.499849253130399E-013         */
   double q_e1l2 = 8417842974672045.0 / 9903520314283042199192993792.0;

   double q_exa[5]={ 
/* q_exa[0] = 5.000000000000000E-001                                     */
              4503599627370496.0 / 9007199254740992.0,
/* q_exa[1] = 1.666666666658136E-001                                     */
              6004799503129925.0 / 36028797018963968.0,
/* q_exa[2] = 4.166666666638950E-002                                     */
              6004799503120717.0 / 144115188075855872.0,
/* q_exa[3] = 8.333362425159880E-003                                     */
              4803856372824746.0 / 576460752303423488.0,
/* q_exa[4] = 1.388893979532449E-003                                     */
              6405142946487772.0 / 4611686018427387904.0 };

   double q_exb[9]={ 
/* q_exb[0] = 1.666666666666666E-001                                     */
              6004799503160660.0 / 36028797018963968.0,
/* q_exb[1] = 4.166666666666610E-002                                     */
              6004799503160579.0 / 144115188075855872.0,
/* q_exb[2] = 8.333333333354122E-003                                     */
              4803839602540513.0 / 576460752303423488.0,
/* q_exb[3] = 1.388888889017890E-003                                     */
              6405119470632951.0 / 4611686018427387904.0,
/* q_exb[4] = 1.984126964158297E-004                                     */
              7320136463514879.0 / 36893488147419103232.0,
/* q_exb[5] = 2.480157863209126E-005                                     */
              7320133978402734.0 / 295147905179352825856.0,
/* q_exb[6] = 2.755792722352050E-006                                     */
              6506931592885707.0 / 2361183241434822606848.0,
/* q_exb[7] = 2.758025508816736E-007                                     */
              5209762888694261.0 / 18889465931478580854784.0,
/* q_exb[8] = 2.448136759253856E-008                                     */
              7399039345524175.0 / 302231454903657293676544.0};

/* approximation for function q_exp2                                     */
   double q_exc[7]={  
/* q_exc[0] = 6.931471805599453E-001                                     */
              6243314768165359.0 / 9007199254740992.0,
/* q_exc[1] = 2.402265069591007E-001                                     */
              8655072057804175.0 / 36028797018963968.0,
/* q_exc[2] = 5.550410866482158E-002                                     */
              7998985059213504.0 / 144115188075855872.0,
/* q_exc[3] = 9.618129107559553E-003                                     */
              5544473941095235.0 / 576460752303423488.0,
/* q_exc[4] = 1.333355814632986E-003                                     */
              6149018367931802.0 / 4611686018427387904.0,
/* q_exc[5] = 1.540358685612716E-004                                     */
              5682920491042682.0 / 36893488147419103232.0,
/* q_exc[6] = 1.525278971414304E-005                                     */
              9003657864540998.0 / 590295810358705651712.0};

/* approximation for function q_ex10                                     */
   double q_exd[7]={  
/* q_exd[0] = 1.302585092994046E+000                                     */
              5866321739426347.0 / 4503599627370496.0,
/* q_exd[1] = 2.650949055239199E+000                                     */
              5969406588676713.0 / 2251799813685248.0,
/* q_exd[2] = 2.034678592293476E+000                                     */
              4581688875035812.0 / 2251799813685248.0,
/* q_exd[3] = 1.171255148903874E+000                                     */
              5274864252159260.0 / 4503599627370496.0,
/* q_exd[4] = 5.393829291915935E-001                                     */
              4858329517834534.0 / 9007199254740992.0,
/* q_exd[5] = 2.069966074549993E-001                                     */
              7457838753610334.0 / 36028797018963968.0,
/* q_exd[6] = 6.808961466129955E-002                                     */
              4906373811462869.0 / 72057594037927936.0};

   double q_exld[32]={
/* qExpLead [ 0]:= 1.000000000000000E+000 */
                   4503599627370496.0 /                 4503599627370496.0,
/* qExpLead [ 1]:= 1.021897148654105E+000 */
                   4602215617889600.0 /                 4503599627370496.0,
/* qExpLead [ 2]:= 1.044273782427410E+000 */
                   4702991017412864.0 /                 4503599627370496.0,
/* qExpLead [ 3]:= 1.067140400676820E+000 */
                   4805973110840128.0 /                 4503599627370496.0,
/* qExpLead [ 4]:= 1.090507732665245E+000 */
                   4911210218475840.0 /                 4503599627370496.0,
/* qExpLead [ 5]:= 1.114386742595883E+000 */
                   5018751718701440.0 /                 4503599627370496.0,
/* qExpLead [ 6]:= 1.138788634756679E+000 */
                   5128648071143936.0 /                 4503599627370496.0,
/* qExpLead [ 7]:= 1.163724858777570E+000 */
                   5240950840352448.0 /                 4503599627370496.0,
/* qExpLead [ 8]:= 1.189207115002716E+000 */
                   5355712719992576.0 /                 4503599627370496.0,
/* qExpLead [ 9]:= 1.215247359980467E+000 */
                   5472987557571008.0 /                 4503599627370496.0,
/* qExpLead [10]:= 1.241857812073476E+000 */
                   5592830379701248.0 /                 4503599627370496.0,
/* qExpLead [11]:= 1.269050957191723E+000 */
                   5715297417922816.0 /                 4503599627370496.0,
/* qExpLead [12]:= 1.296839554651001E+000 */
                   5840446135085568.0 /                 4503599627370496.0,
/* qExpLead [13]:= 1.325236643159741E+000 */
                   5968335252311936.0 /                 4503599627370496.0,
/* qExpLead [14]:= 1.354255546936884E+000 */
                   6099024776549376.0 /                 4503599627370496.0,
/* qExpLead [15]:= 1.383909881963831E+000 */
                   6232576028726656.0 /                 4503599627370496.0,
/* qExpLead [16]:= 1.414213562373092E+000 */
                   6369051672525760.0 /                 4503599627370496.0,
/* qExpLead [17]:= 1.445180806977035E+000 */
                   6508515743784768.0 /                 4503599627370496.0,
/* qExpLead [18]:= 1.476826145939498E+000 */
                   6651033680544128.0 /                 4503599627370496.0,
/* qExpLead [19]:= 1.509164427593419E+000 */
                   6796672353750528.0 /                 4503599627370496.0,
/* qExpLead [20]:= 1.542210825407935E+000 */
                   6945500098633920.0 /                 4503599627370496.0,
/* qExpLead [21]:= 1.575980845107878E+000 */
                   7097586746770880.0 /                 4503599627370496.0,
/* qExpLead [22]:= 1.610490331949251E+000 */
                   7253003658850432.0 /                 4503599627370496.0,
/* qExpLead [23]:= 1.645755478153959E+000 */
                   7411823758157120.0 /                 4503599627370496.0,
/* qExpLead [24]:= 1.681792830507419E+000 */
                   7574121564787584.0 /                 4503599627370496.0,
/* qExpLead [25]:= 1.718619298122476E+000 */
                   7739973230616128.0 /                 4503599627370496.0,
/* qExpLead [26]:= 1.756252160373293E+000 */
                   7909456575025792.0 /                 4503599627370496.0,
/* qExpLead [27]:= 1.794709075003098E+000 */
                   8082651121422400.0 /                 4503599627370496.0,
/* qExpLead [28]:= 1.834008086409341E+000 */
                   8259638134547584.0 /                 4503599627370496.0,
/* qExpLead [29]:= 1.874167634110293E+000 */
                   8440500658608960.0 /                 4503599627370496.0,
/* qExpLead [30]:= 1.915206561397142E+000 */
                   8625323556245696.0 /                 4503599627370496.0,
/* qExpLead [31]:= 1.957144124175400E+000 */
                   8814193548346688.0 /                 4503599627370496.0 };

   double q_extl[32]={ 
/* qExpTrail[ 0]:= 0.000000000000000E+000 */
                   0.0,
/* qExpTrail[ 1]:= 1.159741170639136E-014 */
                   7350732955350452.0 /   633825300114114700748351602688.0,
/* qExpTrail[ 2]:= 3.416187970930849E-015 */
                   8661065463685896.0 /  2535301200456458802993406410752.0,
/* qExpTrail[ 3]:= 3.695759744057116E-015 */
                   4684932057853331.0 /  1267650600228229401496703205376.0,
/* qExpTrail[ 4]:= 1.307016386977872E-014 */
                   8284200537303158.0 /   633825300114114700748351602688.0,
/* qExpTrail[ 5]:= 9.429976191419770E-015 */
                   5976957489595592.0 /   633825300114114700748351602688.0,
/* qExpTrail[ 6]:= 1.252362600256201E-014 */
                   7937791009590795.0 /   633825300114114700748351602688.0,
/* qExpTrail[ 7]:= 7.365764010895274E-015 */
                   4668607584775442.0 /   633825300114114700748351602688.0,
/* qExpTrail[ 8]:= 4.702756855740314E-015 */
                   5961452550906630.0 /  1267650600228229401496703205376.0,
/* qExpTrail[ 9]:= 2.365364347248530E-015 */
                   5996911069096105.0 /  2535301200456458802993406410752.0,
/* qExpTrail[10]:= 7.596096843369434E-015 */
                   4814598361444511.0 /   633825300114114700748351602688.0,
/* qExpTrail[11]:= 9.994675153757751E-015 */
                   6334877978873592.0 /   633825300114114700748351602688.0,
/* qExpTrail[12]:= 8.685122094871109E-015 */
                   5504850118309409.0 /   633825300114114700748351602688.0,
/* qExpTrail[13]:= 4.155018977496740E-016 */
                   8427379681253482.0 / 20282409603651670423947251286016.0,
/* qExpTrail[14]:= 9.180838285724313E-015 */
                   5819047581748367.0 /   633825300114114700748351602688.0,
/* qExpTrail[15]:= 1.042517908037209E-015 */
                   5286193807488183.0 /  5070602400912917605986812821504.0,
/* qExpTrail[16]:= 2.789906930890878E-015 */
                   7073254391049437.0 /  2535301200456458802993406410752.0,
/* qExpTrail[17]:= 1.151608187475169E-014 */
                   7299184050403205.0 /   633825300114114700748351602688.0,
/* qExpTrail[18]:= 1.519472288906291E-015 */
                   7704639836248887.0 /  5070602400912917605986812821504.0,
/* qExpTrail[19]:= 4.117201960800166E-015 */
                   5219173536869173.0 /  1267650600228229401496703205376.0,
/* qExpTrail[20]:= 6.074702681072822E-015 */
                   7700600499869997.0 /  1267650600228229401496703205376.0,
/* qExpTrail[21]:= 8.205513465754880E-015 */
                   5200862035022496.0 /   633825300114114700748351602688.0,
/* qExpTrail[22]:= 3.577420871370299E-015 */
                   4534919714861555.0 /  1267650600228229401496703205376.0,
/* qExpTrail[23]:= 6.338036743689160E-015 */
                   8034416082406136.0 /  1267650600228229401496703205376.0,
/* qExpTrail[24]:= 1.007399732183222E-014 */
                   6385154375859097.0 /   633825300114114700748351602688.0,
/* qExpTrail[25]:= 1.535798430292588E-015 */
                   7787423207959887.0 /  5070602400912917605986812821504.0,
/* qExpTrail[26]:= 6.246850344855366E-015 */
                   7918823589191826.0 /  1267650600228229401496703205376.0,
/* qExpTrail[27]:= 9.122056260354196E-015 */
                   5781790046876837.0 /   633825300114114700748351602688.0,
/* qExpTrail[28]:= 1.587143306717675E-015 */
                   8047772661635512.0 /  5070602400912917605986812821504.0,
/* qExpTrail[29]:= 6.822155118545929E-015 */
                   8648109030874835.0 /  1267650600228229401496703205376.0,
/* qExpTrail[30]:= 5.666960267488855E-015 */
                   7183725584551774.0 /  1267650600228229401496703205376.0,
/* qExpTrail[31]:= 8.960767791036668E-017 */
                   7269838508040587.0 / 81129638414606681695789005144064.0
};


/* --------------------------------------------------------------------- */
/* ---- global constants and table values for  q_lg1p and q_log -------- */
/* --------------------------------------------------------------------- */

/* qLogT1= 9.394130628134757E-001 */
   double q_lgt1= 8461480639267491.0 / 9007199254740992.0;
/* qLogT2= 1.064494458917860E+000 */
   double q_lgt2= 4794056848520430.0 / 4503599627370496.0;
/* qLogT3=-6.058693718652422E-002 */
   double q_lgt3=-8731497847576004.0 / 144115188075855872.0;
/* qLogT4= 6.449445891785943E-002 */
   double q_lgt4= 4647315538398936.0 / 72057594037927936.0;
/* qLogT5= 2^-53 = 1.110223024625157E-016 */
   double q_lgt5= 4503599627370496.0 / 40564819207303340847894502572032.0;
/* qLogT6= 2^55 = 3.60287970189639680E+016 */
   double q_lgt6= 3.60287970189639680E+016;

   double q_lgb[2]={
/* qLogB[1]= 8.333333333326792E-002 */
             6004799503155948.0 /          72057594037927936.0,
/* qLogB[2]= 1.250003418826767E-002 */
             7205779111987292.0 /         576460752303423488.0};

   double q_lgc[4]={
/* qLogC[1]= 8.333333333333318E-002 */
             6004799503160650.0 /          72057594037927936.0,
/* qLogC[2]= 1.250000000132536E-002 */
             7205759404556812.0 /         576460752303423488.0,
/* qLogC[3]= 2.232141161100800E-003 */
             5146967091902417.0 /        2305843009213693952.0,
/* qLogC[4]= 4.347221829254529E-004 */
             8019208851590178.0 /       18446744073709551616.0};

   double q_lgld[129]={0.0,
/* qLogLead [  1]= 7.782140442941454E-003 = 3F7FE02A6B200000 */
                   8972197068537856.0 /        1152921504606846976.0,
/* qLogLead [  2]= 1.550418653641827E-002 = 3F8FC0A8B1000000 */
                   8937555034636288.0 /         576460752303423488.0,
/* qLogLead [  3]= 2.316705928205920E-002 = 3F97B91B07D80000 */
                   6677450211196928.0 /         288230376151711744.0,
/* qLogLead [  4]= 3.077165866670839E-002 = 3F9F829B0E780000 */
                   8869326752317440.0 /         288230376151711744.0,
/* qLogLead [  5]= 3.831886430270970E-002 = 3FA39E87BA000000 */
                   5522330335838208.0 /         144115188075855872.0,
/* qLogLead [  6]= 4.580953603181115E-002 = 3FA77458F6340000 */
                   6601849900892160.0 /         144115188075855872.0,
/* qLogLead [  7]= 5.324451451815548E-002 = 3FAB42DD71180000 */
                   7673343223791616.0 /         144115188075855872.0,
/* qLogLead [  8]= 6.062462181580486E-002 = 3FAF0A30C0100000 */
                   8736928775012352.0 /         144115188075855872.0,
/* qLogLead [  9]= 6.795066190898069E-002 = 3FB16536EEA40000 */
                   4896361210445824.0 /          72057594037927936.0,
/* qLogLead [ 10]= 7.522342123775161E-002 = 3FB341D7961C0000 */
                   5420418749693952.0 /          72057594037927936.0,
/* qLogLead [ 11]= 8.244366921098845E-002 = 3FB51B073F060000 */
                   5940692447002624.0 /          72057594037927936.0,
/* qLogLead [ 12]= 8.961215869021544E-002 = 3FB6F0D28AE60000 */
                   6457236551761920.0 /          72057594037927936.0,
/* qLogLead [ 13]= 9.672962645890948E-002 = 3FB8C345D6320000 */
                   6970104154816512.0 /          72057594037927936.0,
/* qLogLead [ 14]= 1.037967936808855E-001 = 3FBA926D3A4A0000 */
                   7479347221495808.0 /          72057594037927936.0,
/* qLogLead [ 15]= 1.108143663404917E-001 = 3FBC5E548F5C0000 */
                   7985016623333376.0 /          72057594037927936.0,
/* qLogLead [ 16]= 1.177830356555205E-001 = 3FBE27076E2A0000 */
                   8487162167820288.0 /          72057594037927936.0,
/* qLogLead [ 17]= 1.247034785010328E-001 = 3FBFEC9131DC0000 */
                   8985832628944896.0 /          72057594037927936.0,
/* qLogLead [ 18]= 1.315763577895268E-001 = 3FC0D77E7CD10000 */
                   4740537887293440.0 /          36028797018963968.0,
/* qLogLead [ 19]= 1.384023228583828E-001 = 3FC1B72AD52F0000 */
                   4986469197217792.0 /          36028797018963968.0,
/* qLogLead [ 20]= 1.451820098445751E-001 = 3FC29552F8200000 */
                   5230733163495424.0 /          36028797018963968.0,
/* qLogLead [ 21]= 1.519160420266417E-001 = 3FC371FC201F0000 */
                   5473352242102272.0 /          36028797018963968.0,
/* qLogLead [ 22]= 1.586050301757496E-001 = 3FC44D2B6CCB0000 */
                   5714348438388736.0 /          36028797018963968.0,
/* qLogLead [ 23]= 1.652495728958456E-001 = 3FC526E5E3A20000 */
                   5953743319334912.0 /          36028797018963968.0,
/* qLogLead [ 24]= 1.718502569274278E-001 = 3FC5FF3070A80000 */
                   6191558024495104.0 /          36028797018963968.0,
/* qLogLead [ 25]= 1.784076574731444E-001 = 3FC6D60FE71A0000 */
                   6427813277728768.0 /          36028797018963968.0,
/* qLogLead [ 26]= 1.849223384942889E-001 = 3FC7AB8902110000 */
                   6662529397882880.0 /          36028797018963968.0,
/* qLogLead [ 27]= 1.913948530000198E-001 = 3FC87FA065210000 */
                   6895726309212160.0 /          36028797018963968.0,
/* qLogLead [ 28]= 1.978257433293038E-001 = 3FC9525A9CF40000 */
                   7127423551537152.0 /          36028797018963968.0,
/* qLogLead [ 29]= 2.042155414292210E-001 = 3FCA23BC1FE30000 */
                   7357640290271232.0 /          36028797018963968.0,
/* qLogLead [ 30]= 2.105647691078048E-001 = 3FCAF3C94E810000 */
                   7586395325530112.0 /          36028797018963968.0,
/* qLogLead [ 31]= 2.168739383014326E-001 = 3FCBC286742E0000 */
                   7813707101765632.0 /          36028797018963968.0,
/* qLogLead [ 32]= 2.231435513149336E-001 = 3FCC8FF7C79B0000 */
                   8039593716416512.0 /          36028797018963968.0,
/* qLogLead [ 33]= 2.293741010653321E-001 = 3FCD5C216B500000 */
                   8264072928690176.0 /          36028797018963968.0,
/* qLogLead [ 34]= 2.355660713128600E-001 = 3FCE27076E2B0000 */
                   8487162167885824.0 /          36028797018963968.0,
/* qLogLead [ 35]= 2.417199368865113E-001 = 3FCEF0ADCBDC0000 */
                   8708878541520896.0 /          36028797018963968.0,
/* qLogLead [ 36]= 2.478361639041395E-001 = 3FCFB9186D5E0000 */
                   8929238843260928.0 /          36028797018963968.0,
/* qLogLead [ 37]= 2.539152099816420E-001 = 3FD0402594B50000 */
                   4574129780228096.0 /          18014398509481984.0,
/* qLogLead [ 38]= 2.599575244366861E-001 = 3FD0A324E2738000 */
                   4682978440740864.0 /          18014398509481984.0,
/* qLogLead [ 39]= 2.659635484978935E-001 = 3FD1058BF9AE8000 */
                   4791173351636992.0 /          18014398509481984.0,
/* qLogLead [ 40]= 2.719337154831010E-001 = 3FD1675CABAB8000 */
                   4898722318876672.0 /          18014398509481984.0,
/* qLogLead [ 41]= 2.778684510030871E-001 = 3FD1C898C1698000 */
                   5005633009582080.0 /          18014398509481984.0,
/* qLogLead [ 42]= 2.837681731307384E-001 = 3FD22941FBCF8000 */
                   5111912955084800.0 /          18014398509481984.0,
/* qLogLead [ 43]= 2.896332925829483E-001 = 3FD2895A13DE8000 */
                   5217569554202624.0 /          18014398509481984.0,
/* qLogLead [ 44]= 2.954642128934211E-001 = 3FD2E8E2BAE10000 */
                   5322610076352512.0 /          18014398509481984.0,
/* qLogLead [ 45]= 3.012613305781997E-001 = 3FD347DD9A988000 */
                   5427041664532480.0 /          18014398509481984.0,
/* qLogLead [ 46]= 3.070250352957373E-001 = 3FD3A64C55698000 */
                   5530871338205184.0 /          18014398509481984.0,
/* qLogLead [ 47]= 3.127557100033300E-001 = 3FD4043086868000 */
                   5634105996115968.0 /          18014398509481984.0,
/* qLogLead [ 48]= 3.184537311190070E-001 = 3FD4618BC21C8000 */
                   5736752419209216.0 /          18014398509481984.0,
/* qLogLead [ 49]= 3.241194686543167E-001 = 3FD4BE5F95778000 */
                   5838817273020416.0 /          18014398509481984.0,
/* qLogLead [ 50]= 3.297532863725792E-001 = 3FD51AAD872E0000 */
                   5940307110526976.0 /          18014398509481984.0,
/* qLogLead [ 51]= 3.353555419216718E-001 = 3FD5767717458000 */
                   6041228374540288.0 /          18014398509481984.0,
/* qLogLead [ 52]= 3.409265869704541E-001 = 3FD5D1BDBF580000 */
                   6141587400163328.0 /          18014398509481984.0,
/* qLogLead [ 53]= 3.464667673470103E-001 = 3FD62C82F2BA0000 */
                   6241390417281024.0 /          18014398509481984.0,
/* qLogLead [ 54]= 3.519764231568843E-001 = 3FD686C81E9B0000 */
                   6340643552690176.0 /          18014398509481984.0,
/* qLogLead [ 55]= 3.574558889213222E-001 = 3FD6E08EAA2B8000 */
                   6439352832589824.0 /          18014398509481984.0,
/* qLogLead [ 56]= 3.629054936900502E-001 = 3FD739D7F6BC0000 */
                   6537524184612864.0 /          18014398509481984.0,
/* qLogLead [ 57]= 3.683255611595087E-001 = 3FD792A55FDD8000 */
                   6635163439955968.0 /          18014398509481984.0,
/* qLogLead [ 58]= 3.737164097929053E-001 = 3FD7EAF83B828000 */
                   6732276335542272.0 /          18014398509481984.0,
/* qLogLead [ 59]= 3.790783529348118E-001 = 3FD842D1DA1E8000 */
                   6828868516085760.0 /          18014398509481984.0,
/* qLogLead [ 60]= 3.844116989112081E-001 = 3FD89A3386C18000 */
                   6924945535893504.0 /          18014398509481984.0,
/* qLogLead [ 61]= 3.897167511404405E-001 = 3FD8F11E87368000 */
                   7020512860864512.0 /          18014398509481984.0,
/* qLogLead [ 62]= 3.949938082405424E-001 = 3FD947941C210000 */
                   7115575870423040.0 /          18014398509481984.0,
/* qLogLead [ 63]= 4.002431641274597E-001 = 3FD99D9581180000 */
                   7210139859288064.0 /          18014398509481984.0,
/* qLogLead [ 64]= 4.054651081078191E-001 = 3FD9F323ECBF8000 */
                   7304210039144448.0 /          18014398509481984.0,
/* qLogLead [ 65]= 4.106599249844294E-001 = 3FDA484090E58000 */
                   7397791540543488.0 /          18014398509481984.0,
/* qLogLead [ 66]= 4.158278951435932E-001 = 3FDA9CEC9A9A0000 */
                   7490889414475776.0 /          18014398509481984.0,
/* qLogLead [ 67]= 4.209692946442374E-001 = 3FDAF12932478000 */
                   7583508633976832.0 /          18014398509481984.0,
/* qLogLead [ 68]= 4.260843953106814E-001 = 3FDB44F77BCC8000 */
                   7675654095798272.0 /          18014398509481984.0,
/* qLogLead [ 69]= 4.311734648181300E-001 = 3FDB985896930000 */
                   7767330621947904.0 /          18014398509481984.0,
/* qLogLead [ 70]= 4.362367667745275E-001 = 3FDBEB4D9DA70000 */
                   7858542961164288.0 /          18014398509481984.0,
/* qLogLead [ 71]= 4.412745608042314E-001 = 3FDC3DD7A7CD8000 */
                   7949295790424064.0 /          18014398509481984.0,
/* qLogLead [ 72]= 4.462871026280482E-001 = 3FDC8FF7C79A8000 */
                   8039593716383744.0 /          18014398509481984.0,
/* qLogLead [ 73]= 4.512746441396303E-001 = 3FDCE1AF0B860000 */
                   8129441276755968.0 /          18014398509481984.0,
/* qLogLead [ 74]= 4.562374334818742E-001 = 3FDD32FE7E010000 */
                   8218842941685760.0 /          18014398509481984.0,
/* qLogLead [ 75]= 4.611757151214988E-001 = 3FDD83E7258A0000 */
                   8307803115094016.0 /          18014398509481984.0,
/* qLogLead [ 76]= 4.660897299254430E-001 = 3FDDD46A04C20000 */
                   8396326136053760.0 /          18014398509481984.0,
/* qLogLead [ 77]= 4.709797152190731E-001 = 3FDE24881A7C8000 */
                   8484416279838720.0 /          18014398509481984.0,
/* qLogLead [ 78]= 4.758459048698569E-001 = 3FDE744261D68000 */
                   8572077759430656.0 /          18014398509481984.0,
/* qLogLead [ 79]= 4.806885293455707E-001 = 3FDEC399D2468000 */
                   8659314726567936.0 /          18014398509481984.0,
/* qLogLead [ 80]= 4.855078157816024E-001 = 3FDF128F5FAF0000 */
                   8746131272957952.0 /          18014398509481984.0,
/* qLogLead [ 81]= 4.903039880446158E-001 = 3FDF6123FA700000 */
                   8832531431424000.0 /          18014398509481984.0,
/* qLogLead [ 82]= 4.950772667980345E-001 = 3FDFAF588F790000 */
                   8918519177084928.0 /          18014398509481984.0,
/* qLogLead [ 83]= 4.998278695566114E-001 = 3FDFFD2E08580000 */
                   9004098428338176.0 /          18014398509481984.0,
/* qLogLead [ 84]= 5.045560107519123E-001 = 3FE02552A5A5C000 */
                   4544636524019712.0 /           9007199254740992.0,
/* qLogLead [ 85]= 5.092619017905236E-001 = 3FE04BDF9DA94000 */
                   4587023422275584.0 /           9007199254740992.0,
/* qLogLead [ 86]= 5.139457511013461E-001 = 3FE0723E5C1CC000 */
                   4629211786297344.0 /           9007199254740992.0,
/* qLogLead [ 87]= 5.186077642083546E-001 = 3FE0986F4F574000 */
                   4671203467280384.0 /           9007199254740992.0,
/* qLogLead [ 88]= 5.232481437651586E-001 = 3FE0BE72E4254000 */
                   4713000290566144.0 /           9007199254740992.0,
/* qLogLead [ 89]= 5.278670896204858E-001 = 3FE0E44985D1C000 */
                   4754604056231936.0 /           9007199254740992.0,
/* qLogLead [ 90]= 5.324647988691140E-001 = 3FE109F39E2D4000 */
                   4796016539549696.0 /           9007199254740992.0,
/* qLogLead [ 91]= 5.370414658973459E-001 = 3FE12F7195940000 */
                   4837239491395584.0 /           9007199254740992.0,
/* qLogLead [ 92]= 5.415972824321216E-001 = 3FE154C3D2F4C000 */
                   4878274638692352.0 /           9007199254740992.0,
/* qLogLead [ 93]= 5.461324375974073E-001 = 3FE179EABBD88000 */
                   4919123684917248.0 /           9007199254740992.0,
/* qLogLead [ 94]= 5.506471179523942E-001 = 3FE19EE6B467C000 */
                   4959788310446080.0 /           9007199254740992.0,
/* qLogLead [ 95]= 5.551415075406112E-001 = 3FE1C3B81F714000 */
                   5000270172995584.0 /           9007199254740992.0,
/* qLogLead [ 96]= 5.596157879353996E-001 = 3FE1E85F5E704000 */
                   5040570908033024.0 /           9007199254740992.0,
/* qLogLead [ 97]= 5.640701382853877E-001 = 3FE20CDCD192C000 */
                   5080692129185792.0 /           9007199254740992.0,
/* qLogLead [ 98]= 5.685047353526897E-001 = 3FE23130D7BEC000 */
                   5120635428585472.0 /           9007199254740992.0,
/* qLogLead [ 99]= 5.729197535620187E-001 = 3FE2555BCE990000 */
                   5160402377310208.0 /           9007199254740992.0,
/* qLogLead [100]= 5.773153650352469E-001 = 3FE2795E1289C000 */
                   5199994525696000.0 /           9007199254740992.0,
/* qLogLead [101]= 5.816917396350618E-001 = 3FE29D37FEC2C000 */
                   5239413403729920.0 /           9007199254740992.0,
/* qLogLead [102]= 5.860490450031648E-001 = 3FE2C0E9ED448000 */
                   5278660521394176.0 /           9007199254740992.0,
/* qLogLead [103]= 5.903874466021080E-001 = 3FE2E47436E40000 */
                   5317737369042944.0 /           9007199254740992.0,
/* qLogLead [104]= 5.947071077462169E-001 = 3FE307D7334F0000 */
                   5356645417680896.0 /           9007199254740992.0,
/* qLogLead [105]= 5.990081896452466E-001 = 3FE32B1339120000 */
                   5395386119356416.0 /           9007199254740992.0,
/* qLogLead [106]= 6.032908514389419E-001 = 3FE34E289D9D0000 */
                   5433960907472896.0 /           9007199254740992.0,
/* qLogLead [107]= 6.075552502243227E-001 = 3FE37117B5474000 */
                   5472371197034496.0 /           9007199254740992.0,
/* qLogLead [108]= 6.118015411066153E-001 = 3FE393E0D3564000 */
                   5510618385104896.0 /           9007199254740992.0,
/* qLogLead [109]= 6.160298772156239E-001 = 3FE3B6844A000000 */
                   5548703850954752.0 /           9007199254740992.0,
/* qLogLead [110]= 6.202404097512044E-001 = 3FE3D9026A714000 */
                   5586628956471296.0 /           9007199254740992.0,
/* qLogLead [111]= 6.244332880123693E-001 = 3FE3FB5B84D18000 */
                   5624395046420480.0 /           9007199254740992.0,
/* qLogLead [112]= 6.286086594227527E-001 = 3FE41D8FE8468000 */
                   5662003448676352.0 /           9007199254740992.0,
/* qLogLead [113]= 6.327666695706284E-001 = 3FE43F9FE2F9C000 */
                   5699455474581504.0 /           9007199254740992.0,
/* qLogLead [114]= 6.369074622361950E-001 = 3FE4618BC21C4000 */
                   5736752419192832.0 /           9007199254740992.0,
/* qLogLead [115]= 6.410311794206791E-001 = 3FE48353D1EA8000 */
                   5773895561543680.0 /           9007199254740992.0,
/* qLogLead [116]= 6.451379613736208E-001 = 3FE4A4F85DB04000 */
                   5810886164889600.0 /           9007199254740992.0,
/* qLogLead [117]= 6.492279466256150E-001 = 3FE4C679AFCD0000 */
                   5847725477003264.0 /           9007199254740992.0,
/* qLogLead [118]= 6.533012720119586E-001 = 3FE4E7D811B74000 */
                   5884414730387456.0 /           9007199254740992.0,
/* qLogLead [119]= 6.573580727090302E-001 = 3FE50913CC018000 */
                   5920955142602752.0 /           9007199254740992.0,
/* qLogLead [120]= 6.613984822452039E-001 = 3FE52A2D265BC000 */
                   5957347916365824.0 /           9007199254740992.0,
/* qLogLead [121]= 6.654226325445052E-001 = 3FE54B2467998000 */
                   5993594239942656.0 /           9007199254740992.0,
/* qLogLead [122]= 6.694306539429817E-001 = 3FE56BF9D5B40000 */
                   6029695287296000.0 /           9007199254740992.0,
/* qLogLead [123]= 6.734226752123504E-001 = 3FE58CADB5CD8000 */
                   6065652218298368.0 /           9007199254740992.0,
/* qLogLead [124]= 6.773988235909201E-001 = 3FE5AD404C358000 */
                   6101466179010560.0 /           9007199254740992.0,
/* qLogLead [125]= 6.813592248072382E-001 = 3FE5CDB1DC6C0000 */
                   6137138301894656.0 /           9007199254740992.0,
/* qLogLead [126]= 6.853040030982811E-001 = 3FE5EE02A9240000 */
                   6172669705977856.0 /           9007199254740992.0,
/* qLogLead [127]= 6.892332812385575E-001 = 3FE60E32F4478000 */
                   6208061497114624.0 /           9007199254740992.0,
/* qLogLead [128]= 6.931471805601177E-001 = 3FE62E42FEFA4000 */
                   6243314768166912.0 /           9007199254740992.0};

   double q_lgtl[129]={0.0,
/* qLogTrail [  1]=-8.865052917267247E-013 = BD6F30EE07912DF9 */
                   -8779523165335033.0 / 9903520314283042199192993792.0,
/* qLogTrail [  2]=-4.530198941364935E-013 = BD5FE0E183092C59 */
                   -8972983448710233.0 / 19807040628566084398385987584.0,
/* qLogTrail [  3]=-5.248209479295644E-013 = BD62772AB6C0559C */
                   -5197574919181724.0 / 9903520314283042199192993792.0,
/* qLogTrail [  4]= 4.529814257790929E-014 = 3D2980267C7E09E4 */
                    7177777203513828.0 / 158456325028528675187087900672.0,
/* qLogTrail [  5]=-5.730994833076631E-013 = BD642A056FEA4DFD */
                   -5675702375042557.0 / 9903520314283042199192993792.0,
/* qLogTrail [  6]=-5.169456928812220E-013 = BD62303B9CB0D5E1 */
                   -5119582170830305.0 / 9903520314283042199192993792.0,
/* qLogTrail [  7]= 6.567993368985218E-013 = 3D671BEC28D14C7E */
                    6504625575382142.0 / 9903520314283042199192993792.0,
/* qLogTrail [  8]= 6.299848199383311E-013 = 3D662A6617CC9717 */
                    6239067461949207.0 / 9903520314283042199192993792.0,
/* qLogTrail [  9]=-4.729424109166329E-013 = BD60A3E2F3B47D18 */
                   -4683794773998872.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 10]=-1.640830158559866E-013 = BD4717B6B33E44F8 */
                   -6499997923034360.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 11]= 8.614512936087814E-014 = 3D383F69278E686A */
                    6825120308815978.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 12]=-5.283050530808144E-013 = BD62968C836CC8C2 */
                   -5232079825324226.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 13]=-3.583666743009414E-013 = BD5937C294D2F567 */
                   -7098183277802855.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 14]= 7.581073923016376E-013 = 3D6AAC6CA17A4554 */
                    7507931960067412.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 15]=-2.015736841601622E-013 = BD4C5E7514F4083F */
                   -7985156303620159.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 16]= 8.629474042969438E-013 = 3D6E5CBD3D50FFFC */
                    8546217148612604.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 17]=-7.556920687451337E-014 = BD354555D1AE6607 */
                   -5987209403328007.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 18]=-8.075373495358435E-013 = BD6C69A65A23A170 */
                   -7997462545670512.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 19]= 7.363043577087051E-013 = 3D69E80A41811A39 */
                    7292005164063289.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 20]=-7.718001336828099E-014 = BD35B967F4471DFC */
                   -6114830641995260.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 21]=-7.996871607743758E-013 = BD6C22F10C9A4EA8 */
                   -7919718041800360.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 22]= 8.890223439724663E-013 = 3D6F4799F4F6543E */
                    8804450843382846.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 23]=-5.384682618788232E-013 = BD62F21746FF8A47 */
                   -5332731370113607.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 24]=-7.686134224018169E-013 = BD6B0B0DE3077D7E */
                   -7611978642587006.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 25]=-3.260571793105816E-013 = BD56F1B955C4D1DA */
                   -6458227797840346.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 26]=-2.768588431044831E-013 = BD537B720E4A694B */
                   -5483754353748299.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 27]=-3.903387893794952E-013 = BD5B77B7EFFB7F41 */
                   -7731456260144961.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 28]= 6.160755775588723E-013 = 3D65AD1D904C1D4E */
                    6101316997487950.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 29]=-5.301565160060260E-013 = BD62A739B23B93E1 */
                   -5250415826015201.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 30]=-4.551124227747820E-013 = BD600349CC67F9B2 */
                   -4507215124232626.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 31]=-8.182853292737783E-013 = BD6CCA75818C5DBC */
                   -8103905381342652.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 32]=-7.238189921749681E-013 = BD697794F689F843 */
                   -7168356092868675.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 33]=-4.862400015383790E-013 = BD611BA91BBCA682 */
                   -4815487732852354.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 34]=-9.309459495196889E-014 = BD3A342C2AF0003C */
                   -7375713698054204.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 35]= 6.338907368997553E-013 = 3D664D948637950E */
                    6277749789922574.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 36]= 4.417175537131555E-013 = 3D5F1546AAA3361C */
                    8749117532747292.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 37]=-6.785208495970588E-013 = BD67DF928EC217A5 */
                   -6719745017649061.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 38]= 2.399954048421174E-013 = 3D50E35F73F7A018 */
                    4753598734376984.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 39]=-7.555569400283742E-013 = BD6A9573B02FAA5A */
                   -7482673504168538.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 40]= 5.407904186145515E-013 = 3D630701CE63EAB9 */
                    5355728896518841.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 41]= 3.692037508208009E-013 = 3D59FAFBC68E7540 */
                    7312833692726592.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 42]=-9.383417223663700E-014 = BD3A6976F5EB0963 */
                   -7434309047355747.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 43]= 9.433398189512690E-014 = 3D3A8D7AD24C13F0 */
                    7473908048204784.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 44]= 4.148131870425857E-013 = 3D5D309C2CC91A85 */
                    8216221649017477.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 45]=-3.792316480209315E-014 = BD25594DD4C58092 */
                   -6009165327990930.0 / 158456325028528675187087900672.0,
/* qLogTrail [ 46]=-8.254631387250040E-013 = BD6D0B1C68651946 */
                   -8174990963054918.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 47]= 5.668653582900739E-013 = 3D63F1DE86093EFA */
                    5613962591289082.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 48]=-4.723727821986367E-013 = BD609EC17A426426 */
                   -4678153444418598.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 49]=-1.047575005877654E-013 = BD3D7C92CD9AD824 */
                   -8299744281155620.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 50]=-1.111867138955932E-013 = BD3F4BD8DB0A7CC1 */
                   -8809119037947073.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 51]=-5.339989292003297E-013 = BD62C9D5B2A49AF9 */
                   -5288469243140857.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 52]= 1.391284121219757E-013 = 3D4394A11B1C1EE4 */
                    5511444222975716.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 53]=-8.017372713972018E-013 = BD6C356848506EAD */
                   -7940021354000045.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 54]= 2.939185918764800E-013 = 3D54AEC442BE1015 */
                    5821657490788373.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 55]= 4.815896111723205E-013 = 3D60F1C609C98C6C */
                    4769432497392748.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 56]=-6.817539406325327E-013 = BD67FCB18ED9D603 */
                   -6751764000396803.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 57]=-8.009990055432491E-013 = BD6C2EC1F512DC03 */
                   -7932709923118083.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 58]= 6.787566823158706E-013 = 3D67E1B259D2F3DA */
                    6722080591770586.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 59]= 1.576120377396944E-013 = 3D462E927628CBC2 */
                    6243656070122434.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 60]=-8.760375990774874E-013 = BD6ED2A52C73BF78 */
                   -8675856158539640.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 61]=-4.152515806343612E-013 = BD5D3881E8962A96 */
                   -8224904928701078.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 62]= 3.265569889690715E-013 = 3D56FABA4CDD147D */
                    6468127548052605.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 63]=-4.470426501045244E-013 = BD5F753456D113B8 */
                   -8854591933322168.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 64]= 3.452764795203977E-013 = 3D584BF2B68D766F */
                    6838905257948783.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 65]= 8.390050778518307E-013 = 3D6D8515FE535B87 */
                    8309103832292231.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 66]= 1.177697875136921E-013 = 3D40931A909FEA5E */
                    4665341932202590.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 67]=-1.077434146160958E-013 = BD3E53BB31EED7A9 */
                   -8536312763045801.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 68]= 2.186334329321591E-013 = 3D4EC5197DDB55D3 */
                    8660962577700307.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 69]= 2.413263949133313E-013 = 3D50FB598FB14F89 */
                    4779961708793737.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 70]= 3.905746220983070E-013 = 3D5B7BF7861D37AC */
                    7736127408388012.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 71]= 6.437879097373207E-013 = 3D66A6B9D9E0A5BD */
                    6375766642173373.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 72]= 3.713514191959202E-013 = 3D5A21AC25D81EF3 */
                    7355372647489267.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 73]=-1.716692133608243E-013 = BD48290905A86AA6 */
                   -6800518167423654.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 74]=-2.865828515791435E-013 = BD542A9E21373414 */
                   -5676358184678420.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 75]= 6.713692791384601E-013 = 3D679F2828ADD176 */
                    6648919294333302.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 76]=-8.437281040871276E-013 = BD6DAFA08CECADB1 */
                   -8355878418558385.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 77]=-2.821014384618127E-013 = BD53D9E34270BA6B */
                   -5587594652990059.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 78]= 1.070193176211425E-013 = 3D3E1F8DF68DBCF3 */
                    8478943888653555.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 79]= 1.811934636644111E-013 = 3D49802EB9DCA7E7 */
                    7177812592863207.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 80]= 9.840465278232627E-014 = 3D3BB2CD720EC44C */
                    7796419822797900.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 81]= 5.780031989454028E-013 = 3D645630A2B61E5B */
                    5724266422476379.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 82]=-1.830285735604167E-013 = BD49C24CA098362B */
                   -7250508785399339.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 83]=-1.620740015674495E-013 = BD46CF54D05F9367 */
                   -6420412667761511.0 / 39614081257132168796771975168.0,
/* qLogTrail [ 84]= 4.830331494955320E-013 = 3D60FEC69C695D7F */
                    4783728608501119.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 85]=-7.156055317238212E-013 = BD692D9A033EFF75 */
                   -7087013920440181.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 86]= 8.882123951857185E-013 = 3D6F404E57963891 */
                    8796429499119761.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 87]=-3.090058051323824E-013 = BD55BE8DC04AD601 */
                   -6120490536719873.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 88]=-6.107655197285150E-013 = BD657D49676844CC */
                   -6048728731894988.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 89]= 3.565996966334783E-013 = 3D5917EDD5CBBD2D */
                    7063184679353645.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 90]= 3.578239659127638E-013 = 3D592DFBC7D93617 */
                    7087433830708759.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 91]=-4.622608700154458E-013 = BD6043ACFEDCE638 */
                   -4578009916696120.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 92]= 6.227976291722515E-013 = 3D65E9A98F33A396 */
                    6167888972194710.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 93]= 7.283894727206574E-013 = 3D69A0BFC60E6FA0 */
                    7213619939798944.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 94]= 2.680964661521167E-013 = 3D52DD98B97BAEF0 */
                    5310197597449968.0 / 19807040628566084398385987584.0,
/* qLogTrail [ 95]=-1.096082504605928E-013 = BD3EDA1B58389902 */
                   -8684060280396034.0 / 79228162514264337593543950336.0,
/* qLogTrail [ 96]= 2.311949383800538E-014 = 3D1A07BD8B34BE7C */
                    7326860060180092.0 / 316912650057057350374175801344.0,
/* qLogTrail [ 97]=-5.846905800529924E-013 = BD64926CAFC2F08A */
                   -5790495037124746.0 / 9903520314283042199192993792.0,
/* qLogTrail [ 98]=-2.103748251144494E-014 = BD17AFA4392F1BA7 */
                   -6667044333231015.0 / 316912650057057350374175801344.0,
/* qLogTrail [ 99]=-2.332318294558741E-013 = BD506987F78A4A5E */
                   -4619632321907294.0 / 19807040628566084398385987584.0,
/* qLogTrail [100]=-4.233369428814192E-013 = BD5DCA290F81848D */
                   -8385052027225229.0 / 19807040628566084398385987584.0,
/* qLogTrail [101]=-4.393393796973784E-013 = BD5EEA6F465268B4 */
                   -8702012943394996.0 / 19807040628566084398385987584.0,
/* qLogTrail [102]= 4.134164707383556E-013 = 3D5D1772F5386374 */
                    8188556832433012.0 / 19807040628566084398385987584.0,
/* qLogTrail [103]= 6.841763641591467E-014 = 3D334202A10C3491 */
                    5420603616801937.0 / 79228162514264337593543950336.0,
/* qLogTrail [104]= 4.758553400443064E-013 = 3D60BE1FB590A1F5 */
                    4712643026788853.0 / 9903520314283042199192993792.0,
/* qLogTrail [105]= 8.367967867475769E-013 = 3D6D71320556B67B */
                    8287233976481403.0 / 9903520314283042199192993792.0,
/* qLogTrail [106]=-8.576373464665864E-013 = BD6E2CE9146D277A */
                   -8493628883019642.0 / 9903520314283042199192993792.0,
/* qLogTrail [107]= 2.191328122934009E-013 = 3D4ED71774092113 */
                    8680745032294675.0 / 39614081257132168796771975168.0,
/* qLogTrail [108]=-6.224284253643115E-013 = BD65E6563BBD9FC9 */
                   -6164232554782665.0 / 9903520314283042199192993792.0,
/* qLogTrail [109]=-1.098359432543843E-013 = BD3EEA838909F3D3 */
                   -8702099962065875.0 / 79228162514264337593543950336.0,
/* qLogTrail [110]= 6.531043137763365E-013 = 3D66FAA404263D0B */
                    6468031838829835.0 / 9903520314283042199192993792.0,
/* qLogTrail [111]=-4.758019902171077E-013 = BD60BDA4B162AFA3 */
                   -4712114675691427.0 / 9903520314283042199192993792.0,
/* qLogTrail [112]=-3.785425126545704E-013 = BD5AA33736867A17 */
                   -7497806927788567.0 / 19807040628566084398385987584.0,
/* qLogTrail [113]= 4.093923321867867E-013 = 3D5CCEF4E4F736C2 */
                    8108850556647106.0 / 19807040628566084398385987584.0,
/* qLogTrail [114]= 8.742438391485829E-013 = 3D6EC27D0B7B37B3 */
                    8658091620644787.0 / 9903520314283042199192993792.0,
/* qLogTrail [115]= 2.521818845684288E-013 = 3D51BEE7ABD17660 */
                    4994976833435232.0 / 19807040628566084398385987584.0,
/* qLogTrail [116]=-3.608131360422557E-014 = BD244FDD840B8591 */
                   -5717312355927441.0 / 158456325028528675187087900672.0,
/* qLogTrail [117]=-5.051855592428090E-013 = BD61C64E971322CE */
                   -5003115448443598.0 / 9903520314283042199192993792.0,
/* qLogTrail [118]= 7.869940332335532E-013 = 3D6BB09CB0985646 */
                    7794011395348038.0 / 9903520314283042199192993792.0,
/* qLogTrail [119]=-6.702087696194906E-013 = BD6794B434C5A4F5 */
                   -6637426164737269.0 / 9903520314283042199192993792.0,
/* qLogTrail [120]= 1.610857575393246E-013 = 3D46ABB9DF22BC57 */
                    6381264288529495.0 / 39614081257132168796771975168.0,
/* qLogTrail [121]= 5.852718843625151E-013 = 3D6497A915428B44 */
                    5796251996162884.0 / 9903520314283042199192993792.0,
/* qLogTrail [122]=-3.524675729790479E-013 = BD58CD7DC73BD194 */
                   -6981339538248084.0 / 19807040628566084398385987584.0,
/* qLogTrail [123]=-1.837208449562906E-013 = BD49DB3DB43689B4 */
                   -7277932480727476.0 / 39614081257132168796771975168.0,
/* qLogTrail [124]= 8.860668981349492E-013 = 3D6F2CFB29AAA5F0 */
                    8775181525493232.0 / 9903520314283042199192993792.0,
/* qLogTrail [125]= 6.648626807146870E-013 = 3D67648CF6E3C5D7 */
                    6584481064666583.0 / 9903520314283042199192993792.0,
/* qLogTrail [126]= 6.383161517064652E-013 = 3D667570D6095FD2 */
                    6321576975359954.0 / 9903520314283042199192993792.0,
/* qLogTrail [127]= 2.514423072837607E-013 = 3D51B194F912B417 */
                    4980327996109847.0 / 19807040628566084398385987584.0,
/* qLogTrail [128]=-1.723944452561483E-013 = BD48432A1B0E2634 */
                   -6829247562655284.0 / 39614081257132168796771975168.0};

 
/* --------------------------------------------------------------------- */
/* ---- global constants and table values for  q_atan ------------------ */
/* --------------------------------------------------------------------- */

   double q_atnt=1.807032e-8; /* for |x|<=q_atnt approx. x=arctan(x)     */
                              /* used in q_atan, q_atn1, j_atan, q_asin, */
                              /* j_asin, ...                             */ 
   double q_atna[7]={0,
     8960721713639278.0 / 36028797018963968.0,   /* =  0.24871... */
     8960721713639278.0 / 18014398509481984.0,   /* =  0.49742... */
     6720541285229458.0 /  9007199254740992.0,   /* =  0.74613... */
     8960721713639278.0 /  9007199254740992.0,   /* =  0.99484... */
     5600451071024549.0 /  4503599627370496.0,   /* =  1.24355... */
     6720541285229458.0 /  4503599627370496.0};  /* =  1.49226... */
   double q_atnb[8]={0,
     4503599627370496.0 / 36028797018963968.0,   /* =  0.12500... */
     7050717449407908.0 / 18014398509481984.0,   /* =  0.39139... */
     6454487157372003.0 /  9007199254740992.0,   /* =  0.71659... */
     5343484307627230.0 /  4503599627370496.0,   /* =  1.18649... */
     4642583338069965.0 /  2251799813685248.0,   /* =  2.06172... */
     5472919125137495.0 /  1125899906842624.0,   /* =  4.86093... */
     4503599627370496.0 /   562949953421312.0};  /* =  8.00000... */
   double q_atnc[7]={0,
     4575085335741456.0 / 18014398509481984.0,   /* =  0.25397... */
     4890523484394786.0 /  9007199254740992.0,   /* =  0.54296... */
     8326197945442628.0 /  9007199254740992.0,   /* =  0.92439... */
     6934969934934130.0 /  4503599627370496.0,   /* =  1.53987... */
     6633650527568543.0 /  2251799813685248.0,   /* =  2.94593... */
     7153270512133541.0 /   562949953421312.0};  /* = 12.70676... */
   double q_atnd[6]={
    -6004799503160653.0 / 18014398509481984.0,   /* = -0.33333... */
     7205759403717662.0 / 36028797018963968.0,   /* =  0.20000... */
    -5146970946471129.0 / 36028797018963968.0,   /* = -0.14286... */
     8006368526669049.0 / 72057594037927936.0,   /* =  0.11111... */
    -6546869189017288.0 / 72057594037927936.0,   /* = -0.09086... */
     5323534481176937.0 / 72057594037927936.0};  /* =  0.07388... */


/* --------------------------------------------------------------------- */
/* ---- global constants for q_sin and q_cos --------------------------- */
/* --------------------------------------------------------------------- */

   double q_sinc[6]={
        6004799503160652.0 /         144115188075855872.0,
       -6405119470031391.0 /        4611686018427387904.0,
        7320136533669489.0 /      295147905179352825856.0,
       -5205429515405659.0 /    18889465931478580854784.0,
        5047441620321680.0 /  2417851639229258349412352.0,
       -7031457305697611.0 / 618970019642690137449562112.0};
   double q_sins[6]={
       -6004799503160666.0 /          36028797018963968.0,
        4803839602527639.0 /         576460752303423488.0,
       -7320136535288236.0 /       36893488147419103232.0,
        6506787178212600.0 /     2361183241434822606848.0,
       -7571207865408408.0 /   302231454903657293676544.0,
        6155219321001458.0 / 38685626227668133590597632.0};
    double q_sint[5]={
        4704863629888981.0 /  9007199254740992.0,
        4600683640854786.0 /   18014398509481984.0,
        7074237750381340.0 /  2097152.0,
        7800291619608491.0 /   302231454903657293676544.0, 
                                         /* 2.580900000000000E-008 */ 
        5515724051991746.0 /   302231454903657293676544.0
                                         /* 1.825000000000000E-008 */ 
    };
        /* q_sint[2]= 3.373259425345106E+009 */ 

/* --------------------------------------------------------------------- */
/* ---- global constants for q_atnh ------------------------------------ */
/* --------------------------------------------------------------------- */
 
    /*     q_at3i = 3.333333333333333E-001                               */
    double q_at3i = 6004799503160661.0 / 18014398509481984.0;

/* ------------------------------------------------------------------- */
/* ----         global constants for the errorfunctions         ------ */
/* ------------------------------------------------------------------- */

/* ----    worst case relative error bound for q_erf and q_erfc   ---- */         
/*    eps(q_erf)    = 2.8452e-15                                       */
/*        q_erfm    = 1 - eps(q_erf) = 9.999999999999969e-001          */
   double q_erfm    = 9007199254740964.0 /  9007199254740992.0;
/*        q_erfp    = 1 + eps(q_erf) = 1.000000000000003e+000          */
   double q_erfp    = 4503599627370510.0 /  4503599627370496.0;      

/*    eps(q_erfc)   = 6.1641e-15                                       */
/*        q_efcm    = 1 - eps(q_erfc) = 9.999999999999936e-001         */
   double q_efcm    = 9007199254740934.0 /  9007199254740992.0;
/*        q_efcp    = 1 + eps(q_erfc) = 1.000000000000006e+000         */
   double q_efcp    = 4503599627370525.0 /  4503599627370496.0;
         
   double q_erft[7]={
     0.0,
     1.97193e-308,
     /*1.00000000000000003643E-010 = */
     7737125245533627.0 / 77371252455336267000000000.0,
     /*6.50000000000000022204E-001 = */
     5854679515581645.0 /  9007199254740992.0,
     /*2.64999999999999991118E+000 = */
     5967269506265907.0 /  2251799813685248.0,
     8.0,
     /*2.65432500000000004547E+001 = */ 
     7471260675575120.0 /   281474976710656.0};


/* ---------- rational approximation in A2 = [1e-10, 0.65] ----------- */
   double q_epA2[5]={  
     /*1.12837916709551255856e+000 = */
     5081767996463981.0 /  4503599627370496.0,
     /*1.35895070707443554880e-001 = */
     4896135918396240.0 / 36028797018963968.0,
     /*4.03259658325609282592e-002 = */
     5811584150300056.0 / 144115188075855872.0,
     /*1.20339912078812403921e-003 = */
     5549698899926403.0 / 4611686018427387904.0,
     /*6.49254346257748833756e-005 = */
     4790651505664119.0 / 73786976294838206000.0 };
   double q_eqA2[5]={  
     /*1.00000000000000000000e+000 = */
     1.0,
     /*4.53767204030574855533e-001 = */
     8174343243940195.0 / 18014398509481984.0,
     /*8.69936913926476762526e-002 = */
     6268556098232192.0 / 72057594037927936.0,
     /*8.49718523810939763141e-003 = */
     4898293794822088.0 / 576460752303423488.0,
     /*3.64916054139638153589e-004 = */
     6731513059101844.0 / 18446744073709552000.0 };
/* --------- rational approximation in B1 = [0.65, 2.65] ------------ */
   double q_epB1[7]={  
     /*9.99999995053825307956e-001 = */
     9007199210189811.0 /  9007199254740992.0,
     /*1.29137515241946498890e+000 = */
     5815836655231820.0 /  4503599627370496.0,
     /*8.33965460258685453709e-001 = */
     7511693072121760.0 /  9007199254740992.0,
     /*3.07821064389492415891e-001 = */
     5545211323525230.0 / 18014398509481984.0,
     /*6.45809354861053702690e-002 = */
     4653546831847395.0 / 72057594037927936.0,
     /*6.19734297263174228887e-003 = */
     7145049984571258.0 / 1152921504606846976.0,
     /*2.42699360423408255789e-008 = */
     7335138080495378.0 / 302231454903657290000000.0 };
   double q_eqB1[7]={  
     /*1.00000000000000000000e+000 = */
     1.0,
     /*2.41975425418358591756e+000 = */
     5448802178734685.0 /  2251799813685248.0,
     /*2.56436615659663313949e+000 = */
     5774439233645054.0 /  2251799813685248.0,
     /*1.53389534613813460773e+000 = */
     6908050509293041.0 /  4503599627370496.0,
     /*5.51301602659725609179e-001 = */
     4965683384614195.0 /  9007199254740992.0,
     /*1.14445507239651106390e-001 = */
     8246667900139522.0 / 72057594037927936.0,
     /*1.09858799707619209790e-002 = */
     6332928632660529.0 / 576460752303423488.0 };
/* --------- rational approximation in B2 = [2.65, 8.0] ------------- */
   double q_epB2[6]={  
     /*9.99652529969472625204e-001 = */ 
     9004069522940981.0 /  9007199254740992.0,
     /*1.70250355161751087962e+000 = */
     7667394360661568.0 /  4503599627370496.0,
     /*1.38625072852174180404e+000 = */
     6243118264412595.0 /  4503599627370496.0,
     /*6.69754557785788517954e-001 = */
     6032612753747537.0 /  9007199254740992.0,
     /*1.90685363469095009448e-001 = */
     6870164254915391.0 / 36028797018963968.0,
     /*3.08079405409659168313e-002 = */
     8879784290582176.0 / 288230376151711744.0 };
   double q_eqB2[7]={  
     /*1.00000000000000000000e+000 = */
     1.0,
     /*2.82886373185141204445e+000 = */
     6370034824323965.0 /  2251799813685248.0,
     /*3.58414377512046788965e+000 = */
     8070774285037411.0 /  2251799813685248.0,
     /*2.62603304307128482264e+000 = */
     5913300717119224.0 /  2251799813685248.0,
     /*1.21441313373848980284e+000 = */
     5469230536578499.0 /  4503599627370496.0,
     /*3.37980964348375101380e-001 = */
     6088523780390652.0 / 18014398509481984.0,
     /*5.46056535072178828027e-002 = */
     7869504025197724.0 / 144115188075855872.0 };
/* --------- rational approximation in B3 = [8.0, 26.54325] --------- */
   double q_epB3[5]={  
     /*5.64189583547756279280e-001 = */
     5081767996463981.0 /  9007199254740992.0,
     /*9.21322629916612534373e+000 = */
     5186585315975577.0 /   562949953421312.0,
     /*4.22557691999395714788e+001 = */
     5946970825721923.0 /   140737488355328.0,
     /*5.52670521664883693802e+001 = */
     7778146110714462.0 /   140737488355328.0,
     /*9.95533599990016782044e+000 = */
     5604355937437310.0 /   562949953421312.0 };
   double q_eqB3[5]={  
     /*1.00000000000000000000e+000 = */
     1.0,
     /*1.68300184332209603610e+001 = */
     4737229046530781.0 /   281474976710656.0,
     /*8.25614100580297787246e+001 = */
     5809742743320713.0 /    70368744177664.0,
     /*1.28491490639781432037e+002 = */
     4520892416918744.0 /    35184372088832.0,
     /*4.49638472416869063863e+001 = */
     6328098927587658.0 /   140737488355328.0 };


/* -------- constants for the function e^(-z*z), z is integer -------- */
   double q_expz[28] = {
      1.0,   
      .3678794411714423215955238,
      .1831563888873418029371802e-1,
      .1234098040866795494976367e-3,
      .1125351747192591145137752e-6,
      .1388794386496402059466176e-10,
      .2319522830243569388312264e-15,
      .5242885663363463937171805e-21,
      .1603810890548637852976087e-27,
      .6639677199580734400702255e-35,
      .3720075976020835962959696e-43,
      .2820770088460135401118447e-52,
      .2894640311648300280293837e-62,
      .4020060215743355247830339e-73,
      .7555819019711960355051515e-85,
      .1921947727823849068480597e-97,
      .6616261056709485261029531e-111,
      .3082440696949098412671082e-125,
      .1943514850049292733293510e-140,
      .1658410477681145141135306e-156,
      .1915169596714005695019840e-173,
      .2993184452260192731479412e-191,
      .6330977336210591368573409e-210,
      .1812254025793992329712749e-229,
      .7020667798504734713841204e-250,
      .3680855854801800602843630e-271,
      .2611741761284055470541587e-293,
      .4626391858469564202755058e-297 };
