-- test interval library

local I=require"interval"

------------------------------------------------------------------------------
print(I.version)

function new(a,b)
	local x=I.new(a,b)
	print""
	--print(x)
	print("new",x:extremes())
	return x
end

function test(w,x,y)
	print(w,I[w](x,y):extremes())
end

x=new(-1,2)
test("neg",x)
test("add",x,x)
test("sub",x,x)
test("mul",x,x)
test("div",x,2)
test("sqr",x)
--test("sqrt",x:sqrt())
test("sqr",x:sqr())
test("abs",x)

x=new(4,9)
test("sqrt",x)
print("old",x:extremes())

x=new(1,100)
test("log10",x)
x=new(math.exp(2),math.exp(3))
test("log",x)
x=new(2^3,2^7)
test("log2",x)

I.id= function (x) return x end

x=new(-1,2)
test("id",x^0)
test("id",x^1)
test("id",x^2)
test("id",x^3)
test("id",x^4)
--test("id",x^-4)

x=new(-1,2)
y=new(0,3)
test("join",x,y)
test("meet",x,y)
print("contained",I.contained(y,x))
print("disjoint",I.disjoint(y,x))
y=new(0,1)
print("contained",I.contained(y,x))
y=new(3,5)
print("disjoint",I.disjoint(y,x))

Z=0
Z=I.new(0)

function test(a,b)
	X=I.new(a,b)
	print(a,b,X<Z,X<=Z,X>Z,X>=Z,X==Z,X==Y)
end

Y=new(1,2)
print""
print("","X","X<0","X<=0","X>0","X>=0","X==0","X==Y")
test(-3,-2)
test(-3,0)
test(-3,2)
test(0,2)
test(1,2)
test(0,0)

function test(a,b,f)
	local x=I.new(a,b,f)
	local A,B=x:extremes()
	print(a,b,A,B,a==A,b==B,a-A,b-B)
end

print""
test(1,2)
test(1,2,false)
test(1,2,true)

------------------------------------------------------------------------------
print""
print(I.version)
