/*
* ldigest.c
* message digest library for Lua based on OpenSSL or Apple CommonDigest
* Luiz Henrique de Figueiredo <lhf@tecgraf.puc-rio.br>
* 06 Jun 2019 15:21:03
* This code is hereby placed in the public domain and also under the MIT license
*/

#include "ldigest.h"
#include "lua.h"
#include "lauxlib.h"
#include "mycompat.h"

#define MYNAME		"digest"
#define MYVERSION	MYNAME " library for " LUA_VERSION " / Jun 2019 / "\
			"using " AUTHOR

#ifdef MD2_DIGEST_LENGTH
#define DIGEST	MD2
#include "template.c"
#endif

#ifdef MD4_DIGEST_LENGTH
#define DIGEST	MD4
#include "template.c"
#endif

#ifdef MD5_DIGEST_LENGTH
#define DIGEST	MD5
#include "template.c"
#endif

#ifdef SHA1_DIGEST_LENGTH
#define DIGEST	SHA1
#include "template.c"
#endif

#ifdef SHA224_DIGEST_LENGTH
#define DIGEST	SHA224
#include "template.c"
#endif

#ifdef SHA256_DIGEST_LENGTH
#define DIGEST	SHA256
#include "template.c"
#endif

#ifdef SHA384_DIGEST_LENGTH
#define DIGEST	SHA384
#include "template.c"
#endif

#ifdef SHA512_DIGEST_LENGTH
#define DIGEST	SHA512
#include "template.c"
#endif

LUALIB_API int luaopen_digest(lua_State *L)
{
 lua_newtable(L);
 lua_pushliteral(L,"version");
 lua_pushliteral(L,MYVERSION);
 lua_settable(L,-3);
 populate_MD2(L,"md2");
 populate_MD4(L,"md4");
 populate_MD5(L,"md5");
 populate_SHA1(L,"sha1");
 populate_SHA224(L,"sha224");
 populate_SHA256(L,"sha256");
 populate_SHA384(L,"sha384");
 populate_SHA512(L,"sha512");
 return 1;
}
