-- test digest library

local D=require"digest"
print(D.version)

-- simple test
s='The quick brown fox jumps over the lazy dog'
d='9e107d9d372bb6826bd81d3542a419d6'

o=D.md5.new()
o:update(s)
o:update("")
z=o:hexdigest()
print(o.name,"simple",z==d,s)
print('','','',d)

-- complete test

data={

string={
'The quick brown fox jumps over the lazy dog',
'The quick brown fox jumps over the lazy cog',
'',
},

digest={

-- http://en.wikipedia.org/wiki/MD2_(cryptography)#MD2_hashes
md2={
'03d85a0d629d2c442e987525319fc471',
'6b890c9292668cdbbfda00a4ebf31f05',
'8350e5a3e24c153df2275c9f80692773',
},

-- http://en.wikipedia.org/wiki/MD4#MD4_hashes
md4={
'1bee69a46ba811185c194762abaeae90',
'b86e130ce7028da59e672d56ad0113df',
'31d6cfe0d16ae931b73c59d7e0c089c0',
},

-- http://en.wikipedia.org/wiki/MD5#MD5_hashes [test #2 is different]
md5={
'9e107d9d372bb6826bd81d3542a419d6',
'1055d3e698d289f2af8663725127bd4b',
'd41d8cd98f00b204e9800998ecf8427e',
},

-- http://en.wikipedia.org/wiki/SHA1#Example_hashes
sha1={
'2fd4e1c67a2d28fced849ee1bb76e7391b93eb12',
'de9f2c7fd25e1b3afad3e85a0bd17d9b100db4b3',
'da39a3ee5e6b4b0d3255bfef95601890afd80709',
},

sha224={
'730e109bd7a8a32b1cb9d9a09aa2325d2430587ddbc0c38bad911525',
'fee755f44a55f20fb3362cdc3c493615b3cb574ed95ce610ee5b1e9b',
'd14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f',
},

sha256={
'd7a8fbb307d7809469ca9abcb0082e4f8d5651e46d3cdb762d02d0bf37c9e592',
'e4c4d8f3bf76b692de791a173e05321150f7a345b46484fe427f6acc7ecc81be',
'e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855',
},

sha384={
'ca737f1014a48f4c0b6dd43cb177b0afd9e5169367544c494011e3317dbf9a509cb1e5dc1e85a941bbee3d7f2afbc9b1',
'098cea620b0978caa5f0befba6ddcf22764bea977e1c70b3483edfdf1de25f4b40d6cea3cadf00f809d422feb1f0161b',
'38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b',
},

sha512={
'07e547d9586f6a73f73fbac0435ed76951218fb7d0c8d788a309d785436bbb642e93a252a954f23912547d1e8a3b5ed6e1bfd7097821233fa0538f3db854fee6',
'3eeee1d0e11733ef152a6c29503b3ae20c4f1f3cda4cb26f1bc1a41f91c7fe4ab3bd86494049e201c4bd5155f31ecb7a3c8606843c4cc8dfcab7da11c8ae5045',
'cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e',
},

}

}

for k,v in pairs(data.digest) do
	if D[k]==nil then print(k,"not implemented") end
end

function test(d)
	for k,s in ipairs(data.string) do
		local ok= d.hexdigest(s)==data.digest[d.name][k]
		print(d.name,k,ok,s)
		assert(ok)
	end
end

for k,v in pairs(D) do
	if type(v)=="table" then
		if data.digest[k]==nil then
			print(k,"no data available")
		else
			assert(k==v.name)
			--print(k,v.size)
			test(v)
		end
	end
end

print(D.version)
