-- test xml library

local xml=require"xml"
print(xml.version)

-- parse XML text into Lua table
local function parse(s)
	local t,e,w=xml.load(s)
	if t==nil then
		print("    ...",s:sub(w,w+10):gsub("\n",""),"")
		print("","^"..e.." at position "..w)
		error()
	end
	return t
end

-- remove empty slots
local function compact(t)
	local i=0
	for k,v in ipairs(t) do
		if v then
			i=i+1
			t[i]=v
		end
	end
	for k=i+1,#t do t[k]=nil end
end

-- remove empty strings
local function clean(t)
	for k,v in ipairs(t) do
		local w=type(v)
		if w=="table" then
			clean(v)
		elseif w=="string" and v:match("^%s*$") then
			t[k]=false
		end
	end
	compact(t)
end

-- move 1-value subtables to table entries
local function simplify(t)
	for k,v in ipairs(t) do
		if type(v)=="table" then
			if #v==1 and type(v[1])=="string" and t[v[0]]==nil then
				t[v[0]]=v[1]
				t[k]=false
			else
				simplify(v)
			end
		end
	end
	compact(t)
end

-- show it all
local function dump(t,indent)
	indent=indent or ""
	print(indent..t[0])
	indent=indent.."\t"
	for k,v in pairs(t) do
		if type(k)~="number" then
			print(indent..k,'"'..v..'"')
		end
	end
	for k,v in ipairs(t) do
		if type(v)=="table" then
			dump(v,indent)
		elseif v then
			print(indent..k,'"'..v..'"')
		end
	end
end

local t=parse(io.read"*a")
clean(t)
simplify(t)
dump(t)

print(xml.version)
