#include <stdlib.h>
#include <stdio.h>
#include <string.h>
extern "C"
{
#include <lua.h>
#include <lauxlib.h>
}
#include "luabeans.h"

char* LuaBeans::init_code = 
"if LuaBeansTable == nil then LuaBeansTable = {} end";

static void register_methods(lua_State *L, int table_pos, struct luaL_reg* list, int n)
{
   for (int i = 0; i < n; i++)
   {
      lua_pushstring(L, list[i].name);
      lua_pushcfunction(L, list[i].func);
      lua_settable(L, table_pos);
   }
}

static void register_tagmethods(lua_State *L, int tag, struct luaL_reg* table, int n)
{
   int i = 0;
   for (i=0; i < n; i++)
   {
      lua_pushcfunction(L, table[i].func);
      lua_settagmethod(L, tag, table[i].name);
   }
}

LuaBeans* LuaBeans::createBeans(lua_State *lua_state, const char* name)
{
   lua_dostring(lua_state, LuaBeans::init_code);

   LuaBeans* lbeans = new LuaBeans(lua_state, name);
   
   lua_getglobal(lua_state, "LuaBeansTable");
   lua_pushstring(lua_state, (char*)name);
   lua_pushuserdata(lua_state, lbeans);
   lua_settable(lua_state, -3);
   lua_remove(lua_state, -1); /* cleans stack */

   return lbeans;
}

LuaBeans* LuaBeans::getBeans(lua_State *lua_state, const char* name)
{
   int top = lua_gettop(lua_state); /* saves stack top */

   lua_getglobal(lua_state, "LuaBeansTable"); /* S: T */
   lua_pushstring(lua_state, (char*)name); /* S: T S */
   lua_gettable(lua_state, -2); /* S: T O */

   LuaBeans* lbeans = (LuaBeans*) lua_touserdata(lua_state, -1);

   lua_settop(lua_state, top); /* cleans stack */ 

   return lbeans;
}

LuaBeans::LuaBeans(lua_State *lua_state,  const char* name )
{
   char lua_name[50];

   this->mlist = NULL;

   L = lua_state;

   int top = lua_gettop(L);

   sprintf(lua_name,"LB_%s_TAG",name);
   this->tag_name = _strdup(lua_name);

   sprintf(lua_name,"LB_%s_UDTAG",name);

   this->tag = lua_newtag(L);
   lua_pushnumber(L, (double)tag);
   lua_setglobal(L, tag_name);

   this->ud_tag = lua_newtag(L);
   lua_pushnumber(L, (double)ud_tag);
   lua_setglobal(L, lua_name);


   lua_settop(L, top); /* cleans stack */
}

LuaBeans::~LuaBeans()
{
   free(this->tag_name);
   if (this->mlist)
      delete this->mlist;
}

void LuaBeans::reg_tagmethods(struct luaL_reg* table, int n)
{
   register_tagmethods(L, this->tag,table,n);
}

void LuaBeans::reg_ud_tagmethods(struct luaL_reg* table, int n)
{
   register_tagmethods(L, this->ud_tag, table, n);
}

void LuaBeans::reg_methods(struct luaL_reg* table, int n)
{
   if (this->mlist == NULL)
   {
      this->mlist = new LuaBeans::MethodsList;
   }
   this->mlist->n = n;
   this->mlist->table = table;
}

void LuaBeans::push( void* userdata )
{
   lua_newtable(L); /* this is at the top of the stack now */

   int table_pos = lua_gettop(L); 

   lua_pushstring(L, "_USERDATA_REF_");
   lua_pushusertag(L, userdata, this->ud_tag);
   lua_settable(L, table_pos);

   if (this->mlist)
      register_methods(L, table_pos, this->mlist->table, this->mlist->n);

   lua_settop(L, table_pos);
   lua_settag(L, this->tag);
}

void* LuaBeans::check_tag(int index)
{
   void* userdata = this->from_lua(index);

   luaL_arg_check(L, (userdata!=NULL), index, "Object type is wrong");

   return userdata;
}

void* LuaBeans::from_lua(int index)
{
   if (lua_istable(L, index) && lua_tag(L, index) == this->tag)
   {
      lua_pushstring(L, "_USERDATA_REF_");
      lua_gettable(L, index);
      void *obj = lua_touserdata(L, -1);
      lua_remove(L, -1);

      return obj;
   }
   else
      return NULL;
}


lua_State* LuaBeans::getLuaState()
{
  return L;
}
