// tLuaCOMException.cpp: implementation of the tLuaCOMException class.
//
//////////////////////////////////////////////////////////////////////

#include <iostream.h>
#include <string.h>
#include <stdio.h>

#include "tLuaCOMException.h"


char *tLuaCOMException::messages[] =  
     {
       "Internal Error",
       "Parameter(s) out of range",
       "Type conversion error",
       "COM error",
       "COM exception",
       "Unsupported feature required",
       "Windows error",
       "LuaCOM error",
       "Memory allocation error"
     };


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

tLuaCOMException::tLuaCOMException(Errors p_code, char *p_file, int p_line,
                                   const char *p_usermessage)
{
  code = p_code;

  file = p_file;
  line = p_line;
  usermessage = p_usermessage;
  message_shown = false;
}

tLuaCOMException::~tLuaCOMException()
{

#ifndef NDEBUG
  if(!message_shown)
    showMessage();
#endif


}



void tLuaCOMException::showMessage(void)
{
  if(file != NULL)
  {
    cerr << "LuaCOM Exception in file " << file << " at line " << line
      << ": " << messages[code];
  }
  else
  {
    cerr << "LuaCOM Exception: " << messages[code];
  }

  if(usermessage != NULL)
  {
    cerr << ": " << usermessage << endl;
  }
  else
  {
    cerr << endl;
  }

  message_shown = true;
}

const char * tLuaCOMException::getMessage()
{
  static char string[5000];


  strncpy(string, messages[code], sizeof(string)-1);

  if(usermessage != NULL)
  {
    strncat(string, ": ", sizeof(string) - strlen(string) - 1);
    strncat(string, usermessage, sizeof(string) - strlen(string) - 1);
  }

#ifndef NDEBUG
  char error_position[1000];

  if(file != NULL)
  {
    sprintf(error_position, " (file %s, line %d)", file, line);
    strcat(string, error_position);
  }
#endif

  message_shown = true;

  return string;
}

