/*
 * tLuaDispatch.cpp
 *
 * Vinicius Almendra
 */

// RCS Info
static char *rcsid = "$Id: tLuaDispatch.cpp,v 1.18 2003/05/26 17:47:48 almendra Exp $";
static char *rcsname = "$Name:  $";


#include "tLuaDispatch.h"
#include "tLuaCOM.h"
#include "tLuaCOMException.h"
#include "tCOMUtil.h"
#include "LuaAux.h"


long tLuaDispatch::NEXT_ID = 0;

tLuaDispatch::ProvideClassInfo2::ProvideClassInfo2(ITypeInfo* p_coclassinfo,
                                                   IUnknown* p_pUnk)
{
  coclassinfo = p_coclassinfo;
  pUnk = p_pUnk;
}

STDMETHODIMP tLuaDispatch::ProvideClassInfo2::QueryInterface(
                                                            REFIID riid,
                                                            void ** ppvObj)
{
  return pUnk->QueryInterface(riid, ppvObj);
}

STDMETHODIMP_(unsigned long) tLuaDispatch::ProvideClassInfo2::AddRef(void)
{
  return pUnk->AddRef();
}

STDMETHODIMP_(unsigned long) tLuaDispatch::ProvideClassInfo2::Release(void)
{
  return pUnk->Release();
}


STDMETHODIMP tLuaDispatch::ProvideClassInfo2::GetClassInfo(ITypeInfo** ppTypeInfo)
{
  *ppTypeInfo = coclassinfo;
  coclassinfo->AddRef();

  return S_OK;
}

STDMETHODIMP tLuaDispatch::ProvideClassInfo2::GetGUID(DWORD dwGuidKind,
                                                     GUID * pGUID)
{
  ITypeInfo* source_typeinfo = NULL;
  TYPEATTR *typeattr = NULL;
  HRESULT hr = S_OK;

  if(!pGUID)
    return E_POINTER;

  if(dwGuidKind == GUIDKIND_DEFAULT_SOURCE_DISP_IID)
  {
    source_typeinfo = 
      tCOMUtil::GetDefaultInterfaceTypeInfo(coclassinfo, true);

    if(!source_typeinfo)
      return E_UNEXPECTED;

    hr = source_typeinfo->GetTypeAttr(&typeattr);

    if(FAILED(hr))
    {
      source_typeinfo->Release();
      return E_UNEXPECTED;
    }

   *pGUID = typeattr->guid;

   source_typeinfo->ReleaseTypeAttr(typeattr);
   source_typeinfo->Release();
  }
  else
    return E_INVALIDARG;

  return S_OK;
}





//---------------------------------------------------------------------
//                     IUnknown Methods
//---------------------------------------------------------------------


STDMETHODIMP
tLuaDispatch::QueryInterface(REFIID riid, void FAR* FAR* ppv)
{

    if(IsEqualIID(riid, IID_IUnknown)  ||
       IsEqualIID(riid, IID_IDispatch) ||
       IsEqualIID(riid, interface_iid)) {
      *ppv = this;
      AddRef();
      return NOERROR;       
    }

    if((IsEqualIID(riid, IID_IProvideClassInfo) ||
        IsEqualIID(riid, IID_IProvideClassInfo2)   )  &&
       classinfo2)
    {
      *ppv = classinfo2;
      classinfo2->AddRef();
      return NOERROR;
    }

    if(IsEqualIID(riid, IID_IConnectionPointContainer) &&
      cpc)
    {
      *ppv = cpc;
      cpc->AddRef();
      return NOERROR;
    }


	       
    *ppv = NULL;
    return ResultFromScode(E_NOINTERFACE);
}


STDMETHODIMP_(unsigned long)
tLuaDispatch::AddRef()
{
    return ++m_refs;
}


STDMETHODIMP_(unsigned long)
tLuaDispatch::Release()
{
  assert(m_refs > 0);
  if(--m_refs == 0)
  {
    // destrava tabela LUA
    lua_unref(L, table_ref);

    // libera libs

    while(num_methods--)
    {
      typeinfo->ReleaseFuncDesc(funcinfo[num_methods].funcdesc);
      delete funcinfo[num_methods].name;
    }

    delete funcinfo;
    typeinfo->Release();
    typeinfo = NULL;

    delete typehandler;

    if(cpc)
      delete cpc;

    if(classinfo2)
      delete classinfo2;

    // destroi objeto
    delete this;
    return 0;
  }

  return m_refs;
}


//---------------------------------------------------------------------
//                     IDispatch Methods
//---------------------------------------------------------------------



STDMETHODIMP
tLuaDispatch::GetTypeInfoCount(unsigned int FAR* pctinfo)
{
    *pctinfo = 1;
    return NOERROR;
}


STDMETHODIMP
tLuaDispatch::GetTypeInfo(unsigned int itinfo, LCID lcid, ITypeInfo FAR* FAR* pptinfo)
{
  if(itinfo != 0)
    return ResultFromScode(TYPE_E_ELEMENTNOTFOUND);

  if(pptinfo == NULL)
    return ResultFromScode(E_POINTER);

  typeinfo->AddRef();
  *pptinfo = typeinfo;

  return NOERROR;
}


STDMETHODIMP
tLuaDispatch::GetIDsOfNames(
    REFIID riid,
    OLECHAR FAR* FAR* rgszNames,
    unsigned int cNames,
    LCID lcid,
    DISPID FAR* rgdispid)
{
    // this object only exposes a "default" interface.
    //
    if(!IsEqualIID(riid, IID_NULL))
      return ResultFromScode(DISP_E_UNKNOWNINTERFACE);

    return DispGetIDsOfNames(typeinfo, rgszNames, cNames, rgdispid);
}


STDMETHODIMP
tLuaDispatch::Invoke(
    DISPID dispidMember,
    REFIID riid,
    LCID lcid,
    unsigned short wFlags,
    DISPPARAMS FAR* pdispparams,
    VARIANT FAR* pvarResult,
    EXCEPINFO FAR* pexcepinfo,
    unsigned int FAR* puArgErr)
{
  HRESULT hresult         = 0;
  int index               = 0;
  stkIndex member         = -1;
  int current_arg         = 0;
  HRESULT retval          = NOERROR;
  stkIndex return_value_pos = 0;


  if(wFlags & ~(DISPATCH_METHOD | DISPATCH_PROPERTYGET | DISPATCH_PROPERTYPUT | DISPATCH_PROPERTYPUTREF))
    return ResultFromScode(E_INVALIDARG);

  if(!IsEqualIID(riid, IID_NULL))
    return ResultFromScode(DISP_E_UNKNOWNINTERFACE);

  /* descobre qual o nome do metodo */

  for(index = 0; index < num_methods; index++)
  {
    if(funcinfo[index].funcdesc->memid == dispidMember &&
       funcinfo[index].funcdesc->invkind & wFlags)
       break;
  }

  if(index >= num_methods)
    return (ResultFromScode(DISP_E_MEMBERNOTFOUND));

  // gets a reference to the implementation table
  lua_getref(L, table_ref);
  int implementation_table = lua_gettop(L);

  try
  {

    switch(wFlags)
    {
    case DISPATCH_METHOD:
      retval = method(
        funcinfo[index].name,
        funcinfo[index].funcdesc,
        pdispparams,
        pvarResult,
        pexcepinfo,
        puArgErr);

      break;

    case DISPATCH_METHOD | DISPATCH_PROPERTYGET:

      // sometimes the caller can't tell the difference between
      // a property get and a method call. We try first a
      // method call and then, if it's not successful, try
      // a property get

      {
        HRESULT ret = method(
          funcinfo[index].name,
          funcinfo[index].funcdesc,
          pdispparams,
          pvarResult,
          pexcepinfo,
          puArgErr);

        if(ret != S_OK)
        {
          retval = propertyget(
            funcinfo[index].name,
            funcinfo[index].funcdesc,
            pdispparams,
            pvarResult,
            pexcepinfo,
            puArgErr);
        }

      }
      break;

    case DISPATCH_PROPERTYGET:

      retval = propertyget(
        funcinfo[index].name,
        funcinfo[index].funcdesc,
        pdispparams,
        pvarResult,
        pexcepinfo,puArgErr);

      break;

    case DISPATCH_PROPERTYPUT:

      retval = propertyput(
        funcinfo[index].name,
        pdispparams,
        pvarResult,
        pexcepinfo,puArgErr);

      break;

    case DISPATCH_PROPERTYPUTREF:
        retval = DISP_E_EXCEPTION;
        FillExceptionInfo(pexcepinfo, "Property putref not supported.");
      break;

    default: // we can't arrive here unless for a bug...
      retval =  DISP_E_MEMBERNOTFOUND;
      break;
    }
  }
  catch(class tLuaCOMException& e)
  {
    retval = DISP_E_EXCEPTION;
    FillExceptionInfo(pexcepinfo, e.getMessage());
  }

  // removes implementation table
  lua_remove(L, implementation_table);

  return retval;
}

tLuaDispatch::tLuaDispatch(ITypeInfo * pTypeinfo, int ref, LuaBeans *lbeans)
{
  HRESULT hr;

  /* inicializacao do objeto */
  L = lbeans->getLuaState();

  // gets a locked reference to the implementation object
  lua_getref(L, ref);
  int locked_ref = lua_ref(L, 1);
  table_ref = locked_ref;

  m_refs = 0;

  typeinfo = pTypeinfo;

  typeinfo->AddRef();

  // inicializa conversor de tipos
  typehandler = new tLuaCOMTypeHandler(typeinfo, lbeans);

  {
    TYPEATTR * ptypeattr = NULL;
    FUNCDESC *funcdesc = NULL;
    unsigned int i, n;

    hr = typeinfo->GetTypeAttr(&ptypeattr);

    CHECK(SUCCEEDED(hr), INTERNAL_ERROR);

    memcpy(&interface_iid, &ptypeattr->guid, sizeof(IID));


    /* Obtem todas as descricoes das funcoes e guarda-as em
       uma tabela */

    n = ptypeattr->cFuncs;
    typeinfo->ReleaseTypeAttr(ptypeattr);

    funcinfo = new tFuncInfo[n];

    num_methods = 0;

    for (i = 0; i < n;i++)
    {
      hr = typeinfo->GetFuncDesc(i, &funcdesc);

      CHECK(SUCCEEDED(hr) && funcdesc != NULL, INTERNAL_ERROR);

      // ignores functions not accessible via Automation
      if(funcdesc->wFuncFlags & FUNCFLAG_FRESTRICTED)
        continue;

      funcinfo[num_methods].funcdesc = funcdesc;

      BSTR names[1];
      unsigned int dumb; 
      typeinfo->GetNames(funcdesc->memid, names, 1, &dumb); 

      const int str_size = SysStringLen(names[0]);

      funcinfo[num_methods].name = new char[str_size + 1];
      wcstombs(funcinfo[num_methods].name, names[0], str_size+1);

      num_methods++;
    }
  }

  cpc = NULL;
  classinfo2 = NULL;

  ID = tLuaDispatch::NEXT_ID++;
#ifdef LUACOMLOG
  {
    char msg[100];

    sprintf(msg, "%d:created", ID);
    tUtil::log("tLuaDispatch",msg);
  }
#endif

  // agora sim esta' inicializado

  return;
}


tLuaDispatch * tLuaDispatch::CreateLuaDispatch(ITypeInfo* interface_typeinfo,
                                               int ref,
                                               LuaBeans *lbeans)
{
  tLuaDispatch *pdisp = NULL;

  pdisp = new tLuaDispatch(interface_typeinfo, ref, lbeans);

  pdisp->AddRef();

  return pdisp;
}

/*
 * Fills an EXCEPINFO structure
 *
 */

void tLuaDispatch::FillExceptionInfo(EXCEPINFO *pexcepinfo, const char *text)
{
  CHECKPARAM(pexcepinfo && text);

  pexcepinfo->wCode             = 1000;
  pexcepinfo->wReserved         = 0;
  pexcepinfo->bstrSource        = tUtil::string2bstr("LuaCOM");
  pexcepinfo->bstrDescription   = tUtil::string2bstr(text);
  pexcepinfo->bstrHelpFile      = NULL;
  pexcepinfo->pvReserved        = NULL;
  pexcepinfo->pfnDeferredFillIn = NULL;
  pexcepinfo->scode             = 0;
}



HRESULT tLuaDispatch::propertyget(const char* name,
                                  FUNCDESC* funcdesc,
                                  DISPPARAMS *pdispparams,
                                  VARIANT *pvarResult,
                                  EXCEPINFO *pexcepinfo,
                                  unsigned int *puArgErr)
{
  /* le valor contido na tabela */
  lua_pushstring(L, name);

  lua_gettable(L, -2);
  stkIndex member = lua_gettop(L);

  if(lua_isnil(L, member))
  {
    lua_remove(L, member);
    return DISP_E_MEMBERNOTFOUND;
  }

  if(pdispparams->cArgs > 0) // propertyget parametrizado
  {
    if(lua_istable(L, member))
    {
      lua_pushvalue(L, member);
      typehandler->com2lua(pdispparams->rgvarg[pdispparams->cArgs - 1]);

      lua_gettable(L, -2);
      member = lua_gettop(L);
    }
    else
    {
      // funciona como um propget normal, ignorando parametro
    }
  }

  /* converte resultado para COM */

  if(pvarResult != NULL)
  {
    typehandler->setRetval(funcdesc, member, pvarResult);
  }

  return S_OK;
}


HRESULT tLuaDispatch::propertyput(const char* name,
                                  DISPPARAMS *pdispparams,
                                  VARIANT *pvarResult,
                                  EXCEPINFO *pexcepinfo,
                                  unsigned int *puArgErr)
{
  if(pdispparams->cArgs == 1) // propput normal
  {
    lua_pushstring(L, name);

    // Valor a ser setado
    typehandler->com2lua(pdispparams->rgvarg[pdispparams->cArgs - 1]);

    lua_settable(L, -3);
  }
  else if(pdispparams->cArgs == 2) // propertyput parametrizado
  {
    /* verifica se campo referenciado e' uma tabela */
    lua_pushstring(L, name);

    lua_gettable(L, -2);
    stkIndex member = lua_gettop(L);

    if(lua_istable(L, member) || lua_isuserdata(L, member)) // se for, 
    {
      lua_pushvalue(L, member);

      // indice
      typehandler->com2lua(pdispparams->rgvarg[pdispparams->cArgs - 1]);

      // Valor a ser setado
      typehandler->com2lua(pdispparams->rgvarg[pdispparams->cArgs - 2]);

      lua_settable(L, -3);
    }
    else
    {
      FillExceptionInfo(pexcepinfo, "Parametrized property puts only "
        "implemented for tables and userdata's.");

      return DISP_E_EXCEPTION;
    }
  }
  else
  {
    FillExceptionInfo(pexcepinfo, "Property puts with more than two "
      "parameters aren't supported.");

    return DISP_E_EXCEPTION;
  }

  return S_OK;
}


HRESULT tLuaDispatch::method(const char* name,
                             FUNCDESC* funcdesc,
                             DISPPARAMS *pdispparams,
                             VARIANT *pvarResult,
                             EXCEPINFO *pexcepinfo,
                             unsigned int *puArgErr)
{
  // gets lua function from implementation table
  lua_pushstring(L, name);
  lua_gettable(L, -2);

  // stores position of the member function
  stkIndex member = lua_gettop(L);
      
  // tests whether it's really a function

  if(!lua_isfunction(L, member))
  {
    lua_remove(L, member);
    return DISP_E_MEMBERNOTFOUND;
  }

  /* converte parametros e empilha */

  // parametro self
  lua_getref(L, table_ref);

  // Parametros passados via COM
  typehandler->pushLuaArgs(
    pdispparams,
    funcdesc->lprgelemdescParam);

  // chama funcao lua
  lua_call(L, lua_gettop(L) - member, LUA_MULTRET);
  
  /* converte resultado para COM */

  // return values will be put in the place of the function
  // and beyond
  stkIndex return_value_pos = member;

  if(pvarResult != NULL)
  {
    if(return_value_pos <= lua_gettop(L)
      && funcdesc->elemdescFunc.tdesc.vt != VT_VOID
      )
    {
      VARIANTARG result;
      VariantInit(&result);

      typehandler->lua2com(return_value_pos, result);

      *pvarResult = result;

      return_value_pos++;
    }
  }

  // atualiza parametros de saida
  typehandler->setOutValues(funcdesc, pdispparams, return_value_pos);

  return S_OK;
}

void tLuaDispatch::SetCoClassinfo(ITypeInfo *coclassinfo)
{
  classinfo2 = new ProvideClassInfo2(coclassinfo, this);
  CHKMALLOC(classinfo2);
}

void tLuaDispatch::BeConnectable(LuaBeans *lbeans)
{
  try
  {
    cpc = new tLuaCOMConnPointContainer(L, lbeans, this);
  }
  catch(class tLuaCOMException& e)
  {
    UNUSED(e);
    cpc = NULL;
  }
}

tLuaCOMConnPointContainer* tLuaDispatch::GetConnPointContainer()
{
  return cpc;
}

tLuaDispatch::~tLuaDispatch()
{
#ifdef LUACOMLOG
  {
    char msg[100];

    sprintf(msg, "%d:destroyed", ID);
    tUtil::log("tLuaDispatch",msg);
  }
#endif
}
