// tCOMUtil.h: interface for the tCOMUtil class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __TCOMUTIL_H
#define __TCOMUTIL_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <windows.h>
#include <oleauto.h>

class tCOMUtil  
{
public:
	static const char* getPrintableTypeKind(TYPEKIND tkind);
	static void DumpTypeInfo(ITypeInfo* typeinfo);
	static bool SetRegKeyValue(const char* key, const char* subkey, const char* value);
	static HRESULT GetCLSID(ITypeInfo* coclassinfo, CLSID* pClsid);
	static HRESULT ProgID2CLSID(CLSID* pClsid, const char* ProgID);
	static ITypeLib* LoadTypeLibFromCLSID(
    CLSID clsid,
    unsigned short major_version=0);

  static ITypeLib* LoadTypeLibFromProgID(
    const char* ProgID,
    unsigned short major_version=0);

  static ITypeLib* LoadTypeLibByName(const char *pcFilename);

  static ITypeInfo* GetCoClassTypeInfo(ITypeLib* typelib, CLSID clsid);
  static ITypeInfo* GetCoClassTypeInfo(CLSID clsid);
  static ITypeInfo* GetCoClassTypeInfo(IUnknown* punk);
  static ITypeInfo* GetCoClassTypeInfo(IDispatch* pdisp, CLSID clsid);
  static ITypeInfo* GetCoClassTypeInfo(ITypeLib *typelib,
                                       const char *coclassname);
  static ITypeInfo* GetDefaultInterfaceTypeInfo(ITypeInfo* pCoClassinfo,
                                                bool source);
  static ITypeInfo* GetInterfaceTypeInfo(ITypeLib* typelib,
                                         const char *interface_name);
  static ITypeInfo* GetDispatchTypeInfo(IDispatch* pdisp);

	tCOMUtil();
	virtual ~tCOMUtil();

protected:
	static bool GetDefaultTypeLibVersion(
    const char* libid,
    unsigned short* version_major,
    unsigned short* version_minor);
};

#define COM_RELEASE(x) {if(x){(x)->Release(); (x) = NULL;}}

#endif // __TCOMUTIL_H
