/*
 * ttLuaCOM.h
 */


#ifndef __LUACOM_H
#define __LUACOM_H

#include <ole2.h>
#include <ocidl.h> 

extern "C"
{
#include <lua.h>
#include <lauxlib.h>
}

#include "luabeans.h"
#include "tLuaCOMTypeHandler.h"

#include "tLuaObjList.h"

enum tWhichInterface {DISP, SOURCE};

// Types of FUNCDESC

#define MAX_FUNCINFOS 100

struct FuncInfo
{
  char*     name;

  FUNCDESC* propget;
  FUNCDESC* propput;
  FUNCDESC* func;
};


class tLuaCOM
{
public:
	bool hasTypeInfo(void);
	bool may_be_collected(void);
	ITypeInfo* GetTypeInfo(void);
	ITypeInfo* GetCoClassTypeInfo(void);
	void GetIID(IID *piid);
	IDispatch * GetIDispatch(void);
	void ReleaseFuncDesc(FUNCDESC *pfuncdesc);
	ITypeInfo * GetDefaultEventsInterface(void);
  static tLuaCOM * CreateLuaCOM(IDispatch * pdisp,
                                ITypeInfo* coclassinfo,
                                LuaBeans *lbeans,
                                ITypeInfo* typeinfo=NULL,
                                bool can_be_collected=true);

	void getHelpInfo(char **ppHelpFile, unsigned long *pHelpContext);
	bool isMember(const char *name);

   ~tLuaCOM();

   bool addConnection(tLuaCOM *client);
   void releaseConnection(void);

   int call(DISPID dispid,
                  int invkind,
                  FUNCDESC *pFuncDesc,
                  tLuaObjList& params);

   bool getFUNCDESC(const char* name, FuncInfo& funcinfo);
   bool getDISPID(const char* name, DISPID* dispid);

  static char* TAG;
  static long NEXT_ID;
protected:
	ITypeComp* ptcomp;
	bool can_be_collected;
	ITypeInfo* coclassinfo;

  tLuaCOM(
    IDispatch *pdisp_arg,
    ITypeInfo *ptinfo_arg,
    ITypeInfo *coclassinfo,
    LuaBeans *lbeans,
    bool p_can_be_collected=true);

	tLuaCOMTypeHandler * typehandler;


  LPDISPATCH pdisp;
  ITypeInfo* ptinfo;
  IConnectionPoint *connection_point;
  DWORD connection_point_cookie;

  // struct to hold all type information for a
  // member

  FuncInfo pFuncInfo[MAX_FUNCINFOS];
private:
	long ID;
};

#endif // __LUACOM_H
