// tLuaTLB.h: interface for the tLuaTLB class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLUATLB_H__B01390C8_623A_4856_8BE7_B6FA47AC0E37__INCLUDED_)
#define AFX_TLUATLB_H__B01390C8_623A_4856_8BE7_B6FA47AC0E37__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <ocidl.h>

#include "tLuaObject.h"


class tLuaTLB : public tLuaObject  
{
public:
	static int pushNew(lua_State* L, ITypeLib* p_typelib);
  static void Init(lua_State* L);

protected:
	int index(lua_State* L);
  ITypeLib* typelib;

  static const char type_name[];
  static const char pointer_type_name[];

  static int ShowHelp(tLuaObject* lua_obj, lua_State* L);

	tLuaTLB(lua_State* L, ITypeLib *p_typelib);
	virtual ~tLuaTLB();
};



//
// tLuaTypeInfo: generic Lua proxy for ITypeInfo objects
//

class tLuaTypeInfo;

class tLuaTypeInfo: public tLuaObject
{
public:
  virtual bool isPublic();

  static tLuaTypeInfo* pushNew(lua_State* L, ITypeInfo* p_typeinfo);
  static void Init(lua_State* L);

  void fillTable(lua_State* L);

  class Generic;
  class CoClass;
  class Enum;
  class Dispinterface;


protected:
	bool filled;
	int index(lua_State* L);
	virtual void generic_fillTable(lua_State* L);
	static int ShowHelp(tLuaObject* lua_obj, lua_State* L);
  static int public_typeinfo(tLuaObject* lua_obj, lua_State* L);
  static int TypeLib(tLuaObject* lua_obj, lua_State* L);
  static int Load(tLuaObject* lua_obj, lua_State* L);
  static int type(tLuaObject* lua_obj, lua_State* L);


	unsigned long helpcontext;
	char* helpfile;
	TYPEATTR* typeattr;
  ITypeInfo* typeinfo;

  static const char type_name[];
  static const char pointer_type_name[];

	tLuaTypeInfo(lua_State* L,
               ITypeInfo *p_typeinfo
               );

	virtual ~tLuaTypeInfo();
};

class tLuaTypeInfo::Generic: public tLuaTypeInfo
{
public:
  Generic(lua_State* L, ITypeInfo* typeinfo);
};

class tLuaTypeInfo::CoClass: public tLuaTypeInfo
{
public:
	bool isPublic(void);
  CoClass(lua_State* L, ITypeInfo* typeinfo);

protected:
  static int New(tLuaObject* lua_obj, lua_State* L);
};


class tLuaTypeInfo::Enum: public tLuaTypeInfo
{
public:
	bool isPublic(void);
  Enum(lua_State* L, ITypeInfo* typeinfo);
  void fillTable(lua_State* L);
protected:
	void generic_fillTable(lua_State* L);
};

class tLuaTypeInfo::Dispinterface: public tLuaTypeInfo
{
public:
	bool isPublic(void);
  Dispinterface(lua_State* L, ITypeInfo* typeinfo);
  void fillTable(lua_State* L);

protected:
	void generic_fillTable(lua_State* L);
  class tLuaFuncDesc : public tLuaObject
  {
  public:
    static void pushNew(lua_State* L, ITypeInfo* ptypeinfo_p, int i);
    void fillTable(lua_State* L);

  protected:
	  FUNCDESC* pfuncdesc;
	  ITypeInfo* ptypeinfo;

    tLuaFuncDesc(ITypeInfo* ptypeinfo_p, FUNCDESC* pfuncdesc_p);
    ~tLuaFuncDesc();

    static const char type_name[];
    static const char pointer_type_name[];

  };
};





#endif // !defined(AFX_TLUATLB_H__B01390C8_623A_4856_8BE7_B6FA47AC0E37__INCLUDED_)
