/*
 * tLuaControl.cpp
 *
 */

#include <ole2.h>
#include <oleidl.h>
#include <ocidl.h>

extern "C"
{
#include "lua.h"
#include "lualib.h"
#include <lauxlib.h>
#include "LuaCompat.h"
}

#include "tLuaDispatch.h"
#include "tLuaControl.h"

const float  HIMETRIC_PER_PIXEL(26.4583333333f);

SIZEL PixelToHimetric(SIZEL pixelSize) {
	SIZEL ret;
	ret.cx = static_cast<long>(pixelSize.cx * HIMETRIC_PER_PIXEL + 0.5);
	ret.cy = static_cast<long>(pixelSize.cy * HIMETRIC_PER_PIXEL + 0.5);
	return ret;
}

SIZEL HimetricToPixel(SIZEL himetricSize) {
	SIZEL ret;
	ret.cx = static_cast<long>(himetricSize.cx / HIMETRIC_PER_PIXEL + 0.5);
	ret.cy = static_cast<long>(himetricSize.cy / HIMETRIC_PER_PIXEL + 0.5);
	return ret;
}

tLuaControl::tLuaControl(lua_State* L, ITypeInfo *pTypeinfo, int ref) : tLuaDispatch(L, pTypeinfo, ref) {
	pClientSite = NULL;
	CreateOleAdviseHolder(&pAdviseHolder);
}

tLuaControl::~tLuaControl() {
	if(pClientSite)
		pClientSite->Release();
	if(pAdviseHolder)
		pAdviseHolder->Release();
}

STDMETHODIMP tLuaControl::QueryInterface(REFIID riid, void FAR* FAR* ppv)
{

    if(IsEqualIID(riid, IID_IUnknown)  ||
       IsEqualIID(riid, IID_IDispatch) ||
       IsEqualIID(riid, interface_iid)) {
      *ppv = (IDispatch*)this;
	  this->AddRef();
      return NOERROR;       
    }

    if((IsEqualIID(riid, IID_IProvideClassInfo) ||
        IsEqualIID(riid, IID_IProvideClassInfo2)   )  &&
       classinfo2)
    {
      *ppv = classinfo2;
      classinfo2->AddRef();
      return NOERROR;
    }

    if(IsEqualIID(riid, IID_IConnectionPointContainer) &&
      cpc)
    {
      *ppv = cpc;
      cpc->AddRef();
      return NOERROR;
    }

    if(IsEqualIID(riid, IID_ILuaDispatch))
    {
      *ppv = (ILuaDispatch*)this;
      this->AddRef();
      return NOERROR;
    }

    if(IsEqualIID(riid, IID_IOleObject))
    {
      *ppv = (IOleObject*)this;
      this->AddRef();
      return NOERROR;
    }

    if(IsEqualIID(riid, IID_IOleInPlaceObject))
    {
      *ppv = (IOleInPlaceObject*)this;
      this->AddRef();
      return NOERROR;
    }

    if(IsEqualIID(riid, IID_IOleInPlaceActiveObject))
    {
      *ppv = (IOleInPlaceActiveObject*)this;
      this->AddRef();
      return NOERROR;
    }

    *ppv = NULL;
    return ResultFromScode(E_NOINTERFACE);
}

STDMETHODIMP_(unsigned long) tLuaControl::AddRef()
{
	return tLuaDispatch::AddRef();
}


STDMETHODIMP_(unsigned long) tLuaControl::Release()
{
	return tLuaDispatch::Release();
}

STDMETHODIMP tLuaControl::SetClientSite(IOleClientSite* pcs) {
	if(pcs) pcs->AddRef();
	pClientSite = pcs;
	if(pClientSite) {
		IOleContainer *poc;
		HRESULT hr = pClientSite->GetContainer(&poc);
		if(SUCCEEDED(hr)) {
			IOleInPlaceSite *poips;
			hr = poc->QueryInterface(IID_IOleInPlaceSite, (void**)&poips);
			if(SUCCEEDED(hr)) {
				HWND hwnd;
				hr = poips->GetWindow(&hwnd);
				if(SUCCEEDED(hr)) {
				    lua_getref(L, table_ref);
					lua_pushstring(L, "Initialize");
					lua_gettable(L, -2);
					lua_pushvalue(L, -2);
					lua_remove(L, -3);
					luaCompat_pushPointer(L, &hwnd);
					luaCompat_call(L, 2, 0, NULL);
				}
				poips->Release();
			}
			poc->Release();
		}
	}
	return S_OK;
}

STDMETHODIMP tLuaControl::GetClientSite(IOleClientSite** ppcs) {
	if(!ppcs) return E_POINTER;
	*ppcs = pClientSite;
	return S_OK;
}

STDMETHODIMP tLuaControl::SetHostNames(LPCOLESTR szContainerApp, LPCOLESTR szContainerObj) {
	return S_OK;
}

STDMETHODIMP tLuaControl::Close(DWORD dwSaveOption) {
	pAdviseHolder->SendOnClose();
	pClientSite->Release();
	return S_OK;
}

STDMETHODIMP tLuaControl::SetMoniker(DWORD dwWitchMoniker, IMoniker* pmk) {
	return E_NOTIMPL;
}

STDMETHODIMP tLuaControl::GetMoniker(DWORD dwAssign, DWORD dwWitchMoniker, IMoniker** ppMoniker) {
	return E_NOTIMPL;
}

STDMETHODIMP tLuaControl::InitFromData(IDataObject* pDataObject, BOOL fCreation, DWORD dwReserved) {
	return E_NOTIMPL;
}

STDMETHODIMP tLuaControl::IsUpToDate() {
	return S_OK;
}

STDMETHODIMP tLuaControl::GetClipboardData(DWORD dwReserved, IDataObject** ppDataObject) {
	return E_NOTIMPL;
}

STDMETHODIMP tLuaControl::DoVerb(long iVerb, MSG* lpmsg, IOleClientSite* pActiveSite,
		long lIndex, HWND hwndParent, LPCRECT lprcPosRect) {
	return OLEOBJ_E_NOVERBS;
}

STDMETHODIMP tLuaControl::EnumVerbs(IEnumOLEVERB** ppEnumOleVerb) { 
	return OLEOBJ_E_NOVERBS;
}

STDMETHODIMP tLuaControl::Update() {
	return S_OK; 
}

STDMETHODIMP tLuaControl::GetUserClassID(CLSID* pClsid) {
	if(!pClsid) return E_POINTER;
	TYPEATTR *ppta;
	typeinfo->GetTypeAttr(&ppta);
	*pClsid = ppta->guid;
	typeinfo->ReleaseTypeAttr(ppta);
	return S_OK;
}

STDMETHODIMP tLuaControl::GetUserType(DWORD dwFormOfType, LPOLESTR* pszUserType) {
	CLSID clsid;
	this->GetUserClassID(&clsid);
	return OleRegGetUserType(clsid, dwFormOfType, pszUserType);
}

STDMETHODIMP tLuaControl::SetExtent(DWORD dwAspect, SIZEL* pSizel) {
	if(!pSizel) return E_POINTER;
	if(dwAspect != DVASPECT_CONTENT) return E_FAIL;
	SIZEL pixelExtent = HimetricToPixel(*pSizel);
    lua_getref(L, table_ref);
	lua_pushstring(L, "SetExtent");
	lua_gettable(L, -2);
	lua_pushvalue(L, -2);
	lua_remove(L, -3);
	lua_pushnumber(L, pixelExtent.cx);
	lua_pushnumber(L, pixelExtent.cy);
	if(luaCompat_call(L, 3, 0, NULL)) return E_FAIL;
	return S_OK;
}

STDMETHODIMP tLuaControl::GetExtent(DWORD dwAspect, SIZEL* pSizel) {
	if(!pSizel) return E_POINTER;
	if(dwAspect != DVASPECT_CONTENT) return E_INVALIDARG;
	SIZEL pixelExtent;
    lua_getref(L, table_ref);
	lua_pushstring(L, "GetExtent");
	lua_gettable(L, -2);
	lua_pushvalue(L, -2);
	lua_remove(L, -3);
	if(luaCompat_call(L, 0, 2, NULL)) return E_FAIL;
	pixelExtent.cx = lua_tonumber(L, -2);
	pixelExtent.cy = lua_tonumber(L, -1);
	lua_pop(L, 2);
	*pSizel = PixelToHimetric(pixelExtent);
	return S_OK;
}

STDMETHODIMP tLuaControl::Advise(IAdviseSink* pAdvSink, DWORD* pdwConnection) {
	return pAdviseHolder->Advise(pAdvSink, pdwConnection);
}

STDMETHODIMP tLuaControl::Unadvise(DWORD dwConnection) {
	return pAdviseHolder->Unadvise(dwConnection);
}

STDMETHODIMP tLuaControl::EnumAdvise(IEnumSTATDATA** ppEnumAdvise) {
	return pAdviseHolder->EnumAdvise(ppEnumAdvise);
}

STDMETHODIMP tLuaControl::GetMiscStatus(DWORD dwAspect, DWORD* pdwStatus) {
	if(!pdwStatus) return E_POINTER;
	if(dwAspect != DVASPECT_CONTENT) return *pdwStatus = 0, E_FAIL;
	*pdwStatus = OLEMISC_RECOMPOSEONRESIZE | OLEMISC_INSIDEOUT | OLEMISC_ACTIVATEWHENVISIBLE
		| OLEMISC_ALWAYSRUN;
	return S_OK;
}

STDMETHODIMP tLuaControl::SetColorScheme(LOGPALETTE* pLogpal) {
	return E_NOTIMPL;
}

STDMETHODIMP tLuaControl::GetWindow(HWND* phwnd) {
	if(!phwnd) return E_POINTER;
    lua_getref(L, table_ref);
	lua_pushstring(L, "GetWindow");
	lua_gettable(L, -2);
	lua_pushvalue(L, -2);
	lua_remove(L, -3);
	if(luaCompat_call(L, 0, 1, NULL)) return E_FAIL;
	*phwnd = *((HWND*)luaCompat_getPointer(L, -1));
	lua_pop(L, 1);
	return S_OK;
}

STDMETHODIMP tLuaControl::ContextSensitiveHelp(BOOL fEnterMode) {
	return S_OK;
}

STDMETHODIMP tLuaControl::InPlaceDeactivate() {
    lua_getref(L, table_ref);
	lua_pushstring(L, "Deactivate");
	lua_gettable(L, -2);
	if(lua_isnil(L, -1)) {
		lua_pop(L, 1);
		return E_UNEXPECTED;
	}
	lua_pushvalue(L, -2);
	lua_remove(L, -3);
	if(luaCompat_call(L, 0, 0, NULL)) return E_FAIL;
	return S_OK;
}

STDMETHODIMP tLuaControl::UIDeactivate() {
    lua_getref(L, table_ref);
	lua_pushstring(L, "UIDeactivate");
	lua_gettable(L, -2);
	if(lua_isnil(L, -1)) {
		lua_pop(L, 1);
		return E_UNEXPECTED;
	}
	lua_pushvalue(L, -2);
	lua_remove(L, -3);
	if(luaCompat_call(L, 0, 0, NULL)) return E_FAIL;
	return S_OK;
}

STDMETHODIMP tLuaControl::SetObjectRects(LPCRECT lprcPosRect, LPCRECT lprcClipRect){
	return S_OK;
}

STDMETHODIMP tLuaControl::ReactivateAndUndo() {
    lua_getref(L, table_ref);
	lua_pushstring(L, "Reactivate");
	lua_gettable(L, -2);
	if(lua_isnil(L, -1)) {
		lua_pop(L, 1);
		return E_UNEXPECTED;
	}
	lua_pushvalue(L, -2);
	lua_remove(L, -3);
	if(luaCompat_call(L, 0, 0, NULL)) return E_FAIL;
	return S_OK;
}

STDMETHODIMP tLuaControl::TranslateAccelerator(LPMSG lpmsg) {
	return 0;
}

STDMETHODIMP tLuaControl::OnFrameWindowActivate(BOOL fActivate) {
	return S_OK;
}

STDMETHODIMP tLuaControl::OnDocWindowActivate(BOOL fActivate) {
	return S_OK;
}

STDMETHODIMP tLuaControl::ResizeBorder(LPCRECT prcBorder,
										IOleInPlaceUIWindow *pUIWindow,
										BOOL fFrameWindow) {
	return S_OK;
}

STDMETHODIMP tLuaControl::EnableModeless(BOOL fEnable) {
	return S_OK;
}

tLuaControl *tLuaControl::CreateLuaControl(lua_State* L,
                                               ITypeInfo* interface_typeinfo,
                                               int ref
                                               )
{
  tLuaControl *pcont = 
    new tLuaControl(L, interface_typeinfo, ref);

  lua_getref(L, ref);
  luaCompat_pushPointer(L, idxDispatch);
  luaCompat_pushPointer(L, pcont);
  lua_rawset(L,-3);
  lua_pop(L, 1);

  pcont->AddRef();

  return pcont;
}
