/*
 * tLuaControl.h
 */

#ifndef __TLUACONTROL_H
#define __TLUACONTROL_H

#include <ole2.h>
#include <oleidl.h>
#include <ocidl.h>

#include "tLuaDispatch.h"

class tLuaControl: public tLuaDispatch, public IOleObject, public IOleInPlaceObject,
	public IOleInPlaceActiveObject
{
public:
    tLuaControl(lua_State* L, ITypeInfo *pTypeinfo, int ref);
    ~tLuaControl();
    STDMETHOD(QueryInterface)(REFIID riid, void FAR* FAR* ppvObj);
    STDMETHODIMP_(unsigned long) AddRef(void);
    STDMETHODIMP_(unsigned long) Release(void);
	// IOleObject implementation (yikes)
	STDMETHOD(SetClientSite)(IOleClientSite* pcs);
	STDMETHOD(GetClientSite)(IOleClientSite** ppcs);
	STDMETHOD(SetHostNames)(LPCOLESTR szContainerApp, LPCOLESTR szContainerObj);
	STDMETHOD(Close)(DWORD dwSaveOption);
	STDMETHOD(SetMoniker)(DWORD dwWitchMoniker, IMoniker* pmk);
	STDMETHOD(GetMoniker)(DWORD dwAssign, DWORD dwWitchMoniker, IMoniker** ppMoniker);
	STDMETHOD(InitFromData)(IDataObject* pDataObject, BOOL fCreation, DWORD dwReserved);
	STDMETHOD(IsUpToDate)();
	STDMETHOD(GetClipboardData)(DWORD dwReserved, IDataObject** ppDataObject);
	STDMETHOD(DoVerb)(long iVerb, MSG* lpmsg, IOleClientSite* pActiveSite,
		long lIndex, HWND hwndParent, LPCRECT lprcPosRect);
	STDMETHOD(EnumVerbs)(IEnumOLEVERB** ppEnumOleVerb);
	STDMETHOD(Update)();
	STDMETHOD(GetUserClassID)(CLSID* pClsid);
	STDMETHOD(GetUserType)(DWORD dwFormOfType, LPOLESTR* pszUserType);
	STDMETHOD(SetExtent)(DWORD dwAspect, SIZEL* pSizel);
	STDMETHOD(GetExtent)(DWORD dwAspect, SIZEL* pSizel);
	STDMETHOD(Advise)(IAdviseSink* pAdvSink, DWORD* pdwConnection);
	STDMETHOD(Unadvise)(DWORD dwConnection);
	STDMETHOD(EnumAdvise)(IEnumSTATDATA** ppEnumAdvise);
	STDMETHOD(GetMiscStatus)(DWORD dwAspect, DWORD* pdwStatus);
	STDMETHOD(SetColorScheme)(LOGPALETTE* pLogpal);
	// IOleInPlaceObject implementation
	STDMETHOD(GetWindow)(HWND* phwnd);
	STDMETHOD(ContextSensitiveHelp)(BOOL fEnterMode);
	STDMETHOD(InPlaceDeactivate)();
	STDMETHOD(UIDeactivate)();
	STDMETHOD(SetObjectRects)(LPCRECT lprcPosRect, LPCRECT lprcClipRect);
	STDMETHOD(ReactivateAndUndo)();
	// IOleInPlaceActiveObject
    STDMETHOD(TranslateAccelerator)(LPMSG lpmsg);
    STDMETHOD(OnFrameWindowActivate)(BOOL fActivate);
    STDMETHOD(OnDocWindowActivate)(BOOL fActivate);
    STDMETHOD(ResizeBorder)(LPCRECT prcBorder,
            IOleInPlaceUIWindow *pUIWindow,
            BOOL fFrameWindow);
    STDMETHOD(EnableModeless)(BOOL fEnable);

	static tLuaControl *CreateLuaControl(
      lua_State* L,
      ITypeInfo* typeinfo,
      int ref
    );
private:
	IOleClientSite *pClientSite;
	IOleAdviseHolder *pAdviseHolder;
};

#endif // __TLUACONTROL_H