// LuaAux.cpp: implementation of the LuaAux class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <assert.h>

#include <iostream.h>

#include "LuaAux.h"


// RCS Info
static char *rcsid = "$Id: LuaAux.cpp,v 1.5 2002/07/05 18:18:23 almendra Exp $";
static char *rcsname = "$Name:  $";

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

LuaAux::LuaAux()
{

}

LuaAux::~LuaAux()
{

}

/*
 * Prints the lua stack
 */

void LuaAux::printLuaStack(lua_State *L)
{
  int size = lua_gettop(L);
  int i = 0;

  for(i = size; i > 0; i--)
  {
    cout << i << ": " << lua_typename(L, lua_type(L,i)) << " -- ";

    switch(lua_type(L,i))
    {
    case LUA_TNUMBER:
      cout << lua_tonumber(L, i);
      break;

    case LUA_TSTRING:
      cout << lua_tostring(L, i);

    case LUA_TTABLE:
      cout << "table, tag = " << lua_tag(L, i);
      break;

    case LUA_TUSERDATA:
      cout << "value = " << lua_touserdata(L, i) << ", tag = " << lua_tag(L, i);
      break;

    case LUA_TNIL:
      cout << "nil";
      break;
    }      

    cout << endl;
  }
}

void LuaAux::printLuaTable(lua_State *L, stkIndex t)
{

  lua_pushnil(L);  /* first key */
  while (lua_next(L, t) != 0) {
   /* `key' is at index -2 and `value' at index -1 */
   printf("%s - %s\n",
     lua_tostring(L, -2), lua_typename(L, lua_type(L, -1)));
   lua_pop(L, 1);  /* removes `value'; keeps `index' for next iteration */
  }
}
