/*
 * ttLuaCOM.h
 */


#ifndef __LUACOM_H
#define __LUACOM_H

#include <ole2.h>
#include <ocidl.h> 

extern "C"
{
#include <lua.h>
#include <lauxlib.h>
}

#include "luabeans.h"
#include "tLuaCOMTypeHandler.h"

#include "tLuaObjList.h"

enum tWhichInterface {DISP, SOURCE};

class tLuaCOM
{
public:
	ITypeInfo* GetCoClassTypeInfo(void);
	void GetIID(IID *piid);
	IDispatch * GetIDispatch(void);
	void ReleaseFuncDesc(FUNCDESC *pfuncdesc);
	ITypeInfo * GetDefaultEventsInterface(void);
  static tLuaCOM * CreateLuaCOM(IDispatch * pdisp,
                                ITypeInfo* coclassinfo,
                                LuaBeans *lbeans);

	void getHelpInfo(char **ppHelpFile, unsigned long *pHelpContext);
	bool isMember(const char *name);

   ~tLuaCOM();

   bool addConnection(tLuaCOM *client);
   void releaseConnection(void);

   int call(FUNCDESC *pfuncdesc, tLuaObjList& params);
   int putprop(FUNCDESC* pfuncdesc, stkIndex val);
   int getprop(FUNCDESC* pfuncdesc);
   HRESULT get_funcdescr(DISPID dispid,INVOKEKIND invkind,
                         FUNCDESC** ppfuncdesc);
   HRESULT get_dispid(const char* name, DISPID* dispid);

  static char* TAG;
protected:
	ITypeInfo* coclassinfo;

  tLuaCOM(
    IDispatch *pdisp_arg,
    ITypeInfo *ptinfo_arg,
    ITypeInfo *coclassinfo,
    LuaBeans *lbeans);

	tLuaCOMTypeHandler * typehandler;


  LPDISPATCH pdisp;
  ITypeInfo* ptinfo;
  IConnectionPoint *connection_point;
  DWORD connection_point_cookie;
};

#endif // __LUACOM_H
