// tLuaCOMException.h: interface for the tLuaCOMException class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLUACOMEXCEPTION_H__26509908_AFD8_11D4_B882_0000B45D7541__INCLUDED_)
#define AFX_TLUACOMEXCEPTION_H__26509908_AFD8_11D4_B882_0000B45D7541__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class tLuaCOMException  
{
public:
	const char * getMessage(void);
  void showMessage(void);
  enum Errors {INTERNAL_ERROR, PARAMETER_OUT_OF_RANGE,
    TYPECONV_ERROR, COM_ERROR, COM_EXCEPTION, UNSUPPORTED_FEATURE,
    WINDOWS_ERROR
  };

	tLuaCOMException(Errors p_code, char *p_file, int p_line, const char *usermessage = NULL);
	virtual ~tLuaCOMException();

  Errors code;
  char *file;
  int line;
  const char *usermessage;

protected:
  static char *messages[];
};

#define LUACOM_EXCEPTION(x) throw tLuaCOMException(tLuaCOMException::##x, \
  __FILE__, __LINE__)

#define CHECK(x,y) ((x) ? (void) 0 : LUACOM_EXCEPTION(y))

#define TYPECONV_ERROR(x) throw tLuaCOMException(tLuaCOMException::TYPECONV_ERROR, \
  __FILE__, __LINE__, x)

#define COM_ERROR(x) throw tLuaCOMException(tLuaCOMException::COM_ERROR, \
__FILE__, __LINE__, ((x) == NULL ? "Unknown error" : (x)))

#define COM_EXCEPTION(x) throw tLuaCOMException(tLuaCOMException::COM_EXCEPTION, \
  __FILE__, __LINE__, x)

#define CHECKPARAM(x) ((x) ? (void) 0 : LUACOM_EXCEPTION(PARAMETER_OUT_OF_RANGE))

#define CHECKPRECOND(x) ((x) ? (void) 0 : LUACOM_EXCEPTION(INTERNAL_ERROR))

#define CHECKPOSCOND(x) CHECKPRECOND(x)

#define CHECKFEATURE(x, y) ((x) ? (void) 0 : tLuaCOMException( \
        tLuaCOMException::UNSUPPORTED_FEATURE, __FILE__, __LINE__, y))

#define INTERNAL_ERROR() LUACOM_EXCEPTION(INTERNAL_ERROR)

#define WINCHECK(x) ((x) ? (void) 0 : LUACOM_EXCEPTION(WINDOWS_ERROR))


#endif // !defined(AFX_TLUACOMEXCEPTION_H__26509908_AFD8_11D4_B882_0000B45D7541__INCLUDED_)
