
// tLuaCOMTypeHandler.h: interface for the tLuaCOMTypeHandler class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLUACOMTYPEHANDLER_H__2CAF122C_E09B_11D3_BD2F_444553540000__INCLUDED_)
#define AFX_TLUACOMTYPEHANDLER_H__2CAF122C_E09B_11D3_BD2F_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <ole2.h>

#include "luabeans.h"
#include "tLuaObjList.h"
#include "LuaAux.h"

class tLuaCOM;

class tLuaCOMTypeHandler  
{
public:
  void setOutValues(FUNCDESC* pFuncDesc, DISPPARAMS* pDispParams, stkIndex outvalue);
  void pushLuaArgs(
    const DISPPARAMS* pDispParams,
    const ELEMDESC* pElemDesc
    );

  void fillDispParams(
    DISPPARAMS& rDispParams,
    FUNCDESC *pfuncdesc,
    tLuaObjList& params
    );

  void releaseVariants(DISPPARAMS *pDispParams);

  int pushOutValues(
    tLuaObjList& params,
    const FUNCDESC *funcdesc, 
    const DISPPARAMS& dispparams);

  bool setRetval(const FUNCDESC *funcdesc, stkIndex luaval, VARIANTARG *pvarg);

  bool lua2com(
    TYPEDESC tdesc,
    stkIndex luaval,
    VARIANTARG *pvarg,
    bool variant_initialized);

  int com2lua(VARIANTARG varg);
  tLuaCOMTypeHandler(ITypeInfo *ptypeinfo, LuaBeans *lbeans);
  virtual ~tLuaCOMTypeHandler();

protected:
	void lua2com_conversionError(
    stkIndex luaval,
    const char* com_type,
    const char* reason=NULL,
    const HRESULT hr=S_OK);

	int IUnknown_tag;
	void pushIUnknown(IUnknown *punk);
	bool isIUnknown(stkIndex value);
	TYPEDESC processTYPEDESC(TYPEDESC tdesc);
	TYPEDESC processAliases(const TYPEDESC& tdesc);
	void releaseVariant(VARIANTARG *pvarg);
	TYPEDESC processUSERDEFINED(const TYPEDESC& tdesc);
	TYPEDESC processPTR(const TYPEDESC& tdesc);
  lua_State *L;
  tLuaCOM * from_lua(int index);
  stkIndex get_from_array(
    SAFEARRAY* safearray,
    long *indices,
    const VARTYPE& vt);

  void safearray_com2lua(VARIANTARG& varg);
  void safearray_lua2com(const TYPEDESC& tdesc, stkIndex luaval, VARIANTARG* pvarg);
  bool string2safearray(const char* str, long len, VARIANTARG * pvarg);

  void FromDispatchToVariantarg(
    VARIANTARG *pvarg,
    stkIndex luaval,
    VARTYPE vt,
    bool initialized);

  HRESULT FromNumberToVariant(VARIANTARG *pvarg, stkIndex luaval, VARTYPE vt);

  ITypeInfo * m_typeinfo;
  LuaBeans *lbeans;
};

#define LUACOM_IUNKNOWN_TAGNAME "LuaCOM_IUnknown_tag"

#endif // !defined(AFX_TLUACOMTYPEHANDLER_H__2CAF122C_E09B_11D3_BD2F_444553540000__INCLUDED_)
