// tUtil.cpp: implementation of the tUtil class.
//
//////////////////////////////////////////////////////////////////////

// RCS Info
static char *rcsid = "$Id: tUtil.cpp,v 1.2 2002/08/28 12:52:15 almendra Exp $";
static char *rcsname = "$Name:  $";


#include <assert.h>
#include "tUtil.h"

tStringBuffer tUtil::string_buffer = tStringBuffer();

#define MAX_VALID_STRING_SIZE 1000

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

bool tUtil::IsValidString(LPCTSTR string)
{
  bool return_value = string != NULL &&
    !IsBadStringPtr(string, MAX_VALID_STRING_SIZE);

  assert(return_value);

  return return_value;
}

const char *tUtil::GetErrorMessage(DWORD errorcode)
{
  LPVOID lpMsgBuf;
  DWORD result = 0;

  result = FormatMessage( 
    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    NULL,
    errorcode,
    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
    (LPTSTR) &lpMsgBuf,
    0,
    NULL);

  if(result == 0)
    return NULL;

  tUtil::string_buffer.copyToBuffer((char *) lpMsgBuf);

  // Free the buffer.
  LocalFree( lpMsgBuf );

  return tUtil::string_buffer.getBuffer();
}

const char * tUtil::bstr2string(BSTR bstr)
{
  char* str = NULL;
  size_t size = 0;

  if(bstr != NULL)
  {
    size = wcstombs(NULL, bstr, -1);

    str = new char[size + 1];

    wcstombs(str, bstr, wcslen(bstr) + 1);
  }
  else
  {
    str = new char[1];
    str[0] = '\0';
  }

  tUtil::string_buffer.copyToBuffer(str);

  delete str;

  return tUtil::string_buffer.getBuffer();
}

BSTR tUtil::string2bstr(const char * string)
{
  if(!string)
    return NULL;

  BSTR bstr;
  const int length = strlen(string);
  
  wchar_t *widestr = new wchar_t[length + 1];

  mbstowcs(widestr, string, length + 1);

  bstr = SysAllocString(widestr);

  delete widestr;
  widestr = NULL;

  return bstr;
}
