// LuaAux.cpp: implementation of the LuaAux class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <assert.h>

#include "LuaAux.h"

// RCS Info
static char *rcsid = "$Id: LuaAux.cpp,v 1.3 2000-10-09 09:41:03-03 almendra Exp almendra $";
static char *rcsname = "$Name:  $";

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

LuaAux::LuaAux()
{

}

LuaAux::~LuaAux()
{

}

bool LuaAux::getStringParam(int param, char **pString)
{
  lua_Object obj;

  assert(pString);
  assert(param > 0);

  obj = lua_getparam(param);

  if(!lua_isstring(obj))
  {
    *pString = NULL;
    return false;
  }
  else
  {
    *pString = lua_getstring(obj);
    return true;
  }
}

void LuaAux::setTable(lua_Object table, int index, lua_Object value)
{
  assert(table != LUA_NOOBJECT);
  if(table == LUA_NOOBJECT)
    return;

  assert(index >= 1);
  if(index < 1)
    return;

  lua_pushobject(table);

  lua_pushnumber(index);

  lua_pushobject(value);

  lua_settable();
}

lua_Object LuaAux::getTable(lua_Object table, int index)
{
  lua_Object value = LUA_NOOBJECT;

  ////////// Inicio assertivas de entrada
  assert(table != LUA_NOOBJECT);
  if(table == LUA_NOOBJECT)
    return LUA_NOOBJECT;

  assert(index >= 1);
  if(index < 1)
    return LUA_NOOBJECT;
  ////////// Fim assertivas de entrada


  lua_pushobject(table);

  lua_pushnumber(index);

  value = lua_gettable();

  return value;
}

int LuaAux::getNumEntries(lua_Object table)
{
  int ref = 0;
  int num_entries = 0;

  lua_beginblock();

  ref = lua_next(table, 0);

  while(ref != 0)
  {
    lua_beginblock();
    num_entries++;
    ref = lua_next(table, ref);
    lua_endblock();
  }

  lua_endblock();

  return num_entries;
}
