#include <stdlib.h>
#include <stdio.h>
#include <string.h>
extern "C"
{
#include <lua.h>
#include <lauxlib.h>
}
#include "luabeans.h"

int LuaBeans::initialized = 0;
char* LuaBeans::init_code = "LuaBeansTable = {}";

static void register_methods(lua_Object table, struct luaL_reg* list, int n)
{
   for (int i = 0; i < n; i++)
   {
      lua_pushobject(table);
      lua_pushstring(list[i].name);
      lua_pushcfunction(list[i].func);
      lua_settable();
   }
}

static void register_tagmethods(int tag, struct luaL_reg* table, int n)
{
   int i = 0;
   for (i=0; i < n; i++)
   {
      lua_pushcfunction(table[i].func);
      lua_settagmethod(tag,table[i].name);
   }
}

LuaBeans* LuaBeans::createBeans(const char* name)
{
   if ( !LuaBeans::initialized )
   {
      lua_dostring(LuaBeans::init_code);
      LuaBeans::initialized = 1;
   }

   LuaBeans* lbeans = new LuaBeans(name);
   
   lua_pushobject(lua_getglobal("LuaBeansTable"));
   lua_pushstring((char*)name);
   lua_pushuserdata(lbeans);
   lua_settable();

   return lbeans;
}

LuaBeans* LuaBeans::getBeans(const char* name)
{
   lua_pushobject(lua_getglobal("LuaBeansTable"));
   lua_pushstring((char*)name);
   lua_Object lobj = lua_gettable();
   LuaBeans* lbeans = (LuaBeans*) lua_getuserdata(lobj);

   return lbeans;
}

LuaBeans::LuaBeans( const char* name )
{
   char lua_name[50];

   this->mlist = NULL;

   sprintf(lua_name,"LB_%s_TAG",name);
   this->tag_name = strdup(lua_name);

   sprintf(lua_name,"LB_%s_UDTAG",name);

   this->tag = lua_newtag();
   lua_pushnumber((double)tag);
   lua_setglobal(tag_name);

   this->ud_tag = lua_newtag();
   lua_pushnumber((double)ud_tag);
   lua_setglobal(lua_name);
}

LuaBeans::~LuaBeans()
{
   free(this->tag_name);
   if (this->mlist)
      delete this->mlist;
}

void LuaBeans::reg_tagmethods(struct luaL_reg* table, int n)
{
   register_tagmethods(this->tag,table,n);
}

void LuaBeans::reg_ud_tagmethods(struct luaL_reg* table, int n)
{
   register_tagmethods(this->ud_tag,table,n);
}

void LuaBeans::reg_methods(struct luaL_reg* table, int n)
{
   if (this->mlist == NULL)
   {
      this->mlist = new LuaBeans::MethodsList;
   }
   this->mlist->n = n;
   this->mlist->table = table;
}

void LuaBeans::push( void* userdata )
{
   lua_Object table = lua_createtable();

   lua_pushobject(table);
   lua_pushstring("_USERDATA_REF_");
   lua_pushusertag(userdata,this->ud_tag);
   lua_settable();

   if (this->mlist)
      register_methods(table, this->mlist->table, this->mlist->n);

   lua_pushobject(table);
   lua_settag(this->tag);

   lua_pushobject(table);
}

void* LuaBeans::check_tag(int index)
{
   void* userdata = this->from_lua(lua_getparam(index));

   luaL_arg_check((userdata!=NULL),index,"Object type is wrong");

   return userdata;
}

void* LuaBeans::from_lua(lua_Object luaobj)
{
   if (lua_istable(luaobj) && lua_tag(luaobj) == this->tag)
   {
      lua_pushobject(luaobj);
      lua_pushstring("_USERDATA_REF_");
      return lua_getuserdata(lua_gettable());
   }
   else
      return NULL;
}

