// tListArray.h: interface for the tListArray class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLISTARRAY_H__D9585069_945D_11D4_B881_0000B45D7541__INCLUDED_)
#define AFX_TLISTARRAY_H__D9585069_945D_11D4_B881_0000B45D7541__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <assert.h>

template <class T> class tNode
{
public:

  tNode(T& node_elem) : elem(node_elem)
  {
  }

  ~tNode()
  {
  }

  T elem;
};

template <class T> class tListArray  
{
public:
  tListArray()
  {
    num_elements = 0;
    max_elements = 1;

    node_array = new tNode<T>*[max_elements];
    
    {
      unsigned long i = 0;

      for(i = 0; i < max_elements; i++)
        node_array[i] = NULL;
    }

  }

	virtual ~tListArray()
  {
    delete [] node_array;
  }

  void add(T& elem)
  {
    if(num_elements >= max_elements)
    {
      const unsigned long new_max_elements = 2*max_elements;

      tNode<T> **new_node_array = new tNode<T>*[new_max_elements];

      {
        unsigned long i = 0;

        for(i = 0; i < max_elements; i++)
        {
          new_node_array[i] = node_array[i];
        }

        for(;i < new_max_elements; i++)
        {
          new_node_array[i] = NULL;
        }
      }
      
      delete node_array;
      node_array = new_node_array;

      max_elements = new_max_elements;
    }

    node_array[num_elements] = new tNode<T>(elem);
    num_elements++;
  }

  bool get(unsigned long i, T** elem)
  {
    if(i >= num_elements)
    {
      *elem = NULL;
      return false;
    }
    else
    {
      *elem = &node_array[i]->elem;
      return true;
    }
  }

protected:
  tNode<T> **node_array;

  unsigned long max_elements, num_elements;
};

#endif // !defined(AFX_TLISTARRAY_H__D9585069_945D_11D4_B881_0000B45D7541__INCLUDED_)
