/*
 * tLuaCOM.cpp
 *
 *  Implementacao da classe tLuaCOM
 *
 * Renato Cerqueira
 * Vinicius Almendra
 */

// RCS Info
static char *rcsid = "$Id: tLuaCOM.cpp,v 1.12 2001-04-30 09:56:07-03 almendra Exp almendra $";
static char *rcsname = "$Name:  $";

#include <iostream.h>

#include "tLuaCOM.h"
#include "tLuaDispatch.h"
#include "LuaAux.h"
#include "tUtil.h"
#include "tLuaCOMException.h"

char* tLuaCOM::TAG = "LuaCom";
LuaBeans* tLuaCOM::lbeans = NULL;

tLuaCOM::tLuaCOM(IDispatch *pdisp_arg, ITypeInfo *ptinfo_arg)
{
  connection_point = NULL;
  connection_point_cookie = NULL;

  pdisp = pdisp_arg;
  pdisp->AddRef();

  ptinfo = ptinfo_arg;
  ptinfo->AddRef();

  typehandler = new tLuaCOMTypeHandler(ptinfo_arg);
}

tLuaCOM::~tLuaCOM()
{
  if(connection_point != NULL)
    releaseConnection();

  pdisp->Release();
  pdisp = NULL;

  ptinfo->Release();
  ptinfo = NULL;

  delete typehandler;
  typehandler = NULL;
}

HRESULT tLuaCOM::get_funcdescr(DISPID dispid, INVOKEKIND invkind,
                              FUNCDESC** ppfuncdesc)
{
   TYPEATTR * ptypeattr = NULL;
   HRESULT hr;
   unsigned int i, n;

   hr = ptinfo->GetTypeAttr(&ptypeattr);
   if (FAILED(hr))
   {
      return  hr;
   }

   n = ptypeattr->cFuncs;
   ptinfo->ReleaseTypeAttr(ptypeattr);

   for (i = 0; i < n;i++)
   {
      hr = ptinfo->GetFuncDesc(i, ppfuncdesc);
      if (FAILED(hr))
      {
         return  hr;
      }
      if (*ppfuncdesc == NULL)
      {
         return E_INVALIDARG;
      }

      //fazer o que tem que ser feito
      if ((*ppfuncdesc)->memid == dispid && (*ppfuncdesc)->invkind == invkind)
      {
         return S_OK;
      }

      ptinfo->ReleaseFuncDesc(*ppfuncdesc);
   }

   *ppfuncdesc = NULL;
   return E_INVALIDARG;
}

HRESULT tLuaCOM::get_dispid(char* name, DISPID* dispid)
{
   HRESULT hr;
   wchar_t* w_name = (wchar_t*) malloc( (strlen(name) + 1) * sizeof(wchar_t));
   mbstowcs(w_name,name,strlen(name)+1);

   hr = pdisp->GetIDsOfNames(IID_NULL, &w_name, 1,
                          LOCALE_SYSTEM_DEFAULT,dispid);
   free(w_name);
   return  hr;
}

int tLuaCOM::getprop(FUNCDESC* pfuncdesc)
{
   return call(pfuncdesc, tLuaObjList());
}

int tLuaCOM::call(FUNCDESC *pFuncDesc, tLuaObjList& params)
{
   HRESULT hr             = 0;
   unsigned int i         = 0;
   UINT ArgErr            = 0;

   DISPPARAMS dispparams;
   VARIANTARG result;
   EXCEPINFO excepinfo;
      
   VariantInit(&result);
   
   // nao suportado
   if (pFuncDesc->cParamsOpt == -1)
      return 0;

   // preenche estrutura com parametros
   typehandler->fillDispParams(dispparams, pFuncDesc, params);

   hr = pdisp->Invoke(
     pFuncDesc->memid,
     IID_NULL, 
     LOCALE_SYSTEM_DEFAULT,
     pFuncDesc->invkind,
     &dispparams,
     &result,
     &excepinfo,
     &ArgErr);

   if(SUCCEEDED(hr))
   {
     /* empilha valor de retorno */
     typehandler->com2lua(result);

     if(pFuncDesc->invkind == INVOKE_FUNC)
       typehandler->pushOutValues(params, pFuncDesc, dispparams);

     // Limpa parametros
     typehandler->releaseVariants(&dispparams);

     return 1;

   }
   else // Houve erro
   {
     // Limpa parametros
     typehandler->releaseVariants(&dispparams);

     if(hr == DISP_E_EXCEPTION) // excecoes
     {
       lua_error((char *) 
         tUtil::bstr2string(excepinfo.bstrDescription));
     }
     else // Erros comuns
     {
       const char *errormessage = tUtil::GetErrorMessage(hr);

       if(errormessage != NULL)
       {
         lua_error((char *) errormessage);
       }
       else
       {
         lua_error("Unknown error");         
       }
     }

     return  0;
   }
}

int tLuaCOM::putprop(FUNCDESC* pfuncdesc, lua_Object val)
{
   int result;

   tLuaObjList params;
   params.addParam(val);

   result = call(pfuncdesc, params);

   return result;
}

bool tLuaCOM::addConnection(tLuaCOM *client)
{
  HRESULT hr;
  IDispatch *pdisp_client = client->GetIDispatch();

  IConnectionPointContainer *pcpc = NULL;

  assert(connection_point == NULL);
  if(connection_point != NULL)
    return false;

  hr = pdisp->QueryInterface
    (
      IID_IConnectionPointContainer, (void **) &pcpc
    );

  if(FAILED(hr))
  {
    cout << "ERROR: Doesn't implement IConnectionPointContainer" << endl;
    return false;
  }

  {
    IID guid;

    client->GetIID(&guid);

    hr = pcpc->FindConnectionPoint(guid, &connection_point);
  }

  if(FAILED(hr))
  {
    cout << "ERROR: Requested connection point not supported" << endl;

    pcpc->Release();

    pcpc = NULL;

    return false;
  }

  hr = connection_point->Advise
    (
      (IUnknown *) pdisp_client, &connection_point_cookie
    );

  if(FAILED(hr))
  {
    cout << "ERROR: Unable to advise connection point" << endl;

    connection_point->Release();
    connection_point = NULL;

    pcpc->Release();
    pcpc = NULL;

    return false;
  }

  return true;
}

void tLuaCOM::releaseConnection(void)
{
  assert(connection_point);
  if(connection_point == NULL)
    return;

  connection_point->Unadvise(connection_point_cookie);
  connection_point->Release();
  connection_point = NULL;
}

#if 0
void tLuaCOM::getParamsInfo(const FUNCDESC * pfuncdesc,
                            int *pTotal_params,
                            int *pIn_params,
                            int *pRequired_in_params)
{
  int total_params = 0;
  int in_params = 0;

  assert(pfuncdesc != NULL);

  if(!pfuncdesc)
    return;

  total_params = pfuncdesc->cParams;

  in_params = total_params;

  for (int i = 0; i < pfuncdesc->cParams; i++)
  {
    if ( !(pfuncdesc->lprgelemdescParam[i].idldesc.wIDLFlags & IDLFLAG_FIN) &&
      !(pfuncdesc->lprgelemdescParam[i].idldesc.wIDLFlags == IDLFLAG_NONE))
       in_params--;
  }

  if(pTotal_params != NULL)
    *pTotal_params = total_params;

  if(pIn_params != NULL)
    *pIn_params = in_params;

  if(pRequired_in_params != NULL)
    *pRequired_in_params = in_params - pfuncdesc->cParamsOpt;
}

/*
 * getFuncDescInfo
 *  Identifica o FUNCDESC correto
 */

void tLuaCOM::getFuncDescInfo(DISPID dispid, 
                              int num_real_params, 
                              FUNCDESC * * ppfuncdesc
                              )
{
  HRESULT hr = 0;

  hr = get_funcdescr(dispid,INVOKE_FUNC, ppfuncdesc);

  if(!FAILED(hr)) // E' um metodo
    return;

  hr = get_funcdescr(dispid,INVOKE_PROPERTYGET, ppfuncdesc);

  if(!FAILED(hr)) // Pode ser um propertyget
  {
    int inParams = 0;

    getParamsInfo(*ppfuncdesc, NULL, &inParams, NULL);

    if(inParams == num_real_params) // o numero de parametros bate com o get
      return;
    else
      ptinfo->ReleaseFuncDesc(*ppfuncdesc);
  }

  hr = get_funcdescr(dispid,INVOKE_PROPERTYPUT, ppfuncdesc);

  if(!FAILED(hr)) // Pode ser um propertyput
  {
    int total_params = 0;

    getParamsInfo(*ppfuncdesc, &total_params, NULL, NULL);

    if(total_params == num_real_params) // o numero de parametros bate com o put
      return;
    else
      ptinfo->ReleaseFuncDesc(*ppfuncdesc);
  }

  hr = get_funcdescr(dispid,INVOKE_PROPERTYPUTREF, ppfuncdesc);

  if(!FAILED(hr)) // Pode ser um propertyputref
  {
    int total_params = 0;

    getParamsInfo(*ppfuncdesc, &total_params, NULL, NULL);

    if(total_params == num_real_params) // o numero de parametros bate com o putref
      return;
    else
      ptinfo->ReleaseFuncDesc(*ppfuncdesc);
  }

  *ppfuncdesc = NULL; // nao e' nem metodo, nem property get, nem property put

  return;
}
#endif

#if 0
int tLuaCOM::check_and_call(DISPID dispid, lua_Object params_table)
{
  FUNCDESC *pfuncdesc = NULL;
  int retval = 0;
  int num_args = LuaAux::getNumEntries(params_table);

  getFuncDescInfo(
    dispid,
    num_args,    
    &pfuncdesc);

  if(pfuncdesc == NULL)
    lua_error("Member not found");

  retval = call(pfuncdesc, params_table);

  ptinfo->ReleaseFuncDesc(pfuncdesc);

  return retval;
}
#endif

//
//  isMember
//
//    Informa se existe algum metodo ou propriedade com
//    o nome passado como parametro
//

bool tLuaCOM::isMember(char * name)
{
  HRESULT hr;
  DISPID dumb_dispid;
  
  wchar_t* w_name = (wchar_t*) malloc( (strlen(name) + 1) * sizeof(wchar_t));

  assert(w_name);
  if(!w_name)
    return false;

  mbstowcs(w_name, name, strlen(name)+1);

  hr = pdisp->GetIDsOfNames(IID_NULL, &w_name, 1,
                        LOCALE_SYSTEM_DEFAULT, &dumb_dispid);
  free(w_name);
  w_name = NULL;

  if(!FAILED(hr))
    return true;
  else
    return false;
}

bool tLuaCOM::GetDefaultEventsInterface(IUnknown *punk, 
                                        IID * piid, 
                                        ITypeInfo * * pptypeinfo)
{
  HRESULT hr    = S_OK;
  TYPEATTR *pTA = NULL;

  *piid=CLSID_NULL;

  if (!GetTypeInfoFromIUnknown(punk, pptypeinfo, SOURCE))
    return false;

  hr = (*pptypeinfo)->GetTypeAttr(&pTA);

  if (SUCCEEDED(hr))
  {
    *piid=pTA->guid;
    (*pptypeinfo)->ReleaseTypeAttr(pTA);
  }

  return true;
}

bool tLuaCOM::GetTypeInfoFromIUnknown(IUnknown *punk,
                                      ITypeInfo * * pptypeinfo, 
                                      tWhichInterface iface)
{
  HRESULT             hr = S_OK;
  LPTYPEINFO          pITypeInfoAll = NULL;
  LPTYPEATTR          pTA = NULL;

  assert(pptypeinfo);
  if (NULL == pptypeinfo)
    return false;

  if (!GetCoClassTypeInfo(punk, &pITypeInfoAll))
  {
    // tenta obter typeinfo correta a partir de IDispatch
    IDispatch *pdisp = NULL;

    hr = punk->QueryInterface(IID_IDispatch, (void **) &pdisp);

    if(FAILED(hr)) return false;

    hr = pdisp->GetTypeInfo(0, LOCALE_SYSTEM_DEFAULT, pptypeinfo);

    if(FAILED(hr)) return false;

    TYPEATTR *ptypeattr = NULL;

    (*pptypeinfo)->GetTypeAttr(&ptypeattr);

    if(ptypeattr->typekind != TKIND_DISPATCH)
    {
      (*pptypeinfo)->ReleaseTypeAttr(ptypeattr);
      return false;
    }

    (*pptypeinfo)->ReleaseTypeAttr(ptypeattr);
    return true;
  }



  /*
   * We have the object's overall ITypeInfo in pITypeInfoAll.
   * Now get the type attributes which will tell us the number of
   * individual interfaces in this type library.  We then loop
   * through the "implementation types" for all those interfaces
   * calling GetImplTypeFlags, looking for the default.
   */

  *pptypeinfo = NULL;  //Use this to determine success

  if (SUCCEEDED(pITypeInfoAll->GetTypeAttr(&pTA)))
  {
    UINT i;
    int iFlags;

    for (i=0; i < pTA->cImplTypes; i++)
    {
      //Get the implementation type for this interface
      hr = pITypeInfoAll->GetImplTypeFlags(i, &iFlags);

      if (FAILED(hr))
        continue;

      if (iFlags & IMPLTYPEFLAG_FDEFAULT || pTA->cImplTypes == 1)
      {
        if(iface == DISP && !(iFlags & IMPLTYPEFLAG_FSOURCE)
        || iface == SOURCE && (iFlags & IMPLTYPEFLAG_FSOURCE))
        {
          HREFTYPE    hRefType=NULL;

          /*
           * This is the interface we want.  Get a handle to
           * the type description from which we can then get
           * the ITypeInfo.
           */
          pITypeInfoAll->GetRefTypeOfImplType(i, &hRefType);
          hr = pITypeInfoAll->GetRefTypeInfo(hRefType
              , pptypeinfo);

          TYPEATTR *ptypeattr_iface = NULL;

          hr = (*pptypeinfo)->GetTypeAttr(&ptypeattr_iface);

          if(ptypeattr_iface->typekind == TKIND_DISPATCH)
          {
            (*pptypeinfo)->ReleaseTypeAttr(ptypeattr_iface);
            break;
          }
          else
          {
            (*pptypeinfo)->ReleaseTypeAttr(ptypeattr_iface);
            *pptypeinfo = NULL;
          }
        }
      }
    }

    pITypeInfoAll->ReleaseTypeAttr(pTA);
  }

  pITypeInfoAll->Release();
  
  if(*pptypeinfo != NULL)
    return true;
  else
  {
       // tenta obter typeinfo correta a partir de IDispatch
    IDispatch *pdisp = NULL;

    hr = punk->QueryInterface(IID_IDispatch, (void **) &pdisp);

    if(FAILED(hr)) return false;

    hr = pdisp->GetTypeInfo(0, LOCALE_SYSTEM_DEFAULT, pptypeinfo);

    if(FAILED(hr))
      return false;

    return true;
  }

}

bool tLuaCOM::GetCoClassTypeInfo(IUnknown *punk, ITypeInfo * * ppTypeinfo)
{
  HRESULT hr = S_OK;
  IProvideClassInfo *pIProvideClassInfo = NULL;

  assert(ppTypeinfo);
  assert(punk);

  *ppTypeinfo=NULL;


  hr = punk->QueryInterface(IID_IProvideClassInfo,
    (void **) &pIProvideClassInfo);

  if (FAILED(hr))
    return false;

  hr = pIProvideClassInfo->GetClassInfo(ppTypeinfo);
  pIProvideClassInfo->Release();

  if(SUCCEEDED(hr))
    return true;
  else
    return false;
}

void tLuaCOM::getHelpInfo(char **ppHelpFile, unsigned long *pHelpContext)
{
  ITypeLib *typelib = NULL;
  BSTR helpfile;
  HRESULT hr = S_OK;
  
  hr = ptinfo->GetDocumentation(-1, NULL, NULL, pHelpContext, &helpfile);

  if(FAILED(hr) || helpfile == NULL)
  {
    *ppHelpFile = NULL;
    return;
  }

  // Se nao conseguiu help contextna propria interface, tenta obte-lo
  // na type library
  if(*pHelpContext == 0)
  {
    unsigned int dumb_index = 0;
    unsigned long typelib_help_context = 0;
    BSTR helpfile_typelib;

    hr = ptinfo->GetContainingTypeLib(&typelib, &dumb_index);

    if(!FAILED(hr))
    {
      hr = typelib->GetDocumentation(-1, NULL, NULL,
        &typelib_help_context, &helpfile_typelib);

      if(!FAILED(hr))
      {
        SysFreeString(helpfile);

        helpfile = helpfile_typelib;
        *pHelpContext = typelib_help_context;
      }
    }
  }

  int str_size = SysStringLen(helpfile);
  *ppHelpFile = (char *) malloc((str_size + 1)*sizeof(wchar_t));
  wcstombs(*ppHelpFile, helpfile, str_size+1);

  SysFreeString(helpfile);
}



//
// CreateLuaCOM
//
//   Cria um objeto luacom a partir de um IUnknown,
//   Verificando a possibilidade de faze-lo
//
//

tLuaCOM *tLuaCOM::CreateLuaCOM(IUnknown * punk)
{
  IDispatch *pdisp = NULL;
  ITypeInfo *ptypeinfo = NULL;
  IID default_iid;

  // obtem o IID e o TypeInfo da interface dispatch padrao
  bool result = GetDefaultDispinterface(punk, &default_iid, &ptypeinfo);

  if(result == false)
    return NULL;

  // obtem ponteiro para interface
  HRESULT hr = punk->QueryInterface(default_iid, (void **) &pdisp);
  
  if(FAILED(hr))
    return NULL;

  tLuaCOM *pluacom = new tLuaCOM(pdisp, ptypeinfo);

  return pluacom;
}

bool tLuaCOM::GetDefaultDispinterface(IUnknown *punk,
                                  IID * piid,
                                  ITypeInfo * * pptypeinfo)
{
  HRESULT hr    = S_OK;
  TYPEATTR *pTA = NULL;

  *piid=CLSID_NULL;

  bool result = GetTypeInfoFromIUnknown(punk, pptypeinfo, DISP);

  if(result == false)
    return false;

  hr = (*pptypeinfo)->GetTypeAttr(&pTA);

  if (FAILED(hr))
  {
    (*pptypeinfo)->Release();
    return false;
  }

  *piid = pTA->guid;
  (*pptypeinfo)->ReleaseTypeAttr(pTA);
  
  return true;
}


tLuaCOM * tLuaCOM::CreateLuaCOM(IDispatch * pdisp)
{
  ITypeInfo *ptinfo = NULL;
  unsigned int is_there_typeinfo = 0;
  HRESULT hr;

  CHECK(pdisp, PARAMETER_OUT_OF_RANGE);

  hr = pdisp->GetTypeInfoCount(&is_there_typeinfo);

  if(FAILED(hr) || is_there_typeinfo == 0)
    return NULL;

  hr = pdisp->GetTypeInfo(0,LOCALE_SYSTEM_DEFAULT,&ptinfo);

  if(FAILED(hr))
    return NULL;

  tLuaCOM *lcom = new tLuaCOM(pdisp, ptinfo);

  return lcom;
}

ITypeInfo * tLuaCOM::GetDefaultEventsInterface()
{
  IID dumb_iid;
  ITypeInfo *ptinfo;

  bool result = GetDefaultEventsInterface(pdisp, &dumb_iid, &ptinfo);

  if(result == false)
    return NULL;

  return ptinfo;
}

void tLuaCOM::ReleaseFuncDesc(FUNCDESC * pfuncdesc)
{
  ptinfo->ReleaseFuncDesc(pfuncdesc);
}

IDispatch * tLuaCOM::GetIDispatch()
{
  return pdisp;
}

void tLuaCOM::GetIID(IID * piid)
{
  TYPEATTR *ptypeattr;

  ptinfo->GetTypeAttr(&ptypeattr);
  *piid = ptypeattr->guid;
  ptinfo->ReleaseTypeAttr(ptypeattr);
}


