/*
 * ttLuaCOM.h
 */

#include <ole2.h>
#include <ocidl.h> 

extern "C"
{
#include <lua.h>
#include <lauxlib.h>
}

#include "luabeans.h"
#include "tLuaCOMTypeHandler.h"

#include "tLuaObjList.h"

enum tWhichInterface {DISP, SOURCE};

class tLuaCOM
{
public:
	void GetIID(IID *piid);
	IDispatch * GetIDispatch(void);
	void ReleaseFuncDesc(FUNCDESC *pfuncdesc);
	ITypeInfo * GetDefaultEventsInterface(void);
	static tLuaCOM * CreateLuaCOM(IDispatch *pdisp);
	static tLuaCOM *CreateLuaCOM(IUnknown *punk);
	void getHelpInfo(char **ppHelpFile, unsigned long *pHelpContext);
	bool isMember(char *name);

  static LuaBeans* lbeans;


   ~tLuaCOM();

   bool addConnection(tLuaCOM *client);
   void releaseConnection(void);

   int call(FUNCDESC *pfuncdesc, tLuaObjList& params);
   int putprop(FUNCDESC* pfuncdesc,lua_Object val);
   int getprop(FUNCDESC* pfuncdesc);
   HRESULT get_funcdescr(DISPID dispid,INVOKEKIND invkind,
                         FUNCDESC** ppfuncdesc);
   HRESULT get_dispid(char* name, DISPID* dispid);

  static bool GetDefaultEventsInterface(IUnknown *punk,
                                         IID *piid, 
                                         ITypeInfo **pptypeinfo);

  static bool GetDefaultDispinterface(IUnknown *punk,
                                      IID *piid,
                                      ITypeInfo **pptypeinfo);

  static char* TAG;
protected:
  tLuaCOM(IDispatch *pdisp_arg, ITypeInfo *ptinfo_arg);

	static bool GetTypeInfoFromIUnknown(IUnknown *punk,
                                      ITypeInfo **pptypeinfo,
                                      tWhichInterface iface);

	static bool GetCoClassTypeInfo(IUnknown *punk, ITypeInfo **ppTypeinfo);
  

	tLuaCOMTypeHandler * typehandler;


  LPDISPATCH pdisp;
  ITypeInfo* ptinfo;
  IConnectionPoint *connection_point;
  DWORD connection_point_cookie;
};
