// tLuaCOMException.cpp: implementation of the tLuaCOMException class.
//
//////////////////////////////////////////////////////////////////////

#include <iostream.h>

#include "tLuaCOMException.h"


char *tLuaCOMException::messages[] =  
     {
       "Internal Error",
     };


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

tLuaCOMException::tLuaCOMException(Errors p_code, char *p_file, int p_line)
{
  code = p_code;

  file = p_file;
  line = p_line;

#ifndef NDEBUG
  showMessage();
#endif
}

tLuaCOMException::~tLuaCOMException()
{

}



void tLuaCOMException::showMessage(void)
{
  if(file != NULL)
  {
    cerr << "LuaCOM Exception in file " << file << " at line " << line
      << ": " << messages[code] << endl;
  }
  else
  {
    cerr << "LuaCOM Exception: " << messages[code] << endl;
  }
}
