// tLuaCOMException.h: interface for the tLuaCOMException class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLUACOMEXCEPTION_H__26509908_AFD8_11D4_B882_0000B45D7541__INCLUDED_)
#define AFX_TLUACOMEXCEPTION_H__26509908_AFD8_11D4_B882_0000B45D7541__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class tLuaCOMException  
{
public:
  enum Errors {INTERNAL_ERROR, PARAMETER_OUT_OF_RANGE};

	tLuaCOMException(Errors p_code, char *p_file, int p_line);
	virtual ~tLuaCOMException();

  Errors code;
  char *file;
  int line;

protected:
  static char *messages[];

  void showMessage(void);
};

#define LUACOM_EXCEPTION(x) throw tLuaCOMException(tLuaCOMException::##x, \
  __FILE__, __LINE__)

#define CHECK(x,y) ((x) ? (void) 0 : LUACOM_EXCEPTION(y))


#endif // !defined(AFX_TLUACOMEXCEPTION_H__26509908_AFD8_11D4_B882_0000B45D7541__INCLUDED_)
