// tLuaCOMTypeHandler.h: interface for the tLuaCOMTypeHandler class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLUACOMTYPEHANDLER_H__2CAF122C_E09B_11D3_BD2F_444553540000__INCLUDED_)
#define AFX_TLUACOMTYPEHANDLER_H__2CAF122C_E09B_11D3_BD2F_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <ole2.h>

#include "tLuaObjList.h"

#define LUACOM_TRUE  1.
#define LUACOM_FALSE 0.

class tLuaCOMTypeHandler  
{
public:
	void setOutValues(FUNCDESC* pFuncDesc, DISPPARAMS* pDispParams);
	void pushLuaArgs(
    const DISPPARAMS* pDispParams,
    const ELEMDESC* pElemDesc
    );

  void fillDispParams(
    DISPPARAMS& rDispParams,
    FUNCDESC *pfuncdesc,
    tLuaObjList& params
    );

  void releaseVariants(DISPPARAMS *pDispParams);

	void pushOutValues(
    tLuaObjList& params,
    const FUNCDESC *funcdesc, 
    const DISPPARAMS& dispparams);

	bool setRetval(const FUNCDESC *funcdesc, lua_Object luaval, VARIANTARG *pvarg);

	bool lua2com(
    const TYPEDESC& tdesc,
    lua_Object luaval,
    VARIANTARG *pvarg,
    bool variant_initialized);

	bool com2lua(VARIANTARG varg);
	tLuaCOMTypeHandler(ITypeInfo *ptypeinfo);
	virtual ~tLuaCOMTypeHandler();

protected:
  lua_Object get_from_array(
    SAFEARRAY* safearray,
    long *indices,
    const VARTYPE& vt);

	bool safearray_com2lua(VARIANTARG& varg);
	bool safearray_lua2com(const TYPEDESC& tdesc, lua_Object luaval, VARIANTARG* pvarg);

	void initOutParameter(VARIANTARG & varg, const TYPEDESC & tdesc);
  bool is_enum(const TYPEDESC& typedesc);
  bool from_PTR(const TYPEDESC& tdesc, lua_Object luaval, VARIANTARG *pvarg);
	void FromDispatchToVariantarg(VARIANTARG *pvarg, lua_Object luaval, VARTYPE vt);
	void FromBoolToVariantarg(VARIANTARG *pvarg, lua_Object luaval, VARTYPE vt);
	HRESULT FromNumberToVariant(VARIANTARG *pvarg, lua_Object luaval, VARTYPE vt);
	ITypeInfo * m_typeinfo;
};

#endif // !defined(AFX_TLUACOMTYPEHANDLER_H__2CAF122C_E09B_11D3_BD2F_444553540000__INCLUDED_)
