/*
 * tLuaDispatch.cpp
 *
 * Vinicius Almendra
 */

// RCS Info
static char *rcsid = "$Id: tLuaDispatch.cpp,v 1.11 2001-04-30 09:32:31-03 almendra Exp almendra $";
static char *rcsname = "$Name:  $";


#include "tLuaDispatch.h"
#include "tLuaCOM.h"
#include "tLuaCOMException.h"



//---------------------------------------------------------------------
//                     IUnknown Methods
//---------------------------------------------------------------------


STDMETHODIMP
tLuaDispatch::QueryInterface(REFIID riid, void FAR* FAR* ppv)
{

    if(IsEqualIID(riid, IID_IUnknown)  ||
       IsEqualIID(riid, IID_IDispatch) ||
       IsEqualIID(riid, interface_iid)) {
      *ppv = this;
      AddRef();
      return NOERROR;       
    }
	       
    *ppv = NULL;
    return ResultFromScode(E_NOINTERFACE);
}


STDMETHODIMP_(unsigned long)
tLuaDispatch::AddRef()
{
    return ++m_refs;
}


STDMETHODIMP_(unsigned long)
tLuaDispatch::Release()
{
  assert(m_refs > 0);
  if(--m_refs == 0)
  {
    // destrava tabela LUA
    lua_unref(table_ref);

    // libera libs

    while(num_methods--)
    {
      typeinfo->ReleaseFuncDesc(funcinfo[num_methods].funcdesc);
      free(funcinfo[num_methods].name);
    }

    free(funcinfo);
    typeinfo->Release();
    typeinfo = NULL;

    // destroi objeto
    delete this;
    return 0;
  }

  return m_refs;
}


//---------------------------------------------------------------------
//                     IDispatch Methods
//---------------------------------------------------------------------


/*
 * NOTE: Support for the following two methods is not available
 * in this version.
 *
 */

STDMETHODIMP
tLuaDispatch::GetTypeInfoCount(unsigned int FAR* pctinfo)
{
    *pctinfo = 1;
    return NOERROR;
}


STDMETHODIMP
tLuaDispatch::GetTypeInfo(unsigned int itinfo, LCID lcid, ITypeInfo FAR* FAR* pptinfo)
{
  if(itinfo != 0)
    return ResultFromScode(TYPE_E_ELEMENTNOTFOUND);

  if(pptinfo == NULL)
    return ResultFromScode(E_POINTER);

  typeinfo->AddRef();
  *pptinfo = typeinfo;

  return NOERROR;
}


STDMETHODIMP
tLuaDispatch::GetIDsOfNames(
    REFIID riid,
    OLECHAR FAR* FAR* rgszNames,
    unsigned int cNames,
    LCID lcid,
    DISPID FAR* rgdispid)
{
    // this object only exposes a "default" interface.
    //
    if(!IsEqualIID(riid, IID_NULL))
      return ResultFromScode(DISP_E_UNKNOWNINTERFACE);

    return DispGetIDsOfNames(typeinfo, rgszNames, cNames, rgdispid);
}


STDMETHODIMP
tLuaDispatch::Invoke(
    DISPID dispidMember,
    REFIID riid,
    LCID lcid,
    unsigned short wFlags,
    DISPPARAMS FAR* pdispparams,
    VARIANT FAR* pvarResult,
    EXCEPINFO FAR* pexcepinfo,
    unsigned int FAR* puArgErr)
{
  HRESULT hresult         = 0;
  VARIANT varResultDummy;
  int index               = 0;
  lua_Object member       = NULL;
  int return_value_pos    = 0;
  int current_arg         = 0;
  HRESULT retval          = NOERROR;


  if(wFlags & ~(DISPATCH_METHOD | DISPATCH_PROPERTYGET | DISPATCH_PROPERTYPUT | DISPATCH_PROPERTYPUTREF))
    return ResultFromScode(E_INVALIDARG);

  if(!IsEqualIID(riid, IID_NULL))
    return ResultFromScode(DISP_E_UNKNOWNINTERFACE);

  /* descobre qual o nome do metodo */

  for(index = 0; index < num_methods; index++)
  {
    if(funcinfo[index].funcdesc->memid == dispidMember &&
       funcinfo[index].funcdesc->invkind & wFlags)
       break;
  }

  if(index >= num_methods)
    return (ResultFromScode(DISP_E_MEMBERNOTFOUND));

  // Assegura o esvaziamento da pilha de Lua, evitando
  // stack overflows
  lua_beginblock();

  switch(wFlags)
  {
  case DISPATCH_METHOD:

      /* chama metodo lua */

    lua_pushobject(lua_getref(table_ref));

    lua_pushstring(funcinfo[index].name);
    member = lua_gettable();
    
    if(lua_isnil(member))
    {
      retval = DISP_E_MEMBERNOTFOUND;
      break;
    }

    /* converte parametros e empilha */

    // parametro self
    lua_pushobject(lua_getref(table_ref));

    // Parametros passados via COM
    typehandler->pushLuaArgs(
      pdispparams,
      funcinfo[index].funcdesc->lprgelemdescParam);

    // chama funcao lua
    lua_callfunction(member);
    
    /* converte resultado para COM */

    if(pvarResult == (VARIANT FAR*)NULL)
    {
      pvarResult = &varResultDummy;
      VariantInit(pvarResult);
    }
    else
    {
      lua_Object retval = lua_getresult(1);

      if(retval != LUA_NOOBJECT 
        && funcinfo[index].funcdesc->elemdescFunc.tdesc.vt != VT_VOID
        )
      {
        typehandler->lua2com(
          funcinfo[index].funcdesc->elemdescFunc.tdesc,
          retval, 
          pvarResult,
          false
          );
      }
    }

    // atualiza parametros de saida
    typehandler->setOutValues(funcinfo[index].funcdesc, pdispparams);

    break;

  case DISPATCH_PROPERTYGET:

    /* le valor contido na tabela */
    lua_pushobject(lua_getref(table_ref));
    lua_pushstring(funcinfo[index].name);

    member = lua_gettable();

    if(member == NULL)
    {
      retval = DISP_E_MEMBERNOTFOUND;
      break;
    }


    if(pdispparams->cArgs > 0) // propertyget parametrizado
    {
      if(lua_istable(member))
      {
        lua_pushobject(member);
        typehandler->com2lua(pdispparams->rgvarg[pdispparams->cArgs - 1]);

        member = lua_gettable();
      }
      else
      {
        // funciona como um propget normal, ignorando parametro
      }
    }

    /* converte resultado para COM */

    if(pvarResult == (VARIANT FAR*)NULL)
    {
      pvarResult = &varResultDummy;
      VariantInit(pvarResult);
    }
    else
    {
      if(member!= NULL)
        typehandler->setRetval(funcinfo[index].funcdesc, member, pvarResult);
    }
    break;

  case DISPATCH_PROPERTYPUT:

    if(pdispparams->cArgs == 1) // propput normal
    {
      lua_pushobject(lua_getref(table_ref));
      lua_pushstring(funcinfo[index].name);

      // Valor a ser setado
      typehandler->com2lua(pdispparams->rgvarg[pdispparams->cArgs - 1]);

      lua_settable();
    }
    else if(pdispparams->cArgs == 2) // propertyput parametrizado
    {
      /* verifica se campo referenciado e' uma tabela */
      lua_pushobject(lua_getref(table_ref));
      lua_pushstring(funcinfo[index].name);

      member = lua_gettable();

      if(lua_istable(member)) // se for, 
      {
        lua_pushobject(member);

        // indice
        typehandler->com2lua(pdispparams->rgvarg[pdispparams->cArgs - 1]);

        // Valor a ser setado
        typehandler->com2lua(pdispparams->rgvarg[pdispparams->cArgs - 2]);

        lua_settable();
      }
      else
      {
        // nao suportado
      }
    }
    else
    {
      // nao suportado
    }

    pvarResult = &varResultDummy;
    VariantInit(pvarResult);
    break;

  case DISPATCH_PROPERTYPUTREF:
    retval = DISP_E_MEMBERNOTFOUND;
    break;

  default:
    retval =  DISP_E_MEMBERNOTFOUND;
    break;
  }

  lua_endblock();

  return retval;
}

tLuaDispatch::tLuaDispatch(ITypeInfo * pTypeinfo, int ref)
{
  HRESULT hr;

  /* inicializacao do objeto */
  table_ref = ref;
  lua_Object table = lua_getref(ref);
  m_refs = 0;

  typeinfo = pTypeinfo;

  typeinfo->AddRef();

  // inicializa conversor de tipos
  typehandler = new tLuaCOMTypeHandler(typeinfo);

  {
    TYPEATTR * ptypeattr = NULL;
    FUNCDESC *funcdesc = NULL;
    unsigned int i, n;

    hr = typeinfo->GetTypeAttr(&ptypeattr);

    CHECK(SUCCEEDED(hr), INTERNAL_ERROR);

    memcpy(&interface_iid, &ptypeattr->guid, sizeof(IID));


    /* Obtem todas as descricoes das funcoes e guarda-as em
       uma tabela */

    n = ptypeattr->cFuncs;
    typeinfo->ReleaseTypeAttr(ptypeattr);

    funcinfo = (tFuncInfo *) malloc(n * sizeof(tFuncInfo));
    num_methods = n;

    for (i = 0; i < n;i++)
    {
      hr = typeinfo->GetFuncDesc(i, &funcdesc);

      CHECK(SUCCEEDED(hr) && funcdesc != NULL, INTERNAL_ERROR);

      funcinfo[i].funcdesc = funcdesc;

      BSTR names[1];
      unsigned int dumb; 
      typeinfo->GetNames( funcdesc->memid, names, 1, &dumb); 

      int str_size = SysStringLen(names[0]);
      funcinfo[i].name = (char *) malloc((str_size + 1)*sizeof(wchar_t));
      wcstombs(funcinfo[i].name, names[0], str_size+1);
    }
  }

  // agora sim esta' inicializado

  return;
}


tLuaDispatch * tLuaDispatch::CreateLuaDispatch(ITypeLib * ptlib, char * pcInterface, int ref)
{
  HRESULT hr;

  wchar_t* wcInterface = (wchar_t*) 
    malloc( (strlen(pcInterface) + 1) * sizeof(wchar_t));
  mbstowcs(wcInterface, pcInterface, strlen(pcInterface)+1);

  const int max_typeinfos = 30;

  MEMBERID dumb[max_typeinfos];
  ITypeInfo *typeinfos[max_typeinfos];
  unsigned int number = 30;
  
  hr = ptlib->FindName(wcInterface, 0, 
    typeinfos, dumb, (unsigned short *) &number);

  free(wcInterface);
  wcInterface = NULL;

  // a interface especificada nao existe nesta TypeLib
  if(FAILED(hr) || number == 0)
    return false;

  // Procura por uma implementacao IDispatch
  
  unsigned int i = 0;
  TYPEATTR *typeattr;
  int found = -1;

  for(i = 0; i < number && found == -1; i++)
  {
    hr = typeinfos[i]->GetTypeAttr(&typeattr);

    CHECK(SUCCEEDED(hr), INTERNAL_ERROR);

    if(typeattr->typekind == TKIND_DISPATCH)
      found = i;

    typeinfos[i]->ReleaseTypeAttr(typeattr);
  }

  if(found == -1)
    return false;

  // cria o objeto tLuaDispatch

  tLuaDispatch *pdisp = NULL;

  try
  {
    pdisp = new tLuaDispatch(typeinfos[found], ref);
  }
  catch(class tLuaCOMException &)
  {
    return NULL;
  }

  return pdisp;
}
