/*
 * tLuaDispatch.h
 */

#ifndef __TLUADISPATCH_H
#define __TLUADISPATCH_H

#include <string.h>
#include <iostream.h>

#include <ole2.h>
#include <ocidl.h>

#include <assert.h>
#include <stdio.h>

extern "C"
{
#include <lua.h>
#include <lauxlib.h>
#include <luadebug.h>
}

#include "luabeans.h"
#include "tLuaCOMTypeHandler.h"

class tLuaDispatch : public IDispatch
{
public:
	static tLuaDispatch * CreateLuaDispatch(ITypeLib *ptlib, char *pcInterface, int ref);
	 tLuaDispatch(ITypeInfo *pTypeinfo, int ref);
  /* IUnknown methods */
  STDMETHOD(QueryInterface)(REFIID riid, void FAR* FAR* ppvObj);
  STDMETHOD_(unsigned long, AddRef)(void);
  STDMETHOD_(unsigned long, Release)(void);

  /* IDispatch methods */
  STDMETHOD(GetTypeInfoCount)(unsigned int FAR* pcTypeInfo);

  STDMETHOD(GetTypeInfo)(
    unsigned int iTypeInfo,
    LCID lcid,
    ITypeInfo FAR* FAR* ppTypeInfo);

  STDMETHOD(GetIDsOfNames)(
    REFIID riid,
    OLECHAR FAR* FAR* rgszNames,
    unsigned int cNames,
    LCID lcid,
    DISPID FAR* rgdispid);

  STDMETHOD(Invoke)(
    DISPID dispidMember,
    REFIID riid,
    LCID lcid,
    unsigned short wFlags,
    DISPPARAMS FAR* pdispparams,
    VARIANT FAR* pvarResult,
    EXCEPINFO FAR* pexcepinfo,
    unsigned int FAR* puArgErr);

  ITypeInfo *typeinfo;

protected:
	IID interface_iid;
	tLuaCOMTypeHandler * typehandler;
  static int tag;

  unsigned long m_refs;

  struct tFuncInfo
  {
    FUNCDESC *funcdesc;
    char *name;
  } *funcinfo;

  int num_methods;
  int table_ref;
};

#endif // __TLUADISPATCH_H