// tLuaObjList.h: interface for the tLuaObjList class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLUAOBJLIST_H__D9585072_945D_11D4_B881_0000B45D7541__INCLUDED_)
#define AFX_TLUAOBJLIST_H__D9585072_945D_11D4_B881_0000B45D7541__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <lua.h>

#include "tUtil.h"

class tLuaObjList : protected tListArray<lua_Object>
{
public:
	unsigned long get_num_elements(void);
  tLuaObjList(long first_param_pos) : tListArray<lua_Object>()
  {
    int param_pos = first_param_pos;
    lua_Object param = LUA_NOOBJECT;

    param = lua_getparam(param_pos);

    while(param != LUA_NOOBJECT)
    {
      add(param);
      param_pos++;
      param = lua_getparam(param_pos);
    }
  }

  tLuaObjList(void) : tListArray<lua_Object>()
  {
  }

  lua_Object getparam(long i)
  {
    lua_Object *retval = NULL;

    if(get(i, &retval))
      return *retval;
    else
      return LUA_NOOBJECT;
  }

  void addParam(lua_Object param)
  {
    add(param);
  }

};

#endif // !defined(AFX_TLUAOBJLIST_H__D9585072_945D_11D4_B881_0000B45D7541__INCLUDED_)
