// tLuaVector.h: interface for the tLuaVector class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLUAVECTOR_H__BAD115E6_A282_11D4_9DF6_0000B45D6611__INCLUDED_)
#define AFX_TLUAVECTOR_H__BAD115E6_A282_11D4_9DF6_0000B45D6611__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <iostream.h>

extern "C"
{
#include "lua.h"
}


class tLuaVectorException
{
public:
  enum Errors {
    INTERNAL_ERROR,
    INDEX_OUT_OF_BOUNDS,
    PARAMETER_OUT_OF_BOUNDS,
    PRECONDITION_FAILED
  };

  Errors code;
  char *file;
  int line;

  tLuaVectorException(Errors p_code, char *p_file, int p_line)
  {
    code = p_code;

    file = p_file;
    line = p_line;

#ifndef NDEBUG
    showMessage();
#endif
  }

protected:
  static char *messages[];

  void showMessage(void)
  {
    if(file != NULL)
    {
      cerr << "tLuaVector Exception in file " << file << " at line " << line
        << ": " << messages[code] << endl;
    }
    else
    {
      cerr << "tLuaVector Exception: " << messages[code] << endl;
    }
  }
};


class tLuaVector  
{
public:
  enum tResults {OK, ALREADY_INITIALIZED, NOT_TABLE};
  enum Type {NOTYPE, NUMBER, STRING, USERDATA, OTHER, MANY};

	tResults InitVectorFromTable(lua_Object table);
  tResults InitVectorFromDimensions(
    long *dimensions,
    unsigned long num_dimensions);
	
	void setindex(lua_Object luaval, long *dimensions, unsigned long size);
	lua_Object CreateTable(void);

	Type lua2Type(lua_Object luaval);
	Type getType(void);
  unsigned long getLength(void);
	lua_Object getindex(long *indices, unsigned long size);
	unsigned long get_Nth_Dimension(unsigned long n);
	unsigned long get_Dimensions(void);
	tLuaVector();
	virtual ~tLuaVector();

protected:
  enum {UNKNOWN, VECTOR, SCALAR} elem_type;

	void freeData(void);

	unsigned long max_length;
	unsigned long length;
	lua_Object*  luavals;
	tLuaVector** vectors;
	bool initialized;

  Type array_type;
};

#endif // !defined(AFX_TLUAVECTOR_H__BAD115E6_A282_11D4_9DF6_0000B45D6611__INCLUDED_)
